package headwear_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-user/_const/enum/headwear_e"
	"hilo-user/domain/model/user_m"
	"hilo-user/myerr"
	"hilo-user/myerr/bizerr"
	"time"
)

type HeadwearService struct {
	svc *domain.Service
}

func NewHeadwearService(myContext *mycontext.MyContext) *HeadwearService {
	svc := domain.CreateService(myContext)
	return &HeadwearService{svc}
}

// 下发头饰
func (s *HeadwearService) SendHeadwear(receiverUserId mysql.ID, headdressId mysql.ID, days int) error {
	var model = domain.CreateModelContext(s.svc.MyContext)
	// 头饰增加
	receiveHeadwearDuration := uint32(days) * 3600 * 24
	if headdressId <= 0 {
		return bizerr.InvalidParameter
	}
	userHeadwear, err := user_m.GetUserHeadwearOrInit(model, receiverUserId, headdressId)
	if err != nil {
		return err
	}
	nowTime := time.Now()
	if userHeadwear.EndTime.After(nowTime) {
		nowTime = userHeadwear.EndTime
	}
	userHeadwear.EndTime = nowTime.Add(time.Duration(receiveHeadwearDuration) * time.Second)
	if err := userHeadwear.Persistent(); err != nil {
		return err
	}
	//日志错误，并不事务回调
	if _, err = addUserHeadwearLog(model, receiverUserId, headdressId, headwear_e.ActivityTrigger, headwear_e.AddSecond, &receiveHeadwearDuration, nil, 0); err != nil {
		model.Log.Error(err)
	}
	return err
}

//增加修改日志
func addUserHeadwearLog(model *domain.Model, userId mysql.ID, headwearId mysql.ID, originType headwear_e.UserHeadwearLogOrginType, t headwear_e.UserHeadwearLogType, addSecond *uint32, UpdateEndTime *time.Time, operateUserId mysql.ID) (mysql.ID, error) {
	userHeadwearLog := user_m.UserHeadwearLog{
		UserId:        userId,
		OperateUserId: operateUserId,
		HeadwearId:    headwearId,
		OriginType:    originType,
		Type:          t,
		AddSecond:     addSecond,
		UpdateEndTime: UpdateEndTime,
	}
	if err := model.Db.Create(&userHeadwearLog).Error; err != nil {
		return 0, myerr.WrapErr(err)
	}
	return userHeadwearLog.ID, nil
}
