package user_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

//注册监听
var userBagSendListen = new(domain.EventBase)

type UserBagSendEvent struct {
	UserId  mysql.ID
	ResType mysql.Type // 道具类型 1:礼物道具
	ResId   mysql.ID   // 道具资源id
	Count   mysql.Num  // 下发数量
	Day     int        // 天数
	Reason  string     // 原因
}

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddUserBagSendSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(userBagSendListen, callback)
}

//加入到异步操作中
func AddUserBagSendAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(userBagSendListen, callback)
}

//领域事件发布
func PublishUserBagSend(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(userBagSendListen, model, event)
}
