package cp_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/myerr/bizerr"
	"time"
)

type CpRelation struct {
	Id          uint64    `json:"id"`
	UserId1     uint64    `json:"userId1"`
	UserId2     uint64    `json:"userId2"`
	CreatedTime time.Time `json:"createdTime"`
}

type CpInvite struct {
	Id           uint64              `json:"id"`
	UserId       uint64              `json:"userId"`
	InviteUserId uint64              `json:"inviteUserId"`
	DiamondNum   uint32              `json:"diamondNum"`
	Status       cp_e.CpInviteStatus `json:"status"`
}

// 发送私信
type CpInviteMessage struct {
	Identifier string `json:"identifier"`
	Msg        string `json:"msg"`
	Status     uint8  `json:"status"` //1.发起邀请2.接受3.拒接
	Avatar1    string `json:"avatar1"`
	Avatar2    string `json:"avatar2"`
}

type CpCancel struct {
	Id        uint64              `json:"id"`
	UserId    uint64              `json:"userId"`
	RecUserId uint64              `json:"recUserId"`
	Status    cp_e.CpCancelStatus `json:"status"`
}

// 发送私信（解除）
type CpCancelMessage struct {
	Identifier string `json:"identifier"`
	Msg        string `json:"msg"`
	Status     uint8  `json:"status"` //1.发起解除2.撤销解除3.接受解除
}

func CreateCp(model *domain.Model, userId1, userId2 uint64) error {
	userIds := []uint64{userId1, userId2}
	result := model.DB().Exec("insert into cp_relation(user_id1, user_id2) values(?,?) where not exists (select user_id1 from cp_relation where user_id1 in (?) or user_id2 in (?));", userId1, userId2, userIds, userIds)
	if result.Error != nil {
		model.Log.Errorf("CreateCp user1:%d, user2:%d, err:%v", userId1, userId2, result.Error)
		return result.Error
	}
	if result.RowsAffected <= 0 {
		model.Log.Errorf("CreateCp user1:%d, user2:%d, err:%v", userId1, userId2, bizerr.TransactionFailed)
		return bizerr.TransactionFailed
	}
	return nil
}

func GetCp(model *domain.Model, userId uint64) (*CpRelation, error) {
	res := new(CpRelation)
	err := model.DB().Model(CpRelation{}).Where("user_id1 = ? or user_id2 = ?", userId, userId).First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return res, nil
		}
		model.Log.Errorf("CreateCp userId:%d, err:%v", userId, err)
		return nil, err
	}
	return res, nil
}

func GetCpInvite(model *domain.Model, userId, userIdInvite uint64, status cp_e.CpInviteStatus) (*CpInvite, error) {
	res := new(CpInvite)
	err := model.DB().Model(CpInvite{}).Where(CpInvite{UserId: userId, InviteUserId: userIdInvite, Status: status}).First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		}
		model.Log.Errorf("GetCpInvite user1:%d, user2:%d, err:%v", userId, userIdInvite, err)
		return nil, err
	}
	return res, nil
}

func CreateCpInvite(model *domain.Model, userId, userIdInvite uint64, diamondNum uint32) (uint64, error) {
	cpInvite := CpInvite{UserId: userId, InviteUserId: userIdInvite, DiamondNum: diamondNum, Status: cp_e.CpInvite}
	err := model.DB().Model(CpInvite{}).Create(cpInvite).Error
	if err != nil {
		model.Log.Errorf("CreateCpInvite user1:%d, user2:%d, diamondNum:%d, err:%v", userId, userIdInvite, diamondNum, err)
		return 0, err
	}
	return cpInvite.Id, nil
}

// userId：发起邀请者
func UpdateStatusCpInvite(model *domain.Model, id uint64, status cp_e.CpInviteStatus) error {
	result := model.DB().Exec("update cp_invite set status=? where id=? and status=? limit 1", status, id, cp_e.CpInvite)
	if result.Error != nil {
		model.Log.Errorf("UpdateStatusCpInvite id:%d, status:%d, err:%v", id, status, result.Error)
		return result.Error
	}
	if result.RowsAffected <= 0 {
		model.Log.Errorf("UpdateStatusCpInvite id:%d, status:%d, err:%v", id, status, bizerr.TransactionFailed)
		return bizerr.TransactionFailed
	}
	return nil
}

func CreateCpCancel(model *domain.Model, userId, recUserId uint64) (uint64, error) {
	cpCancel := CpCancel{UserId: userId, RecUserId: recUserId, Status: cp_e.CpCancel}
	err := model.DB().Model(CpCancel{}).Create(cpCancel).Error
	if err != nil {
		model.Log.Errorf("CreateCpCancel user1:%d, user2:%d, err:%v", userId, recUserId, err)
		return 0, err
	}
	return cpCancel.Id, nil
}

func GetCpCancel(model *domain.Model, userIds []uint64, status cp_e.CpCancelStatus) (*CpCancel, error) {
	res := new(CpCancel)
	err := model.DB().Model(CpCancel{}).Where("status = ? and user_id in (?) and rec_user_id in (?)", status, userIds, userIds).First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		}
		model.Log.Errorf("GetCpCancel users:%d, err:%v", userIds, err)
		return nil, err
	}
	return res, nil
}

func GetCpCancelWithMe(model *domain.Model, userId uint64, status cp_e.CpCancelStatus) (*CpCancel, error) {
	res := new(CpCancel)
	err := model.DB().Model(CpCancel{}).Where("status = ? and (user_id = ? or rec_user_id = ?)", status, userId, userId).First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		}
		model.Log.Errorf("GetCpCancel user1:%d, err:%v", userId, err)
		return nil, err
	}
	return res, nil
}

func UpdateStatusCpCancel(model *domain.Model, id uint64, status cp_e.CpCancelStatus) error {
	result := model.DB().Exec("update cp_cancel set status=? where id=? and status=? limit 1", status, id, cp_e.CpCancel)
	if result.Error != nil {
		model.Log.Errorf("UpdateStatusCpCancel id:%d, status:%d, err:%v", id, status, result.Error)
		return result.Error
	}
	if result.RowsAffected <= 0 {
		model.Log.Errorf("UpdateStatusCpCancel id:%d, status:%d, err:%v", id, status, bizerr.TransactionFailed)
		return bizerr.TransactionFailed
	}
	return nil
}

func DelCpRelation(model *domain.Model, userId1, userId2 uint64) error {
	userIds := []uint64{userId1, userId2}
	result := model.DB().Exec("delete from cp_relation where user_id1 in (?) and user_id2 in (?) limit 1;", userIds, userIds)
	if result.Error != nil {
		model.Log.Errorf("DelCpRelation user1:%d, user2:%d, err:%v", userId1, userId2, result.Error)
		return result.Error
	}
	if result.RowsAffected <= 0 {
		model.Log.Errorf("DelCpRelation user1:%d, user2:%d, err:%v", userId1, userId2, bizerr.TransactionFailed)
		return bizerr.TransactionFailed
	}
	return nil
}
