package res_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-user/_const/enum/res_e"
)

type ResMedal struct {
	mysql.Entity
	Name     string
	PicUrl   string
	SvgaUrl  string
	Sort     mysql.Num
	NoPicUrl *string
	//类型 （0：代表自身就是一种类型 > 0, 一种相关联的类型）
	Type  res_e.ResMedalType
	Scope res_e.ResMedalScope
	//限制 （-1， 没有限制）
	Threshold mysql.Num
	I         mysql.Num
}

// 查勋章中的等级关系
func GetUserMedalLevelMap(db *gorm.DB) (map[uint64]uint8, map[uint8][]uint64, error) {
	rows := make([]ResMedal, 0)
	if err := db.Model(&ResMedal{}).Order("threshold ASC").Find(&rows).Error; err != nil {
		return nil, nil, err
	}
	medalTypes := make(map[uint64]uint8, 0)
	result := make(map[uint8][]uint64, 0)
	for _, i := range rows {
		medalTypes[i.ID] = i.Type

		if i.Type != 0 {
			if _, ok := result[i.Type]; !ok {
				result[i.Type] = make([]uint64, 0)
			}
			result[i.Type] = append(result[i.Type], i.ID)
		}
	}
	return medalTypes, result, nil
}
