package cp_s

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/_const/enum/diamond_e"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/myerr/comerr"
	"git.hilo.cn/hilo-common/rpc"
	"git.hilo.cn/hilo-common/sdk/tencentyun"
	"git.hilo.cn/hilo-common/txop/msg"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/domain/model/cp_m"
	"hilo-user/domain/model/diamond_m"
	"hilo-user/domain/model/user_m"
	"hilo-user/myerr/bizerr"
)

func InviteCpRelation(myCtx *mycontext.MyContext, myUserId uint64, externalId, lang string) error {
	model := domain.CreateModelContext(myCtx)
	user, err := user_m.GetUser(model, myUserId)
	if err != nil {
		return err
	}
	userInvite, err := user_m.GetUserByExtId(model, externalId)
	if err != nil {
		return err
	}

	// 自己是否有cp了
	myCp, err := cp_m.GetCp(model, myUserId)
	if err != nil {
		return err
	}
	if myCp.Id > 0 {
		return msg.GetErrByLanguage(model, 0, lang, comerr.InvalidParameter)
	}
	// 对方是否已经有cp了
	inviCp, err := cp_m.GetCp(model, userInvite.ID)
	if err != nil {
		return err
	}
	if inviCp.Id > 0 {
		return msg.GetErrByLanguage(model, 0, lang, comerr.InvalidParameter)
	}

	// 我是否发起过cp邀请，且还未被处理
	myInvite, err := cp_m.GetCpInvite(model, user.ID, 0, cp_e.CpInvite)
	if err != nil {
		model.Log.Errorf("InviteCpRelation myUserId:%d, err:%v", myUserId, err)
		return err
	}
	if myInvite != nil && myInvite.Id > 0 {
		return bizerr.CpAlreadyInvite
	}

	err = model.Transaction(func(model *domain.Model) error {
		// 创建邀请记录
		cpInvId, err := cp_m.CreateCpInvite(model, myUserId, userInvite.ID, cp_e.CpRelationInviteDiamond)
		if err != nil {
			model.Log.Errorf("InviteCpRelation myUserId:%d, err:%v", myUserId, err)
			return err
		}
		// 扣费
		err = diamond_m.ChangeDiamondAccountDetail(model, diamond_e.CpInvite, cpInvId, myUserId, cp_e.CpRelationInviteDiamond)
		if err != nil {
			model.Log.Errorf("InviteCpRelation myUserId:%d, err:%v", myUserId, err)
			return err
		}
		// 发送私信
		data, _ := json.Marshal(cp_m.CpInviteMessage{
			Identifier: "CpInviteMessage",
			Msg:        "Do you want to be CP with me?",
			Status:     uint8(cp_e.CpInvite),
		})
		if err := tencentyun.BatchSendCustomMsg(model, 1, user.ExternalId, []string{userInvite.ExternalId}, string(data), "cp邀请"); err != nil {
			model.Log.Errorf("BatchSendCustomMsg fail:%v", err)
			return err
		}
		return nil
	})
	if err != nil {
		model.Log.Errorf("InviteCpRelation myUserId:%d, err:%v", myUserId, err)
		return err
	}
	// socket 推送弹窗
	go rpc.SendCpInviteNotice(userInvite.ID, user.Code, user.Nick, user.Avatar, "Do you want to be CP with me?")

	return nil
}

func CancelCpRelation(myCtx *mycontext.MyContext, myUserId uint64, externalId, lang string) error {
	model := domain.CreateModelContext(myCtx)
	user, err := user_m.GetUser(model, myUserId)
	if err != nil {
		return err
	}
	userRec, err := user_m.GetUserByExtId(model, externalId)
	if err != nil {
		return err
	}

	// 自己没有cp了
	myCp, err := cp_m.GetCp(model, myUserId)
	if err != nil {
		return err
	}
	if myCp.Id == 0 {
		return msg.GetErrByLanguage(model, 0, lang, comerr.InvalidParameter)
	}
	// 对方没有cp了
	inviCp, err := cp_m.GetCp(model, userRec.ID)
	if err != nil {
		return err
	}
	if inviCp.Id == 0 {
		return msg.GetErrByLanguage(model, 0, lang, comerr.InvalidParameter)
	}

	// 是否有关于我的cp解除申请，且还未被处理
	myCancel, err := cp_m.GetCpCancelWithMe(model, user.ID, cp_e.CpCancel)
	if err != nil {
		model.Log.Errorf("InviteCpRelation myUserId:%d, err:%v", myUserId, err)
		return err
	}
	if myCancel != nil && myCancel.Id > 0 {
		return bizerr.CpHaveCancelNoDeal
	}

	err = model.Transaction(func(model *domain.Model) error {
		// 创建邀请记录
		_, err = cp_m.CreateCpCancel(model, myUserId, userRec.ID)
		if err != nil {
			model.Log.Errorf("CancelCpRelation myUserId:%d, err:%v", myUserId, err)
			return err
		}
		// 发送私信
		data, _ := json.Marshal(cp_m.CpCancelMessage{
			Identifier: "CpCancelMessage",
			Msg:        "I want to unbind the CP relationship",
			Status:     1,
		})
		if err := tencentyun.BatchSendCustomMsg(model, 1, user.ExternalId, []string{userRec.ExternalId}, string(data), "cp解除"); err != nil {
			model.Log.Errorf("CancelCpRelation BatchSendCustomMsg fail:%v", err)
			return err
		}
		return nil
	})
	if err != nil {
		model.Log.Errorf("CancelCpRelation myUserId:%d, err:%v", myUserId, err)
		return err
	}

	return nil
}
