package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
	"hilo-user/myerr"
)

type UserOauth struct {
	UserId         uint64 `json:"user_id"`
	ThirdPartyId   string `json:"third_party_id"`
	ThirdPartyType int8   `json:"third_party_type"`
}

func (*UserOauth) TableName() string {
	return "user_oauth"
}

// 根据id获取第三方登录信息
func GetUserOauthByUserId(model *domain.Model, userId uint64, thirdType uint8) ([]*UserOauth, error) {
	res := make([]*UserOauth, 0)
	db := model.DB().Where(&UserOauth{UserId: userId})
	if thirdType > 0 {
		db = db.Where(&UserOauth{ThirdPartyType: int8(thirdType)})
	}
	err := db.Find(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}
