package res_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/bluele/gcache"
	"gorm.io/gorm"
	"hilo-user/_const/enum/res_e"
	"time"
)

type ResMedal struct {
	mysql.Entity
	Name     string
	PicUrl   string
	SvgaUrl  string
	Sort     mysql.Num
	NoPicUrl *string
	//类型 （0：代表自身就是一种类型 > 0, 一种相关联的类型）
	Type  res_e.ResMedalType
	Scope res_e.ResMedalScope
	//限制 （-1， 没有限制）
	Threshold mysql.Num
	I         mysql.Num
}

// 查勋章中的等级关系
func GetUserMedalLevelMap(db *gorm.DB) (map[uint64]uint8, map[uint8][]uint64, error) {
	rows := make([]ResMedal, 0)
	if err := db.Model(&ResMedal{}).Order("threshold ASC").Find(&rows).Error; err != nil {
		return nil, nil, err
	}
	medalTypes := make(map[uint64]uint8, 0)
	result := make(map[uint8][]uint64, 0)
	for _, i := range rows {
		medalTypes[i.ID] = i.Type

		if i.Type != 0 {
			if _, ok := result[i.Type]; !ok {
				result[i.Type] = make([]uint64, 0)
			}
			result[i.Type] = append(result[i.Type], i.ID)
		}
	}
	return medalTypes, result, nil
}

var medalCache = gcache.New(1000).LRU().Build()
var medalMapCache = gcache.New(1).LRU().Build()

const medalKey = "MEDAL"

// pprof看到内存分配很多
// 加上15min lru
func MedalGetAll(db *gorm.DB) ([]ResMedal, error) {
	if data, err := medalCache.Get(medalKey); err == nil {
		return data.([]ResMedal), nil
	}
	rows := make([]ResMedal, 0)
	err := db.Find(&rows).Error
	if err != nil {
		return nil, err
	}
	_ = medalCache.SetWithExpire(medalKey, rows, time.Minute*15)
	return rows, nil
}

func MedalGetAllMap(db *gorm.DB) (map[uint32]ResMedal, error) {
	if data, err := medalMapCache.Get(medalKey); err == nil {
		return data.(map[uint32]ResMedal), nil
	}
	rows, err := MedalGetAll(db)
	if err != nil {
		return nil, err
	}
	result := make(map[uint32]ResMedal, 0)
	for _, i := range rows {
		result[uint32(i.ID)] = i
	}
	_ = medalMapCache.SetWithExpire(medalKey, result, time.Minute*15)
	return result, nil
}
