package cp_cv

import (
	"hilo-user/_const/enum/cp_e"
	"hilo-user/cv/user_cv"
)

// cp信息
type CvCpBase struct {
	UserInfo   user_cv.UserTiny `json:"userInfo"`             // 用户信息
	CpUserInfo user_cv.UserTiny `json:"cpUserInfo,omitempty"` // cp用户信息
}

type CvCpAnniversary struct {
	Type      cp_e.AnniversaryItemType `json:"type"`             // 列表类型 0:普通 1:头像
	CpInfo    *CvCpBase                `json:"cpInfo,omitempty"` // cp信息,type=1(头像)时候用到
	Id        uint64                   `json:"id"`               // 记录id
	Content   string                   `json:"content"`          // 纪念日内容
	Timestamp int64                    `json:"timestamp"`        // 纪念日时间戳
	IsRemind  bool                     `json:"isRemind"`         // 是否提醒
	CanDel    bool                     `json:"canDel"`           // 能否删除
	IsTop     bool                     `json:"isTop"`            // 是否置顶
}
