package event_s

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/jinzhu/now"
	"hilo-user/_const/enum/cp_e"
	"hilo-user/domain/event/gift_ev"
	"hilo-user/domain/model/cp_m"
	"time"
)

// 送礼增加cp等级
// 送礼增加cp排行榜
func CpGiftEvent() {
	gift_ev.AddSendGiftEventSync(func(model *domain.Model, event interface{}) error {
		sendGiftEvent, ok := event.(*gift_ev.SendGiftEvent)
		if !ok {
			model.Log.Errorf("AddSendGiftEventAsync event type err")
			return nil
		}
		// 只处理cp礼物
		if !sendGiftEvent.ResGift.Cp {
			return nil
		}
		for _, receiverUid := range sendGiftEvent.ReceiveUserIds {
			diamonds := sendGiftEvent.GiftN * sendGiftEvent.ResGift.DiamondNum
			// 有cp关系
			if cpRelation, exits := cp_m.GetCpRelationPair(model, sendGiftEvent.SendUserId, receiverUid); exits {
				if err := cp_m.AddCpLevelPoints(model, cpRelation, diamonds, sendGiftEvent.SceneType, sendGiftEvent.SceneUid); err != nil {
					model.Log.Errorf("AddCpLevelPoints fail:%v", err)
				}
				if err := cp_m.AddCpDayRank(model, cpRelation, diamonds); err != nil {
					model.Log.Errorf("AddCpDayRank fail:%v", err)
				}
				// 检查最新的等级
				if cpLevel := cp_m.GetCpLevel(model, cpRelation.Id); cpLevel.CpId >= 0 {
					points := cpLevel.Points + cp_e.CpLevelPoints[cpLevel.Level]
					if err := cp_m.UpdateCpAchievement(model, cpLevel.CpId, cpRelation.UserId1, cpRelation.UserId2, cp_e.CpAchievementLevel, points); err != nil {
						model.Log.Errorf("UpdateCpAchievement fail:%v", err)
					}
				}
				// 检查最高的分数
				for _, queryType := range []string{"day", "week", "month"} {
					var beginDate, endDate string
					var cpAchievementType cp_e.CpAchievement
					switch queryType {
					case "day":
						beginDate, endDate = time.Now().Format("2006-01-02"), time.Now().Format("2006-01-02")
						cpAchievementType = cp_e.CpAchievementDayRank
					case "week":
						beginDate = now.BeginningOfWeek().Format("2006-01-02")
						endDate = now.EndOfWeek().Format("2006-01-02")
						cpAchievementType = cp_e.CpAchievementWeekRank
					case "month":
						beginDate = now.BeginningOfMonth().Format("2006-01-02")
						endDate = now.EndOfMonth().Format("2006-01-02")
						cpAchievementType = cp_e.CpAchievementMonthRank
					}
					if data := cp_m.GetCpDayRank(model, beginDate, endDate, cpRelation.Id); data.Score > 0 {
						if err := cp_m.UpdateCpAchievement(model, cpRelation.Id, cpRelation.UserId1, cpRelation.UserId2, cpAchievementType, data.Score); err != nil {
							model.Log.Errorf("UpdateCpAchievement fail:%v", err)
						}
					}
				}
				// 检查最新日周月榜单
				return nil // 业务场景允许提前break(cp是唯一的)
			}
		}
		return nil
	})
}
