package gift_cron

import (
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/mylogrus"
	"hilo-user/domain/service/event_s"
	"time"
)

// 送礼事件
func SendGiftEventInit() {

	mylogrus.MyLog.Infof("SendGiftEventInit")
	go func() {
		ticker := time.NewTicker(time.Millisecond * 500)
		defer ticker.Stop()
		for {
			select {
			case <-ticker.C:
				//start := time.Now()
				myCtx := mycontext.CreateMyContext(nil)
				// 消费送礼事件
				if err := event_s.NewGiftSendEventService(myCtx).Consume(); err != nil {
					myCtx.Log.Errorf("eventServcie consume fail:%v", err)
				} else {
					//myCtx.Log.Infof("eventServcie consume success,cost:%v", time.Now().Sub(start))
				}
			}
		}
	}()
}
