package redis_r

import (
	"context"
	"fmt"
	"github.com/gin-gonic/gin"
	"github.com/go-redis/redis/v8"
	"hilo-user/domain"
	"hilo-user/mycontext"
	"hilo-user/mylogrus"
	"hilo-user/resource/config"
	"strconv"
	"strings"
	"time"
)

var stop = make(chan struct{})
var match = "match_relation_*"

func Scan(c *gin.Context) (*mycontext.MyContext, error) {
	go func() {
		return
		myCtx := mycontext.CreateMyContext(c.Keys)
		var model = domain.CreateModelContext(myCtx)
		cursor := uint64(0)
		first := true
		var err error
		var keys []string
		for first || cursor != 0 {
			first = false
			select {
			case <-stop:
				return
			default:
				keys, cursor, err = model.Redis.Scan(model, cursor, match, 1000).Result()
				if err != nil {
					model.Log.Errorf("SCAN fail:%v", err)
					return
				}
				var delKeys []string
				for _, key := range keys {
					arr := strings.Split(key, "_")
					if len(arr) == 4 {
						cycle, _ := strconv.ParseInt(arr[2], 10, 64)
						if cycle > 0 && cycle < 208933198 { // 2022-12-20号
							delKeys = append(delKeys, key)
						}
					}
				}
				if len(delKeys) > 0 {
					cnt, err := model.Redis.Del(model, keys...).Result()
					model.Log.Infof("del redis keys:%v,cnt:%v,err:%v", delKeys, cnt, err)
				}
				time.Sleep(time.Second)
			}
		}
	}()
	return mycontext.CreateMyContext(nil), nil
}

func ScanStop(c *gin.Context) (*mycontext.MyContext, error) {
	return nil, nil
	myCtx := mycontext.CreateMyContext(c.Keys)
	stop <- struct{}{}
	return myCtx, nil
}

func Hscan(c *gin.Context) (*mycontext.MyContext, error) {
	RedisClient := redis.NewClient(&redis.Options{
		Addr:         config.GetConfigRedis().REDIS_HOST,
		Password:     config.GetConfigRedis().REDIS_PASSWORD, // no password set
		DB:           1,                                      // use default DB
		PoolSize:     20,
		MinIdleConns: 20,
	})
	cursor := uint64(0)
	first := true
	var err error
	var keys []string
	for first || cursor != 0 {
		first = false
		select {
		case <-stop:
			return nil, nil
		default:
			keys, cursor, err = RedisClient.HScan(context.Background(), "user", cursor, "*", 1000).Result()
			if err != nil {
				return nil, err
			}
			l := len(keys)
			if l%2 != 0 {
				mylogrus.MyLog.Errorf("Hscan keys err:%v", keys)
				continue
			}
			for i := 0; i < len(keys); i += 2 {
				if !strings.Contains(keys[i+1], "172.26.95.48:50050") && !strings.Contains(keys[i+1], "172.26.95.24:50050") {
					res, err := RedisClient.HDel(context.Background(), "user", keys[i]).Result()
					msg := fmt.Sprintf("hdel user %v,value:%v,res:%v,err:%v", keys[i], keys[i+1], res, err)
					mylogrus.MyLog.Infof("%v", msg)
				}
			}
		}
	}
	return nil, nil
}
