package route

import (
	"github.com/gin-gonic/gin"
	ginSwagger "github.com/swaggo/gin-swagger"
	"github.com/swaggo/gin-swagger/swaggerFiles"
	_ "hilo-user/docs"
	"hilo-user/route/redis_r"
	"hilo-user/route/user_r"
)

func InitRouter() *gin.Engine {
	var r = gin.Default()

	r.GET("/user-swagger/*any", ginSwagger.WrapHandler(swaggerFiles.Handler))

	needLogin := r.Group("")
	needLogin.Use(ExceptionHandle, LoggerHandle, JWTApiHandle)
	v1 := needLogin.Group("/v1")
	user := v1.Group("/user")
	{
		user.GET("/nameplate", wrapper(user_r.UserNameplate))
	}
	inner := r.Group("/inner")
	inner.Use(ExceptionHandle, LoggerHandle)
	//}
	test := r.Group("/test")
	{
		//test.GET("/user", wrapper(user_r.Test))
		test.GET("/scan/redis", wrapper(redis_r.Scan))
		test.GET("/hscan/redis", wrapper(redis_r.Hscan))
		test.GET("/scan/redis/stop", wrapper(redis_r.ScanStop))
	}
	return r
}
