package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
	"hilo-user/_const/enum/group_e"
	"hilo-user/myerr/bizerr"
	"time"
)

type GroupInfo struct {
	Id             int64
	ImGroupId      string
	TxGroupId      string
	Type           uint16
	Code           string
	OriginCode     string
	Owner          uint64
	Name           string
	Introduction   string
	Notification   string
	FaceUrl        string
	Country        string
	ChannelId      string
	Password       string
	EntryLevel     uint32 // obsolete
	MicOn          bool
	LoadHistory    bool
	ThemeId        int16
	MicNumType     group_e.GroupMicNumType
	TouristMic     uint8     // 游客是否能上麦1是2否
	TouristSendMsg uint8     // 游客是否能发消息1是2否
	TouristSendPic uint8     // 游客是否能发图片1是2否
	MemberFee      uint64    // 加入会员需要黄钻数
	CreatedTime    time.Time `gorm:"->"`
	UpdatedTime    time.Time `gorm:"->"`
}

func GetGroupInfo(model *domain.Model, groupId string) (*GroupInfo, error) {
	if len(groupId) <= 0 {
		return nil, bizerr.GroupNotFound
	}
	r := GroupInfo{}
	err := model.Db.Where(&GroupInfo{ImGroupId: groupId}).First(&r).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, err
		}
	}
	return &r, nil
}

func FindGroupByOwner(model *domain.Model, ownerId uint64) ([]GroupInfo, error) {
	rows := make([]GroupInfo, 0)
	err := model.Db.Where(&GroupInfo{Owner: ownerId}).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	return rows, nil
}

func ToTxGroupId(model *domain.Model, imGroupId string) (string, error) {
	if len(imGroupId) <= 0 {
		return "", nil
	}

	gi, err := GetGroupInfo(model, imGroupId)
	if err != nil {
		return "", err
	}
	if gi == nil {
		return "", bizerr.GroupNotFound
	}
	return gi.TxGroupId, nil
}

func ToImGroupId(model *domain.Model, txGroupId string) (string, error) {
	if len(txGroupId) <= 0 {
		return "", nil
	}

	gi, err := GetInfoByTxGroupId(model, txGroupId)
	if err != nil {
		return "", err
	}
	if gi == nil {
		return "", bizerr.GroupNotFound
	}
	return gi.ImGroupId, nil
}

func GetInfoByTxGroupId(model *domain.Model, txGroupId string) (*GroupInfo, error) {
	if len(txGroupId) <= 0 {
		return nil, bizerr.GroupNotFound
	}

	r := GroupInfo{}
	err := model.Db.Where(&GroupInfo{TxGroupId: txGroupId}).First(&r).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, err
		}
	}
	return &r, nil
}
