package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

/**
 * 用户财富分数
 **/
type MatchWealthUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num
}

// 批量获取财富等级
func MGetWealthGrade(model *domain.Model, userIds []mysql.ID) (map[mysql.ID]mysql.Num, error) {
	res := make(map[mysql.ID]mysql.Num)
	var wealthUserScore []*MatchWealthUserScore
	if err := model.Db.Model(&MatchWealthUserScore{}).Where("user_id in ?", userIds).Find(&wealthUserScore).Error; err != nil {
		return res, err
	}
	for _, r := range wealthUserScore {
		res[r.UserId] = r.Grade
	}
	return res, nil
}
