package req

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/gin-gonic/gin"
	"hilo-user/domain/cache/user_c"
	"hilo-user/domain/model/res_m"
	"hilo-user/myerr/bizerr"
)

// 分页base
type PageReqBase struct {
	PageIndex int `form:"pageIndex,default=0"`
	PageSize  int `form:"pageSize,default=10"`
}

type PageRespBase struct {
	NextPageIndex int         `json:"nextPageIndex"`
	HasNextPage   bool        `json:"hasNextPage"`
	Data          interface{} `json:"data"` // 需要具体自定义
}

func GetUserId(c *gin.Context) (mysql.ID, error) {
	if userIdStr, ok := c.Keys[mycontext.USERID]; ok {
		userId := userIdStr.(uint64)
		return userId, nil
	}
	return 0, bizerr.ParaMissing
}

func ToUserId(myContext *mycontext.MyContext, externalId mysql.Str) (mysql.ID, error) {
	return user_c.ToUserId(domain.CreateModelContext(myContext), externalId)
	//if externalId == "" {
	//	return 0, myerr.NewSysError("externalId 不能为空")
	//}
	//var user user_m.User
	//if err := mysql.Db.Where(&user_m.User{
	//	ExternalId: externalId,
	//}).First(&user).Error; err != nil {
	//	return 0, bizerr.ExternalIdNoExist
	//}
	//return user.ID, nil
}

// 获取userId和externalId
func GetUserIdAndExtId(c *gin.Context, myContext *mycontext.MyContext) (mysql.ID, string, error) {
	if userIdStr, ok := c.Keys[mycontext.USERID]; ok {
		userId := userIdStr.(uint64)

		externalId, ok := c.Get(mycontext.EXTERNAL_ID)
		if ok {
			return userId, externalId.(string), nil
		} else {
			user, err := user_c.GetUserTinyById(domain.CreateModelContext(myContext), userId)
			if err != nil {
				return 0, "", bizerr.ExternalIdNoExist
			}
			return userId, user.ExternalId, nil
		}
	}
	return 0, "", bizerr.ParaMissing
}

// 获取userId和ExtId和code
func GetUserIdExtIdCode(c *gin.Context, myContext *mycontext.MyContext) (mysql.ID, string, string, error) {
	if userIdStr, ok := c.Keys[mycontext.USERID]; ok {
		userId := userIdStr.(uint64)

		userCode, ok1 := c.Get(mycontext.CODE)
		externalId, ok2 := c.Get(mycontext.EXTERNAL_ID)
		if ok1 && ok2 {
			return userId, externalId.(string), userCode.(string), nil
		} else {
			user, err := user_c.GetUserTinyById(domain.CreateModelContext(myContext), userId)
			if err != nil {
				return 0, "", "", bizerr.ExternalIdNoExist
			}
			return userId, user.ExternalId, user.Code, nil
		}
	}
	return 0, "", "", bizerr.ParaMissing
}

// 获取userId和LANGUAGE
func GetUserIdLang(c *gin.Context, myContext *mycontext.MyContext) (mysql.ID, string, error) {
	if userIdStr, ok := c.Keys[mycontext.USERID]; ok {
		userId := userIdStr.(uint64)

		lang, ok := c.Get(mycontext.LANGUAGE)
		if ok {
			return userId, lang.(string), nil
		} else {
			model := domain.CreateModelContext(myContext)
			user, err := user_c.GetUserTinyById(model, userId)
			if err != nil {
				return 0, "", bizerr.ExternalIdNoExist
			}
			lang, err := res_m.GetLangeByCountry(model.Db, user.Country)
			if err != nil {
				return 0, "", err
			}
			return userId, lang, nil
		}
	}
	return 0, "", bizerr.ParaMissing
}
