package user_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/gin-gonic/gin"
	"hilo-user/domain/model/res_m"
	"hilo-user/domain/model/user_m"
	"hilo-user/myerr"
	"hilo-user/myerr/bizerr"
	"hilo-user/req"
	"hilo-user/resp"
)

type ReturnUserNameplatePublic struct {
	Id      uint64 `json:"id"`
	Name    string `json:"name"`
	PicUrl  string `json:"picUrl"`
	SvgaUrl string `json:"svgaUrl"`
	//类型 （0：代表自身就是一种类型 > 0, 一种相关联的类型）
	//Type res_m2.ResMedalType `json:"type"`
	//
	//IsHas bool `json:"isHas"`
}

// @Tags 用户
// @Summary 获取用户的铭牌
// @Param code query string false "用户code，不传则获取自己的"
// @Success 200 {object} ReturnUserNameplatePublic
// @Router /v1/user/nameplate [get]
func UserNameplate(c *gin.Context) (*mycontext.MyContext, error) {
	myContext := mycontext.CreateMyContext(c.Keys)
	userId, err := req.GetUserId(c)
	if err != nil {
		return myContext, err
	}
	model := domain.CreateModelContext(myContext)

	code := c.Query("code")
	if code != "" {
		u, err := user_m.GetUserByCode(model, code)
		if err != nil {
			return myContext, myerr.WrapErr(err)
		}
		if u.ID <= 0 {
			return myContext, bizerr.InvalidParameter
		}
		userId = u.ID
	}

	//所有的勋章
	var resNameplates []res_m.ResNameplate
	if err := mysql.Db.Model(&res_m.ResNameplate{}).Order("sort asc, type asc, threshold asc").Find(&resNameplates).Error; err != nil {
		return myContext, myerr.WrapErr(err)
	}
	resNameplateIds := make([]mysql.ID, 0, len(resNameplates))
	for _, r := range resNameplates {
		resNameplateIds = append(resNameplateIds, r.ID)
	}

	//获取用户的
	var userNameplates []user_m.UserNameplate
	if err := mysql.Db.Model(&user_m.UserNameplate{}).Where(&user_m.UserNameplate{
		UserId: userId,
	}).Where("(end_time >= NOW() or end_time is null)").Find(&userNameplates).Error; err != nil {
		return myContext, myerr.WrapErr(err)
	}
	//转换成map
	userNameplateMap := make(map[uint32]struct{})
	for _, r := range userNameplates {
		userNameplateMap[r.NameplateId] = struct{}{}
	}

	results := make([]ReturnUserNameplatePublic, 0, len(resNameplates))
	for i, r := range resNameplates {
		if _, flag := userNameplateMap[uint32(r.ID)]; flag {
			results = append(results, ReturnUserNameplatePublic{
				Id:      resNameplates[i].ID,
				Name:    resNameplates[i].Name,
				PicUrl:  resNameplates[i].PicUrl,
				SvgaUrl: resNameplates[i].SvgaUrl,
				//Type:    resNameplates[i].Type,
				//IsHas:   true,
			})
		}
	}

	resp.ResponseOk(c, results)
	return myContext, nil
}
