package cp_cron

import (
	"git.hilo.cn/hilo-common/_const/enum/msg_e"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/robfig/cron"
	"hilo-user/domain/model/cp_m"
	"hilo-user/domain/model/msg_m"
)

// 纪念日
type CpAnniversaryNoticeMsg struct {
	Identifier string `json:"identifier"`
	Content    string `json:"content"`
	Timestamp  int64  `json:"timestamp"`
}

func CpAnniversaryNotice() {
	c := cron.New()
	// 1小时操作一次
	spec := "0 0 */1 * * ?"
	if !config.AppIsRelease() {
		// 测服1分钟
		spec = "0 * * * * ?"
	}
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		anniversary := cp_m.GetNeedRemindCpAnniversary(model)
		for _, v := range anniversary {
			var userIds []uint64
			userIds = append(userIds, v.UserId1, v.UserId2)
			record1 := msg_m.NewUserRecord(model, v.UserId1, msg_e.CpAnniversaryNotice, v.Content, 0, "", "", "", "", "")
			record2 := msg_m.NewUserRecord(model, v.UserId2, msg_e.CpAnniversaryNotice, v.Content, 0, "", "", "", "", "")
			err1, err2 := record1.Persistent(), record2.Persistent()
			if err1 != nil || err2 != nil {
				model.Log.Errorf("NewUserRecord fail:%v-%v", err1, err2)
				return
			}
			//if err := tencentyun.BatchSendCustomMsg(model, 1, users[0].ExternalId, []string{users[1].ExternalId}, string(data), "cp纪念日"); err != nil {
			//	model.Log.Errorf("BatchSendCustomMsg fail:%v", err)
			//}
			//if err := tencentyun.BatchSendCustomMsg(model, 1, users[1].ExternalId, []string{users[0].ExternalId}, string(data), "cp纪念日"); err != nil {
			//	model.Log.Errorf("BatchSendCustomMsg fail:%v", err)
			//}
			if err := cp_m.UpdateCpAnniversaryReminded(model, v.ID); err != nil {
				model.Log.Errorf("UpdateCpAnniversaryReminded fail:%v", err)
			}
		}
	})
	c.Start()
}
