package main

import (
	"bufio"
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"os"
	"time"
)

func main() {
	batchSize := 1000
	errLog := "diamond.error.log"
	file, err := os.OpenFile(errLog, os.O_WRONLY|os.O_CREATE, 0666)
	if err != nil {
		fmt.Println("文件打开失败", err)
	}
	defer file.Close()
	n := 0
	id := uint64(4536403001)
	for {
		var details []*model.DiamondAccountDetail
		if err := mysql.ProdReadOnlyDB.Model(model.DiamondAccountDetail{}).Where("id < ? AND id >= 3275366391", id).Order("id DESC").Limit(batchSize).Find(&details).Error; err != nil {
			panic(err)
		}
		if err := mysql.ProdWriteDB.Table(model.DiamondAccountDetailCopy{}.TableName()).CreateInBatches(details, batchSize).Error; err != nil {
			write := bufio.NewWriter(file)
			write.WriteString(fmt.Sprintf("%s\n", err.Error()))
			write.Flush()
		}
		if len(details) <= 0 {
			break
		}
		id = details[len(details)-1].ID
		fmt.Printf("n:%v,lastest id:%v\n", n, id)
		n++
		time.Sleep(time.Millisecond * 300)
		if n >= 1 {
			//break
		}
	}
}
