package main

import (
	"encoding/json"
	"fmt"
	"github.com/tealeg/xlsx"
	"io/ioutil"
	"net/http"
)

type AutoGenerated2 struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Total int `json:"total"`
		Data  []struct {
			Rank        int     `json:"rank"`
			UserCode    string  `json:"userCode"`
			Country     string  `json:"country"`
			Stake       int     `json:"stake"`
			Award       int     `json:"award"`
			ProfitLoss  int     `json:"profitLoss"`
			ChargeMoney float64 `json:"chargeMoney"`
		} `json:"data"`
	} `json:"data"`
}

func ats29(a interface{}) string {
	return fmt.Sprintf("%v", a)
}

func main() {
	url := "https://apiv2.faceline.live/v1/fruitMachine/rank/stake?lang=zh-cn&pageIndex=4&pageSize=5000&beginDate=2023-06-01&endDate=2023-06-30&userCode=&timezone=0"
	method := "GET"

	client := &http.Client{}
	req, err := http.NewRequest(method, url, nil)

	if err != nil {
		fmt.Println(err)
		return
	}
	req.Header.Add("nonce", "hilo")
	req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjI1MSwiRXh0ZXJuYWxJZCI6IiIsImV4cCI6MTY5MDYwOTY4NX0.dVsFGjc1wLPxqhAMloXICs-xQcVxM5FkweLvFta3ncA")

	res, err := client.Do(req)
	if err != nil {
		fmt.Println(err)
		return
	}
	defer res.Body.Close()

	body, err := ioutil.ReadAll(res.Body)
	if err != nil {
		panic(err)
	}
	var response = new(AutoGenerated2)
	err = json.Unmarshal(body, &response)
	if err != nil {
		panic(err)
	}
	excelFileName := fmt.Sprintf("./水果机投注榜单前15000-20000.xlsx")
	xlFile := xlsx.NewFile()
	sheet, _ := xlFile.AddSheet("charge")
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value = "排名", "用户ID", "国家", "投注钻石数", "中奖钻石数", "盈亏（中奖-投注）",
		"充值金额 $"
	for _, d := range response.Data.Data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value = ats29(d.Rank), ats29(d.UserCode), ats29(d.Country), ats29(d.Stake), ats29(d.Award), ats29(d.ProfitLoss)
		c7.Value = ats29(d.ChargeMoney)
	}
	_ = xlFile.Save(excelFileName)
}
