package main

import (
	"encoding/json"
	"fmt"
	"github.com/tealeg/xlsx"
	"io/ioutil"
	"net/http"
)

type AutoGenerated struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Total int `json:"total"`
		Data  []struct {
			Date               string `json:"Date"`
			Pool               int    `json:"Pool"`
			RoundNum           int    `json:"RoundNum"`
			UserNum            int    `json:"UserNum"`
			AwardNum           int    `json:"AwardNum"`
			Stake              int    `json:"Stake"`
			Award              int    `json:"Award"`
			Recycle            int    `json:"Recycle"`
			TopConsumer        string `json:"TopConsumer"`
			TopConsumerDiamond int    `json:"TopConsumerDiamond"`
			TopWinner          string `json:"TopWinner"`
			TopWinnerDiamond   int    `json:"TopWinnerDiamond"`
			LeftOver           int    `json:"LeftOver"`
		} `json:"data"`
	} `json:"data"`
}

func ats28(a interface{}) string {
	return fmt.Sprintf("%v", a)
}

func main() {
	url := "https://apiv2.faceline.live/v1/fruitMachine/day/stats?lang=zh-cn&pageIndex=1&pageSize=100000&beginDate=2023-04-01&endDate=2023-06-31"
	method := "GET"

	client := &http.Client{}
	req, err := http.NewRequest(method, url, nil)

	if err != nil {
		fmt.Println(err)
		return
	}
	req.Header.Add("nonce", "hilo")
	req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjI1MSwiRXh0ZXJuYWxJZCI6IiIsImV4cCI6MTY5MDYwOTY4NX0.dVsFGjc1wLPxqhAMloXICs-xQcVxM5FkweLvFta3ncA")

	res, err := client.Do(req)
	if err != nil {
		fmt.Println(err)
		return
	}
	defer res.Body.Close()

	body, err := ioutil.ReadAll(res.Body)
	if err != nil {
		fmt.Println(err)
		return
	}
	var response = new(AutoGenerated)
	json.Unmarshal(body, &response)
	excelFileName := fmt.Sprintf("./水果机每日统计.xlsx")
	xlFile := xlsx.NewFile()
	sheet, _ := xlFile.AddSheet("charge")
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7, c8 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value = "日期", "参与人数", "中奖人数", "投注钻石数", "中奖钻石数", "系统回收",
		"今日盈余", "奖池盈余"
	for _, d := range response.Data.Data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7, c8 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value = d.Date, ats28(d.UserNum), ats28(d.AwardNum), ats28(d.Stake), ats28(d.Award), ats28(d.Recycle)
		c7.Value, c8.Value = ats28(d.LeftOver), ats28(d.Pool)
	}
	_ = xlFile.Save(excelFileName)
}
