package main

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"github.com/tealeg/xlsx"
	"io/ioutil"
	"net/http"
)

type GroupPowerResponse struct {
	Data struct {
		Total int64            `json:"total"`
		Data  []GroupPowerData `json:"data"`
	}
}

type GroupPowerData struct {
	Id                        uint64  `json:"id"`   // 家族id
	Code                      string  `json:"code"` // 家族长ID
	Area                      string  `json:"-"`
	GroupPowerName            string  `json:"groupPowerName"`            // 家族昵称
	GroupPowerExp             int64   `json:"groupPowerExp"`             // 经验值
	GroupPowerConsume         int64   `json:"groupPowerConsume"`         // 家族房间流水
	GroupPowerMemberNum       int     `json:"groupPowerMemberNum"`       // 成员数
	GroupPowerMemberCharge    float64 `json:"groupPowerMemberCharge"`    // 成员充值$
	GroupPowerNewMemberNum    int     `json:"groupPowerNewMemberNum"`    // 新成员数
	GroupPowerNewMemberCharge float64 `json:"groupPowerNewMemberCharge"` // 新成员充值$
	CodeSvip                  int     `json:"-"`                         // 家族长svip等级
	Svip3UpCnt                int     `json:"-"`                         // svip3以上的成员数
}

func ats23(a interface{}) string {
	return fmt.Sprintf("%v", a)
}

func getAreaByCode(code string) string {
	sql := "SELECT area FROM res_country c,user u WHERE u.country = c.name AND u.code = ?"
	var area int
	if err := mysql.ProdReadOnlyDB.Raw(sql, code).Scan(&area).Error; err != nil {
		panic(err)
	}
	if area == 1 {
		return "阿语区"
	}
	return "非阿语区"
}

func getUserSvipLevel(code string) int {
	var user model.User
	if err := mysql.ProdReadOnlyDB.Model(model.User{}).Where("code = ?", code).First(&user).Error; err != nil {
		panic(err)
	}
	var level int
	err := mysql.ProdReadOnlyDB.Table("user_svip").Where("user_id = ?", user.Id).Select("level").Scan(&level).Error
	if err != nil {
		panic(err)
	}
	return level
}

func getUserSvip3Cnt(groupPowerId uint64) int {
	var total int
	err := mysql.ProdReadOnlyDB.Raw("SELECT count(*) FROM `group_power_user` p,user_svip s where p.user_id = s.user_id AND s.`level` >= 3 AND p.group_power_id = ?", groupPowerId).Scan(&total).Error
	if err != nil {
		panic(err)
	}
	return total
}

func main() {
	var data []GroupPowerData
	pageIndex := 1
	pageSize := 500
	for {
		url := fmt.Sprintf("https://apiv2.faceline.live/v1/groupPower/page?lang=zh-cn&ownerCode=&beginDate=2023-04-01&endDate=2023-04-30&pageIndex=%d&pageSize=%d&status=1", pageIndex, pageSize)
		method := "GET"

		client := &http.Client{}
		req, err := http.NewRequest(method, url, nil)

		if err != nil {
			fmt.Println(err)
			return
		}
		req.Header.Add("nonce", "hilo")
		req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjI1MSwiRXh0ZXJuYWxJZCI6IiIsImV4cCI6MTY4ODU0MDUxOX0.VWJAIv0iWtOgnefrfE5Wbeqc1MvmGjaxuRc47M1PvH8")

		res, err := client.Do(req)
		if err != nil {
			fmt.Println(err)
			return
		}

		body, err := ioutil.ReadAll(res.Body)
		if err != nil {
			fmt.Println(err)
			return
		}
		_ = res.Body.Close()
		var resp GroupPowerResponse
		err = json.Unmarshal(body, &resp)
		if err != nil {
			panic(err)
		}
		if len(resp.Data.Data) <= 0 {
			break
		}
		data = append(data, resp.Data.Data...)
		pageIndex++
	}
	excelFileName := fmt.Sprintf("./家族4月数据.xlsx")
	xlFile := xlsx.NewFile()
	sheet, err := xlFile.AddSheet("slot")
	if err != nil {
		panic(err)
	}
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value = "家族长ID", "家族名称", "区域", "经验值", "家族房间流水", "成员数", "成员充值$", "新成员数", "新成员充值$", "家族长svip等级", "家族超过SVIP3的人数"
	for _, d := range data {
		d.Area = getAreaByCode(d.Code)
		d.CodeSvip = getUserSvipLevel(d.Code)
		d.Svip3UpCnt = getUserSvip3Cnt(d.Id)
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value =
			d.Code, d.GroupPowerName, d.Area, ats23(d.GroupPowerExp), ats23(d.GroupPowerConsume), ats23(d.GroupPowerMemberNum),
			ats23(d.GroupPowerMemberCharge), ats23(d.GroupPowerNewMemberNum), ats23(d.GroupPowerNewMemberCharge), ats23(d.CodeSvip), ats23(d.Svip3UpCnt)
	}
	_ = xlFile.Save(excelFileName)
}
