package main

import (
	"encoding/json"
	"fmt"
	"github.com/tealeg/xlsx"
	"io/ioutil"
	"net/http"
)

type SlotDataResponse struct {
	Data struct {
		Total int64      `json:"total"`
		Data  []SlotData `json:"data"`
	}
}

type SlotData struct {
	Code        string  `json:"userCode"`
	Country     string  `json:"country"`
	Stake       int64   `json:"stake"`
	Award       int64   `json:"award"`
	ChargeMoney float64 `json:"chargeMoney"`
	ProfitLoss  int64   `json:"profitLoss"`
	Rank        int     `json:"rank"`
}

func ats24(a interface{}) string {
	return fmt.Sprintf("%v", a)
}

func main() {
	var data []SlotData
	//pageIndex := 1
	//pageSize := 50
	for {
		url := fmt.Sprintf("https://apiv2.faceline.live/v1/fruitMachine/rank/stake?lang=zh-cn&pageIndex=1&pageSize=50&beginDate=2023-05-01&endDate=2023-05-31&userCode=&timezone=1")
		method := "GET"

		client := &http.Client{}
		req, err := http.NewRequest(method, url, nil)

		if err != nil {
			fmt.Println(err)
			return
		}
		req.Header.Add("nonce", "hilo")
		req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjI1MSwiRXh0ZXJuYWxJZCI6IiIsImV4cCI6MTY4ODAwNDgwMX0.x5vNFTFvemRq9Vk2ixOluc7Cynm9wSs5dvItjI5ZH-M")

		res, err := client.Do(req)
		if err != nil {
			fmt.Println(err)
			return
		}

		body, err := ioutil.ReadAll(res.Body)
		if err != nil {
			fmt.Println(err)
			return
		}
		_ = res.Body.Close()
		var resp SlotDataResponse
		err = json.Unmarshal(body, &resp)
		if err != nil {
			panic(err)
		}
		if len(resp.Data.Data) <= 0 {
			break
		}
		data = append(data, resp.Data.Data...)
		break
	}
	excelFileName := fmt.Sprintf("./fruit数据.xlsx")
	xlFile := xlsx.NewFile()
	sheet, err := xlFile.AddSheet("fruit")
	if err != nil {
		panic(err)
	}
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value = "用户ID", "国家", "投注钻石数", "中奖钻石数", "盈亏（中奖-投注）", "充值金额 $", "排名"
	for _, d := range data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value = d.Code, d.Country, ats24(d.Stake), ats24(d.Award), ats24(d.ProfitLoss),
			ats24(d.ChargeMoney), ats24(d.Rank)
	}
	_ = xlFile.Save(excelFileName)
}
