package main

import (
	"git.hilo.cn/hilo-common/script/mysql"
	"time"
)

type FruitDayRank struct {
	Period string
	UserId uint64
	Stake  int64
	Award  int64
}

type FruitDayRankKsa struct {
	Period string
	UserId uint64
	Stake  int64
	Award  int64
}

type FruitMachineStake struct {
	Date   string
	UserId uint64
	Stake  int64
}

type FruitMachineAward struct {
	Date   string
	UserId uint64
	Award  int64
}

var Cstzone = time.FixedZone("CST", 3*3600) // 东三

func main() {
	start := time.Date(2023, time.January, 2, 0, 0, 0, 0, Cstzone)
	for start.Before(time.Now()) {
		var rows []FruitMachineStake
		if err := mysql.ProdReadOnlyDB.Table("fruit_machine_stake FORCE INDEX(created_time)").Where("DATE(`created_time`) = ?", start.Format("2006-01-02")).
			Select("`date`,user_id,SUM(stake) stake").Group("DATE(`created_time`),user_id").Find(&rows).Error; err != nil {
			panic(err)
		}
		for _, row := range rows {
			if err := mysql.ProdWriteDB.Create(FruitDayRankKsa{
				Period: start.Format("2006-01-02"),
				UserId: row.UserId,
				Stake:  row.Stake,
				Award:  0,
			}).Error; err != nil {
				panic(err)
			}
		}
		var rows2 []FruitMachineAward
		if err := mysql.ProdReadOnlyDB.Table("fruit_machine_player FORCE INDEX(created_time)").Where("DATE(`created_time`) = ?", start.Format("2006-01-02")).
			Select("`date`,user_id,SUM(award) award").Group("DATE(`created_time`),user_id").Find(&rows2).Error; err != nil {
			panic(err)
		}
		for _, row := range rows2 {
			if err := mysql.ProdWriteDB.Table("fruit_day_rank_ksa").Where("period = ? AND user_id = ?", start.Format("2006-01-02"), row.UserId).
				Update("award", row.Award).Error; err != nil {
				panic(err)
			}
		}
		start = start.AddDate(0, 0, 1)
		//break
	}
}
