package rediskey

import (
	"fmt"
	"git.hilo.cn/hilo-common/utils"
	"time"
)

func GetSlotFruitDailyTimes(userId uint64, nowTime time.Time) string {
	var cstZone = time.FixedZone("CST", 3*3600) // 东三区，沙特时间
	return fmt.Sprintf(SlotFruitWeeklyDailyTask, nowTime.In(cstZone).Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanChargeAwardTimes(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanChargeAwardTimes, actId, userId)
}

func GetOpenRamadanTaskTimesMic(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesMic, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesLudo(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesLudo, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesFruit(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesFruit, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesSlot(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesSlot, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesEnter(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesEnter, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesRoom(actId, userId, roomId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesRoom, actId, time.Now().Format(utils.DATE_FORMAT), userId, roomId)
}

func GetOpenRamadanFruitBet(actId, userId uint64, round uint, date string) string {
	return fmt.Sprintf(OpenRamadanFruitBet, actId, date, userId, round)
}
