package timezone_e

import "time"

type Timezone int

const (
	TimezoneBeijing Timezone = 0
	TimezoneKSA     Timezone = 1
)

var Timezones = []Timezone{TimezoneBeijing, TimezoneKSA}
var (
	BeijingTimezoneLoc = time.FixedZone("CST", 8*3600) // 东八
	KSATimezoneLoc     = time.FixedZone("CST", 3*3600) // 东三
)

var TimezoneLocMap = map[Timezone]*time.Location{
	TimezoneBeijing: BeijingTimezoneLoc,
	TimezoneKSA:     KSATimezoneLoc,
}
