package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

//用户信息
type User struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	ExternalId    mysql.Str
	Avatar        mysql.Str
	DefaultAvatar bool
	Nick          mysql.Str
	Sex           mysql.Sex
	Birthday      mysql.Timestamp
	Country       mysql.Str
	CountryIcon   mysql.Str
	Language      mysql.Str
	Description   mysql.Str
	Code          mysql.Str
	OriginCode    mysql.Str
	IsPush        mysql.OpenClose
	IsShowAge     mysql.OpenClose
	Status        mysql.Type
	DeviceType    mysql.Str
	LogoutTime    int64
}

//获取用户
func GetUser(model *domain.Model, id mysql.ID) (*User, error) {
	var user User
	if err := model.Db.WithContext(model.Context).Where(&User{
		Entity: mysql.Entity{ID: id},
	}).First(&user).Error; err != nil {
		return nil, err
	}
	user.Model = model
	return &user, nil
}
