package domain

import (
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"gorm.io/gorm"
)

type Model struct {
	*CtxAndDb `gorm:"-"`
}

func CreateModel(ctxAndDb *CtxAndDb) *Model {
	return &Model{CtxAndDb: ctxAndDb}
}

func CreateModelContext(myContext *mycontext.MyContext) *Model {
	return &Model{
		CtxAndDb: &CtxAndDb{
			Db:        mysql.Db,
			MyContext: myContext,
			Redis:     redisCli.GetRedis(),
		},
	}
}

func CreateModelNil() *Model {
	return &Model{
		CtxAndDb: &CtxAndDb{
			Db:        mysql.Db,
			MyContext: mycontext.CreateMyContext(nil),
			Redis:     redisCli.GetRedis(),
		},
	}
}

func (m *Model) DB() *gorm.DB {
	return m.Db.WithContext(m)
}

// 包装事务
// 注意:需要使用新的model
func (m *Model) Transaction(f func(*Model) error) error {
	// 公用context
	// 新的db
	txModel := CreateModelContext(m.MyContext)
	txModel.Db = m.Db.Begin().WithContext(m)
	err := f(txModel)
	if err != nil {
		txModel.Db.Rollback()
		return err
	}
	return txModel.Db.Commit().Error
}
