package jwt

import (
	"github.com/dgrijalva/jwt-go"
	"time"
)

// 载荷，增加用户别名
type Claims struct {
	UserId     uint64
	ExternalId string
	jwt.StandardClaims
}

//生成token
func GenerateToken(userId uint64, externalId string, issuer string) (string, error) {
	duration, err := time.ParseDuration("240h")
	if err != nil {
		return "", err
	}

	expireTime := time.Now().Add(duration)
	claims := Claims{
		UserId:     userId,
		ExternalId: externalId,
		StandardClaims: jwt.StandardClaims{
			ExpiresAt: expireTime.Unix(), //过期时间
			Issuer:    issuer,            //签名的发行者
		},
	}
	tokenClaims := jwt.NewWithClaims(jwt.SigningMethodHS256, claims)
	token, err := tokenClaims.SignedString(GetJWTSecret())
	return token, err
}

func GetJWTSecret() []byte {
	return []byte("hilo1632")
}

//解析token
func ParseToken(token string) (*Claims, error) {
	tokenClaims, err := jwt.ParseWithClaims(token, &Claims{}, func(token *jwt.Token) (interface{}, error) {
		return GetJWTSecret(), nil
	})
	if err != nil {
		return nil, err
	}
	if tokenClaims != nil {
		claims, ok := tokenClaims.Claims.(*Claims)
		if ok && tokenClaims.Valid {
			return claims, nil
		}
	}
	return nil, err
}
