package rpc

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/protocol/userProxy"
	"google.golang.org/protobuf/proto"
)

func SendFruitMachine(date string, round uint32) error {
	msg := &userProxy.FruitMachine{
		Date:  date,
		Round: round,
	}
	if buffer, err := proto.Marshal(msg); err == nil {
		rspUids, err := broadcast(MsgFruitMachine, buffer)

		//记录socket,注意闭包问题
		go func(userId uint64, msg *userProxy.FruitMachine, rspUids []uint64, err error) {
			buf, _ := json.Marshal(msg)
			AddRpcLog(MsgFruitMachine, userId, string(buf[:]), rspUids, err)
		}(0, msg, rspUids, err)

		if err != nil {
			mylogrus.MyLog.Errorf("grpc SendFruitMachine send fail")
			return err
		} else {
			mylogrus.MyLog.Info("grpc SendFruitMachine send success")
		}
	} else {
		return err
	}
	return nil
}

func SendGlobalRocketNotice(groupId string, period string, round uint32, stage uint32, fromUserId uint64, topUserIcon string, nick string, code string, avatar string) error {
	msg := &userProxy.GlobalRocketNotice{
		GroupId:     groupId,
		Period:      period,
		Round:       round,
		Stage:       stage,
		TopUserIcon: topUserIcon,
		Nick:        nick,
		Code:        code,
		Avatar:      avatar,
	}

	if buffer, err := proto.Marshal(msg); err == nil {
		rspUids, err := broadcast(MsgTypeGlobalRocketNotice, buffer)

		//记录socket,注意闭包问题
		go func(userId uint64, msg *userProxy.GlobalRocketNotice, rspUids []uint64, err error) {
			buf, _ := json.Marshal(msg)
			AddRpcLog(MsgTypeGlobalRocketNotice, userId, string(buf[:]), rspUids, err)
		}(fromUserId, msg, rspUids, err)

		if err != nil {
			mylogrus.MyLog.Errorf("grpc GlobalRocketNotice send fail")
			return err
		} else {
			mylogrus.MyLog.Info("grpc GlobalRocketNotice send success")
		}
	} else {
		return err
	}
	return nil
}

// 发送钻石变化通知
func SendDiamondChange(userId uint64, diamond uint32) error {
	msg := &userProxy.DiamondChange{
		RemainDiamond: diamond,
	}
	if buffer, err := proto.Marshal(msg); err == nil {
		rspUids, err := multicast([]uint64{userId}, MsgDiamondChange, buffer)
		//记录socket,注意闭包问题
		go func(userId uint64, msg *userProxy.DiamondChange, rspUids []uint64, err error) {
			buf, _ := json.Marshal(msg)
			AddRpcLog(MsgDiamondChange, userId, string(buf[:]), rspUids, err)
		}(userId, msg, rspUids, err)

		if err != nil {
			mylogrus.MyLog.Errorf("grpc SendDiamondChange send fail")
			return err
		} else {
			mylogrus.MyLog.Info("grpc SendDiamondChange send success")
		}
	} else {
		return err
	}
	return nil
}

// 发送游戏横幅
// param winUserId:胜利的用户id
// param gameType 0:slot 5:luckybox 6:fruit
func SendGlobalGameBanner(winUserId uint64, diamond uint64, avatar string, gameType uint32) error {
	bannerUrl := ""
	switch gameType {
	case 0:
		bannerUrl = "https://image.whoisamy.shop/hilo/resource/game/game_banner_slot.png"
	case 5:
		bannerUrl = "https://image.whoisamy.shop/hilo/resource/game/game_banner_luckybox.png"
	case 6:
		bannerUrl = "https://image.whoisamy.shop/hilo/resource/game/game_banner_fruit.png"
	}
	msg := &userProxy.GlobalGameBanner{
		GameType:  gameType,
		UserId:    winUserId,
		Avatar:    avatar,
		Diamond:   diamond,
		BannerUrl: bannerUrl,
	}
	if buffer, err := proto.Marshal(msg); err == nil {
		rspUids, err := broadcast(MsgTypeGlobalGameBanner, buffer)

		//记录socket,注意闭包问题
		go func(userId uint64, msg *userProxy.GlobalGameBanner, rspUids []uint64, err error) {
			buf, _ := json.Marshal(msg)
			AddRpcLog(MsgTypeGlobalGameBanner, userId, string(buf[:]), rspUids, err)
		}(winUserId, msg, rspUids, err)

		if err != nil {
			mylogrus.MyLog.Errorf("grpc SendGlobalGameBanner send fail")
			return err
		} else {
			mylogrus.MyLog.Info("grpc SendGlobalGameBanner send success")
		}
	} else {
		return err
	}
	return nil
}
