package emas

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/services/push"
	"strings"
)

var EmasClient *push.Client

func SendMsg(externalId string, deviceType string, body string) error {
	if strings.ToLower(deviceType) == "android" {
		return sendAndroidMsg(externalId, body)
	} else if strings.ToLower(deviceType) == "ios" {
		return sendIosMsg(externalId, body)
	} else {
		err1 := sendAndroidMsg(externalId, body)
		err2 := sendIosMsg(externalId, body)
		if err1 != nil {
			return err1
		} else if err2 != nil {
			return err2
		}
		return nil
	}
}

func SendNotice(externalId string, deviceType string, title string, body string) error {
	if strings.ToLower(deviceType) == "android" {
		return sendAndroidNotice(externalId, title, body)
	} else if strings.ToLower(deviceType) == "ios" {
		return sendIosNotice(externalId, title, body)
	} else {
		err1 := sendAndroidNotice(externalId, title, body)
		err2 := sendIosNotice(externalId, title, body)
		if err1 != nil {
			return err1
		} else if err2 != nil {
			return err2
		}
		mylogrus.MyLog.Infof("emas send notice success externalId:%v", externalId)
		return nil
	}
}

func SendAndroidNoticeAll(title string, body string) error {

	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	request.PushType = "NOTICE"
	request.DeviceType = "ANDROID"
	request.Target = "ALL"
	request.TargetValue = "ALL"
	request.Body = body
	request.Title = title
	//request.JobKey = "1"
	//request.SendSpeed = requests.NewInteger(1)
	//产品决定
	request.StoreOffline = requests.NewBoolean(true)
	//request.PushTime = "1"
	//默认是72小时
	//request.ExpireTime = time.Now().Add(time.Duration(time.Hour * 72)).UTC().Format(time.RFC3339)
	/*	request.iOSApnsEnv = "1"
		request.iOSRemind = requests.NewBoolean(false)
		request.iOSRemindBody = "1"
		request.iOSBadge = requests.NewInteger(1)
		request.iOSBadgeAutoIncrement = requests.NewBoolean(false)
		request.iOSSilentNotification = requests.NewBoolean(false)
		request.iOSMusic = "1"
		request.iOSSubtitle = "1"
		request.iOSNotificationCategory = "1"
		request.iOSMutableContent = requests.NewBoolean(false)
		request.iOSExtParameters = "1"*/
	request.AndroidNotifyType = "BOTH"
	request.AndroidOpenType = "APPLICATION"
	//request.AndroidActivity = "1"
	//request.AndroidMusic = "1"
	//request.AndroidOpenUrl = "1"
	//request.AndroidXiaoMiActivity = "1"
	//request.AndroidXiaoMiNotifyTitle = "1"
	//request.AndroidXiaoMiNotifyBody = "1"
	request.AndroidPopupActivity = "MainActivity"
	request.AndroidPopupTitle = title
	request.AndroidPopupBody = body
	//request.AndroidNotificationBarType = requests.NewInteger(1)
	//request.AndroidNotificationBarPriority = requests.NewInteger(1)
	//request.AndroidExtParameters = "1"
	request.AndroidRemind = requests.NewBoolean(true)
	//产品未给信息
	request.AndroidNotificationChannel = "com.qiahao.nextvideo_channel_random_pairing"
	//request.AndroidNotificationChannel = "2000"
	//request.AndroidNotificationXiaomiChannel = "1000"
	//
	//request.SmsTemplateName = "1"
	//request.SmsSignName = "1"
	//request.SmsParams = "1"
	//request.SmsDelaySecs = requests.NewInteger(1)
	//request.SmsSendPolicy = requests.NewInteger(1)

	//产品未给信息
	//request.AndroidNotificationVivoChannel = "1"
	//request.AndroidNotificationHuaweiChannel = "1"

	//request.AndroidNotificationNotifyId = requests.NewInteger(1)
	//request.iOSNotificationCollapseId = "1"

	//mylogrus.MyLog.Infof("emas sendAndroidNotice expireTime:%v ", request.ExpireTime)
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendAndroidNoticeAll fail err:%v title:%v body:%v response:%v", err, title, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendAndroidNoticeAll success title:%v body:%v", title, body)
	}
	return err
}

func SendIosNoticeAll(title string, body string) error {
	requestIOS := push.CreatePushNoticeToiOSRequest()
	requestIOS.Scheme = "https"
	requestIOS.AppKey = requests.Integer(config.GetEmasIosAppKey())
	requestIOS.Target = "ALL"
	requestIOS.TargetValue = "ALL"
	requestIOS.Body = body
	requestIOS.Title = title
	requestIOS.ApnsEnv = config.GetEmasApns()
	response, err := EmasClient.PushNoticeToiOS(requestIOS)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas SendIosNoticeAll fail err:%v response:%#v, title:%v, body:%v, apnsEnv:%v", err, string(buf), title, body, config.GetEmasApns())
	} else {
		mylogrus.MyLog.Infof("emas SendIosNoticeAll success title:%v body:%v", title, body)
	}
	return err
}

func sendAndroidNotice(externalId string, title string, body string) error {

	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	request.PushType = "NOTICE"
	request.DeviceType = "ANDROID"
	request.Target = "ACCOUNT"
	request.TargetValue = externalId
	request.Body = body
	request.Title = title
	//request.JobKey = "1"
	//request.SendSpeed = requests.NewInteger(1)
	//产品决定
	request.StoreOffline = requests.NewBoolean(true)
	//request.PushTime = "1"
	//默认是72小时
	//request.ExpireTime = time.Now().Add(time.Duration(time.Hour * 72)).UTC().Format(time.RFC3339)
	/*	request.iOSApnsEnv = "1"
		request.iOSRemind = requests.NewBoolean(false)
		request.iOSRemindBody = "1"
		request.iOSBadge = requests.NewInteger(1)
		request.iOSBadgeAutoIncrement = requests.NewBoolean(false)
		request.iOSSilentNotification = requests.NewBoolean(false)
		request.iOSMusic = "1"
		request.iOSSubtitle = "1"
		request.iOSNotificationCategory = "1"
		request.iOSMutableContent = requests.NewBoolean(false)
		request.iOSExtParameters = "1"*/
	request.AndroidNotifyType = "BOTH"
	request.AndroidOpenType = "APPLICATION"
	//request.AndroidActivity = "1"
	//request.AndroidMusic = "1"
	//request.AndroidOpenUrl = "1"
	//request.AndroidXiaoMiActivity = "1"
	//request.AndroidXiaoMiNotifyTitle = "1"
	//request.AndroidXiaoMiNotifyBody = "1"
	request.AndroidPopupActivity = "MainActivity"
	request.AndroidPopupTitle = title
	request.AndroidPopupBody = body
	//request.AndroidNotificationBarType = requests.NewInteger(1)
	//request.AndroidNotificationBarPriority = requests.NewInteger(1)
	//request.AndroidExtParameters = "1"
	request.AndroidRemind = requests.NewBoolean(true)
	//产品未给信息
	request.AndroidNotificationChannel = "com.qiahao.nextvideo_channel_random_pairing"
	//request.AndroidNotificationChannel = "2000"
	//request.AndroidNotificationXiaomiChannel = "1000"
	//
	//request.SmsTemplateName = "1"
	//request.SmsSignName = "1"
	//request.SmsParams = "1"
	//request.SmsDelaySecs = requests.NewInteger(1)
	//request.SmsSendPolicy = requests.NewInteger(1)

	//产品未给信息
	//request.AndroidNotificationVivoChannel = "1"
	//request.AndroidNotificationHuaweiChannel = "1"

	//request.AndroidNotificationNotifyId = requests.NewInteger(1)
	//request.iOSNotificationCollapseId = "1"

	//mylogrus.MyLog.Infof("emas sendAndroidNotice expireTime:%v ", request.ExpireTime)
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendAndroidNotice fail err:%v externalId:%v, title:%v, body:%v response:%#v", err, externalId, title, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendAndroidNotice success externalId:%v, title:%v body:%v", externalId, title, body)
	}
	return err
}

func SendMultNotice(externalIds []string, title string, body string, deviceType string) (string, error) {
	if strings.ToLower(deviceType) == "android" {
		return SendMultAndroidNotice(externalIds, title, body)
	} else if strings.ToLower(deviceType) == "ios" {
		return SendMultIosNotice(externalIds, title, body)
	} else {
		return "", fmt.Errorf("deviceType:%v not find", deviceType)
	}
}

func SendMultIosNotice(externalIds []string, title string, body string) (string, error) {
	externalIdStr := ""
	if len(externalIds) > 0 {
		externalIdStr += externalIds[0]
	}
	for i := 1; i < len(externalIds); i++ {
		externalIdStr = externalIdStr + "," + externalIds[i]
	}

	requestIOS := push.CreatePushNoticeToiOSRequest()
	requestIOS.Scheme = "https"
	requestIOS.AppKey = requests.Integer(config.GetEmasIosAppKey())
	requestIOS.Target = "ACCOUNT"
	requestIOS.TargetValue = externalIdStr
	requestIOS.Body = body
	requestIOS.Title = title
	requestIOS.ApnsEnv = config.GetEmasApns()
	response, err := EmasClient.PushNoticeToiOS(requestIOS)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas SendMultIosNoticeAll fail err:%v response:%#v, title:%v, body:%v, apnsEnv:%v", err, string(buf), title, body, config.GetEmasApns())
	} else {
		mylogrus.MyLog.Infof("emas SendMultIosNoticeAll success title:%v body:%v", title, body)
	}
	messageId := ""
	if response != nil {
		messageId = response.MessageId
	}

	return messageId, err
}

func SendMultAndroidNotice(externalIds []string, title string, body string) (string, error) {
	externalIdStr := ""
	if len(externalIds) > 0 {
		externalIdStr += externalIds[0]
	}
	for i := 1; i < len(externalIds); i++ {
		externalIdStr = externalIdStr + "," + externalIds[i]
	}

	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	request.PushType = "NOTICE"
	request.DeviceType = "ALL"
	request.Target = "ACCOUNT"
	request.TargetValue = externalIdStr
	request.Body = body
	request.Title = title
	//request.JobKey = "1"
	//request.SendSpeed = requests.NewInteger(1)
	//产品决定
	request.StoreOffline = requests.NewBoolean(true)
	//request.PushTime = "1"
	//默认是72小时
	//request.ExpireTime = time.Now().Add(time.Duration(time.Hour * 72)).UTC().Format(time.RFC3339)
	/*	request.iOSApnsEnv = "1"
		request.iOSRemind = requests.NewBoolean(false)
		request.iOSRemindBody = "1"
		request.iOSBadge = requests.NewInteger(1)
		request.iOSBadgeAutoIncrement = requests.NewBoolean(false)
		request.iOSSilentNotification = requests.NewBoolean(false)
		request.iOSMusic = "1"
		request.iOSSubtitle = "1"
		request.iOSNotificationCategory = "1"
		request.iOSMutableContent = requests.NewBoolean(false)
		request.iOSExtParameters = "1"*/
	request.AndroidNotifyType = "BOTH"
	request.AndroidOpenType = "APPLICATION"
	//request.AndroidActivity = "1"
	//request.AndroidMusic = "1"
	//request.AndroidOpenUrl = "1"
	//request.AndroidXiaoMiActivity = "1"
	//request.AndroidXiaoMiNotifyTitle = "1"
	//request.AndroidXiaoMiNotifyBody = "1"
	request.AndroidPopupActivity = "MainActivity"
	request.AndroidPopupTitle = title
	request.AndroidPopupBody = body
	//request.AndroidNotificationBarType = requests.NewInteger(1)
	//request.AndroidNotificationBarPriority = requests.NewInteger(1)
	//request.AndroidExtParameters = "1"
	request.AndroidRemind = requests.NewBoolean(true)
	//产品未给信息
	request.AndroidNotificationChannel = "com.qiahao.nextvideo_channel_random_pairing"
	//request.AndroidNotificationChannel = "2000"
	//request.AndroidNotificationXiaomiChannel = "1000"
	//
	//request.SmsTemplateName = "1"
	//request.SmsSignName = "1"
	//request.SmsParams = "1"
	//request.SmsDelaySecs = requests.NewInteger(1)
	//request.SmsSendPolicy = requests.NewInteger(1)

	//产品未给信息
	//request.AndroidNotificationVivoChannel = "1"
	//request.AndroidNotificationHuaweiChannel = "1"

	//request.AndroidNotificationNotifyId = requests.NewInteger(1)
	//request.iOSNotificationCollapseId = "1"

	//mylogrus.MyLog.Infof("emas sendAndroidNotice expireTime:%v ", request.ExpireTime)
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendAndroidNotice fail err:%v externalId:%v, title:%v, body:%v response:%#v", err, externalIds, title, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendAndroidNotice success externalId:%v, title:%v body:%v", externalIds, title, body)
	}

	messageId := ""
	if response != nil {
		messageId = response.MessageId
	}

	return messageId, err
}

/*func sendAndroidNotice(externalId string, title string, body string) error {

	requestAndroid := push.CreatePushNoticeToAndroidRequest()
	requestAndroid.Scheme = "https"
	requestAndroid.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	requestAndroid.Target = "ACCOUNT"
	requestAndroid.TargetValue = externalId
	requestAndroid.Body = body
	requestAndroid.Title = title

	response, err := EmasClient.PushNoticeToAndroid(requestAndroid)
	if err != nil {
		mylogrus.MyLog.Errorf("emas sendAndroidNotice externalId:%v, fail, response:%#v", externalId, response)
	} else {
		mylogrus.MyLog.Errorf("emas sendAndroidNotice externalId:%v, success", externalId)
	}

	return err
}*/

func sendIosNotice(externalId string, title string, body string) error {
	requestIOS := push.CreatePushNoticeToiOSRequest()
	requestIOS.Scheme = "https"
	requestIOS.AppKey = requests.Integer(config.GetEmasIosAppKey())
	requestIOS.Target = "ACCOUNT"
	requestIOS.TargetValue = externalId
	requestIOS.Body = body
	requestIOS.Title = title
	requestIOS.ApnsEnv = config.GetEmasApns()
	response, err := EmasClient.PushNoticeToiOS(requestIOS)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendIosNotice fail err:%v externalId:%v response:%#v, title:%v, body:%v, apnsEnv:%v", err, externalId, string(buf), title, body, config.GetEmasApns())
	} else {
		mylogrus.MyLog.Infof("emas sendIosNotice success externalId:%v  title:%v body:%v", externalId, title, body)
	}
	return err
}

func sendAndroidMsg(externalId string, body string) error {

	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	request.PushType = "MESSAGE"
	request.DeviceType = "ANDROID"
	request.Target = "ACCOUNT"
	request.TargetValue = externalId
	request.Body = body
	request.Title = body
	//产品决定
	//request.StoreOffline = requests.NewBoolean(true)
	//request.PushTime = "1"
	//默认是72小时
	//request.ExpireTime = time.Now().Add(time.Minute).UTC().Format(time.RFC3339)
	//
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendAndroidMsg fail err:%v, externalId:%v , body:%v ,response:%#v", err, externalId, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendAndroidMsg success externalId:%v, body:%v ", externalId, body)
	}
	return err

	//暂时不修改
	/*	requestAndroid := push.CreatePushMessageToAndroidRequest()
		requestAndroid.Scheme = "https"
		requestAndroid.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
		requestAndroid.Target = "ACCOUNT"
		requestAndroid.TargetValue = externalId
		requestAndroid.Body = body
		requestAndroid.Title = body
		response, err := EmasClient.PushMessageToAndroid(requestAndroid)
		if err != nil {
			mylogrus.MyLog.Errorf("emas sendAndroidMsg fail externalId:%v, body:%v , response:%#v", externalId, body, response)
		} else {
			mylogrus.MyLog.Infof("emas sendAndroidMsg success externalId:%v, body:%v", externalId, body)
		}
		return err*/
}

func sendIosMsg(externalId string, body string) error {
	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasIosAppKey())
	request.PushType = "MESSAGE"
	request.DeviceType = "iOS"
	request.Target = "ACCOUNT"
	request.TargetValue = externalId
	request.Body = body
	request.Title = body
	//request.StoreOffline = requests.NewBoolean(true)
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendIosMsg fail externalId:%v, err:%v body:%v, response:%#v", externalId, err, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendIosMsg success externalId:%v body:%v", externalId, body)
	}
	return err
	/*	requestIos := push.CreatePushMessageToiOSRequest()
		requestIos.Scheme = "https"
		requestIos.AppKey = requests.Integer(config.GetEmasIosAppKey())
		requestIos.Target = "ACCOUNT"
		requestIos.TargetValue = externalId
		requestIos.Body = body
		requestIos.Title = body
		response, err := EmasClient.PushMessageToiOS(requestIos)
		if err != nil {
			mylogrus.MyLog.Errorf("emas sendIosMsg fail externalId:%v body:%v response:%#v", externalId, body, response)
		} else {
			mylogrus.MyLog.Infof("emas sendIosMsg success externalId:%v body:%v ", externalId, body)
		}
		return err*/
}

func SendAndroidMsgAll(body string) error {

	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
	request.PushType = "MESSAGE"
	request.DeviceType = "ANDROID"
	request.Target = "ALL"
	request.TargetValue = "ALL"
	request.Body = body
	request.Title = body
	//产品决定
	request.StoreOffline = requests.NewBoolean(true)
	//request.PushTime = "1"
	//默认是72小时
	//request.ExpireTime = time.Now().Add(time.Duration(time.Hour * 72)).UTC().Format(time.RFC3339)
	//
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendAndroidMsgAll fail err:%v body:%v ,response:%#v", err, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendAndroidMsgAll success body:%v ", body)
	}
	return err

	//暂时不修改
	/*	requestAndroid := push.CreatePushMessageToAndroidRequest()
		requestAndroid.Scheme = "https"
		requestAndroid.AppKey = requests.Integer(config.GetEmasAndroidAppKey())
		requestAndroid.Target = "ALL"
		requestAndroid.TargetValue = "all"
		requestAndroid.Body = body
		requestAndroid.Title = body
		response, err := EmasClient.PushMessageToAndroid(requestAndroid)
		if err != nil {
			mylogrus.MyLog.Errorf("emas sendAndroidMsgAll fail, body:%v err:%v, response:%#v",body, err, response)
		} else {
			mylogrus.MyLog.Infof("emas sendAndroidMsgAll success body:%v", body)
		}
		return err*/
}

func SendIosMsgAll(body string) error {
	request := push.CreatePushRequest()
	request.Scheme = "https"

	request.AppKey = requests.Integer(config.GetEmasIosAppKey())
	request.PushType = "MESSAGE"
	request.DeviceType = "iOS"
	request.Target = "ALL"
	request.TargetValue = "ALL"
	request.Body = body
	request.Title = body
	request.StoreOffline = requests.NewBoolean(true)
	response, err := EmasClient.Push(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas sendIosMsgAll fail err:%v body:%v, response:%#v", err, body, string(buf))
	} else {
		mylogrus.MyLog.Infof("emas sendIosMsgAll success, body:%v", body)
	}
	return err
	/*	requestIos := push.CreatePushMessageToiOSRequest()
		requestIos.Scheme = "https"
		requestIos.AppKey = requests.Integer(config.GetEmasIosAppKey())
		requestIos.Target = "ALL"
		requestIos.TargetValue = "all"
		requestIos.Body = body
		requestIos.Title = body
		response, err := EmasClient.PushMessageToiOS(requestIos)
		if err != nil {
			mylogrus.MyLog.Errorf("emas sendIosMsgAll fail, body:%v, err:%v, response:%#v", body, err, response)
		} else {
			mylogrus.MyLog.Infof("emas sendIosMsgAll, success, body:%v", body)
		}
		return err*/
}

func QueryPushStatByMsg(messageId string) (push.PushStats, error) {
	request := push.CreateQueryPushStatByMsgRequest()
	request.Scheme = "https"
	request.AppKey = requests.Integer(config.GetEmasIosAppKey())
	request.MessageId = requests.Integer(messageId)
	response, err := EmasClient.QueryPushStatByMsg(request)
	if err != nil {
		buf, _ := json.Marshal(response)
		mylogrus.MyLog.Errorf("emas QueryPushStatByMsg fail err:%v messageId:%v, response:%#v", err, messageId, string(buf))
		return push.PushStats{}, err
	}
	return response.PushStats, nil
}

func init() {
	var err error
	EmasClient, err = push.NewClientWithAccessKey(config.GetEmasRegionId(), config.GetEmasAccessKeyId(), config.GetEmasAccessKeySecret())
	if err != nil {
		mylogrus.MyLog.Fatal(err)
	}
}
