package res_m

import (
	"git.hilo.cn/hilo-common/_const/common"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/myerr"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type ResMultiText struct {
	mysql.Entity
	MsgId    uint
	Language mysql.Str
	Content  mysql.Str
}

func (r *ResMultiText) Get(db *gorm.DB) error {
	return db.Where(r).First(r).Error
}

func GetResMultiTextBy(model *domain.Model, msgId uint, Language mysql.Str) (*ResMultiText, error) {
	r := ResMultiText{}
	if err := model.DB().Where(&ResMultiText{
		MsgId:    msgId,
		Language: Language,
	}).First(&r).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			if err := model.DB().Where(&ResMultiText{
				MsgId:    msgId,
				Language: common.DEFAULT_LANG,
			}).First(&r).Error; err != nil {
				return nil, myerr.WrapErr(err)
			}
		} else {
			return nil, myerr.WrapErr(err)
		}

	}
	return &r, nil
}
