package main

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"github.com/tealeg/xlsx"
	"time"
)

type GroupActivityAwardLog struct {
	GroupActId  uint64 // 活动id
	UserId      uint64 // 用户id
	ImGroupId   string // imGroupId
	Award       string
	CreatedTime string
}

type Award struct {
	ResGiftId uint64
	Num       int
}

type GroupActivityData struct {
	Country          string // 国家
	Area             string // 区域
	OwnerCode        string // 房主靓号
	GroupCode        string // 群组靓号
	AwardGift3111Num int    // 3111礼物id数量
	AwardGift3101Num int    // 3101礼物id数量
	AwardGift3091Num int    // 3091礼物id数量
	AwardPrice       int    // 总的礼物价值
	ActivityConsume  uint64 // 活动流水
	AwardTime        string // 奖励时间
}

type GroupActivity struct {
	Id      uint64
	StartAt int64
	EndAt   int64
}

func ats3(a interface{}) string {
	return fmt.Sprintf("%d", a)
}

func main() {
	var awardLogs []GroupActivityAwardLog
	if err := mysql.ProdReadOnlyDB.Model(GroupActivityAwardLog{}).Where("created_time < ?", "2023-03-17 12:15:18").Find(&awardLogs).Error; err != nil {
		panic(err)
	}
	var countrys []model.ResCountry
	if err := mysql.ProdReadOnlyDB.Model(model.ResCountry{}).Find(&countrys).Error; err != nil {
		panic(err)
	}
	cm := make(map[string]int)
	for _, c := range countrys {
		cm[c.Name] = c.Area
	}
	var data []GroupActivityData
	for _, log := range awardLogs {
		var user = new(model.User)
		if err := mysql.ProdReadOnlyDB.Table("user").Where("id = ?", log.UserId).First(user).Error; err != nil {
			panic(err)
		}
		var group = new(model.GroupInfo)
		if err := mysql.ProdReadOnlyDB.Table("group_info").Where("im_group_id = ?", log.ImGroupId).First(group).Error; err != nil {
			panic(err)
		}
		area := "阿语"
		if cm[user.Country] == 2 {
			area = "非阿语"
		}
		var awards []Award
		if err := json.Unmarshal([]byte(log.Award), &awards); err != nil {
			panic(err)
		}
		var num3111, num3101, num3091 int
		for _, a := range awards {
			if a.ResGiftId == 3111 {
				num3111 = a.Num
			}
			if a.ResGiftId == 3101 {
				num3101 = a.Num
			}
			if a.ResGiftId == 3091 {
				num3091 = a.Num
			}
		}
		var groupActivity = new(GroupActivity)
		if err := mysql.ProdReadOnlyDB.Model(GroupActivity{}).Where("id = ?", log.GroupActId).First(groupActivity).Error; err != nil {
			panic(err)
		}
		start := time.UnixMilli(groupActivity.StartAt)
		end := time.UnixMilli(groupActivity.EndAt)
		type summary struct {
			C       uint32
			Consume uint64
		}
		rows := make([]summary, 0)
		if err := mysql.ProdReadOnlyDB.Table("gift_operate").
			Select("COUNT(DISTINCT(send_user_id)) AS c, SUM(send_user_diamond) AS Consume").
			Where("scene_type = 4 AND scene_uid = ?", log.ImGroupId).
			Where("created_time BETWEEN ? AND ?", start, end).
			Find(&rows).Error; err != nil {
			panic(err)
		}
		consume := uint64(0)
		if len(rows) > 0 {
			consume = rows[0].Consume
		}
		data = append(data, GroupActivityData{
			Country:          user.Country,
			Area:             area,
			OwnerCode:        user.Code,
			GroupCode:        group.Code,
			AwardGift3111Num: num3111,
			AwardGift3101Num: num3101,
			AwardGift3091Num: num3091,
			AwardPrice:       num3111*10000 + num3101*3000 + num3091*1000,
			ActivityConsume:  consume,
			AwardTime:        log.CreatedTime,
		})
	}
	excelFileName := fmt.Sprintf("./群组扶持数据.xlsx")
	xlFile := xlsx.NewFile()
	sheet, _ := xlFile.AddSheet("charge")
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7, c8, c9, c10 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value =
		"国家", "区域", "房主靓号", "群组靓号", "3111礼物数量", "3101礼物数量", "3091礼物数量", "总的礼物价值", "活动流水", "奖励时间"
	for _, d := range data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7, c8, c9, c10 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value, c9.Value, c10.Value =
			d.Country, d.Area, d.OwnerCode, d.GroupCode, ats3(d.AwardGift3111Num), ats3(d.AwardGift3101Num), ats3(d.AwardGift3091Num), ats3(d.AwardPrice), ats3(d.ActivityConsume), d.AwardTime
	}
	_ = xlFile.Save(excelFileName)
}
