package main

import (
	"fmt"
	model2 "git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	uuid "github.com/satori/go.uuid"
	"strings"
)

/*
# redis 事务拿出3000个code
MULTI
LRANGE USER_CODE 0 2999
LTRIM USER_CODE 3000 -1
exec
*/
var codes = []string{"1384891", "1387474", "1379229", "1382208", "1385588", "1384219", "1387250", "1386050", "1385145", "1384131", "1379899", "1378039", "1378652", "1384610", "1384331", "1379038", "1383215", "1383941", "1378895", "1387750", "1381181", "1378742", "1385928", "1384913", "1382887", "1378537", "1387797", "1384050", "1387423", "1379889", "1385325", "1381724", "1381641", "1384721", "1382095", "1381067", "1385285", "1379171", "1382658", "1378496", "1381677", "1386298", "1381876", "1380575", "1378675", "1380325", "1383050", "1385554", "1380526", "1385429", "1386109", "1384869", "1381799", "1381101", "1381755", "1385665", "1384402", "1380546", "1384737", "1383094", "1384557", "1387961", "1380166", "1381880", "1385857", "1379627", "1383710", "1378858", "1381698", "1384091", "1378436", "1382451", "1380509", "1384983", "1384293", "1379352", "1381793", "1386619", "1378796", "1384071", "1383465", "1385608", "1380193", "1381721", "1382722", "1384834", "1382329", "1379123", "1379084", "1386273", "1381307", "1385713", "1382486", "1383445", "1380764", "1381866", "1387216", "1384000", "1381867", "1379721", "1387494", "1387975", "1385872", "1386986", "1382003", "1384425", "1379281", "1385176", "1379679", "1382213", "1385607", "1386677", "1382106", "1383468", "1383189", "1385120", "1379224", "1386522", "1383476", "1384436", "1380260", "1380718", "1386910", "1380549", "1381400", "1380595", "1382930", "1385899", "1387347", "1381720", "1381178", "1379402", "1384312", "1386549", "1379962", "1380194", "1386157", "1386029", "1387067", "1378054", "1380707", "1384974", "1385541", "1387971", "1381121", "1381823", "1380894", "1384473", "1384944", "1387442", "1380381", "1378084", "1381077", "1382846", "1378548", "1387041", "1384852", "1385756", "1380199", "1386657", "1379318", "1383430", "1383433", "1384369", "1385782", "1383686", "1385694", "1379909", "1383238", "1383060", "1378824", "1386728", "1378818", "1383392", "1379617", "1382726", "1379842", "1378410", "1386938", "1380334", "1382261", "1380895", "1380210", "1384647", "1383422", "1380122", "1384417", "1383726", "1384349", "1379852", "1379192", "1386516", "1385863", "1378672", "1384410", "1378443", "1387393", "1380576", "1383872", "1381047", "1383161", "1381863", "1382972", "1380938", "1385330", "1379440", "1384503", "1386779", "1380975", "1380633", "1381593", "1385915", "1382717", "1379128", "1378197", "1381039", "1380064", "1386512", "1384489", "1382360", "1379683", "1380475", "1379648", "1383384", "1381083", "1384526", "1378495", "1385038", "1387734", "1387968", "1382867", "1383711", "1378292", "1381023", "1382978", "1381472", "1384240", "1382772", "1379385", "1384101", "1383936", "1382467", "1379906", "1380820", "1379955", "1381809", "1387696", "1384533", "1386484", "1386647", "1386190", "1383722", "1387262", "1386115", "1380397", "1387382", "1384233", "1380026", "1382770", "1386525", "1383777", "1385409", "1384467", "1383472", "1385696", "1379081", "1382181", "1384306", "1378407", "1386434", "1382945", "1387532", "1378549", "1382965", "1378632", "1386457", "1378885", "1385487", "1378829", "1385839", "1380316", "1383480", "1385054", "1382435", "1380376", "1380188", "1378786", "1381519", "1379494", "1387386", "1383097", "1380249", "1379578", "1386980", "1379441", "1381449", "1386084", "1380239", "1383795", "1387090", "1381623", "1380310", "1381985", "1379462", "1384367", "1379624", "1386541", "1378381", "1378255", "1379612", "1379795", "1383005", "1384534", "1379239", "1383356", "1383807", "1380649", "1384715", "1385210", "1382551", "1378722", "1384151", "1379585", "1385277", "1381263", "1384110", "1379579", "1382109", "1386531", "1386978", "1378949", "1378961", "1381668", "1383533", "1378533", "1384490", "1379957", "1383323", "1386590", "1381868", "1379383", "1387249", "1378217", "1384399", "1383167", "1383347", "1385641", "1387507", "1381853", "1380169", "1379718", "1386916", "1380211", "1385448", "1379214", "1384291", "1382793", "1384774", "1378524", "1378550", "1387851", "1385377", "1380674", "1378832", "1384734", "1387815", "1380100", "1379988", "1387486", "1378363", "1379745", "1385772", "1387220", "1381408", "1381404", "1378259", "1385293", "1387384", "1383165", "1383233", "1378518", "1383713", "1386324", "1387085", "1378711", "1385341", "1380168", "1384469", "1380302", "1381324", "1379572", "1378120", "1379746", "1386759", "1386663", "1379259", "1382376", "1378226", "1387841", "1385794", "1379152", "1379813", "1386638", "1386368", "1384315", "1379100", "1384250", "1381106", "1387794", "1383540", "1383450", "1385374", "1385981", "1379327", "1379073", "1386162", "1386648", "1380274", "1383946", "1381428", "1383147", "1379998", "1381607", "1380097", "1378269", "1385071", "1383381", "1385806", "1383765", "1380620", "1387418", "1384209", "1379333", "1385023", "1386545", "1379875", "1382231", "1378641", "1383258", "1379893", "1380090", "1378544", "1387837", "1380813", "1383328", "1382784", "1383411", "1385383", "1378682", "1381642", "1378815", "1379484", "1381787", "1382573", "1379191", "1378328", "1378016", "1387472", "1384249", "1381523", "1383359", "1380555", "1378825", "1382091", "1379439", "1383467", "1379102", "1383139", "1383776", "1380599", "1379004", "1387240", "1387018", "1380222", "1386353", "1381953", "1379798", "1383391", "1382027", "1384636", "1383712", "1382549", "1380840", "1380912", "1386149", "1387214", "1383567", "1387069", "1384714", "1385077", "1384569", "1381508", "1380001", "1383008", "1382904", "1381885", "1383440", "1384004", "1383582", "1382185", "1385147", "1378121", "1385162", "1381299", "1380661", "1386415", "1386530", "1379879", "1387443", "1385455", "1387358", "1386467", "1379308", "1381757", "1386727", "1378889", "1386575", "1380744", "1383025", "1378316", "1378312", "1380902", "1379197", "1381549", "1384220", "1385279", "1386395", "1387482", "1385833", "1383039", "1386203", "1379616", "1384954", "1386927", "1387721", "1378617", "1381015", "1385228", "1386370", "1382881", "1384133", "1385661", "1379766", "1387164", "1379355", "1386735", "1380876", "1382312", "1379528", "1387397", "1379256", "1386893", "1387273", "1384529", "1382021", "1388195", "1392767", "1389031", "1393453", "1395114", "1393278", "1394469", "1390039", "1396089", "1397235", "1388241", "1393500", "1390233", "1394839", "1393583", "1393906", "1393443", "1392540", "1393556", "1388846", "1397841", "1395615", "1389378", "1392168", "1393468", "1396621", "1392539", "1390237", "1388153", "1395022", "1391252", "1396318", "1389544", "1397997", "1396854", "1392836", "1389486", "1393665", "1397934", "1394049", "1394265", "1390614", "1391445", "1392106", "1396160", "1390467", "1394221", "1388272", "1397798", "1393005", "1392230", "1394766", "1388052", "1397914", "1389246", "1391609", "1390699", "1394025", "1392480", "1397795", "1396384", "1393546", "1397360", "1390477", "1388271", "1393295", "1397226", "1390220", "1391220", "1393524", "1391887", "1391936", "1392571", "1395548", "1395838", "1395212", "1391035", "1390085", "1389352", "1397823", "1397649", "1389926", "1389571", "1391451", "1396606", "1391167", "1388005", "1395575", "1390090", "1393603", "1389588", "1389592", "1394965", "1396631", "1395052", "1390636", "1394144", "1397635", "1389718", "1397177", "1390956", "1395616", "1396915", "1396929", "1389958", "1392750", "1395660", "1396323", "1397197", "1388584", "1395606", "1390890", "1394414", "1392903", "1394787", "1393698", "1397434", "1390375", "1388416", "1393697", "1396771", "1389782", "1394453", "1390362", "1389257", "1396597", "1393248", "1392570", "1395439", "1397937", "1397919", "1395784", "1389446", "1397514", "1394552", "1396184", "1389576", "1395502", "1397603", "1394065", "1394854", "1397779", "1388941", "1397943", "1397153", "1388373", "1392006", "1390175", "1391861", "1392417", "1388956", "1391202", "1393020", "1391681", "1391171", "1396027", "1389029", "1393274", "1395366", "1389628", "1388179", "1394850", "1395869", "1392166", "1392169", "1395800", "1391097", "1392066", "1396408", "1396989", "1395186", "1388748", "1392634", "1395882", "1388546", "1394722", "1396293", "1388391", "1393391", "1395517", "1395132", "1392243", "1388233", "1393168", "1390424", "1397870", "1396377", "1390516", "1394304", "1394377", "1389406", "1390173", "1389823", "1390053", "1389131", "1389087", "1392899", "1390372", "1391546", "1391219", "1391409", "1390936", "1395988", "1389228", "1391596", "1391213", "1395153", "1388229", "1392299", "1396361", "1391995", "1389079", "1396197", "1393682", "1389822", "1390457", "1390950", "1393092", "1395565", "1393352", "1391216", "1396721", "1389593", "1393207", "1388130", "1396782", "1390186", "1393581", "1397958", "1393231", "1388680", "1397355", "1390730", "1390044", "1389397", "1392942", "1394790", "1394573", "1395718", "1393786", "1388740", "1388569", "1394625", "1388618", "1397579", "1389043", "1389442", "1397517", "1397169", "1393323", "1396946", "1395835", "1395531", "1392641", "1389968", "1392912", "1388987", "1391510", "1394534", "1395421", "1389382", "1389626", "1393001", "1396142", "1392088", "1395320", "1397907", "1392777", "1394946", "1395176", "1395050", "1390528", "1394051", "1396772", "1396753", "1391285", "1389808", "1392527", "1388146", "1388087", "1390561", "1392419", "1391732", "1388605", "1393903", "1388852", "1390215", "1390356", "1391901", "1397280", "1389285", "1391580", "1394097", "1390712", "1388683", "1397060", "1397502", "1394029", "1389115", "1391627", "1392295", "1388252", "1393889", "1393255", "1393385", "1392101", "1388630", "1397320", "1391450", "1394966", "1389189", "1392314", "1390047", "1390170", "1389707", "1396061", "1394925", "1395216", "1393865", "1396433", "1391760", "1391910", "1394141", "1395885", "1397326", "1396126", "1390435", "1396216", "1396839", "1391380", "1396687", "1397830", "1393762", "1397310", "1391364", "1397124", "1396015", "1389877", "1395091", "1393757", "1395071", "1389451", "1390399", "1397512", "1397842", "1391701", "1395073", "1390510", "1391125", "1397118", "1392387", "1395641", "1393681", "1394857", "1394505", "1397429", "1394044", "1397718", "1393181", "1389311", "1396378", "1397304", "1396344", "1394088", "1393792", "1393377", "1391254", "1394994", "1396459", "1392252", "1395470", "1397151", "1391674", "1395371", "1394609", "1390157", "1396048", "1396493", "1395016", "1392934", "1392928", "1389508", "1394571", "1389957", "1392937", "1394768", "1394898", "1389745", "1388744", "1394570", "1394775", "1388627", "1394876", "1393310", "1392460", "1391082", "1396056", "1390839", "1389171", "1394801", "1393854", "1390834", "1393804", "1397044", "1394756", "1395259", "1394147", "1391300", "1388591", "1395941", "1389388", "1390947", "1396214", "1397370", "1397068", "1397607", "1392194", "1390815", "1396735", "1394995", "1394383", "1388002", "1389538", "1388583", "1389000", "1395457", "1396440", "1394371", "1393610", "1397908", "1396267", "1394060", "1392813", "1392709", "1394435", "1390278", "1392189", "1388926", "1390130", "1394000", "1393860", "1394259", "1394376", "1397632", "1394553", "1390064", "1389145", "1395214", "1393701", "1390968", "1392917", "1388381", "1392154", "1388066", "1395253", "1397839", "1390893", "1390363", "1391094", "1388535", "1396579", "1395161", "1392543", "1392116", "1390267", "1395463", "1394047", "1395804", "1394217", "1390790", "1396650", "1388673", "1394709", "1390843", "1397980", "1394403", "1390774", "1391362", "1397381", "1394538", "1397560", "1388447", "1397926", "1390191", "1388945", "1390421", "1390957", "1396586", "1395925", "1397513", "1388480", "1391641", "1395523", "1396528", "1395769", "1392361", "1392119", "1391742", "1392897", "1396898", "1394776", "1396824", "1388456", "1388439", "1391937", "1391988", "1397491", "1390891", "1394757", "1393530", "1395475", "1395075", "1395883", "1388221", "1395224", "1394186", "1397538", "1390316", "1392545", "1393406", "1393138", "1388224", "1391119"}

func main() {
	println(len(codes)) // 1078个key的
	var testRobots []model2.UserNoId
	sql := "SELECT *  FROM `user` where id BETWEEN 4564 and 7615 limit 1078"
	if err := mysql.TestDB.Raw(sql).Find(&testRobots).Error; err != nil {
		panic(err)
	}
	if len(codes) != len(testRobots) {
		panic("len no right")
	}
	for i, user := range testRobots {
		user.ExternalId = GetUUID() // 重新生成新的externalId
		user.Code = codes[i]        // code赋值
		user.OriginCode = user.Code
		fmt.Printf("user:%v", user)
		// 写线上mysql！！！
		if err := mysql.ProdWriteDB.Create(user).Error; err != nil {
			fmt.Printf("create fail:%v-%v", user, err)
		}
		//break
	}
	var userIds []uint64
	if err := mysql.ProdReadOnlyDB.Model(model2.User{}).Select("id").Where("code in ?", codes).Find(&userIds).Error; err != nil {
		panic("get user id fail")
	}
	for _, userId := range userIds {
		gameRobot := &model2.GameRobot{UserId: userId}
		if err := mysql.ProdWriteDB.Create(gameRobot).Error; err != nil {
			fmt.Printf("create robot fail:%v-%v", gameRobot, err)
		}
	}
}

func GetUUID() string {
	return strings.Replace(uuid.NewV4().String(), "-", "", -1)
}
