package main

import (
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
)

func main() {
	var powerOwners []model.GroupPowerUser
	if err := mysql.ProdReadOnlyDB.Model(model.GroupPowerUser{}).Where("role = 2").Find(&powerOwners).Error; err != nil {
		panic(err)
	}
	for _, owner := range powerOwners {
		var groupInfo model.GroupInfo
		if err := mysql.ProdReadOnlyDB.Model(model.GroupInfo{}).Where("owner = ?", owner.UserId).First(&groupInfo).Error; err != nil {
			continue
		}
		if owner.GroupPowerId <= 0 {
			panic("0 powerId")
		}
		if err := mysql.ProdWriteDB.Model(model.GroupPower{}).Where("id = ?", owner.GroupPowerId).UpdateColumn("icon", groupInfo.FaceUrl).Error; err != nil {
			panic(err)
		}
		//break
	}
}
