package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"git.hilo.cn/hilo-common/script/utils/jwt"
	"io/ioutil"
	"net/http"
	"strings"
	"time"
)

var micCodes2 = []string{"1000628", "1000629", "1000630", "1000631", "1000632", "1000633", "1000634", "1000635", "1000636", "1000637", "1000638", "1000639", "1000651", "1000652", "1000653", "1000660", "1000661", "1000662", "1000663", "1000675", "1000676", "1000685", "1000686", "1000687", "1000689", "1000690", "1000691", "1000702", "1000703", "1000704", "1000705", "1000706", "1000707", "1000710", "1000711", "1000712", "1000713", "1000714", "1000717", "1000718", "1000719", "1000720", "1000723", "1000724", "1000733", "1000734", "1000741", "1000749", "1000755", "1000756", "1000757", "1000758", "1000759", "1000760", "1000761", "1000762", "1000763", "1000764", "1000765", "1000766", "1000767", "1000768", "1000769", "1000770", "1000771", "1000772", "1000773", "1000774", "1000775", "1000776", "1000777", "1000778", "1000779", "1000780", "1000781", "1000782", "1000783", "1000784", "1000785", "1000787", "1000788", "1000789", "1000790", "1000792", "1000794", "1000795", "1000810", "1000830", "1000831", "1000835", "1000836", "1000839", "1000840", "1000841", "1000842", "1000843", "1000844", "1000845", "1000846", "1000847", "1000848", "1000849", "1000850", "10100", "1000852", "1000853", "1000854", "1000688", "1000856", "1000857", "1000858", "1000859", "1000860", "1000861", "1000862", "1000863", "1000864", "1000865", "1000866", "1000867", "1000868", "1000869", "1000870", "1000871", "1000872", "1000873", "666", "", "56", "1000875", "1000890", "1000891", "1000892", "1000893", "1000894", "1000895", "1000896", "1000897", "1000898", "1000899", "1000900", "1000901", "1000902", "1000903", "1000904", "1000905", "10009053", "1", "10009055", "10009056", "10009057", "2", "10009059", "222", "10009061", "22", "10009063", "10009064", "10009065", "10009066", "10009067", "10009068", "10009069", "10009070", "10009071", "1113", "10009073", "10009074", "10009075", "10009076", "10009077", "10009078", "10009079", "10009080", "10009081", "10009082", "10009083", "10009084", "10009085", "10009086", "10009087", "10009088", "10009089", "10009090", "10009091", "10009092", "10009093", "10009094", "10009095", "10009096", "10009097", "10009098", "A11111", "10009100", "10009101", "104", "10009103", "777", "10009105", "111111", "10028956", "10023979", "10021808", "10021480", "10025751", "10026454", "1827", "1099643", "1099645", "1099646", "1099649", "1099650", "1099654", "1099656", "1099658", "1099659", "1099669", "1099673", "1099675", "1099685", "1099687", "1099693", "1099702", "1099704", "1099705", "1099706", "1099708", "1099709", "100711", "1099717", "1099718", "1099724", "1099725", "1099728", "1099737", "1099739", "1099740", "1099742", "1099743", "1099746", "450045", "1099753", "1099754", "1099762", "1099764", "1099768", "1099778", "1099780", "1099781", "1099782", "1099786", "1099788", "1099789", "1099800", "1099804", "1099807", "1099810", "1099816", "1099820", "1099824", "1099830", "1099832", "1099836", "1099841", "1099848", "1099853", "1099863", "1099865", "1099869", "1099870", "1099875", "1099882", "1099888", "1099896", "1099897", "14333", "1099900", "1099903", "1099909", "1099938", "1099940", "1099946", "1099948", "1099949", "1099951", "1099985", "1099990", "1099994", "1099999", "1000192", "1100007", "1100011", "1100024", "1100029", "1100033", "1100037", "1100046", "1100048", "1100050", "1100054", "1100055", "1100057", "1100059", "1100062", "1100065", "1100070", "1100072", "1100073", "78786", "1100079", "1100080", "1100084", "1100085", "1100092", "1100093", "1100094", "1100096", "1100097", "1100100", "1100105", "1100109", "1100111", "1100114", "1100116", "1100120", "22225", "1100127", "1100129", "1100130", "1100138", "1100139", "1100141", "1100142", "1100144", "1100145", "1100147", "1100150", "1100153", "1100163", "1100165", "1100167", "1100168", "1100169", "1100173", "1100174", "1100175", "1100176", "1100178", "1100183", "1100197", "1100205", "1100209", "1100212", "1100222", "1100229", "1100232", "1100236", "1100241", "1100245", "1100247", "1100250", "1100254", "1100256", "1100259", "1100260", "1100266", "1100276", "1100279", "1100280", "1100281", "1100286", "1100288", "1100289", "1100290", "1100292", "1100295", "1100297", "1100300", "1100304", "1100317", "1100323", "1100342", "1100344", "1100349", "1100351", "1100352", "1100361", "1100363", "1100368", "1100369", "1100375", "1100379", "1100380", "55505", "1100382", "1100383", "1100385", "1100390", "1100392", "1100402", "1100405", "1100407", "1100408", "1100409", "1100411", "1100415", "1100421", "1100427", "1100438", "1100450", "1100452", "1100456", "1100458", "1100459", "1100468", "1100471", "1100476", "1100480", "1100482", "1100490", "1100511", "1100518", "1100519", "1100520", "1100521", "1100523", "1100531", "1100532", "1100536", "1100538", "1100539", "1100547", "1100553", "1100563", "1100565", "1100566", "1100567", "1100569", "1100573", "1100574", "1100579", "1100580", "1100581", "1100590", "1100593", "1100600", "1100601", "1100610", "1100613", "1100614", "1100617", "1100619", "1100621", "1100622", "1100626", "1100636", "1100639", "1100640", "1100642", "1100657", "1100667", "1100669", "1100675", "1100702", "1100703", "1100717", "1100732", "1100738", "1100742", "444555", "1100751", "1100753", "1100755", "1100765", "1100769", "1100770", "110077", "1100773", "1100789", "1100790", "30004", "1100796", "111009", "1100807", "1100811", "1100812", "1100815", "1100819", "1100822", "1100823", "1100825", "1100841", "1100843", "1100853", "1100856", "1100859", "1100863", "1100865", "1100870", "1100873", "1100874", "1100876", "1100879", "1100883", "300002", "1100886", "1100900", "1100909", "1100910", "112233", "1100915", "1100920", "1100923", "1100925", "1100926", "1100933", "1100937", "1100941", "1100942", "1100945", "1100948", "1100952", "1100954", "1100956", "1100958", "1100959", "1100961", "1100962", "1100963", "1100966", "1100968", "1100970", "1100974", "1100979", "1100980", "1100983", "1100984", "1100989", "1100990", "1100991", "1100994", "1100995", "1100999", "1101000", "1101006", "1101011", "340007", "1101014", "1101015", "1101016", "1101044", "1101048", "1101049", "1101060", "1101063", "1101065", "1101066", "1101067", "1101081", "1101094", "1101098", "1101123", "1101124", "1101126", "1101130", "1101131", "1101136", "1101137", "1101138", "1101141", "1101146", "1101148", "1101149", "1101153", "1101157", "20001", "1101160", "1101161", "1101166", "556", "1101175", "1101181", "1101183", "1101184", "1101191", "1101194", "1101203", "1101205", "1101207", "200019", "1101213", "1101222", "1101224", "1101226", "1101227", "1101231", "70020", "1101250", "1101255", "1101259", "1101263", "1101272", "1101274", "353535", "1101280", "1101281", "1101283", "1101284", "1101286", "1101290", "1101292", "21212", "1101297", "1101300", "1101304", "1101311", "1101314", "1101316", "1101318", "1101319", "1101323", "1101324", "1101326", "1101328", "1101329", "1101332", "1101333", "1101335", "1101336", "1101337", "1101339", "1101342", "1101343", "1101344", "500004", "1101349", "1101351", "1101354", "1101357", "20002", "1101360", "1101364", "1101366"}

func main() {
	var users []model.User
	if err := mysql.TestDB.Model(model.User{}).Where("code in ?", micCodes2).Find(&users).Error; err != nil {
		panic(err)
	}
	for _, user := range users {
		url := "https://test.apiv1.faceline.live/v1/imGroup/in"
		method := "PUT"

		payload := strings.NewReader("groupId=HTGS%23a56194639&i=")

		client := &http.Client{}
		req, err := http.NewRequest(method, url, payload)

		if err != nil {
			fmt.Println(err)
			return
		}
		token, _ := jwt.GenerateToken(user.Id, user.ExternalId, "hiloApi")
		req.Header.Add("nonce", "hilo")
		req.Header.Add("token", token)
		req.Header.Add("deviceType", "android")
		req.Header.Add("appVersion", "99.99.99")
		req.Header.Add("Content-Type", "application/x-www-form-urlencoded")

		res, err := client.Do(req)
		if err != nil {
			fmt.Println(err)
			return
		}
		body, _ := ioutil.ReadAll(res.Body)
		println(string(body))
		res.Body.Close()
		time.Sleep(time.Millisecond * 500)
	}
}
