package ride_tx

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/internal/enum/property_e"
	"git.hilo.cn/hilo-common/internal/model/msg_m"
	"git.hilo.cn/hilo-common/internal/model/res_m"
	"git.hilo.cn/hilo-common/internal/model/user_m"
	"git.hilo.cn/hilo-common/resource/mysql"
	"strconv"
	"time"
)

// 下发座驾
func SendRide(model *domain.Model, receiverUserId mysql.ID, rideId mysql.ID, days int) error {
	// 增加座驾
	receivePropertyDuration := uint32(days) * 3600 * 24
	userProperty, err := user_m.GetUserPropertyOrInit(model, receiverUserId, rideId)
	if err != nil {
		return err
	}
	nowTime := time.Now()
	if userProperty.EndTime.After(nowTime) {
		nowTime = userProperty.EndTime
	}
	userProperty.EndTime = nowTime.Add(time.Duration(receivePropertyDuration) * time.Second)
	if err := userProperty.Persistent(); err != nil {
		return err
	}
	//日志错误，并不事务回调
	if err := (&user_m.UserPropertyLog{
		Model:         model,
		UserId:        receiverUserId,
		PropertyId:    rideId,
		OriginType:    property_e.ActivityBillboardTrigger,
		Type:          property_e.AddSecond,
		AddSecond:     &receivePropertyDuration,
		UpdateEndTime: nil,
	}).Persistent(); err != nil {
		model.Log.Error(err)
	}
	// 配套小助手
	go func() {
		model := domain.CreateModelContext(model.MyContext)
		resProperty := res_m.ResProperty{}
		if err := model.Db.Model(&res_m.ResProperty{}).First(&resProperty, rideId).Error; err != nil {
			model.Log.Errorf("SendRide get ResProperty fail:%v", err)
			return
		}
		user, err := user_m.GetUser(model, receiverUserId)
		if err != nil {
			model.Log.Errorf("SendRide GetUser fail:%v", err)
			return
		}
		if err := msg_m.NewUserRecord(model, user.ID, msg_e.AddProps, user.Nick, user.ID, "", strconv.Itoa(int(days)), resProperty.PicUrl, "", "").Persistent(); err != nil {
			model.Log.Errorf("SendRide NewUserRecord fail:%v", err)
			return
		}
		//推送msg
		_ = msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
	}()
	return nil
}
