package timezone_e

import (
	"regexp"
	"strconv"
	"time"
)

type Timezone int

const (
	TimezoneBeijing Timezone = 0
	TimezoneKSA     Timezone = 1
)

var Timezones = []Timezone{TimezoneBeijing, TimezoneKSA}
var (
	BeijingTimezoneLoc = time.FixedZone("CST", 8*3600) // 东八
	KSATimezoneLoc     = time.FixedZone("CST", 3*3600) // 东三
)

var TimezoneLocMap = map[Timezone]*time.Location{
	TimezoneBeijing: BeijingTimezoneLoc,
	TimezoneKSA:     KSATimezoneLoc,
}

// 根据header的Timezone获取时区
// return nil: 无法解析
func GetFixedTimezone(tz string) *time.Location {
	re := regexp.MustCompile(`\d+`)
	timeZone := re.FindString(tz)
	offset, _ := strconv.Atoi(timeZone)
	if offset <= 0 {
		return nil
	}
	return time.FixedZone("CST", offset*3600)
}
