package rediskey

import (
	"fmt"
	"git.hilo.cn/hilo-common/utils"
	"strings"
	"time"
)

func GetSlotFruitDailyTimes(userId uint64, nowTime time.Time) string {
	var cstZone = time.FixedZone("CST", 3*3600) // 东三区，沙特时间
	return fmt.Sprintf(SlotFruitWeeklyDailyTask, nowTime.In(cstZone).Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanChargeAwardTimes(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanChargeAwardTimes, actId, userId)
}

func GetOpenRamadanTaskTimesMic(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesMic, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesLudo(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesLudo, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesFruit(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesFruit, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesSlot(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesSlot, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesEnter(actId, userId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesEnter, actId, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetOpenRamadanTaskTimesRoom(actId, userId, roomId uint64) string {
	return fmt.Sprintf(OpenRamadanTaskTimesRoom, actId, time.Now().Format(utils.DATE_FORMAT), userId, roomId)
}

func GetOpenRamadanFruitBet(actId, userId uint64, round uint, date string) string {
	return fmt.Sprintf(OpenRamadanFruitBet, actId, date, userId, round)
}

func GetConvertToTRTCNum() string {
	return fmt.Sprintf(ConvertToTRTCNum, time.Now().Format(utils.DATE_FORMAT))
}

func GetUserTmpActId(relateId, userId uint64) string {
	return fmt.Sprintf(TmpActUserActId, relateId, userId)
}

func GetActChargeDiamond(userId, actId uint64) string {
	if actId > 500 {
		return fmt.Sprintf(ActIdChargeDiamond, actId, time.Now().Format(utils.DATE_FORMAT), userId)
	}
	return fmt.Sprintf(ActChargeDiamond, time.Now().Format(utils.DATE_FORMAT), userId)
}

func GetActChargeGetPoint(userId, actId uint64, dollar int64) string {
	if actId > 500 {
		return fmt.Sprintf(ActIdChargeGetPoint, actId, time.Now().Format(utils.DATE_FORMAT), dollar, userId)
	}
	return fmt.Sprintf(ActChargeGetPoint, time.Now().Format(utils.DATE_FORMAT), dollar, userId)
}

func GetMonthChargeTimes(userId uint64) string {
	var cstZone = time.FixedZone("CST", 3*3600) // 东三区，沙特时间
	return fmt.Sprintf(MonthChargeTimes, time.Now().In(cstZone).Format(utils.MONTH_FORMAT), userId)
}

func GetRamadanDailyTaskGet(actId, userId uint64, nowTime time.Time) string {
	return fmt.Sprintf(RamadanDailyTaskGet, nowTime.Format(utils.DATE_FORMAT), actId, userId)
}

func GetRamadanGetDailyLottery(actId, userId uint64) string {
	return fmt.Sprintf(RamadanGetDailyLottery, time.Now().Format(utils.DATE_FORMAT), actId, userId)
}

func GetCronLockKey(subKey string) string {
	return strings.Replace(cronLock, "{subKey}", subKey, -1)
}

func GetActIpAwardTimesKey(actId uint64, awardType, level int, ip string) string {
	return fmt.Sprintf(ActIpGetAwardTimes, actId, awardType, level, ip)
}

func GetActImeiAwardTimesKey(actId uint64, awardType, level int, device string) string {
	return fmt.Sprintf(ActImeiGetAwardTimes, actId, awardType, level, device)
}
