package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"git.hilo.cn/hilo-common/utils/jwt"
	"net/http"
	"strings"
	"time"
)

var micCodes = []string{"1000653", "1000516", "1000675", "1000890", "1000755", "1000593", "1000629", "1000634", "1000765", "1000591", "1000633", "1000224", "1000611", "1000689", "1000467", "1000384", "1000367", "1000623"}

func main() {
	var users []model.User
	if err := mysql.TestDB.Model(model.User{}).Where("code in ?", micCodes).Find(&users).Error; err != nil {
		panic(err)
	}
	for _, user := range users {
		url := "https://test.apiv1.faceline.live/v1/imGroup/mic/in"
		method := "POST"

		payload := strings.NewReader("groupUuid=HTGS%23a56194639&i=")

		client := &http.Client{}
		req, err := http.NewRequest(method, url, payload)

		if err != nil {
			fmt.Println(err)
			return
		}
		token, _ := jwt.GenerateToken(user.Id, user.ExternalId, "hiloApi")
		req.Header.Add("nonce", "hilo")
		req.Header.Add("token", token)
		req.Header.Add("Content-Type", "application/x-www-form-urlencoded")

		res, err := client.Do(req)
		if err != nil {
			fmt.Println(err)
			return
		}
		res.Body.Close()
		time.Sleep(time.Second * 2)
	}
}
