package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
)

func main() {
	//uids := []uint64{889621, 904971, 1072931, 1083981, 1108951, 1147471, 1187511, 1365041, 1496521, 1540091, 1888121, 2037771, 2236221, 2396461, 2603721, 2613321, 2648851, 2778081, 3142631, 3219391, 3401561, 3533911, 3602511, 3791481, 3840571, 3845671, 3865481, 3873381, 3892321, 4009941}
	var uids []uint64
	if err := mysql.ProdReadOnlyDB.Raw("select id from user where origin_code <> `code`").Find(&uids).Error; err != nil {
		panic(err)
	}
	var users []model.User
	if err := mysql.ProdReadOnlyDB.Model(model.User{}).Where("id in ?", uids).Find(&users).Error; err != nil {
		panic(err)
	}
	uM := make(map[uint64]model.User)
	for k, u := range users {
		uM[u.Id] = users[k]
	}
	var data = make(map[uint64]int64)
	for _, uid := range uids {
		m1, _ := GetUsersChargeMoneySum([]uint64{uid})
		m2, _ := GetUserDealerTransferMoneySum([]uint64{uid})
		data[uid] = m1 + m2
	}
	for uid, num := range data {
		fmt.Printf("%d,%s,%d\n", uid, uM[uid].Country, num)
	}
}

// 获取用户范围内充值金额
// param sinceTime: 过去n时间内
// 返回美分
func GetUsersChargeMoneySum(uids []uint64) (int64, error) {
	if len(uids) <= 0 {
		return 0, nil
	}
	type R struct {
		Money int64
	}
	var money R
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN pay_order AS p ON d.origin_id = p.id").
		Where("d.user_id in (?) AND operate_type in (?) AND add_reduce = 1",
			uids, []int{int(4), int(42), int(55), int(68)}).
		Select("SUM(p.price) as money").Scan(&money).Error; err != nil {
		return 0, err
	}
	return money.Money, nil
}

// 获取代理范围内总充值金额
// param sinceTime: 过去n时间内
// 返回美分
func GetUserDealerTransferMoneySum(uids []uint64) (int64, error) {
	if len(uids) <= 0 {
		return 0, nil
	}
	type R struct {
		Price int64
	}
	var money R
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN dealer_transfer_detail AS t ON d.origin_id = t.id").
		Where("d.user_id in (?) AND operate_type = ? AND add_reduce = 1",
			uids, 26).Select("SUM(t.dollar) as price").
		Scan(&money).Error; err != nil {
		return 0, err
	}
	return money.Price, nil
}
