package redisCli

import (
	"context"
	"git.hilo.cn/hilo-common/mylogrus"
	"time"
)

//这个用户避免多个服务器并发问题。
func SetNX(key string, value interface{}, expiration time.Duration, callBack func()) {
	flag, err := RedisClient.SetNX(context.Background(), key, value, expiration).Result()
	if err != nil {
		mylogrus.MyLog.Errorf("key:%v lock start setNx err: %v", key, err)
	}
	if !flag {
		mylogrus.MyLog.Infof("key:%v lock setNx has lock", key)
		return
	}
	mylogrus.MyLog.Infof("key:%v lock setNx begin", key)
	callBack()
	//执行结束之后，移除key
	//RedisClient.Del(context.Background(), key)
	mylogrus.MyLog.Infof("key:%v lock setNx end", key)
}

func Lock(key string, expiration time.Duration) bool {
	flag, err := RedisClient.SetNX(context.Background(), key, 1, expiration).Result()
	if err != nil {
		return false
	}
	if !flag {
		return false
	}
	return true
}
