package msg

import (
	"fmt"
	"git.hilo.cn/hilo-common/_const/common"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/internal/model/msg_m"
	"git.hilo.cn/hilo-common/internal/model/res_m"
	"git.hilo.cn/hilo-common/internal/model/user_m"
	"git.hilo.cn/hilo-common/myerr"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/utils"
	"gorm.io/gorm"
)

// 发送小助手消息
func SendLittleAssistantMsg(model *domain.Model, userId mysql.ID, t msg_e.MsgUserRecordType, diamondIncome mysql.Str,
	dayNum mysql.Str, propertyUrl mysql.Str, beanNum mysql.Str, groupCode mysql.Str, users ...*user_m.User) (err error) {
	defer utils.CheckGoPanic()
	var user *user_m.User
	if len(users) > 0 {
		user = users[0]
	} else {
		user, err = user_m.GetUser(model, userId)
		if err != nil {
			model.Log.Errorf("SendLittleAssistantMsg GetUser userId:%v, err:%v", userId, err)
			return err
		}
	}
	if t > 0 {
		if err = msg_m.NewUserRecord(model, user.ID, t, user.Nick, user.ID, diamondIncome, dayNum, propertyUrl, beanNum, groupCode).Persistent(); err != nil {
			model.Log.Errorf("SendLittleAssistantMsg NewUserRecord err:%v", err)
			return err
		}
	}
	// 异步emas提醒
	go func() {
		defer utils.CheckGoPanic()
		err = msg_m.SendEmasMsgAssistant(domain.CreateModelContext(model.MyContext), user.ExternalId, user.DeviceType)
		if err != nil {
			model.Log.Errorf("SendLittleAssistantMsg SendEmasMsgAssistant userId:%v, err:%v", userId, err)
		}
	}()
	return nil
}

// 错误toast翻译
func GetErrByLanguage(model *domain.Model, msgId common.MsgIdType, lang string, myErr *myerr.BusinessError, args ...interface{}) *myerr.BusinessError {
	var msg string
	if len(args) > 0 {
		msg = fmt.Sprintf(myErr.GetMsg(), args...)
	} else {
		msg = myErr.GetMsg()
	}
	if resMul, _ := res_m.GetResMultiTextBy(model, msgId, lang); resMul != nil {
		if len(args) > 0 {
			msg = fmt.Sprintf(resMul.Content, args...)
		} else {
			msg = resMul.Content
		}
	}
	return myerr.NewBusinessCodeNoCheck(myErr.GetCode(), msg, myerr.BusinessData{})
}

// 生成弹窗错误
func NewAlertErrByLanguage(model *domain.Model, msgId1, msgId2 common.MsgIdType, lang string, args1 []interface{}, args2 []interface{}) *myerr.BusinessError {
	var title, content string
	if resMul, _ := res_m.GetResMultiTextBy(model, msgId1, lang); resMul != nil {
		if len(args1) > 0 {
			title = fmt.Sprintf(resMul.Content, args1...)
		} else {
			title = resMul.Content
		}
	}
	if resMul, _ := res_m.GetResMultiTextBy(model, msgId2, lang); resMul != nil {
		if len(args2) > 0 {
			content = fmt.Sprintf(resMul.Content, args2...)
		} else {
			content = resMul.Content
		}
	}
	return myerr.NewBusinessCodeNoCheck(1020, "", myerr.BusinessData{Title: title, Detail: content})
}

func GetResMultiTextBy(model *domain.Model, msgId uint, Language mysql.Str) (string, error) {
	r := res_m.ResMultiText{}
	if err := model.DB().Where(&res_m.ResMultiText{
		MsgId:    msgId,
		Language: Language,
	}).First(&r).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			if err := model.DB().Where(&res_m.ResMultiText{
				MsgId:    msgId,
				Language: common.DEFAULT_LANG,
			}).First(&r).Error; err != nil {
				return "", myerr.WrapErr(err)
			}
		} else {
			return "", myerr.WrapErr(err)
		}

	}
	return r.Content, nil
}
