package main

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/script/mysql"
	"github.com/tealeg/xlsx"
	"io/ioutil"
	"net/http"
)

type GroupPowerResponse struct {
	Data struct {
		Total int64            `json:"total"`
		Data  []GroupPowerData `json:"data"`
	}
}

type GroupPowerData struct {
	Code                      string  `json:"code"` // 家族长ID
	Area                      string  `json:"-"`
	GroupPowerExp             int64   `json:"groupPowerExp"`             // 经验值
	GroupPowerConsume         int64   `json:"groupPowerConsume"`         // 家族房间流水
	GroupPowerMemberNum       int     `json:"groupPowerMemberNum"`       // 成员数
	GroupPowerMemberCharge    float64 `json:"groupPowerMemberCharge"`    // 成员充值$
	GroupPowerNewMemberNum    int     `json:"groupPowerNewMemberNum"`    // 新成员数
	GroupPowerNewMemberCharge float64 `json:"groupPowerNewMemberCharge"` // 新成员充值$
}

func ats23(a interface{}) string {
	return fmt.Sprintf("%v", a)
}

func getAreaByCode(code string) string {
	sql := "SELECT area FROM res_country c,user u WHERE u.country = c.name AND u.code = ?"
	var area int
	if err := mysql.ProdReadOnlyDB.Raw(sql, code).Scan(&area).Error; err != nil {
		panic(err)
	}
	if area == 1 {
		return "阿语区"
	}
	return "非阿语区"
}

func main() {
	var data []GroupPowerData
	pageIndex := 1
	pageSize := 500
	for {
		url := fmt.Sprintf("https://apiv2.faceline.live/v1/groupPower/page?lang=zh-cn&ownerCode=&beginDate=2023-04-01&endDate=2023-04-12&pageIndex=%d&pageSize=%d&status=1", pageIndex, pageSize)
		method := "GET"

		client := &http.Client{}
		req, err := http.NewRequest(method, url, nil)

		if err != nil {
			fmt.Println(err)
			return
		}
		req.Header.Add("nonce", "hilo")
		req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjI1MSwiRXh0ZXJuYWxJZCI6IiIsImV4cCI6MTY4Mzg3NTI2MH0.EH4OFsM8WIjBxvQjvq6vBuEPaHR0vOoCUdS53wmB-yo")

		res, err := client.Do(req)
		if err != nil {
			fmt.Println(err)
			return
		}

		body, err := ioutil.ReadAll(res.Body)
		if err != nil {
			fmt.Println(err)
			return
		}
		_ = res.Body.Close()
		var resp GroupPowerResponse
		err = json.Unmarshal(body, &resp)
		if err != nil {
			panic(err)
		}
		if len(resp.Data.Data) <= 0 {
			break
		}
		data = append(data, resp.Data.Data...)
		pageIndex++
	}
	excelFileName := fmt.Sprintf("./家族4月数据.xlsx")
	xlFile := xlsx.NewFile()
	sheet, err := xlFile.AddSheet("slot")
	if err != nil {
		panic(err)
	}
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7, c8 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value = "家族长ID", "区域", "经验值", "家族房间流水", "成员数", "成员充值$", "新成员数", "新成员充值$"
	for _, d := range data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7, c8 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value, c7.Value, c8.Value = d.Code, getAreaByCode(d.Code), ats23(d.GroupPowerExp), ats23(d.GroupPowerConsume), ats23(d.GroupPowerMemberNum),
			ats23(d.GroupPowerMemberCharge), ats23(d.GroupPowerNewMemberNum), ats23(d.GroupPowerNewMemberCharge)
	}
	_ = xlFile.Save(excelFileName)
}
