package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"git.hilo.cn/hilo-common/script/utils/jwt"
	"io/ioutil"
	"math/rand"
	"net/http"
	"strings"
	"time"
)

func init() {
	rand.Seed(time.Now().UnixNano())
}

var fruitUserCodes = []string{"1000653", "1000516", "1000675", "1000890", "1000755", "1000593", "1000629", "1000634", "1000765",
	"1000591", "1000633", "1000224", "1000611", "1000689", "1000467", "1000384", "1000367", "1000623"}
var fruitAmounts = []int{10, 100, 1000, 3000}

func main() {
	var users []model.User
	if err := mysql.TestDB.Model(model.User{}).Where("code in ?", fruitUserCodes).Find(&users).Error; err != nil {
		panic(err)
	}
	for {
		times := 20 + rand.Intn(30)
		for i := 0; i < times; i++ {

			arr := []int{1, 2, 3, 4, 5, 6, 7, 8}
			rand.Shuffle(len(arr), func(i, j int) {
				arr[i], arr[j] = arr[j], arr[i]
			})
			for _, id := range arr {
				if rand.Intn(100) < 30 {
					break
				}
				url := "https://test.apiv1.faceline.live/v1/fruitMachine/"
				method := "POST"
				amount := fruitAmounts[rand.Intn(len(fruitAmounts))]
				payload := strings.NewReader(fmt.Sprintf("fruitId=%d&amount=%d", id, amount))

				client := &http.Client{}
				req, err := http.NewRequest(method, url, payload)

				if err != nil {
					fmt.Println(err)
					return
				}
				u := users[rand.Intn(len(users))]
				token, _ := jwt.GenerateToken(u.Id, u.ExternalId, "hiloApi")
				req.Header.Add("nonce", "hilo")
				req.Header.Add("token", token)
				req.Header.Add("Content-Type", "application/x-www-form-urlencoded")

				res, err := client.Do(req)
				if err != nil {
					fmt.Println(err)
					return
				}
				defer res.Body.Close()

				body, err := ioutil.ReadAll(res.Body)
				if err != nil {
					fmt.Println(err)
					return
				}
				fmt.Println(string(body))
			}
		}
		//time.Sleep(time.Second * 55)
	}
}
