package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"github.com/tealeg/xlsx"
	"time"
)

type UserChargeData struct {
	UserId              uint64 // 用户ID
	Code                string // 用户ID
	Country             string // 国家
	ChargeMoneySum      int64  // 美分
	EarnDiamondSum      int64  // 获得钻石总数
	ChargeDiamondSum    int64  // 充值钻石总数
	NotChargeDiamondSum int64  // 非充值钻石总数
	CostDiamondSum      int64  // 消费钻石数
	GiftDiamondSum      int64  // 礼物消费
	FruitDiamondCostSum int64  // 水果机消费
	FruitDiamondEarnSum int64  // 水果机收入
	FruitDiamondDiff    int64  // 水果机收入-消费
	SlotsDiamondCostSum int64  // slots消费
	SlotsDiamondEarnSum int64  // slots收入
	SlotsDiamondDiff    int64  // slots收入-消费
}

var bt = "2023-01-01 00:00:00"
var et = "2023-02-01 00:00:00"

func ats(a int64) string {
	return fmt.Sprintf("%d", a)
}

// 1月的所有充值用户明细
func main() {
	var uids []uint64
	//if err := mysql.ProdReadOnlyDB.Raw("select DISTINCT(user_id) FROM diamond_account_detail where created_time >= ? AND created_time < ?", bt, et).Find(&uids).Error; err != nil {
	//	panic(err)
	//}
	uids = []uint64{1947441, 3209001, 2305621, 3060891, 921681, 2182811, 42631, 2218821, 303001, 1688761, 2683011, 3140551, 1911701, 3015171, 1776681, 3089531, 1740481, 218401, 2424171, 2290651, 1547941, 2599901, 2128571, 3206611, 1287401, 2553741, 1055451, 905501, 1705411, 2953251, 1178081, 558861, 2346361, 3192701, 1408471, 2786241, 2606671, 2217591, 2979341, 1718721, 967281, 2843701, 986911, 1959141, 3143831, 2311241, 2419931, 3095011, 1687521, 2102031, 957321, 1362781, 2048201, 2808231, 1656411, 734821, 2999361, 1896181, 1996861, 1021261, 1585141, 187681, 2013101, 2899871, 1597261, 2583781, 3200881, 2413511, 1680651, 2472901, 3232511, 2291511, 2628201, 2370281, 2217861, 2285101, 2151781, 1147471, 2398061, 2704881, 1724181, 3236601, 2455891, 2201631, 1522261, 260881, 1199541, 870121, 2886901, 1977221, 2689971, 1600641, 1764451, 2468421, 1670131, 2159371, 3113351, 1027751, 2839091, 2164751, 975411, 2781081, 1843121, 1066961, 3239881, 2981521, 2232101, 3236131, 1885681, 3142631, 2247231, 1978261, 2568861, 2345351, 2802381, 2292201, 2986291, 3242391, 220051, 2792051, 3032251, 2329451, 2542011, 3222531, 2791721, 2251211, 932991, 3244621, 2967701, 285161, 2922111, 2797031, 73951, 3166551, 2078671, 2198751, 1069651, 1394261, 2622241, 2745371, 2688511, 2364671, 2840781, 2549541, 2217411, 2493301, 2156761, 3119081, 3066651, 2458871, 2333571, 3111841, 2441961, 2135061, 2412361, 3235801, 1496351, 2088751, 3042181, 1160621, 3062911, 1597151, 3174821, 2090111, 3253911, 2005881, 2396821, 1102001, 2065711, 2986311, 1104501, 1769061, 118401, 3200531, 2431331, 2904021, 3259271, 2623491, 3245671, 904641, 2419821, 3181491, 390031, 3260281, 1429711, 2870531, 1721511, 2986241, 2111851, 1475521, 232771, 1707781, 1598861, 132711, 3243081, 1015701, 337341, 2842621, 976671, 1552591, 3264351, 2047301, 1416901, 1442301, 2120091, 2326611, 1049691, 2841971, 3261181, 2326591, 3041281, 2182131, 3266461, 2882411, 3029701, 2736811, 2706531, 2461401, 101361, 2769621, 2630321, 2399521, 995871, 1329291, 2539331, 3266571, 3247341, 3182371, 1205271, 2923431, 1378711, 2372391, 1010611, 2284031, 2502911, 2967431, 1751501, 29281, 3269211, 2660521, 2887011, 3171101, 2815211, 2922671, 2741071, 3209991, 2426411, 1210301, 2781161, 1211151, 3095751, 907001, 2674191, 2600521, 3021601, 3032581, 3265121, 702581, 1569971, 3179191, 3262391, 3283131, 3283611, 2797211, 2460751, 3218991, 1818011, 3249701, 3183401, 2001341, 2476121, 1940421, 2807281, 862401, 2134121, 2223751, 1010931, 974861, 2875431, 2582051, 3263891, 3119041, 2995791, 3243121, 2214011, 3292141, 2648851, 2288261, 2138921, 3294291, 2327001, 1141991, 2151931, 1596611, 2214211, 3271591, 2370791, 3057101, 1952811, 3296961, 1795331, 1921491, 2727111, 1969941, 3095941, 974201, 3300451, 2183521, 3295741, 2581231, 951, 1651701, 1403651, 3220231, 1132461, 1227621, 2982091, 956901, 1022001, 2384491, 1670391, 3002021, 2260171, 3180861, 3306201, 3146801, 3258961, 1876831, 177031, 2125651, 344741, 3120521, 2658841, 410011, 1069611, 477001, 3132231, 1765671, 690191, 3105581, 200261, 2722861, 3219631, 1841111, 891171, 1094481, 1410661, 1465821, 962411, 1391231, 1227581, 1028081, 644741, 2530681, 1120671, 11611, 2129451, 1992441, 3221741, 2415641, 2188041, 3133581, 2132651, 3316021, 3315551, 2493581, 981901, 21591, 20621, 1522471, 2777081, 3016361, 3318161, 3314511, 3318901, 1895421, 1000301, 82101, 1725561, 3288421, 2600261, 1987161, 1434021, 1091471, 2203361, 2809891, 1150811, 917891, 1480481, 1131661, 3324461, 2782521, 2184721, 1751461, 2261961, 2748561, 2384881, 2768101, 2309221, 2066631, 974741, 2983121, 1000221, 267201, 2915281, 962841, 3180711, 2259741, 3306151, 3220221, 2291111, 3143801, 3102111, 1334661, 2352541, 3330601, 2293751, 2167481, 2649261, 3330791, 3144141, 2675711, 2328401, 1350971, 1873491, 2063251, 3314301, 1888121, 2923451, 1421071, 1200661, 2690511, 2406371, 2917851, 2940141, 565631, 3279471, 2140861, 2420791, 1213321, 1089931, 2274831, 2304521, 1927791, 2847871, 2475781, 3341141, 1673601, 2779291, 3247741, 259721, 1258491, 1643441, 3043971, 2004571, 1314981, 3291761, 3263491, 1238031, 3286031, 3107181, 3345151, 1746951, 1476061, 1068611, 2455621, 1133111, 3326271, 3159071, 1119561, 2032161, 3278491, 3154761, 2957471, 3204251, 2321341, 2733401, 2090721, 3208401, 3346061, 2903191, 3067391, 1185001, 1684131, 2732551, 1657601, 3268811, 973371, 3355741, 3016781, 3337801, 2965321, 1178051, 3200021, 2877271, 3358761, 3359141, 2432381, 1735701, 255621, 2170191, 81811, 2331581, 1395771, 2965751, 3328031, 3365331, 3240871, 1126861, 3348001, 3094231, 2828091, 1528041, 23891, 1534541, 1616451, 2779121, 2619531, 3307661, 3368851, 2676311, 1276901, 3360631, 3054991, 1724221, 1784391, 1653701, 1143461, 2234731, 2496061, 2214061, 1922351, 2698721, 3356781, 2335731, 1293641, 2122601, 3373341, 2561271, 3375461, 1784121, 3084281, 3041131, 1817621, 3376311, 3333421, 3367531, 3372491, 2790861, 2962591, 142181, 3371121, 2532831, 2453421, 3333141, 2965821, 3377211, 3360581, 3379371, 3012001, 3297011, 3208731, 3001311, 1465241, 259731, 3368971, 3375861, 3304921, 2323521, 489201, 2958241, 3083601, 2960501, 1169731, 3081321, 2320751, 2797831, 3388251, 1004971, 1247221, 3391771, 1782401, 3056141, 2375661, 3000641, 3353491, 3394281, 3328161, 3387931, 406631, 2494011, 3395811, 2683201, 3380111, 2429641, 2475961, 2212171, 2517361, 230471, 2683361, 3087571, 2790181, 2435611, 1910591, 357611, 1715491, 2745061, 3231221, 3394781, 2172231, 3402181, 3196071, 3402131, 2557951, 1320461, 2868131, 3397561, 987411, 3349971, 2567731, 3406021, 1210251, 2215871, 3387661, 3237281, 3050761, 3371081, 1109001, 1108951, 2122801, 3191991, 1942841, 2090651, 2864761, 3409911, 2809971, 2790341, 3312951, 2524141, 2350301, 2809281, 1064501, 3399031, 2894461, 2633821, 2765021, 2695141, 1983111, 3419261, 3419441, 3412311, 3419581, 2179941, 956161, 2675701, 2276881, 939571, 2165761, 2996001, 3415941, 2788741, 1792061, 2847801, 3386821, 2981831, 3158831, 1599161, 1105001, 3426271, 68031, 1127861, 1884431, 2612811, 1862511, 3423501, 2808571, 2000321, 2768181, 2604161, 3416641, 2705461, 2901241, 2551921, 2759051, 2440991, 1832171, 2012371, 1680681, 3269001, 2329171, 3433961, 1496141, 3400921, 3074421, 3056101, 1462491, 3208241, 2809321, 2297221, 3427851, 1050851, 3129621, 1922791, 3312461, 3360801, 3088481, 3441681, 2762811, 2578141, 2637001, 3298311, 2175871, 1722011, 3018241, 2599211, 2672181, 3039671, 2095331, 1706311, 2797481, 1950241, 3197291, 2918251, 2660881, 3449801, 835341, 1645561, 3432001, 2322481, 3444581, 2352331, 927161, 1144101, 964711, 2872181, 3381411, 2215271, 2140781, 1388701, 3057291, 1005521, 3454571, 3455201, 3011201, 1881131, 2445101, 3312241, 2575291, 2298231, 3458061, 2774811, 2700251, 1879491, 3458991, 3179041, 2559781, 2993381, 2460441, 3071771, 3449151, 3363361, 2835301, 2563341, 1738571, 2096471, 2960301, 3444631, 3403961, 3444721, 1371911, 1049341, 3254381, 2665971, 169311, 2039501, 2615151, 3468681, 3402111, 2396671, 3470751, 3182131, 3470441, 3471031, 1597231, 1397691, 2903981, 1949411, 1797921, 1879931, 984381, 1788701, 1784531, 3475291, 3476061, 2701961, 1106201, 2831991, 1181721, 1003511, 3126751, 2864731, 1225981, 2581191, 2592251, 2698411, 1119711, 3474121, 3401131, 2699551, 989091, 2054861, 3472761, 1625221, 916811, 1856071, 3268621, 2966651, 1960111, 3478821, 2199501, 3063501, 3476991, 2695991, 2334151, 3490771, 359021, 1826511, 3205111, 3448991, 3001461, 1153331, 1012461, 3489471, 1543371, 3494941, 2541621, 3495861, 2309891, 3047171, 2024431, 3371521, 3007051, 2983791, 67931, 1912511, 3268411, 2661231, 2333701, 2056171, 3131521, 2894301, 3006701, 1667121, 2415141, 912611, 2334541, 3463771, 3045041, 2429021, 3390391, 3390631, 1579901, 2221821, 2971771, 1333131, 2966531, 3366871, 2950751, 2185021, 3506691, 2496281, 3507231, 1136401, 2280511, 3390871, 1207551, 3439441, 3138361, 3512591, 959901, 2190761, 2842531, 2830851, 2566471, 2502541, 3506681, 3076311, 2214261, 3451291, 3501021, 3513211, 1385971, 850411, 3172261, 3505811, 1229591, 3498851, 971051, 1759641, 3488531, 1007221, 1775221, 3523921, 2447501, 3350641, 3163561, 2249401, 2003161, 2826191, 2750541, 2627481, 3263721, 1817541, 2987501, 3496721, 3420211, 3143661, 2898431, 3140181, 2022841, 2820091, 1835751, 2177861, 2016251, 1305281, 3366141, 3032261, 3517221, 1212121, 3413121, 2603141, 2541191, 1185241, 2603381, 3051881, 3228731, 3527721, 2508981, 1301261, 1528401, 1243651, 3330861, 3181851, 2901051, 2987061, 2042741, 2625641, 1818921, 3438741, 2367131, 2871651, 1130091, 3555471, 3285181, 3536241, 3476801, 346191, 1120881, 3556641, 3554381, 864391, 3448941, 3374741, 3562841, 3565241, 3565361, 3507351, 3463351, 3463371, 3520811, 3268891, 3232421, 3449501, 3567921, 3571541, 2197831, 3302451, 2283411, 1833621, 3545731, 3574511, 1546511, 3343751, 779271, 2850081, 2970731, 2417851, 3449271, 2115641, 3565501, 3553471, 2231801, 3314761, 3396701, 2181101, 3428111, 3503841, 3601961, 3534441, 3248291, 2015541, 2159601, 3605471, 1931411, 1714581, 3552641, 2132221, 2739991, 1891111, 3019261, 2666121, 3032711, 3591071, 3618441, 3005961, 3618541, 2335371, 3622601, 1473191, 3459411, 3579361, 3130071, 1983221, 2314351, 2160471, 2246641, 2356791, 2430111, 2287911, 2843471, 3564271, 2456561, 2997961, 3557771, 3632371, 1591361, 3631361, 3078301, 1495421, 3612111, 3634951, 2104271, 717501, 2021191, 3033381, 2619951, 2091071, 3504791, 201191, 949801, 2088911, 2603311, 3631211, 3525521, 2684141, 3428981, 3571341, 3649711, 3075191, 3652531, 2907691, 1791671, 2758191, 2285981, 2784711, 3643991, 24241, 1187671, 1686761, 3262521, 3636341, 3457591, 2563211, 2996921, 3643321, 3446141, 2730721, 1131141, 3609421, 3672381, 2138731, 3564751, 3324141, 3676861, 3621031, 1824931, 3601741, 3654381, 1481511, 3674461, 3555331, 3686221, 3673961, 2703491, 1180761, 2313691, 3690271, 3692641, 3536631, 2218561, 3551451, 3219821, 3694731, 1015031, 3564051, 3632761, 2295601, 3698261, 3451451, 2281721, 2216801, 3104701, 548601, 3666261, 3599981, 3066591, 3468811, 3696471, 3707381, 2570661, 3498741, 3451801, 1532551, 3705441, 1238751, 1541501, 2622331, 2158211, 1059321, 2144701, 2133071, 3630441, 1764121, 2552881, 944421, 1572751, 3671111, 2552671, 1970471, 1191751, 2780091, 980911, 3728921, 1657261, 3703631, 3429351, 2958731, 3716401, 3444651, 3574371, 2767511, 3389711, 2315761, 3691821, 2509571, 2691971, 2527951, 262661, 3447411, 1892541, 2911491, 2411111, 3508131, 2160751, 3751951, 2683711, 2046991, 2330771, 1909131, 989571, 1166201, 3711981, 3537721, 3757011, 3280241, 2342491, 3673731, 980761, 1864181, 3759561, 3759831, 3749511, 3691801, 982941, 3761891, 2993141, 2306821, 2546981, 2489171, 3276961, 2647861, 1089761, 3538131, 1760351, 3688331, 2251411, 2018541, 1115171, 1609281, 2160761, 3551661, 3262811, 2139301, 93901, 2882441, 1601111, 2304961, 3781561, 3649011, 3342131, 3511311, 2093411, 3606271, 2792521, 3725481, 1985231, 301411, 3690631, 2825421, 2573251, 3793621, 3333861, 3354721, 3323871, 3094411, 2780221, 1711611, 2838641, 3780491, 1893271, 2157681, 3800691, 2575021, 2746971, 3807721, 3808471, 95071, 2996151, 2781181, 3808311, 998171, 3419861, 2332881, 3813891, 1680131, 1746411, 3706551, 424161, 1401851, 1714461, 2563621, 2478981, 3558421, 235251, 3721861, 1006401, 3277091, 3798841, 2386551, 3779171, 3560151, 3827901, 3799751, 3317501, 2563751, 2142631, 3815441, 1491511, 369721, 3459051, 3832981, 3326511, 3783241, 3176541, 2584661, 3838301, 1373711, 3755911, 3826411, 3762971, 1946461, 3754381, 1050211, 2487041, 1744831, 3690051, 3812031, 2444221, 2314741, 3844271, 3666761, 2459871, 2981951, 3504731, 3219391, 1762771, 1863371, 3845671, 3840571, 874041, 2740411, 3676491, 3848451, 1545481, 2965261, 3407851, 3846601, 3771741, 3037821, 3001231, 2047571, 1829281, 3509581, 2365961, 1689191, 2014931, 1938851, 3100131, 2493941, 140421, 3675861, 2478611, 3781391, 1104481, 2624491, 1992061, 3181511, 3859691, 3880831, 3736721, 3868061, 2876781, 2946301, 3752311, 3874551, 3866211, 2396501, 1330351, 3892121, 3893621, 3895041, 81301, 3815871, 80041, 2266701, 3470141, 3084131, 1799701, 1332381, 1450801, 1187511, 3614211, 1631331, 953501, 88971, 3054781, 3107451, 31471, 3903401, 3893421, 1886291, 2897311, 1977211, 3907991, 3430921, 3357911, 3326131, 3724631, 3746081, 3746251, 3861011, 3911421, 3434181, 1425421, 1457841, 1819521, 2175091, 3337191, 2365721, 3212151, 1431141, 3014691, 1427191, 3663191, 3734221, 3924601, 2108891, 3907281, 2893471, 2611181, 1550611, 3715661, 2189741, 3897081, 3285391, 1038731, 1033451, 3935071, 2305431, 1395821, 3464851, 1739021, 3112361, 2328361, 3005861, 2504211, 2928821, 2251351, 1081971, 3856321, 1796141, 3509851, 2509861, 2054111, 2745611, 3955321, 3126011, 2954631, 1389541, 3926001, 3712481, 1792761, 3964141, 3178351, 3963541, 1922541, 1969421, 3960821, 1707911, 2459681, 3931741, 2011581, 2903521, 3146121, 2704431, 3276361, 3668631, 3883691, 3619471, 3858571, 1778971, 3228251, 2577651, 2392791, 3979961, 1365041, 3814011, 3562771, 2072291, 3070871, 1837321, 3986551, 3912841, 3582011, 3969961, 2228241, 28831, 1522461, 1784321, 2536411, 2930101, 1388201, 1392501, 965091, 3120101, 1393541, 1025571, 2174551, 886081, 2081031, 2100511, 2951631, 1544911, 2341401, 2453271, 2955201, 1522661, 156231, 3095881, 904971, 2965401, 2909721, 3216281, 3165571, 3199741, 2416891, 3225131, 3167531, 2130991, 2413111, 2668561, 1943751, 3248281, 2923641, 2416141, 1072581, 2087771, 2600121, 2755011, 1061271, 2782261, 2714941, 1404931, 2064531, 1282051, 2607891, 1906081, 2617811, 1110721, 2349501, 3119071, 2535941, 1543531, 2630121, 3149851, 2552011, 1300031, 2922851, 3219491, 2264901, 3097231, 2380691, 2752871, 2078221, 1563651, 2705871, 3259721, 3126371, 3052081, 1855651, 235781, 2541581, 2132371, 1131771, 210121, 2116841, 2177281, 3270831, 2565891, 2461351, 1114691, 3292081, 342191, 3294051, 2941981, 3058361, 2413641, 3165681, 2488841, 2987131, 3278641, 3300121, 3117681, 2958391, 2342381, 2933231, 3193311, 2220491, 1004331, 1009801, 858941, 2948091, 2981261, 2979631, 2744061, 343301, 2145971, 2264431, 3287021, 1776061, 3008081, 2986621, 2006271, 1626031, 2280381, 3162091, 1858491, 232611, 301561, 2758991, 3267481, 3091611, 2776471, 2780961, 2794871, 3043941, 1919411, 2514921, 1844281, 2930521, 2396461, 974621, 3330571, 2144321, 1132251, 2360161, 2368931, 3346251, 2883431, 3067911, 1782221, 1987961, 3318621, 3143791, 2971681, 2410211, 2517531, 2296881, 1866211, 1035271, 124521, 2880791, 2035041, 3350891, 1369251, 1711991, 1725951, 3350841, 3116481, 2729171, 2772911, 3151911, 1399421, 2507241, 930851, 2262211, 3327371, 26251, 2118621, 3206761, 3168601, 3147491, 1018411, 1431891, 2037281, 3247401, 3336431, 3246121, 3355461, 3262491, 1092721, 2290411, 1661871, 1969911, 3160311, 1516211, 3381181, 2985221, 1308991, 2831841, 1466671, 1661291, 1262341, 2063231, 1334291, 1062651, 1676751, 3377871, 3159001, 3189051, 1614861, 3403981, 1092631, 1404621, 2845491, 2491561, 2908221, 3133631, 1427491, 1578341, 1126491, 2019501, 2208361, 1726401, 2936331, 3425041, 3189191, 2295681, 2438541, 2118671, 3406691, 2755721, 3241741, 2977881, 3458481, 1496521, 2321001, 2799531, 1392291, 1741791, 1099391, 2246911, 2144111, 1109271, 3429541, 3408841, 3179311, 3420341, 2552351, 1956571, 1533351, 2254281, 2375321, 3474641, 3485781, 125621, 1664401, 2494631, 1700741, 2067451, 3471451, 2294151, 3066421, 2107541, 1610741, 3487161, 3484651, 3485761, 1718051, 1856091, 981841, 2054361, 2094811, 2339971, 2871041, 2236221, 3506001, 2600031, 2304121, 3411261, 2991381, 180621, 1937171, 3508071, 3429441, 2764361, 3108061, 3375931, 2910151, 2146071, 3502231, 3466011, 1073651, 3469191, 1399501, 1655291, 2993771, 2552281, 3475601, 2176251, 2127921, 2207361, 2197081, 2515731, 3513821, 2382101, 1712771, 2113091, 3343151, 992641, 1385281, 1744931, 1277931, 995931, 996011, 2080101, 3391711, 313121, 1515641, 1849221, 2264521, 3139361, 1056161, 1126511, 1655271, 3530481, 3533911, 2749141, 1610841, 3517981, 2113811, 3360561, 920781, 2663951, 3502901, 2736591, 1866241, 2964301, 3431111, 3524341, 1739891, 2131011, 3568501, 2642031, 2087751, 2088121, 240341, 3110241, 1345171, 3120811, 2291121, 2978431, 2094001, 2598221, 3350651, 3525381, 3705711, 3525721, 893041, 3538231, 3643661, 3516091, 2198491, 3456551, 3674431, 3372011, 3584401, 3585291, 1059501, 3669421, 2312891, 3575911, 2037771, 3392601, 3509471, 917581, 2279971, 3758061, 3496581, 1785631, 1500671, 1755161, 3056401, 3287601, 2025111, 3555521, 2618981, 76521, 1139191, 1436271, 2911421, 1754061, 1640051, 915591, 2543081, 3699011, 2835631, 3131581, 3755671, 2911991, 1131691, 1668051, 3034991, 3752411, 2729411, 1219081, 1543431, 2324141, 1581561, 2449491, 2031351, 3259481, 3751781, 1840001, 3303201, 2400811, 2457771, 2549301, 2759881, 2441241, 2216721, 1786161, 3098161, 2085511, 1127141, 190591, 2089191, 2316621, 3345031, 1555951, 1703391, 3373451, 3302431, 1701481, 1853811, 1793101, 2301901, 2283421, 859001, 1271741, 3866561, 3813281, 3152681, 1293851, 1235331, 1943431, 3873301, 2515851, 1384201, 2810641, 3416131, 2943941, 2171961, 1781901, 2208041, 3522271, 3563991, 1753001, 3829531, 1133301, 3904431, 2433621, 3561871, 2937421, 2457521, 3875761, 3866071, 3909021, 1553361, 1178141, 3851051, 3730491, 3919151, 1753651, 3142851, 3103131, 3048121, 3349561, 2083631, 3869891, 1878011, 3935061, 3126031, 3623411, 2609281, 3431051, 2603721, 3940061, 2125471, 3930381, 3947551, 2474771, 3875801, 3908631, 3486881, 379491, 1612371, 3933211, 2413271, 1000541, 3111181, 2420221, 2565981, 2215441, 1861711, 242731, 288181, 1111251, 1259521, 2729461, 923871, 1734091, 3077411, 1786531, 2506351, 2162821, 1697211, 2928461, 2931961, 2103331, 1735791, 2790511, 2723091, 1149891, 3305801, 2980541, 1938471, 2145641, 3381611, 3427591, 1620631, 3008131, 1882371, 2417151, 2598721, 3544051, 1024011, 1597241, 2314891, 2968001, 910451, 1612391, 2015181, 1942471, 1791631, 2330621, 1144281, 2950571, 102501, 3241751, 2205581, 2342981, 3299031, 3376791, 1815481, 2636981, 2099541, 2118311, 2263141, 2523881, 1572231, 3379761, 1946031, 3225781, 3416721, 2382981, 3749671, 2099421, 1664231, 3828281}
	//uids = []uint64{3318161, 3113351, 2648851, 255621, 2984041, 3219391, 2290651, 3721861, 644741, 93901, 3755901, 3504751, 3556641, 2220071, 3908411, 2102031, 1550611, 3997241, 3115691, 1104481, 1066961, 2736811, 1104501, 862401, 1784531, 1893271, 3856321, 1922261, 2139301, 1106201, 3333141, 3127261, 1120671, 2285101, 2151781, 3412311, 3297011, 3758351, 2352331, 3799751, 4000921, 3582011, 2496281, 4000431, 3271591, 3513211, 3950971, 3889691, 3400921, 2334541, 2392791, 2120091, 4003921, 3952681, 962841, 3691801, 935721, 3573581, 2338401, 2745611, 2981831, 3063501, 3472761, 3996721, 3420211, 3875851, 3997951, 3997981, 3891471, 3808311, 2899871, 2076641, 2175091, 3525161, 1058891, 1176101, 3386821, 3715661, 1187511, 3328031, 3964141, 3935111, 2159601, 88971, 1010931, 1166201, 1843121, 2090651, 3618441, 2270061, 2271751, 1831311, 3471921, 2138731, 3676861, 3076311, 3463351, 2502911, 2115641, 66981, 1007221, 3952331, 3130071, 1788701, 3553291, 4013391, 3999391, 3228731, 2167481, 1727411, 3601421, 2627481, 954551, 2201631, 1350971, 2660521, 2986291, 2345351, 1147471, 3873381, 3941431, 905501, 623661, 3969961, 3262391, 2915281, 2658841, 3963541, 3780651, 3490491, 2014931, 3345151, 734821, 2911491, 3606271, 3705441, 1724221, 2583781, 24241, 2327001, 1762771, 2199501, 1324231, 3840571, 3181851, 3062911, 1270231, 3094411, 3298311, 907001, 2797481, 2197831, 3513821, 1515121, 3369701, 3803801, 3887241, 1015701, 3507351, 2814831, 4008691, 2176271, 3541451, 3574511, 4027871, 2504211, 858941, 1105001, 3178351, 4012531, 3624261, 4009551, 4006711, 4028091, 953501, 1862511, 2610461, 2493301, 1765101, 4031101, 3779171, 1129691, 3834471, 2740411, 3509851, 2134121, 3648251, 1332781, 1811531, 1892541, 4031831, 2419931, 2769621, 3087571, 3401561, 881011, 3821931, 3394781, 1201981, 1160621, 4034451, 3235801, 3356731, 3798841, 1018681, 3254381, 2370621, 4036661, 2575021, 986911, 3366141, 3677081, 2313691, 2218561, 3419861, 3936961, 3724631, 2386551, 101361, 4040631, 1085971, 2418851, 42631, 118401, 3268891, 1673601, 1764971, 3978981, 4043031, 4036091, 4043121, 3181491, 2274831, 1821361, 2648811, 4037111, 2373141, 3237281, 1682211, 4022591, 3005961, 3696471, 1707911, 2299101, 1893181, 1033411, 2739581, 395031, 2001341, 2982091, 2695141, 1191181, 4029971, 2292901, 3796791, 2182131, 3917881, 3911121, 3826411, 2876911, 3403521, 1940421, 3302321, 4048751, 4050361, 3318141, 3631211, 3066651, 3468261, 3690631, 2333701, 3390631, 1133581, 3564051, 916811, 4051581, 1764121, 1746411, 3951131, 3735981, 3749671, 1829281, 2615151, 21591, 2142631, 2468421, 1963961, 1532551, 3558421, 2002561, 1010611, 3666171, 1711611, 4013011, 2561791, 1992061, 2453341, 1990201, 949801, 1450801, 2102571, 4037461, 2871651, 969971, 2619531, 3536631, 3963511, 1656411, 4065111, 3688561, 20621, 2563341, 1791671, 240601, 4070951, 3241711, 2553741, 3011201, 3666761, 1185241, 2552411, 3893411, 2020681, 3792361, 1371911, 369721, 4017161, 1245741, 3875081, 4068311, 914561, 1403891, 2350301, 2900941, 3833331, 3821461, 3534441, 1600641, 3143061, 1760351, 2030131, 4079371, 2793271, 3366871, 2042741, 3930451, 2372391, 3839151, 1884431, 1841951, 4076611, 1186951, 1259521, 3438741, 3712481, 2708381, 2309221, 4069211, 3845671, 1119561, 1258521, 3688331, 4049611, 3139761, 2841031, 3325661, 4053771, 3734221, 2563751, 2509861, 4088571, 2624721, 2366581, 1601111, 3446301, 4081541, 1528041, 2725541, 2175871, 3866641, 2601041, 1879491, 3897281, 2476121, 1477521, 4093291, 3033381, 1680681, 3513781, 990851, 2487041, 4065651, 2807381, 1921491, 4098171, 2399491, 3538131, 4098721, 4068911, 3560151, 4099111, 885731, 1845481, 2888781, 3895791, 4046511, 1591361, 1651701, 4085491, 2378511, 3619471, 3104701, 2098541, 2128571, 1073901, 2317451, 1870991, 2382981, 3468571, 1567361, 1150811, 2756731, 3469601, 4093981, 3180711, 3554061, 3487321, 2496061, 2217591, 3021601, 2676311, 4112521, 4104551, 1864181, 2731531, 4079631, 2259941, 3964501, 4114551, 1715251, 1220361, 390031, 2400271, 3926001, 3762791, 2962531, 2141241, 3119041, 4118331, 4118051, 2182811, 1040881, 3321011, 2923431, 1070361, 4119531, 4112571, 4120761, 3928391, 2447501, 4053331, 3954251, 4048611, 4086851, 2946321, 2412361, 4124091, 2692631, 1977221, 3181511, 3873031, 4126921, 3991771, 1599031, 4128121, 1640051, 1911701, 2011581, 2802381, 2903191, 2958601, 2424171, 2398061, 2683711, 1217221, 2971771, 1674451, 2420791, 4102991, 4131781, 1787231, 1882361, 2619951, 3783241, 3021861, 2958401, 4120611, 1141991, 2095311, 2788701, 2129701, 3323031, 4134311, 4119371, 2022841, 3790651, 1055811, 3126301, 3032251, 1620631, 2575291, 1362781, 1429711, 1740481, 1320461, 2049551, 1227581, 2996001, 565631, 1597231, 4138481, 2305621, 4138921, 2731641, 2455891, 964711, 4140531, 4022371, 4127061, 4094141, 2933231, 97481, 4141951, 4064251, 3142631, 4131151, 885481, 30111, 1229591, 4109991, 3427851, 3488821, 4130661, 2683011, 4145911, 2185021, 3619801, 3174291, 4136201, 2705351, 4105501, 1132461, 4151381, 1059201, 1810261, 2518221, 4142441, 967281, 2380051, 4122141, 1024011, 3057291, 2352541, 3509581, 4116641, 1004971, 4155951, 2549541, 3850651, 1070481, 1643441, 1258491, 4110931, 1598861, 1689191, 4134571, 2698411, 2247231, 1126591, 4003001, 1551241, 3874551, 965281, 885431, 3551451, 4141771, 2872181, 1206161, 2337131, 4094201, 2256821, 405811, 4162511, 2230451, 2986661, 4097881, 974741, 3795521, 4086961, 3533911, 3886681, 3856771, 1775221, 4166151, 1462491, 3703631, 3032581, 2572491, 3993681, 1959141, 1572751, 2288261, 1988471, 4167371, 2433761, 2160751, 4099211, 23891, 2177861, 2981951, 3403961, 2467791, 4111821, 4167961, 4093151, 1204931, 4171741, 1238031, 2652461, 4038671, 2102491, 4039761, 3349441, 4151821, 1210251, 3355401, 1109001, 2332881, 956161, 4175891, 3953341, 2622241, 676001, 1519501, 2119981, 1235331, 3191991, 974861, 1144101, 3049581, 4086581, 1195201, 2192811, 3479151, 4180291, 1599141, 4094351, 4152001, 3075191, 1667831, 4185421, 31471, 3081321, 1708481, 2882411, 2493581, 4186471, 271821, 2812671, 2791721, 3953091, 1046271, 3736721, 4081711, 3203601, 3247741, 4178761, 3508131, 1942841, 3182131, 2186341, 4194561, 4195031, 3370431, 3166551, 1545621, 1788151, 2144701, 1096031, 1561291, 3552641, 357611, 2882441, 4183751, 3621031, 2268841, 3813231, 2365961, 3765971, 4201461, 1403651, 2147251, 4186891, 3228251, 2184721, 3737251, 1027751, 4205041, 3690441, 1777311, 4206331, 3915501, 3840741, 4127391, 1238751, 4209901, 3814011, 4204771, 1021261, 2449121, 2628191, 4106401, 4212971, 4178291, 1970471, 1818011, 4095841, 4045331, 4059561, 4068411, 1416901, 2456361, 4216481, 3174821, 1913071, 1050881, 1207551, 2914741, 1157811, 1096671, 4076671, 4192501, 3979961, 2056171, 921681, 4202521, 2174551, 3074421, 4071821, 1625421, 1766681, 3220151, 2217411, 3718501, 2987501, 3875331, 3901061, 4092861, 2295101, 2048201, 2319551, 2922671, 1108951, 4158281, 2561271, 1348521, 2394221, 4230551, 1114691, 1766491, 2704771, 4226141, 2026711, 2827901, 2484381, 4199881, 4195871, 1925881, 3943741, 1784121, 4129991, 1033941, 1086201, 2284381, 1050851, 3428981, 4117991, 4237171, 3876911, 2520121, 3553261, 4157221, 3213791, 160471, 4203111, 4208291, 4124771, 1444731, 4209991, 4141991, 1249631, 989571, 4210551, 4240261, 2741071, 2918251, 3791481, 3674461, 1219081, 4157291, 2668561, 1109791, 4246641, 3671431, 4146591, 2146071, 2683951, 1604591, 4249371, 2781081, 4248651, 4232181, 1545481, 1640181, 894041, 3325941, 2570941, 959131, 4104051, 948121, 3635581, 2517361, 1954411, 2850081, 4222361, 4245701, 2624491, 3116641, 2046991, 3933841, 1777431, 4135081, 4074101, 3636341, 3489691, 957321, 3874241, 3758571, 1365041, 2293751, 3015681, 2006271, 1015031, 1888121, 2677371, 4229001, 932991, 3750961, 2457771, 1049221, 2826191, 1670441, 232771, 841321, 4221801, 1985231, 1942971, 96471, 4198841, 4123421, 1368261, 1013671, 2187871, 4263461, 4271751, 1968371, 2183221, 1302931, 4268361, 904641, 2411851, 4211361, 2091071, 1922351, 4271141, 3693651, 3487061, 4191971, 4167911, 2572421, 1105321, 3475291, 143401, 4107041, 4268881, 1707781, 2945051, 1089761, 2606671, 2151971, 4166041, 1660141, 4285581, 2431331, 4273531, 4289211, 4264731, 3745201, 3203191, 2989741, 2600261, 3465191, 1653701, 2843471, 2114941, 3628331, 4120651, 4112391, 1751461, 4190721, 4294161, 2249401, 1817621, 4007061, 144971, 3988811, 2936611, 2000321, 4167381, 4295111, 206061, 4261141, 2768611, 3103621, 3497311, 4298081, 3571501, 906121, 4209671, 4241411, 2324351, 1048161, 4305571, 2527951, 246461, 1822511, 2354141, 1975041, 3372201, 2398861, 4282951, 4312401, 313121, 2966041, 1071551, 1856321, 1143461, 1126161, 28831, 1097781, 4319521, 4121271, 1876441, 4266241, 4305411, 2415141, 3874231, 4232281, 4324321, 3417211, 3865481, 1799701, 4302631, 4325861, 3142301, 3039161, 3333421, 4158101, 4329101, 2678781, 4144701, 3717501, 4078351, 1929581, 4172801, 4331201, 2092271, 1425421, 2460451, 4175011, 3801231, 3288421, 1013641, 1128631, 975411, 4306781, 1042371, 4301001, 2695391, 987361, 1063661, 974201, 1579041, 2087311, 3017071, 3729981, 3993191, 4345351, 242771, 2342331, 4167141, 2090721, 4331081, 2344331, 2831991, 2325961, 2496921, 4349651, 3365331, 2554051, 3950161, 2126411, 3119011, 1807221, 4342281, 11691, 4109941, 3218991, 1210301, 3004511, 4053821, 3981861, 2049861, 2372621, 1227621, 1876831, 3511861, 4342901, 1145781, 935921, 1895421, 3988621, 2842401, 4360201, 3056821, 3360801, 1074561, 1782841, 4247131, 4319631, 3963501, 1049341, 3611591, 3482601, 4336741, 2165761, 2454101, 3545061, 2189741, 4024851, 4098211, 4028291, 4165911, 4292671, 4220411, 2221821, 3995981, 4367281, 4368871, 4355191, 4116471, 2550391, 4372321, 3793311, 4375121, 2673791, 2907691, 4364231, 2951781, 976671, 4321801, 4323311, 1327561, 1236971, 2440991, 4357471, 1091451, 1977901, 4307461, 4364481, 4379711, 1476061, 4364131, 3398211, 4376121, 2117681, 2297221, 1154231, 905311, 4217601, 2329171, 2471251, 1339751, 2131011, 3869421, 2304521, 2507521, 1522261, 315591, 1103531, 3472231, 2099421, 1353361, 4392501, 3864891, 4357081, 4363301, 2780221, 3830941, 2759051, 4201001, 4364431, 4361641, 4138011, 1609281, 3514051, 4338941, 4093191, 1388701, 4352721, 3853801, 3262721, 3071561, 1051581, 4219441, 4331561, 2183881, 4405291, 4388261, 4406061, 4313871, 2116841, 1947441, 2730551, 3919621, 1649191, 2370791, 4170111, 4315331, 1569821, 4132201, 267501, 3709101, 4040211, 4414241, 1499551, 2129451, 1241281, 2088911, 4342391, 1331411, 201141, 4335821, 4419691, 1714461, 1766881, 4375131, 2998141, 4404941, 4419831, 1766781, 2029621, 2115471, 2940891, 4421981, 4226761, 3614211, 3568991, 1526801, 376151, 2333041, 1875641, 2115111, 2100961, 4372281, 4422121, 1812201, 3955911, 3463371, 3817951, 4239761, 2540411, 4429941, 952831, 1332381, 3389711, 3124571, 4423021, 4433821, 3226161, 4425291, 4428931, 4433631, 2210811, 3415431, 3857041, 4126231, 4423701, 4415971, 2214261, 1115171, 1707591, 3343361, 2339101, 29281, 4156231, 4279071, 4443421, 4443391, 2275531, 2997351, 4444291, 4418601, 4445491, 4398991, 4447051, 4304381, 4252581, 3478821, 4435341, 4448621, 4399811, 4200121, 4320981, 4447091, 1435321, 968331, 4192871, 3610171, 2279921, 1597391, 1034591, 4453061, 4457091, 4454451, 4437511, 3201911, 1178081, 2864761, 2046431, 4459061, 2236491, 4356561, 4280371, 2158431, 1396971, 3150191, 1330381, 4463681, 1796141, 464051, 3129621, 4284701, 2104211, 2474041, 4424951, 4469281, 4434111, 4458001, 1071241, 4176091, 3001231, 1937171, 4262371, 1442301, 2985911, 2485471, 4468781, 4385771, 1144281, 2791461, 2218821, 3368081, 2794871, 3480931, 4464801, 1100011, 1203231, 2287781, 4254301, 2259371, 4462431, 4479341, 4482191, 2188041, 4483991, 1067001, 1597151, 1819521, 4466981, 4450511, 4472621, 4488381, 2079811, 1033731, 1855651, 4490501, 4452801, 4036171, 4032501, 4156541, 1709821, 4446771, 3875801, 2312891, 2283421, 1399421, 3940061, 3665851, 1782221, 3400181, 3932911, 974851, 1016011, 2941981, 2723091, 3928181, 2326591, 2923451, 1410661, 1522461, 3270831, 3954141, 2223351, 2776011, 3530481, 2394751, 3730491, 3855461, 3562771, 4003521, 2133891, 1853811, 4009621, 3551951, 2937421, 2294881, 980911, 1703391, 2755011, 1496141, 2130141, 76521, 1336051, 169311, 3584401, 3305661, 2568861, 3956611, 1938471, 4013421, 1925331, 3731641, 3911321, 1849221, 2930101, 3554231, 3046461, 3336391, 886081, 2752871, 3769411, 2121231, 2477291, 870121, 1739891, 2535941, 981841, 3935061, 3502901, 2209211, 2162821, 3915121, 3524421, 4031081, 2729411, 3947551, 4045791, 3345661, 2626441, 1025571, 2087751, 2088121, 1661291, 2132651, 2037771, 3474641, 3373451, 2256741, 3815701, 1055451, 2958391, 3674431, 2543081, 2787921, 1127141, 3519511, 2810111, 2144321, 3808471, 2985031, 3981111, 3431051, 1508281, 1271741, 4062691, 3079611, 117001, 2208361, 3933211, 2429021, 1965841, 2457521, 1401851, 4002621, 1602461, 1475491, 2314351, 1139191, 3034991, 2790511, 1212121, 1328051, 3372801, 2177281, 3865941, 1092631, 190591, 2994791, 4082791, 2814631, 1547941, 2208041, 3747181, 2460381, 4049921, 2993771, 3751781, 2144111, 1519301, 2104271, 870391, 3162091, 4113771, 1828071, 4036921, 2308421, 4074381, 3058361, 2303521, 2690511, 2810641, 2170191, 548601, 177031, 3303211, 1427491, 2983351, 1126491, 2400811, 2279971, 1139241, 3787001, 4018401, 981901, 1971471, 987411, 1263881, 3043971, 2909161, 4023301, 1072581, 1073651, 1024271, 1383491, 1894831, 1062651, 2228241, 2603721, 3595951, 2099541, 2981261, 3930381, 1282051, 2352391, 1840001, 2951631, 3471451, 1553361, 2037281, 3571331, 1189531, 1225981, 3699011, 1858491, 1657261, 2875961, 3669421, 1167111, 1106561, 1897401, 4121831, 1949541, 3640031, 3970141, 4094501, 1191411, 2186481, 2515851, 1610741, 1388201, 4063461, 1152281, 2246081, 2395181, 2192641, 3108061, 2317221, 1703471, 1643781, 1071311, 1610191, 1062541, 1838181, 2055791, 3003761, 3048121, 1844281, 3416681, 1325791, 2383981, 4081491, 885201, 4022111, 3375931, 1670021, 2846731, 4066171, 1055741, 4174161, 2341401, 1726401, 2215441, 2862681, 3205111, 3602251, 2754441, 3144141, 2251931, 2013621, 3506001, 3043691, 2140781, 1687521, 1132251, 1133301, 4153791, 41, 4206461, 1293851, 998151, 3829211, 1334291, 2384781, 4187261, 3430311, 2979631, 4227101, 4206531, 2054791, 2742211, 2598721, 2087771, 2270581, 976431, 4169231, 3203821, 2304961, 2368001, 3561871, 4186971, 4160181, 1234651, 1059431, 3872961, 3448441, 3303201, 4178151, 1987961, 3572051, 1950241, 1391231, 4167161, 4046661, 2130991, 2840651, 4264181, 2938321, 2264431, 2687291, 3750731, 2097181, 3944601, 1362941, 3895551, 2296881, 1496521, 2118621, 2517531, 3206761, 3186891, 3394351, 3186671, 3265601, 4278621, 3102111, 4152841, 1108821, 3505701, 2638251, 2584591, 3755911, 3222691, 4287961, 4301101, 1663761, 4149611, 4219311, 4310141, 3908741, 4320531, 1786161, 4326281, 2834371, 4328751, 4134561, 1321721, 2335991, 1440491, 240341, 4094341, 3908451, 2730291, 2217861, 4098681, 1110791, 1716591, 4279741, 2751661, 4325351, 1059321, 1701481, 232611, 3821611, 2323521, 3930431, 49401, 4169311, 1149891, 4167721, 1369251, 4361961, 995221, 2420221, 2307421, 1668051, 2744061, 4261001, 1007851, 4394131, 3262491, 3560951, 3320321, 2461571, 1007801, 1943431, 889931, 4404641, 2411781, 1712771, 2642031, 1013131, 2309331, 3416131, 2943941, 2171961, 23951, 3126371, 2430111, 2691971, 4015771, 3457951, 1655271, 4309131, 1572231, 4436771, 902691, 926981, 1283981, 4437051, 2142261, 4452871, 2416141, 2843701, 2599901, 129141, 2410211, 3240791, 4141361, 2280381, 1345171, 2987131, 4297141, 4127231, 2922851, 2980541, 3058941, 4462811, 2015541, 2397511, 3705221, 1857151, 2328671, 2782261, 3805941, 4481551, 1907281, 4447741, 2729461, 2314891, 1867161, 384251, 923871, 2113811, 1786531, 1896181, 3876341, 1734091, 2649261, 3567921, 1625221, 2054111, 1983081, 3179221, 2145641, 1508251, 2464891, 910451, 1797921, 2183521, 1563651, 3075741, 4168431, 1739681, 3165421, 4077861, 2834191, 2099851, 2082901, 3908631, 2523881, 3690051, 2092851, 2754151, 2263141, 3376791, 3771841, 862361, 908121, 1779311, 1984291, 4128521, 4155121, 1673561, 2165961, 1719111, 1735791, 1764961, 1682431}
	var users []model.User
	if err := mysql.ProdReadOnlyDB.Model(model.User{}).Where("id in ?", uids).Find(&users).Error; err != nil {
		panic(err)
	}
	uM := make(map[uint64]model.User)
	for k, u := range users {
		uM[u.Id] = users[k]
	}
	var data = make(map[uint64]*UserChargeData)
	for _, uid := range uids {
		m1, d1, _ := GetUsersChargeMoneySum([]uint64{uid})
		m2, d2, _ := GetUserDealerTransferMoneySum([]uint64{uid})
		data[uid] = &UserChargeData{UserId: uid, Code: uM[uid].Code, Country: uM[uid].Country, ChargeMoneySum: m1 + m2, ChargeDiamondSum: d1 + d2}
	}
	var err error
	var n = 0
	for d, u := range data {
		n++
		println(n)
		data[d].EarnDiamondSum, err = GetDiamondSumOperateTypeAll(u.UserId, 1)
		if err != nil {
			panic(err)
		}
		data[d].NotChargeDiamondSum = data[d].EarnDiamondSum - data[d].ChargeDiamondSum
		data[d].CostDiamondSum, err = GetDiamondSumOperateTypeAll(u.UserId, 2)
		if err != nil {
			panic(err)
		}
		data[d].GiftDiamondSum, err = GetDiamondSumOperateType2(u.UserId, 1)
		if err != nil {
			panic(err)
		}
		data[d].FruitDiamondCostSum, err = GetDiamondSumOperateType2(u.UserId, 39)
		if err != nil {
			panic(err)
		}
		data[d].FruitDiamondEarnSum, err = GetDiamondSumOperateType2(u.UserId, 38)
		if err != nil {
			panic(err)
		}
		//data[d].BoxDiamondSum, err = GetDiamondSumOperateType2(u.UserId, 29)
		//if err != nil {
		//	panic(err)
		//}
		data[d].FruitDiamondDiff = data[d].FruitDiamondEarnSum - data[d].FruitDiamondCostSum
		data[d].SlotsDiamondCostSum, err = GetDiamondSumOperateType2(u.UserId, 69)
		if err != nil {
			panic(err)
		}
		data[d].SlotsDiamondEarnSum, err = GetDiamondSumOperateType2(u.UserId, 70)
		if err != nil {
			panic(err)
		}
		data[d].SlotsDiamondDiff = data[d].SlotsDiamondEarnSum - data[d].SlotsDiamondCostSum
	}
	excelFileName := fmt.Sprintf("./充值数据1%s.xlsx", time.Now().Format("20060102"))
	xlFile := xlsx.NewFile()
	sheet, err := xlFile.AddSheet("charge")
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value = "code", "country", "充值美分", "获得钻石数", "充值钻石数"
	c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value = "非充值钻石数", "消费钻石总数", "礼物消费", "水果机投注", "水果机净消费", "slot净消费"
	for _, d := range data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value = d.Code, d.Country, ats(d.ChargeMoneySum), ats(d.EarnDiamondSum), ats(d.ChargeDiamondSum)
		c6.Value, c7.Value, c8.Value, c9.Value, c10.Value, c11.Value = ats(d.NotChargeDiamondSum), ats(d.CostDiamondSum), ats(d.GiftDiamondSum), ats(d.FruitDiamondCostSum), ats(d.FruitDiamondDiff), ats(d.SlotsDiamondDiff)
	}
	_ = xlFile.Save(excelFileName)
}

// 获取用户范围内充值金额
// param sinceTime: 过去n时间内
// 返回美分
func GetUsersChargeMoneySum(uids []uint64) (int64, int64, error) {
	if len(uids) <= 0 {
		return 0, 0, nil
	}
	type R struct {
		Money   int64
		Diamond int64
	}
	var money R
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN pay_order AS p ON d.origin_id = p.id").
		Where("d.user_id in (?) AND operate_type in (?) AND add_reduce = 1",
			uids, []int{int(4), int(42), int(55), int(68)}).
		Where("d.created_time >= ? AND d.created_time < ?", bt, et).
		Order("d.user_id").
		Select("SUM(p.price) as money,SUM(d.num) as diamond").Scan(&money).Error; err != nil {
		return 0, 0, err
	}
	return money.Money, money.Diamond, nil
}

// 获取代理范围内总充值金额
// param sinceTime: 过去n时间内
// 返回美分
func GetUserDealerTransferMoneySum(uids []uint64) (int64, int64, error) {
	if len(uids) <= 0 {
		return 0, 0, nil
	}
	type R struct {
		Price   int64
		Diamond int64
	}
	var money R
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN dealer_transfer_detail AS t ON d.origin_id = t.id").
		Where("d.user_id in (?) AND operate_type = ? AND add_reduce = 1",
			uids, 26).Select("SUM(t.dollar) as price,SUM(d.num) as diamond").
		Where("d.created_time >= ? AND d.created_time < ?", bt, et).
		Order("d.user_id").
		Scan(&money).Error; err != nil {
		return 0, 0, err
	}
	return money.Price, money.Diamond, nil
}

func GetDiamondSumOperateTypeAll(uid uint64, addReduce int) (int64, error) {
	var num int64
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail").
		Where("user_id = ? AND add_reduce = ?", uid, addReduce).
		Where("created_time >= ? AND created_time < ?", bt, et).
		Group("user_id").
		Select("SUM(num) as num").
		Scan(&num).Error; err != nil {
		return num, err
	}
	return num, nil
}

// operType: 1:送礼 29:幸运盒子购买 39:水果机投注 69:slot消费
func GetDiamondSumOperateType2(uid uint64, operType int) (int64, error) {
	var num int64
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail").
		Where("user_id = ? AND operate_type = ?", uid, operType).
		Where("created_time >= ? AND created_time < ?", bt, et).
		Group("user_id").
		Select("SUM(num) as num").
		Scan(&num).Error; err != nil {
		return num, err
	}
	return num, nil
}
