package trtc

import (
	"fmt"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/config"
)

//创建群组的TRTC通道，token有效时长：一个星期
func CreateGroupTRTCUserSig(uid uint64, config config.TRTCConfig) string {
	expireTimeInSeconds := 60 * 60 * 24 * 7 //一个星期

	sig, err := GenUserSig(config.APP_ID, config.APP_CERTIFICATE, fmt.Sprintf("%d", uid), expireTimeInSeconds)
	if err != nil {
		mylogrus.MyLog.Errorf("CreateGroupTRTCUserSig uid:%d, err:%v", uid, err)
	}
	mylogrus.MyLog.Infof("CreateGroupTRTCUserSig uid:%d, token:%s", uid, sig)

	return sig
}
