package rpc

import (
	"encoding/json"
	"errors"
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/consul"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/utils"
	"math/rand"
)

const (
	defaultActivityConsulName   = "hiloActivity"
	defaultActivityServerScheme = "http"
	defaultActivityServerAddr   = "127.0.0.1:9010" // 默认内网转发,本地回环
)

var activityServerHost = []string{defaultActivityServerAddr}

func init() {
	go func() {
		consul.RegisterWatcher(defaultActivityConsulName, func(addr []string) {
			if len(addr) > 0 {
				activityServerHost = addr
			}
		})
	}()
}

// 活动积分增加 fType: 1.上麦 2.ludo游戏完成 3.slots游戏完成 4.fruit游戏完成 5.特定座驾进入房间
func AddActPoint(model *domain.Model, userId mysql.ID, fType mysql.Type, roomId int64) error {
	defer utils.CheckGoPanic()
	type Response struct {
		Code    int    `json:"code"`
		Message string `json:"message"`
	}
	_url := fmt.Sprintf("%v://%v/inner/act/addPoint", defaultActivityServerScheme, getActivityHost())
	resp, err := HttpPostForm(model, _url, nil, map[string]string{
		"userId": fmt.Sprintf("%d", userId),
		"fType":  fmt.Sprintf("%d", fType),
		"roomId": fmt.Sprintf("%d", roomId),
	})
	if err != nil {
		model.Log.Errorf("AddActPoint fail:%v", err)
		return err
	}
	response := new(Response)
	if err = json.Unmarshal(resp, response); err != nil {
		model.Log.Errorf("AddActPoint json fail:%v", err)
		return err
	}
	if response.Code != 200 {
		model.Log.Errorf("AddActPoint fail:%v", *response)
		return errors.New(response.Message)
	}
	return nil
}

func getActivityHost() string {
	l := len(activityServerHost)
	r := rand.Intn(l) // 随机一个
	mylogrus.MyLog.Infof("getHostActivity:%v---%v", r, activityServerHost[r])
	return activityServerHost[r]
}
