-- MySQL dump 10.13  Distrib 5.7.33, for Linux (x86_64)
--
-- Host: 47.244.34.27    Database: hilo
-- ------------------------------------------------------
-- Server version	8.0.20

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `act_award_config`
--

DROP TABLE IF EXISTS `act_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_award_config` (
  `id` bigint unsigned NOT NULL COMMENT 'id',
  `task_id` smallint unsigned NOT NULL COMMENT '任务ID',
  `n` smallint unsigned NOT NULL COMMENT '序列号',
  `type` smallint unsigned NOT NULL COMMENT '奖品类型',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'ID/贵族等级',
  `number` int unsigned NOT NULL COMMENT '数量',
  `duration` int unsigned NOT NULL DEFAULT '0' COMMENT '时长（天）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`task_id`,`n`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_award_record`
--

DROP TABLE IF EXISTS `act_award_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_award_record` (
  `activity_id` bigint unsigned NOT NULL,
  `type` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`activity_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动奖励发放记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_ballot`
--

DROP TABLE IF EXISTS `act_ballot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_ballot` (
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '金选票剩余可使用数量',
  `get_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '金选票获得的数量',
  `has_thumbs_up` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否获得了点赞卡0否1是',
  `is_thumbs_up` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否投出了点赞卡0否1是',
  `vote_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '别人投给我的金选票数量',
  `vote_thumbs_up_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '别人投给我的点赞卡数量',
  `cost_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '我投给别人的金选票数量',
  `tup_user_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '我把点赞卡投给了谁',
  `cost_diamond` bigint unsigned NOT NULL DEFAULT '0' COMMENT '已花费钻石',
  `imei` varchar(255) NOT NULL DEFAULT '' COMMENT '获得点赞卡的设备号',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT '获得点赞卡的ip',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `imei_idx` (`imei`) USING BTREE,
  UNIQUE KEY `ip_idx` (`ip`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='沙特国家管理员选票活动';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_ballot_log`
--

DROP TABLE IF EXISTS `act_ballot_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_ballot_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `receiver_id` bigint unsigned NOT NULL COMMENT '获得者id',
  `number` bigint unsigned NOT NULL COMMENT '金选票数量',
  `log_type` int unsigned NOT NULL COMMENT '类型1.金选票日志2.点赞卡日志',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_idx` (`user_id`) USING BTREE,
  KEY `rec_idx` (`receiver_id`) USING BTREE,
  KEY `ltype_idx` (`log_type`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=248 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='沙特国家管理员选票活动日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_ballot_record`
--

DROP TABLE IF EXISTS `act_ballot_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_ballot_record` (
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '剩余可使用票数',
  `get_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '累计获得的数量',
  `has_thumbs_up` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否获得了点赞卡0否1是',
  `is_thumbs_up` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否投出了点赞卡0否1是',
  `vote_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '别人投给我的选票数量',
  `vote_thumbs_up_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '别人投给我的点赞卡数量',
  `cost_ballot_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '我投给别人的金选票数量',
  `tup_user_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '我把点赞卡投给了谁',
  `cost_diamond` bigint unsigned NOT NULL DEFAULT '0' COMMENT '已花费钻石',
  `imei` varchar(255) NOT NULL DEFAULT '' COMMENT '获得点赞卡的设备号',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT '获得点赞卡的ip',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ac_id`,`user_id`),
  UNIQUE KEY `imei_idx` (`imei`) USING BTREE,
  UNIQUE KEY `ip_idx` (`ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动票数记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_ballot_record_log`
--

DROP TABLE IF EXISTS `act_ballot_record_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_ballot_record_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `receiver_id` bigint unsigned NOT NULL COMMENT '获得者id',
  `number` bigint unsigned NOT NULL COMMENT '选票数量',
  `log_type` int unsigned NOT NULL COMMENT '类型1.选票日志2.点赞卡日志',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ac_id_idx` (`ac_id`) USING BTREE,
  KEY `user_idx` (`user_id`) USING BTREE,
  KEY `rec_idx` (`receiver_id`) USING BTREE,
  KEY `ltype_idx` (`log_type`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动票数记录日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_charge_record`
--

DROP TABLE IF EXISTS `act_charge_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_charge_record` (
  `activity_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `diamond_amount` bigint unsigned NOT NULL DEFAULT '0' COMMENT '充值的黄钻数',
  `price` bigint unsigned NOT NULL DEFAULT '0' COMMENT '充值的花费（美分）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `svip_level` int unsigned NOT NULL DEFAULT '0' COMMENT 'svip等级',
  PRIMARY KEY (`activity_id`,`user_id`),
  KEY `created_time_IDX` (`created_time`) USING BTREE,
  KEY `updated_time_IDX` (`updated_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动充值记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_family_month_rank_log`
--

DROP TABLE IF EXISTS `act_family_month_rank_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_family_month_rank_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `period` varchar(20) NOT NULL DEFAULT '' COMMENT '月份',
  `family_id` bigint unsigned NOT NULL COMMENT '家族id',
  `rank_family` int unsigned NOT NULL DEFAULT '0' COMMENT '家族排名',
  `rank_user` int unsigned NOT NULL DEFAULT '0' COMMENT '用户在家族中的家族排名',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `award` varchar(500) NOT NULL DEFAULT '' COMMENT '获得的奖励',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `period` (`period`,`family_id`,`rank_user`),
  KEY `user_idx` (`user_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='家族月度排行发奖日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_fruit_rank_config`
--

DROP TABLE IF EXISTS `act_fruit_rank_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_fruit_rank_config` (
  `id` bigint unsigned NOT NULL,
  `level` smallint unsigned NOT NULL COMMENT '级别',
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章ID',
  `medal_duration` int unsigned NOT NULL COMMENT '勋章时长（单位天）',
  `headdress_id` bigint unsigned NOT NULL COMMENT '头饰ID',
  `headdress_duration` int NOT NULL COMMENT '头饰时长（单位秒， -1：无限）',
  `medal_id_times_five` bigint unsigned NOT NULL COMMENT '周榜连续5次奖励勋章ID',
  `medal_duration_times_five` int unsigned NOT NULL COMMENT '周榜连续5次奖励勋章时长（单位天）',
  `diamond_times_five` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL DEFAULT '1' COMMENT '配置类型1.周排行2.阶梯任务',
  `threshold` bigint NOT NULL DEFAULT '0' COMMENT '阈值,梯度奖励type=2时候用到',
  `gift_id` bigint NOT NULL DEFAULT '0' COMMENT '礼物id',
  `gift_duration` int NOT NULL DEFAULT '0' COMMENT '礼物时长，单位天',
  `gift_n` int NOT NULL DEFAULT '0' COMMENT '礼物数量',
  PRIMARY KEY (`id`),
  KEY `level_IDX` (`level`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='水果机下注排行奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_fruit_record`
--

DROP TABLE IF EXISTS `act_fruit_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_fruit_record` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint unsigned NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `take_award` tinyint NOT NULL DEFAULT '2' COMMENT '是否领取奖励 1:是 2:否',
  `area` tinyint NOT NULL DEFAULT '0' COMMENT '区域1.阿语2.非阿语',
  PRIMARY KEY (`period`,`user_id`,`area`),
  KEY `user_id_IDX` (`user_id`) USING BTREE,
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='水果机投注记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_fruit_user_award`
--

DROP TABLE IF EXISTS `act_fruit_user_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_fruit_user_award` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint unsigned NOT NULL,
  `type` int unsigned NOT NULL COMMENT '1.排行榜奖励2.个人梯度奖励',
  `level` smallint unsigned NOT NULL COMMENT '级别',
  `diamond` int unsigned NOT NULL DEFAULT '0',
  `has_five_reward` tinyint unsigned NOT NULL COMMENT '是否获得周榜连续5次奖励',
  `award_data` varchar(1000) NOT NULL DEFAULT '' COMMENT '具体获得了哪些奖励',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`,`type`,`level`),
  KEY `user_id_IDX` (`user_id`,`type`) USING BTREE,
  KEY `level_IDX` (`type`,`level`) USING BTREE,
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='水果机下注排行奖励发放记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_game_challenge_apply`
--

DROP TABLE IF EXISTS `act_game_challenge_apply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_game_challenge_apply` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `game_type` int NOT NULL DEFAULT '0' COMMENT '游戏类型1.candy',
  `act_id` int NOT NULL DEFAULT '0' COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `svip_lv` int NOT NULL DEFAULT '0' COMMENT '报名时的等级',
  `need_diamond` int NOT NULL DEFAULT '0' COMMENT '领取所需条件(n盈利钻石)',
  `diamond` int NOT NULL DEFAULT '0' COMMENT '可获得的钻石',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态 1未达到 2已领取',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '领取时间',
  `period` varchar(20) NOT NULL COMMENT '哪一天的挑战（东三区时间）',
  PRIMARY KEY (`id`),
  UNIQUE KEY `period` (`game_type`,`user_id`,`period`) USING BTREE,
  KEY `act_id` (`act_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='游戏挑战活动-申请任务表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_game_challenge_data`
--

DROP TABLE IF EXISTS `act_game_challenge_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_game_challenge_data` (
  `period` date NOT NULL COMMENT '开始日期',
  `game_type` int NOT NULL DEFAULT '0' COMMENT '游戏类型1.candy',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `area` tinyint(1) NOT NULL COMMENT '区域 1:阿语 2:非阿语',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`game_type`,`user_id`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏挑战活动日数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_game_challenge_prize`
--

DROP TABLE IF EXISTS `act_game_challenge_prize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_game_challenge_prize` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `game_type` int NOT NULL DEFAULT '0' COMMENT '游戏类型1.candy',
  `act_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '数据类型 1真实用户，2造假用户',
  `need_diamond` int NOT NULL DEFAULT '0' COMMENT '领取时候所需达到条件',
  `diamond` bigint unsigned NOT NULL DEFAULT '0' COMMENT '奖励钻石',
  `created_at` bigint unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `period` varchar(20) NOT NULL COMMENT '哪天的挑战',
  PRIMARY KEY (`id`),
  UNIQUE KEY `period_only` (`game_type`,`act_id`,`user_id`,`period`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='游戏挑战活动-领奖记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_gift_config`
--

DROP TABLE IF EXISTS `act_gift_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_gift_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` bigint unsigned NOT NULL,
  `gift_id` bigint unsigned NOT NULL COMMENT '礼物id',
  `status` tinyint unsigned NOT NULL COMMENT '1-开;2-关',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `act_gift_idx` (`activity_id`,`gift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动礼物配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_gift_record`
--

DROP TABLE IF EXISTS `act_gift_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_gift_record` (
  `activity_id` bigint unsigned NOT NULL,
  `send_user_id` bigint unsigned NOT NULL,
  `receive_user_id` bigint unsigned NOT NULL,
  `group_id` char(32) NOT NULL DEFAULT '',
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `team_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '战队id',
  `svip_sender` int unsigned NOT NULL DEFAULT '0' COMMENT '赠送人svip等级',
  `svip_receiver` int unsigned NOT NULL DEFAULT '0' COMMENT '收礼人svip等级',
  PRIMARY KEY (`activity_id`,`send_user_id`,`receive_user_id`,`group_id`),
  KEY `send_user_IDX` (`activity_id`,`receive_user_id`) USING BTREE,
  KEY `group_IDX` (`group_id`) USING BTREE,
  KEY `team_IDX` (`team_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动礼物记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_gift_record_cp`
--

DROP TABLE IF EXISTS `act_gift_record_cp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_gift_record_cp` (
  `activity_id` bigint unsigned NOT NULL,
  `send_user_id` bigint unsigned NOT NULL,
  `receive_user_id` bigint unsigned NOT NULL,
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `cp` varchar(200) NOT NULL DEFAULT '' COMMENT '两个userid拼成的值(小:大)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `svip_level` int unsigned NOT NULL DEFAULT '0' COMMENT 'svip等级',
  `svip_sender` int unsigned NOT NULL DEFAULT '0' COMMENT '赠送人svip等级',
  `svip_receiver` int unsigned NOT NULL DEFAULT '0' COMMENT '收礼人svip等级',
  PRIMARY KEY (`activity_id`,`send_user_id`,`receive_user_id`,`group_id`),
  KEY `send_user_IDX` (`activity_id`,`receive_user_id`) USING BTREE,
  KEY `group_IDX` (`group_id`) USING BTREE,
  KEY `cp_IDX` (`cp`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='cp活动礼物记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_highest_award_config`
--

DROP TABLE IF EXISTS `act_highest_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_highest_award_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `type` int unsigned NOT NULL COMMENT '奖励类型1.勋章',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '道具id',
  `diamond` int unsigned NOT NULL COMMENT '黄钻要求数量',
  `number` int unsigned NOT NULL COMMENT '数量',
  `duration` int unsigned NOT NULL DEFAULT '0' COMMENT '时长（天）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `acid_idx` (`ac_id`) USING BTREE,
  KEY `type_idx` (`type`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='活动奖励-取最高符合';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_lottery_config`
--

DROP TABLE IF EXISTS `act_lottery_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_lottery_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` int NOT NULL COMMENT '类型1.低概率2.高概率',
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `diamond` bigint unsigned NOT NULL COMMENT '钻石数量',
  `noble_level` bigint unsigned NOT NULL COMMENT '贵族等级',
  `noble_day` bigint unsigned NOT NULL COMMENT '贵族天数',
  `prize_value` bigint unsigned NOT NULL COMMENT '奖品价值',
  `prob` bigint unsigned NOT NULL COMMENT '中奖概率',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `index` smallint unsigned NOT NULL DEFAULT '0' COMMENT '客户端显示的位置',
  `property_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '座驾id',
  `property_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '座驾天数',
  `headdress_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '头饰id',
  `headdress_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '头饰天数',
  `medal_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '勋章id',
  `medal_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '勋章天数',
  PRIMARY KEY (`id`),
  KEY `ac_id` (`ac_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动抽奖配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_lottery_info`
--

DROP TABLE IF EXISTS `act_lottery_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_lottery_info` (
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `left_times` bigint unsigned NOT NULL DEFAULT '0' COMMENT '剩余总可使用抽奖次数',
  `get_times` bigint unsigned NOT NULL DEFAULT '0' COMMENT '累计获得的次数',
  `high_times` int NOT NULL DEFAULT '0' COMMENT 'left_times中，剩余高概率抽奖次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ac_id`,`user_id`),
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动抽奖信息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_lottery_log`
--

DROP TABLE IF EXISTS `act_lottery_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_lottery_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '道具id',
  `res_day` bigint unsigned NOT NULL DEFAULT '0' COMMENT '道具有效天数',
  `diamond` bigint unsigned NOT NULL DEFAULT '0' COMMENT '钻石数量',
  `noble_level` bigint unsigned NOT NULL DEFAULT '0' COMMENT '贵族等级',
  `noble_day` bigint unsigned NOT NULL DEFAULT '0' COMMENT '贵族天数',
  `prize_value` bigint unsigned NOT NULL DEFAULT '0' COMMENT '奖品价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `property_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '座驾id',
  `property_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '座驾天数',
  `headdress_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '头饰id',
  `headdress_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '头饰天数',
  `medal_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '勋章id',
  `medal_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '勋章天数',
  PRIMARY KEY (`id`),
  KEY `ac_id` (`ac_id`) USING BTREE,
  KEY `user_idx` (`user_id`) USING BTREE,
  KEY `prize_value` (`prize_value`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动抽奖中奖日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_point`
--

DROP TABLE IF EXISTS `act_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_point` (
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `point` bigint unsigned NOT NULL DEFAULT '0' COMMENT '活动积分',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ac_id`,`user_id`),
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动积分记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_point_log`
--

DROP TABLE IF EXISTS `act_point_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_point_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ac_id` bigint unsigned NOT NULL COMMENT '活动id',
  `user_id` bigint unsigned NOT NULL COMMENT 'id',
  `point` bigint unsigned NOT NULL DEFAULT '0' COMMENT '积分数量',
  `add_reduce` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '增加减少',
  `remark` varchar(10) NOT NULL DEFAULT '' COMMENT '备注',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ac_id` (`ac_id`) USING BTREE,
  KEY `user_idx` (`user_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=406 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动积分日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_record`
--

DROP TABLE IF EXISTS `act_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` smallint unsigned NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动名称',
  `banner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'banner图片',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `begin_time` datetime NOT NULL COMMENT '活动开始时间',
  `end_time` datetime NOT NULL COMMENT '活动结束时间',
  `status` smallint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `charge_switch` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否记录充值0否1是',
  `is_cp` tinyint NOT NULL DEFAULT '0' COMMENT '是否cp活动礼物',
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '0.全部区域；1.阿语区；2.除了阿语区的其他地区',
  `relate_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '关联的活动id',
  `ban_dealer` tinyint NOT NULL DEFAULT '1' COMMENT '是否禁止币商上榜',
  `svip_send` tinyint NOT NULL DEFAULT '0' COMMENT '送礼者所需svip等级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=508 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='通用活动';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_record_area`
--

DROP TABLE IF EXISTS `act_record_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_record_area` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `act_id` bigint unsigned NOT NULL COMMENT '活动id',
  `relate_id` bigint unsigned NOT NULL COMMENT '关联的活动id',
  `country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `relate_id_IDX` (`relate_id`,`country`),
  KEY `act_id_IDX` (`act_id`,`country`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动举办的国家区域';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_challenge_apply`
--

DROP TABLE IF EXISTS `act_slot_challenge_apply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_challenge_apply` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int NOT NULL DEFAULT '0' COMMENT '活动id',
  `user_id` int NOT NULL DEFAULT '0' COMMENT '用户id',
  `star_id` int NOT NULL DEFAULT '0' COMMENT '星级',
  `check_id` int NOT NULL DEFAULT '0' COMMENT '选中的任务id',
  `svip_lv` int NOT NULL DEFAULT '0' COMMENT '报名时的等级',
  `slot_lv` int NOT NULL DEFAULT '0' COMMENT '报名时的slot游戏等级',
  `reached_diamond` int NOT NULL DEFAULT '0' COMMENT '领取所需条件(n盈利钻石)',
  `diamond` int NOT NULL DEFAULT '0' COMMENT '可获得的钻石',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态 1未达到 2已领取',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '领取时间',
  `period` varchar(20) NOT NULL COMMENT '哪一天的挑战（东三区时间）',
  PRIMARY KEY (`id`),
  UNIQUE KEY `period` (`user_id`,`period`) USING BTREE,
  KEY `act_id` (`act_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slots挑战-申请任务表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_challenge_data`
--

DROP TABLE IF EXISTS `act_slot_challenge_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_challenge_data` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `area` tinyint(1) NOT NULL COMMENT '区域 1:阿语 2:非阿语',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot挑战活动日数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_challenge_prize`
--

DROP TABLE IF EXISTS `act_slot_challenge_prize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_challenge_prize` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int NOT NULL DEFAULT '0' COMMENT '活动id',
  `user_id` int NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '数据类型 1真实用户，2造假用户',
  `reached_diamond` int NOT NULL DEFAULT '0' COMMENT '领取时候所需达到条件',
  `diamond` int NOT NULL DEFAULT '0' COMMENT '奖励钻石',
  `created_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
  `period` varchar(20) NOT NULL COMMENT '哪天的挑战',
  PRIMARY KEY (`id`),
  UNIQUE KEY `period_only` (`act_id`,`user_id`,`period`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7335 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slots挑战-领奖记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_day_rank_area`
--

DROP TABLE IF EXISTS `act_slot_day_rank_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_day_rank_area` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `area` tinyint(1) NOT NULL COMMENT '区域 1:阿语 2:非阿语',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `take_award` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否领取奖励 1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot分区日榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_month_config`
--

DROP TABLE IF EXISTS `act_slot_month_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_month_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `prob` bigint unsigned NOT NULL COMMENT '中奖概率',
  `diamond` bigint unsigned NOT NULL COMMENT '钻石数量',
  `gift_id` bigint unsigned NOT NULL COMMENT '礼物id',
  `gift_num` bigint unsigned NOT NULL COMMENT '礼物数量',
  `noble_level` bigint unsigned NOT NULL COMMENT '贵族等级',
  `noble_day` bigint unsigned NOT NULL COMMENT '贵族天数',
  `headwear_id` bigint unsigned NOT NULL COMMENT '头饰id',
  `headwear_day` bigint unsigned NOT NULL COMMENT '头饰天数',
  `prize_value` bigint unsigned NOT NULL COMMENT '奖品价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slot月度活动抽奖配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_month_prize`
--

DROP TABLE IF EXISTS `act_slot_month_prize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_month_prize` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int NOT NULL DEFAULT '0' COMMENT '活动id',
  `user_id` int NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '数据类型 1真实用户，2造假用户',
  `reached_diamond` int NOT NULL DEFAULT '0' COMMENT '领取时候所需达到条件',
  `award_id` int NOT NULL DEFAULT '0' COMMENT '获得的奖励配置的id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `u_idx` (`act_id`,`user_id`) USING BTREE,
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slots月度活动-领奖记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_week_rank_area`
--

DROP TABLE IF EXISTS `act_slot_week_rank_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_week_rank_area` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `area` tinyint(1) NOT NULL COMMENT '区域 1:阿语 2:非阿语',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`,`area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot分区周榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_week_rank_config`
--

DROP TABLE IF EXISTS `act_slot_week_rank_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_week_rank_config` (
  `id` bigint unsigned NOT NULL,
  `type` tinyint NOT NULL DEFAULT '1' COMMENT '类型 1: 排行榜奖励 2:梯度奖励',
  `threshold` bigint NOT NULL DEFAULT '0' COMMENT '阈值,梯度奖励type=2时候用到',
  `level` smallint unsigned NOT NULL COMMENT '级别',
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章ID',
  `medal_duration` int unsigned NOT NULL COMMENT '勋章时长（单位天）',
  `headdress_id` bigint unsigned NOT NULL COMMENT '头饰ID',
  `headdress_duration` int NOT NULL COMMENT '头饰时长（单位秒， -1：无限）',
  `medal_id_times_five` bigint unsigned NOT NULL COMMENT '周榜连续5次奖励勋章ID',
  `medal_duration_times_five` int unsigned NOT NULL COMMENT '周榜连续5次奖励勋章时长（单位天）',
  `diamond_times_five` int unsigned NOT NULL,
  `gift_id` bigint NOT NULL DEFAULT '0' COMMENT '礼物id',
  `gift_duration` int NOT NULL DEFAULT '0' COMMENT '礼物时长，单位天',
  `gift_n` int NOT NULL DEFAULT '0' COMMENT '礼物数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `level_IDX` (`level`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slot周活动排行奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_slot_week_rank_user_award`
--

DROP TABLE IF EXISTS `act_slot_week_rank_user_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_slot_week_rank_user_award` (
  `period` date NOT NULL COMMENT '开始日期',
  `area` tinyint NOT NULL COMMENT '区域 1:阿语 2:非阿语',
  `user_id` bigint unsigned NOT NULL,
  `type` int unsigned NOT NULL COMMENT '1.排行榜奖励2.个人梯度奖励',
  `level` smallint unsigned NOT NULL COMMENT '级别',
  `diamond` int unsigned NOT NULL DEFAULT '0',
  `has_five_reward` tinyint unsigned NOT NULL COMMENT '是否获得周榜连续4次奖励',
  `award_data` varchar(1000) NOT NULL DEFAULT '' COMMENT '具体获得了哪些奖励',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `uni_indx` (`period`,`area`,`user_id`,`type`,`level`) USING BTREE,
  KEY `user_id_IDX` (`user_id`,`type`) USING BTREE,
  KEY `level_IDX` (`type`,`level`) USING BTREE,
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='slot下注排行奖励发放记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_task_config`
--

DROP TABLE IF EXISTS `act_task_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_task_config` (
  `activity_id` bigint unsigned NOT NULL,
  `task_id` smallint unsigned NOT NULL COMMENT '任务ID',
  `type` smallint unsigned NOT NULL COMMENT '任务类型：1-梯度奖；2-个人送礼排行；3-个人收礼排行；4-房间送礼排行',
  `name` varchar(64) NOT NULL COMMENT '任务名称',
  `threshold` int unsigned NOT NULL DEFAULT '0' COMMENT '任务触发值',
  `level` smallint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `diamond_pool` int unsigned NOT NULL DEFAULT '0' COMMENT '钻石瓜分奖池',
  `diamond_people` int unsigned NOT NULL DEFAULT '0' COMMENT '奖池瓜分人数',
  `diamond_from` smallint NOT NULL DEFAULT '0' COMMENT '奖池关联类型：1-个人送礼排行',
  `svip_limit` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否打开svip限制0否1是',
  PRIMARY KEY (`activity_id`,`task_id`),
  UNIQUE KEY `type_level_idx` (`activity_id`,`type`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动任务';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_team`
--

DROP TABLE IF EXISTS `act_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_team` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `act_uid_IDX` (`activity_id`,`user_id`),
  KEY `created_time_IDX` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动战队信息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_team_user`
--

DROP TABLE IF EXISTS `act_team_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_team_user` (
  `activity_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `team_id` bigint unsigned NOT NULL COMMENT 'act_team id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`activity_id`,`user_id`),
  KEY `team_IDX` (`team_id`),
  KEY `created_time_IDX` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动战队用户信息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `act_user_award`
--

DROP TABLE IF EXISTS `act_user_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `act_user_award` (
  `activity_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `type` int unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `diamond` int unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`activity_id`,`user_id`,`type`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='通用活动领奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_award_config`
--

DROP TABLE IF EXISTS `activity_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_award_config` (
  `id` bigint unsigned NOT NULL,
  `level` smallint unsigned NOT NULL COMMENT '级别',
  `diamond` int unsigned NOT NULL,
  `noble_level` smallint unsigned NOT NULL COMMENT '贵族等级',
  `noble_duration` int unsigned NOT NULL COMMENT '贵族时长（天）',
  `headdress_id` bigint unsigned NOT NULL COMMENT '头饰ID',
  `headdress_duration` int NOT NULL COMMENT '头饰时长（单位秒， -1：无限）',
  `property_id` bigint unsigned NOT NULL COMMENT '坐骑ID',
  `property_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章ID',
  `medal_duration` int unsigned NOT NULL COMMENT '勋章时长（单位天）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard`
--

DROP TABLE IF EXISTS `activity_billboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` bigint NOT NULL COMMENT '活动ID',
  `start_time` timestamp NOT NULL COMMENT '开始时间',
  `end_time` timestamp NOT NULL COMMENT '结束时间',
  `reward_time` timestamp NULL DEFAULT NULL COMMENT '发奖时间',
  `new_time` timestamp NULL DEFAULT NULL COMMENT '重新开始时间',
  `is_cycle` tinyint NOT NULL DEFAULT '0' COMMENT '是否周期',
  `n_cycle` int NOT NULL DEFAULT '0' COMMENT '周期次数',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint NOT NULL,
  `reward` tinyint NOT NULL DEFAULT '1' COMMENT '是否已经发放奖励（1：未发放 2：已经发放）',
  `type` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`activity_id`),
  KEY `Index_2` (`end_time`,`start_time`)
) ENGINE=InnoDB AUTO_INCREMENT=7401 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动—榜单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_be_like_config`
--

DROP TABLE IF EXISTS `activity_billboard_be_like_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_be_like_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` int NOT NULL COMMENT '周期（单位秒）',
  `woman_first_diamond` int NOT NULL COMMENT '女性第一名钻石数量',
  `woman_second_diamond` int NOT NULL COMMENT '女性第二名钻石数量',
  `woman_third_diamond` int NOT NULL COMMENT '女性第三名钻石数量',
  `woman_four_diamond` int NOT NULL COMMENT '女性第四名钻石数量',
  `woman_five_diamond` int NOT NULL COMMENT '女性第五名钻石数量',
  `woman_six_diamond` int NOT NULL COMMENT '女性第六名钻石数量',
  `woman_seven_diamond` int NOT NULL COMMENT '女性第七名钻石数量',
  `woman_eight_diamond` int NOT NULL COMMENT '女性第八名钻石数量',
  `woman_nine_diamond` int NOT NULL COMMENT '女性第九名钻石数量',
  `woman_ten_diamond` int NOT NULL COMMENT '女性第十名钻石数量',
  `woman_first_property_id` bigint NOT NULL COMMENT '女性第一名坐骑ID',
  `woman_second_property_id` bigint NOT NULL COMMENT '女性第二名坐骑ID',
  `woman_third_property_id` bigint NOT NULL COMMENT '女性第三名坐骑ID',
  `woman_fout_property_id` bigint NOT NULL COMMENT '女性第四名坐骑ID',
  `woman_five_property_id` bigint NOT NULL COMMENT '女性第五名坐骑ID',
  `woman_six_property_id` bigint NOT NULL COMMENT '女性第六名坐骑ID',
  `woman_seven_property_id` bigint NOT NULL COMMENT '女性第七名坐骑ID',
  `woman_eight_property_id` bigint NOT NULL COMMENT '女性第八名坐骑ID',
  `woman_nine_property_id` bigint NOT NULL COMMENT '女性第九名坐骑ID',
  `woman_ten_property_id` bigint NOT NULL COMMENT '女性第十名坐骑ID',
  `woman_first_property_duration` int NOT NULL COMMENT '女性第一名坐骑时长（单位秒， -1：无限）',
  `woman_second_property_duration` int NOT NULL COMMENT '女性第二名坐骑时长（单位秒， -1：无限）',
  `woman_third_property_duration` int NOT NULL COMMENT '女性第三名坐骑时长（单位秒， -1：无限）',
  `woman_fout_property_duration` int NOT NULL COMMENT '女性第四名坐骑时长（单位秒， -1：无限）',
  `woman_five_property_duration` int NOT NULL COMMENT '女性第五名坐骑时长（单位秒， -1：无限）',
  `woman_six_property_duration` int NOT NULL COMMENT '女性第六名坐骑时长（单位秒， -1：无限）',
  `woman_seven_property_duration` int NOT NULL COMMENT '女性第七名坐骑时长（单位秒， -1：无限）',
  `woman_eight_property_duration` int NOT NULL COMMENT '女性第八名坐骑时长（单位秒， -1：无限）',
  `woman_nine_property_duration` int NOT NULL COMMENT '女性第九名坐骑时长（单位秒， -1：无限）',
  `woman_ten_property_duration` int NOT NULL COMMENT '女性第十名坐骑时长（单位秒， -1：无限）',
  `woman_first_headwear_id` bigint NOT NULL DEFAULT '0' COMMENT '女性第一名坐骑ID',
  `woman_second_headwear_id` bigint NOT NULL COMMENT '女性第二名坐骑ID',
  `woman_third_headwear_id` bigint NOT NULL COMMENT '女性第三名坐骑ID',
  `woman_fout_headwear_id` bigint NOT NULL COMMENT '女性第四名坐骑ID',
  `woman_five_headwear_id` bigint NOT NULL COMMENT '女性第五名坐骑ID',
  `woman_six_headwear_id` bigint NOT NULL COMMENT '女性第六名坐骑ID',
  `woman_seven_headwear_id` bigint NOT NULL COMMENT '女性第七名坐骑ID',
  `woman_eight_headwear_id` bigint NOT NULL COMMENT '女性第八名坐骑ID',
  `woman_nine_headwear_id` bigint NOT NULL COMMENT '女性第九名坐骑ID',
  `woman_ten_headwear_id` bigint NOT NULL COMMENT '女性第十名坐骑ID',
  `woman_first_headwear_duration` int NOT NULL COMMENT '女性第一名坐骑时长（单位秒， -1：无限）',
  `woman_second_headwear_duration` int NOT NULL COMMENT '女性第二名坐骑时长（单位秒， -1：无限）',
  `woman_third_headwear_duration` int NOT NULL COMMENT '女性第三名坐骑时长（单位秒， -1：无限）',
  `woman_fout_headwear_duration` int NOT NULL COMMENT '女性第四名坐骑时长（单位秒， -1：无限）',
  `woman_five_headwear_duration` int NOT NULL COMMENT '女性第五名坐骑时长（单位秒， -1：无限）',
  `woman_six_headwear_duration` int NOT NULL COMMENT '女性第六名坐骑时长（单位秒， -1：无限）',
  `woman_seven_headwear_duration` int NOT NULL COMMENT '女性第七名坐骑时长（单位秒， -1：无限）',
  `woman_eight_headwear_duration` int NOT NULL COMMENT '女性第八名坐骑时长（单位秒， -1：无限）',
  `woman_nine_headwear_duration` int NOT NULL COMMENT '女性第九名坐骑时长（单位秒， -1：无限）',
  `woman_ten_headwear_duration` int NOT NULL COMMENT '女性第十名坐骑时长（单位秒， -1：无限）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单被喜欢配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_config`
--

DROP TABLE IF EXISTS `activity_billboard_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `talk_time` int NOT NULL COMMENT '通话时长\r\n            ',
  `cycle` int NOT NULL COMMENT '周期（单位秒）',
  `man_first_diamond` int NOT NULL COMMENT '男性第一名钻石数量',
  `man_second_diamond` int NOT NULL COMMENT '男性第二名钻石数量',
  `man_third_diamond` int NOT NULL COMMENT '男性第三名钻石数量',
  `man_first_property_id` bigint NOT NULL COMMENT '男性第一名坐骑ID',
  `man_second_property_id` bigint NOT NULL COMMENT '男性第二名坐骑ID',
  `man_third_property_id` bigint NOT NULL COMMENT '男性第三名坐骑ID',
  `man_first_property_duration` int NOT NULL COMMENT '男性第一名坐骑时长（单位秒， -1：无限）',
  `man_second_property_duration` int NOT NULL COMMENT '男性第二名坐骑时长（单位秒， -1：无限）',
  `man_third_property_duration` int NOT NULL COMMENT '男性第三名坐骑时长（单位秒， -1：无限）',
  `woman_first_diamond` int NOT NULL COMMENT '女性第一名钻石数量',
  `woman_second_diamond` int NOT NULL COMMENT '女性第二名钻石数量',
  `woman_third_diamond` int NOT NULL COMMENT '女性第三名钻石数量',
  `woman_first_property_id` bigint NOT NULL COMMENT '女性第一名坐骑ID',
  `woman_second_property_id` bigint NOT NULL COMMENT '女性第二名坐骑ID',
  `woman_third_property_id` bigint NOT NULL COMMENT '女性第三名坐骑ID',
  `woman_first_property_duration` int NOT NULL COMMENT '女性第一名坐骑时长（单位秒， -1：无限）',
  `woman_second_property_duration` int NOT NULL COMMENT '女性第二名坐骑时长（单位秒， -1：无限）',
  `woman_third_property_duration` int NOT NULL COMMENT '女性第三名坐骑时长（单位秒， -1：无限）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_cp_config`
--

DROP TABLE IF EXISTS `activity_billboard_cp_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_cp_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` int NOT NULL COMMENT '周期（单位秒）',
  `first_diamond` int NOT NULL COMMENT '第一名钻石数量',
  `second_diamond` int NOT NULL COMMENT '第二名钻石数量',
  `third_diamond` int NOT NULL COMMENT '第三名钻石数量',
  `woman_first_headwear_id` bigint NOT NULL COMMENT '女性第一名坐骑ID',
  `woman_second_headwear_id` bigint NOT NULL COMMENT '女性第二名坐骑ID',
  `woman_third_headwear_id` bigint NOT NULL COMMENT '女性第三名坐骑ID',
  `woman_first_headwear_duration` int NOT NULL COMMENT '女性第一名坐骑时长（单位秒， -1：无限）',
  `woman_second_headwear_duration` int NOT NULL COMMENT '女性第二名坐骑时长（单位秒， -1：无限）',
  `woman_third_headwear_duration` int NOT NULL COMMENT '女性第三名坐骑时长（单位秒， -1：无限）',
  `man_first_headwear_id` bigint NOT NULL COMMENT '男性第一名坐骑ID',
  `man_second_headwear_id` bigint NOT NULL COMMENT '男性第二名坐骑ID',
  `man_third_headwear_id` bigint NOT NULL COMMENT '男性第三名坐骑ID',
  `man_first_headwear_duration` int NOT NULL COMMENT '男性第一名坐骑时长（单位秒， -1：无限）',
  `man_second_headwear_duration` int NOT NULL COMMENT '男性第二名坐骑时长（单位秒， -1：无限）',
  `man_third_headwear_duration` int NOT NULL COMMENT '男性第三名坐骑时长（单位秒， -1：无限）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `man_second_property_id` bigint NOT NULL COMMENT '男性第二名坐骑ID',
  `man_third_property_id` bigint NOT NULL COMMENT '男性第三名坐骑ID',
  `man_second_property_duration` int NOT NULL COMMENT '男性第二名坐骑时长（单位秒， -1：无限）',
  `man_third_property_duration` int NOT NULL COMMENT '男性第三名坐骑时长（单位秒， -1：无限）',
  `woman_second_property_id` bigint NOT NULL COMMENT '女性第二名坐骑ID',
  `woman_third_property_id` bigint NOT NULL COMMENT '女性第三名坐骑ID',
  `woman_second_property_duration` int NOT NULL COMMENT '女性第二名坐骑时长（单位秒， -1：无限）',
  `woman_third_property_duration` int NOT NULL COMMENT '女性第三名坐骑时长（单位秒， -1：无限）',
  `man_first_property_id` bigint NOT NULL COMMENT '男性第一名坐骑ID',
  `woman_first_property_id` bigint NOT NULL COMMENT '女性第一名坐骑ID',
  `man_first_property_duration` bigint NOT NULL COMMENT '男性第一名坐骑时长',
  `woman_first_property_duration` bigint NOT NULL COMMENT '女性第一名坐骑时长',
  `count_top1_medal_id` bigint NOT NULL DEFAULT '0',
  `count_top1_medal_duration` bigint NOT NULL,
  `count_top1_num` int NOT NULL,
  `count_top2_medal_id` bigint NOT NULL DEFAULT '0',
  `count_top2_medal_duration` bigint NOT NULL,
  `count_top2_num` int NOT NULL,
  `count_top3_medal_id` bigint NOT NULL DEFAULT '0',
  `count_top3_medal_duration` bigint NOT NULL,
  `count_top3_num` int NOT NULL,
  `top3_limit` int NOT NULL,
  `first_noble_level` int NOT NULL,
  `first_noble_duration` int NOT NULL,
  `second_noble_level` int DEFAULT NULL,
  `second_noble_duration` int DEFAULT NULL,
  `third_noble_level` int DEFAULT NULL,
  `third_noble_duration` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_pk`
--

DROP TABLE IF EXISTS `activity_billboard_pk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_pk` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` tinyint NOT NULL COMMENT '类型（1：2：匹配喜欢）',
  `activity_billboard_id` bigint NOT NULL COMMENT '榜单ID',
  `id1` bigint NOT NULL COMMENT 'id1',
  `id2` bigint NOT NULL COMMENT 'id2',
  `status` tinyint NOT NULL COMMENT 'status',
  `win_id` bigint NOT NULL COMMENT 'win_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`activity_billboard_id`,`id1`,`id2`),
  UNIQUE KEY `activity_billboard_id` (`activity_billboard_id`,`id1`),
  UNIQUE KEY `activity_billboard_id_2` (`activity_billboard_id`,`id2`) USING BTREE,
  UNIQUE KEY `activity_billboard_id_3` (`activity_billboard_id`,`id2`,`id1`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单PK';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_reward`
--

DROP TABLE IF EXISTS `activity_billboard_reward`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_reward` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_user_id` bigint NOT NULL COMMENT '活动榜单用户ID',
  `group_uid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `diamond` int NOT NULL COMMENT '钻石数量',
  `property_id` bigint NOT NULL COMMENT '坐骑ID',
  `property_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `headwear_id` bigint NOT NULL COMMENT '坐骑ID',
  `headwear_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `medal_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '勋章ID',
  `medal_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '勋章时长（单位:天）',
  `noble_leave` int NOT NULL,
  `noble_duration` int NOT NULL,
  `opportunity` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`activity_billboard_user_id`,`user_id`),
  KEY `Index_1` (`activity_billboard_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6884 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_trigger`
--

DROP TABLE IF EXISTS `activity_billboard_trigger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_trigger` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_id` bigint NOT NULL COMMENT '榜单ID',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `type` tinyint NOT NULL COMMENT '活动类型',
  `trigger_id` bigint NOT NULL COMMENT '条件ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`activity_billboard_id`,`user_id`,`trigger_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1908 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单触发结果';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_user`
--

DROP TABLE IF EXISTS `activity_billboard_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_id` bigint NOT NULL COMMENT '榜单ID',
  `user_id` bigint NOT NULL COMMENT '用户ID/CP_ID',
  `score` int NOT NULL COMMENT '分数',
  `type` tinyint NOT NULL DEFAULT '1',
  `history` tinyint NOT NULL DEFAULT '2' COMMENT '1:是历史记录 2：不是历史记录（结算了，才算历史记录）',
  `n` int NOT NULL DEFAULT '0' COMMENT '排名（只有history=1）的情况才有效',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`activity_billboard_id`,`user_id`),
  KEY `Index_1` (`activity_billboard_id`,`score`,`updated_time`) USING BTREE,
  KEY `activity_billboard_id` (`activity_billboard_id`,`history`,`score`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单参与用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_billboard_user_detail`
--

DROP TABLE IF EXISTS `activity_billboard_user_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_billboard_user_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_id` bigint NOT NULL COMMENT '活动榜单ID',
  `activity_billboard_user_id` bigint NOT NULL COMMENT '活动榜单用户ID',
  `user_id` bigint NOT NULL COMMENT '用户ID/CP_ID',
  `other_user_id` bigint NOT NULL COMMENT '另一个用户Id',
  `match_confirm_id` bigint NOT NULL COMMENT '匹配确认结果ID',
  `score` int NOT NULL COMMENT '分数',
  `type` tinyint NOT NULL DEFAULT '1',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_type_un` (`user_id`,`match_confirm_id`,`type`),
  KEY `activity_billboard_user_id` (`activity_billboard_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19372 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单参与用户详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_config`
--

DROP TABLE IF EXISTS `activity_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动标题',
  `url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '前端URL',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图片',
  `begin_time` datetime NOT NULL COMMENT '活动开始时间',
  `end_time` datetime NOT NULL COMMENT '活动结束时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_day_pay_dealer_trigger_award_config`
--

DROP TABLE IF EXISTS `activity_day_pay_dealer_trigger_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_day_pay_dealer_trigger_award_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `trigger_config_id` bigint NOT NULL COMMENT 'trigger_config_id',
  `n` bigint NOT NULL COMMENT 'diamond的数量，也可以时头饰的ID',
  `duration` int NOT NULL COMMENT '周期（秒）',
  `rate` int NOT NULL COMMENT '比率 40/100',
  `type` tinyint NOT NULL COMMENT '类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='每日充值活动奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_day_pay_dealer_trigger_config`
--

DROP TABLE IF EXISTS `activity_day_pay_dealer_trigger_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_day_pay_dealer_trigger_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `dollar_total` int NOT NULL COMMENT '美元总量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='每日充值活动';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_group_billboard`
--

DROP TABLE IF EXISTS `activity_group_billboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_group_billboard` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` bigint NOT NULL COMMENT '活动ID',
  `start_time` timestamp NOT NULL COMMENT '开始时间',
  `end_time` timestamp NOT NULL COMMENT '结束时间',
  `status` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`activity_id`),
  KEY `Index_2` (`end_time`,`start_time`)
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动-群组—榜单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_group_billboard_config`
--

DROP TABLE IF EXISTS `activity_group_billboard_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_group_billboard_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` int NOT NULL COMMENT '周期（单位秒）',
  `first_diamond` int NOT NULL COMMENT '男性第一名钻石数量',
  `second_diamond` int NOT NULL COMMENT '男性第二名钻石数量',
  `third_diamond` int NOT NULL COMMENT '男性第三名钻石数量',
  `first_property_id` bigint NOT NULL COMMENT '男性第一名坐骑ID',
  `second_property_id` bigint NOT NULL COMMENT '男性第二名坐骑ID',
  `third_property_id` bigint NOT NULL COMMENT '男性第三名坐骑ID',
  `first_property_duration` int NOT NULL COMMENT '男性第一名坐骑时长（单位秒， -1：无限）',
  `second_property_duration` int NOT NULL COMMENT '男性第二名坐骑时长（单位秒， -1：无限）',
  `third_property_duration` int NOT NULL COMMENT '男性第三名坐骑时长（单位秒， -1：无限）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组活动榜单配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_group_billboard_result`
--

DROP TABLE IF EXISTS `activity_group_billboard_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_group_billboard_result` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_group_billboard_id` bigint NOT NULL COMMENT '榜单ID',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户ID',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`activity_group_billboard_id`,`group_id`),
  KEY `Index_1` (`activity_group_billboard_id`,`score`,`updated_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1222 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动群组榜单参与用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_group_billboard_reward`
--

DROP TABLE IF EXISTS `activity_group_billboard_reward`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_group_billboard_reward` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_group_billboard_result_id` bigint NOT NULL COMMENT '活动榜单用户ID',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户ID',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `diamond` int NOT NULL COMMENT '钻石数量',
  `property_id` bigint NOT NULL COMMENT '坐骑ID',
  `property_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`activity_group_billboard_result_id`,`user_id`),
  KEY `Index_1` (`activity_group_billboard_result_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=662 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite`
--

DROP TABLE IF EXISTS `activity_invite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `apply_user_id` bigint NOT NULL COMMENT '申请人ID',
  `apply_ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invite_user_id` bigint NOT NULL COMMENT '邀请人ID',
  `profile_pic` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'profile_pic',
  `assess_pic` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'assess_pic',
  `mgr_id` bigint NOT NULL COMMENT '管理人',
  `status` tinyint NOT NULL COMMENT '状态(1:未处理 2：通过 3：未通过)',
  `audit_time` datetime DEFAULT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index_1` (`apply_user_id`) USING BTREE,
  KEY `Index_2` (`invite_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=724 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动-邀请新人';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202210`
--

DROP TABLE IF EXISTS `activity_invite_award_202210`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202210` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202211`
--

DROP TABLE IF EXISTS `activity_invite_award_202211`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202211` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202212`
--

DROP TABLE IF EXISTS `activity_invite_award_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202212` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202301`
--

DROP TABLE IF EXISTS `activity_invite_award_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202301` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202302`
--

DROP TABLE IF EXISTS `activity_invite_award_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202302` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202303`
--

DROP TABLE IF EXISTS `activity_invite_award_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202303` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_award_202304`
--

DROP TABLE IF EXISTS `activity_invite_award_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_award_202304` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_invite_ward`
--

DROP TABLE IF EXISTS `activity_invite_ward`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_invite_ward` (
  `user_id` bigint unsigned NOT NULL COMMENT '邀请人',
  `stage` smallint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`stage`),
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_month_pay_dealer_trigger_config`
--

DROP TABLE IF EXISTS `activity_month_pay_dealer_trigger_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_month_pay_dealer_trigger_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `dollar_total` int NOT NULL COMMENT '美元总量',
  `diamond` int NOT NULL COMMENT '奖励钻石',
  `headwear_id` bigint NOT NULL COMMENT '奖励头饰ID',
  `headwear_duration` int NOT NULL COMMENT '奖励头饰时长（秒）',
  `property_id` bigint NOT NULL COMMENT '奖励座驾ID',
  `property_duration` int NOT NULL COMMENT '奖励座驾时长（秒）',
  `noble_level` int NOT NULL DEFAULT '0',
  `noble_duration` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章id',
  `medal_duration` bigint unsigned NOT NULL COMMENT '勋章时长（秒）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='每月充值活动';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_ramadan_gift_config`
--

DROP TABLE IF EXISTS `activity_ramadan_gift_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_ramadan_gift_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT '礼物ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`res_gift_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='斋日触发礼物';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_ramadan_group_config`
--

DROP TABLE IF EXISTS `activity_ramadan_group_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_ramadan_group_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `first_medal_id` bigint NOT NULL COMMENT '第一名勋章ID',
  `second_medal_id` bigint NOT NULL COMMENT '第二名勋章ID',
  `third_medal_id` bigint NOT NULL COMMENT '第三名勋章ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='斋日活动群组配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_ramadan_trigger_config`
--

DROP TABLE IF EXISTS `activity_ramadan_trigger_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_ramadan_trigger_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `trigger_diamond` int NOT NULL COMMENT '触发钻石',
  `property_id1` bigint NOT NULL COMMENT '座驾ID',
  `property_duration1` int NOT NULL COMMENT '座驾时长',
  `property_id2` bigint NOT NULL COMMENT '座驾ID',
  `property_duration2` int NOT NULL COMMENT '座驾时长',
  `headwear_id1` bigint NOT NULL COMMENT '头饰ID',
  `headwear_duration1` int NOT NULL COMMENT '头饰时长',
  `headwear_id2` bigint NOT NULL COMMENT '头饰ID',
  `headwear_duration2` int NOT NULL COMMENT '头饰时长',
  `medal_id` bigint NOT NULL COMMENT '勋章ID',
  `medal_duration` int NOT NULL COMMENT '勋章时长',
  `diamond` int NOT NULL COMMENT '钻石',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='斋日触发';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_ramadan_user_config`
--

DROP TABLE IF EXISTS `activity_ramadan_user_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_ramadan_user_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` tinyint NOT NULL,
  `first_diamond` int NOT NULL,
  `second_diamond` int NOT NULL,
  `third_diamond` int NOT NULL,
  `first_property_id` bigint NOT NULL COMMENT '第一名座驾ID',
  `first_property_duration` int NOT NULL COMMENT '第一名座驾时长',
  `second_property_id` bigint NOT NULL COMMENT '第二名座驾ID',
  `second_property_duration` int NOT NULL COMMENT '第二名座驾时长',
  `third_property_id` bigint NOT NULL COMMENT '第三名座驾ID',
  `third_property_duration` int NOT NULL COMMENT '第三名座驾时长',
  `first_headwear_id1` bigint NOT NULL COMMENT '第一名头饰ID',
  `first_headwear_duration1` int NOT NULL COMMENT '第一名头饰时长',
  `first_headwear_id2` bigint NOT NULL COMMENT '第一名头饰ID',
  `first_headwear_duration2` int NOT NULL COMMENT '第一名头饰时长',
  `second_headwear_id1` bigint NOT NULL COMMENT '第二名头饰ID',
  `second_headwear_duration1` int NOT NULL COMMENT '第二名头饰时长',
  `second_headwear_id2` bigint NOT NULL COMMENT '第二名头饰ID',
  `second_headwear_duration2` int NOT NULL COMMENT '第二名头饰时长',
  `third_headwear_id1` bigint NOT NULL COMMENT '第三名头饰ID',
  `third_headwear_duration1` int NOT NULL COMMENT '第三名头饰时长',
  `third_headwear_id2` bigint NOT NULL COMMENT '第三名头饰ID',
  `third_headwear_duration2` int NOT NULL COMMENT '第三名头饰时长',
  `first_medal_id` bigint NOT NULL COMMENT '第一名勋章ID',
  `first_medal_duration` int NOT NULL COMMENT '第一名勋章时长(特殊情况：单位天)',
  `second_medal_id` bigint NOT NULL COMMENT '第二名勋章ID',
  `second_medal_duration` int NOT NULL COMMENT '第二名勋章时长(特殊情况：单位天)',
  `third_medal_id` bigint NOT NULL COMMENT '第三名勋章ID',
  `third_medal_duration` int NOT NULL COMMENT '第三名勋章时长(特殊情况：单位天)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `first_noble_level` int NOT NULL DEFAULT '0',
  `first_noble_duration` int NOT NULL DEFAULT '0',
  `second_noble_level` int NOT NULL DEFAULT '0',
  `second_noble_duration` int NOT NULL DEFAULT '0',
  `third_noble_level` int NOT NULL DEFAULT '0',
  `third_noble_duration` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='斋日活动用户配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_recharge_first_config`
--

DROP TABLE IF EXISTS `activity_recharge_first_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_recharge_first_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `res_medal_id` bigint NOT NULL COMMENT '勋章ID',
  `res_medal_duration` int NOT NULL COMMENT '勋章时长',
  `res_medal_diamond` int NOT NULL,
  `res_headwear_id` bigint NOT NULL COMMENT '头饰ID',
  `res_headwear_duration` int NOT NULL COMMENT '头饰时长',
  `res_headwear_diamond` int NOT NULL,
  `res_property_id` bigint NOT NULL COMMENT '座驾ID',
  `res_property_duration` int NOT NULL COMMENT '座驾时长',
  `res_property_diamond` int NOT NULL,
  `res_noble_level` int NOT NULL COMMENT '贵族等级',
  `res_noble_duration` int NOT NULL COMMENT '贵族时长',
  `res_noble_diamond` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动首充配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_recharge_first_user`
--

DROP TABLE IF EXISTS `activity_recharge_first_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_recharge_first_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond_account_detail_id` bigint NOT NULL COMMENT 'diamond_account_detail_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=858 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动首充用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_tunisia_national_day_gift_config`
--

DROP TABLE IF EXISTS `activity_tunisia_national_day_gift_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_tunisia_national_day_gift_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT '礼物ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`res_gift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='突尼斯国庆节触发礼物';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_tunisia_national_day_group_config`
--

DROP TABLE IF EXISTS `activity_tunisia_national_day_group_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_tunisia_national_day_group_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `first_medal_id` bigint NOT NULL COMMENT '第一名勋章ID',
  `second_medal_id` bigint NOT NULL COMMENT '第二名勋章ID',
  `third_medal_id` bigint NOT NULL COMMENT '第三名勋章ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='突尼斯国庆日活动群组配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_tunisia_national_day_trigger_config`
--

DROP TABLE IF EXISTS `activity_tunisia_national_day_trigger_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_tunisia_national_day_trigger_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `trigger_diamond` int NOT NULL COMMENT '触发钻石',
  `property_id1` bigint NOT NULL COMMENT '座驾ID',
  `property_duration1` int NOT NULL COMMENT '座驾时长',
  `property_id2` bigint NOT NULL COMMENT '座驾ID',
  `property_duration2` int NOT NULL COMMENT '座驾时长',
  `headwear_id1` bigint NOT NULL COMMENT '头饰ID',
  `headwear_duration1` int NOT NULL COMMENT '头饰时长',
  `headwear_id2` bigint NOT NULL COMMENT '头饰ID',
  `headwear_duration2` int NOT NULL COMMENT '头饰时长',
  `medal_id` bigint NOT NULL COMMENT '勋章ID',
  `medal_duration` int NOT NULL COMMENT '勋章时长',
  `diamond` int NOT NULL COMMENT '钻石',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='突尼斯国庆节触发';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `activity_tunisia_national_day_user_config`
--

DROP TABLE IF EXISTS `activity_tunisia_national_day_user_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_tunisia_national_day_user_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `first_diamond` int NOT NULL,
  `second_diamond` int NOT NULL,
  `third_diamond` int NOT NULL,
  `first_property_id` bigint NOT NULL COMMENT '第一名座驾ID',
  `first_property_duration` int NOT NULL COMMENT '第一名座驾时长',
  `second_property_id` bigint NOT NULL COMMENT '第二名座驾ID',
  `second_property_duration` int NOT NULL COMMENT '第二名座驾时长',
  `third_property_id` bigint NOT NULL COMMENT '第三名座驾ID',
  `third_property_duration` int NOT NULL COMMENT '第三名座驾时长',
  `first_headwear_id1` bigint NOT NULL COMMENT '第一名头饰ID',
  `first_headwear_duration1` int NOT NULL COMMENT '第一名头饰时长',
  `first_headwear_id2` bigint NOT NULL COMMENT '第一名头饰ID',
  `first_headwear_duration2` int NOT NULL COMMENT '第一名头饰时长',
  `second_headwear_id1` bigint NOT NULL COMMENT '第二名头饰ID',
  `second_headwear_duration1` int NOT NULL COMMENT '第二名头饰时长',
  `second_headwear_id2` bigint NOT NULL COMMENT '第二名头饰ID',
  `second_headwear_duration2` int NOT NULL COMMENT '第二名头饰时长',
  `third_headwear_id1` bigint NOT NULL COMMENT '第三名头饰ID',
  `third_headwear_duration1` int NOT NULL COMMENT '第三名头饰时长',
  `third_headwear_id2` bigint NOT NULL COMMENT '第三名头饰ID',
  `third_headwear_duration2` int NOT NULL COMMENT '第三名头饰时长',
  `first_medal_id` bigint NOT NULL COMMENT '第一名勋章ID',
  `first_medal_duration` int NOT NULL COMMENT '第一名勋章时长(特殊情况：单位天)',
  `second_medal_id` bigint NOT NULL COMMENT '第二名勋章ID',
  `second_medal_duration` int NOT NULL COMMENT '第二名勋章时长(特殊情况：单位天)',
  `third_medal_id` bigint NOT NULL COMMENT '第三名勋章ID',
  `third_medal_duration` int NOT NULL COMMENT '第三名勋章时长(特殊情况：单位天)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='突尼斯国庆日活动用户配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `advertisement`
--

DROP TABLE IF EXISTS `advertisement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertisement` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '广告标题',
  `icon` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '广告缩略图标',
  `url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '前端URL',
  `status` tinyint NOT NULL COMMENT '状态（1-上架，0-下架）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='广告';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `agent_banner`
--

DROP TABLE IF EXISTS `agent_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agent_banner` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `image` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩略图',
  `url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'URL',
  `group_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `n` int NOT NULL COMMENT '排序',
  `status` int NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `start_at` int unsigned NOT NULL DEFAULT '0' COMMENT '上架时间戳',
  `end_at` int unsigned NOT NULL DEFAULT '0' COMMENT '下架时间戳',
  `country_list` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`n`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代理banner';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `agent_mgr`
--

DROP TABLE IF EXISTS `agent_mgr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agent_mgr` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `agent_id` bigint unsigned NOT NULL COMMENT '代理id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `agent_id` (`agent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=350 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代理管理员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `agora_recording`
--

DROP TABLE IF EXISTS `agora_recording`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agora_recording` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `day` date NOT NULL,
  `video_uid` varchar(256) NOT NULL,
  `audio_filename` varchar(512) NOT NULL DEFAULT '',
  `video_filename` varchar(512) NOT NULL DEFAULT '',
  `mp4_filename` varchar(512) NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `USER_DAY` (`user_id`,`day`),
  KEY `video_uid` (`video_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=1439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='音视频录制';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `award`
--

DROP TABLE IF EXISTS `award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `award` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_user_id` bigint NOT NULL COMMENT '活动榜单用户ID',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `diamond` int NOT NULL COMMENT '钻石数量',
  `property_id` bigint NOT NULL COMMENT '坐骑ID',
  `property_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `headwear_id` bigint NOT NULL COMMENT '坐骑ID',
  `headwear_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `medal_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `medal_duration` int unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`activity_billboard_user_id`,`user_id`),
  KEY `Index_1` (`activity_billboard_user_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活动榜单奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bean_account`
--

DROP TABLE IF EXISTS `bean_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bean_account` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bean_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '豆子数量',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `gold_num` bigint unsigned NOT NULL DEFAULT '0' COMMENT '收粉钻礼物得到的金币',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_alias` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=111119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bean_account_detail`
--

DROP TABLE IF EXISTS `bean_account_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bean_account_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bean_account_id` bigint NOT NULL COMMENT '豆子帐号ID',
  `operate_id` bigint NOT NULL,
  `operate_type` tinyint NOT NULL COMMENT '来源类型（1:充值, 2:礼物',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少）',
  `num` int NOT NULL COMMENT '数量',
  `remark` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `bef_num` bigint NOT NULL COMMENT '之前豆子数量',
  `aft_num` bigint NOT NULL COMMENT '之后豆子数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`operate_type`),
  KEY `Index_2` (`bean_account_id`,`operate_type`),
  KEY `created_time` (`created_time`),
  KEY `origin_id` (`origin_id`,`operate_type`)
) ENGINE=InnoDB AUTO_INCREMENT=1733629 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='豆子账号流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bean_account_detail_gold`
--

DROP TABLE IF EXISTS `bean_account_detail_gold`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bean_account_detail_gold` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bean_account_id` bigint NOT NULL COMMENT '豆子帐号ID',
  `operate_id` bigint NOT NULL,
  `operate_type` tinyint NOT NULL COMMENT '来源类型（1:充值, 2:礼物',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少）',
  `num` int NOT NULL COMMENT '数量',
  `remark` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `bef_num` bigint NOT NULL COMMENT '之前数量',
  `aft_num` bigint NOT NULL COMMENT '之后数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`operate_type`),
  KEY `Index_2` (`bean_account_id`,`operate_type`),
  KEY `created_time` (`created_time`),
  KEY `origin_id` (`origin_id`,`operate_type`)
) ENGINE=InnoDB AUTO_INCREMENT=783 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='金币流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bean_operate_set`
--

DROP TABLE IF EXISTS `bean_operate_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bean_operate_set` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `bean_num` int NOT NULL COMMENT '钻石数量',
  `frequency_num` int NOT NULL COMMENT '频率次数',
  `frequency_day` int NOT NULL COMMENT '频率天数',
  `bean_max_num` int NOT NULL COMMENT '最大金币数',
  `add_reduce` tinyint NOT NULL COMMENT '增加减少',
  `type` tinyint NOT NULL COMMENT '操作类型',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作名字',
  `status` tinyint NOT NULL COMMENT '状态（1：开始 0：关闭）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `diamond_type` tinyint NOT NULL DEFAULT '1' COMMENT '钻石类型1.黄钻2.粉钻',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='豆子操作';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `billboard_limit_user`
--

DROP TABLE IF EXISTS `billboard_limit_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billboard_limit_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id，cp的话，就是cpId',
  `first_type` tinyint NOT NULL,
  `second_type` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`first_type`,`second_type`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='榜单黑名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cache_db`
--

DROP TABLE IF EXISTS `cache_db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_db` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `table_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'table_name',
  `table_id` bigint NOT NULL COMMENT 'table_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `status` tinyint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `candy_day_rank`
--

DROP TABLE IF EXISTS `candy_day_rank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candy_day_rank` (
  `date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `tz` tinyint NOT NULL DEFAULT '0' COMMENT '时区 0:北京 1:沙特',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `stake_times` bigint NOT NULL DEFAULT '0' COMMENT '投注次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`tz`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='candy 日榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `candy_level_config`
--

DROP TABLE IF EXISTS `candy_level_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candy_level_config` (
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `exp` bigint unsigned NOT NULL COMMENT '所需经验值',
  `award_type` tinyint(1) NOT NULL COMMENT '奖励类型 1:钻石 2:礼物 3:头饰 4:贵族 5:座驾',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '资源id,钻石类型为0,贵族类型为贵族等级',
  `res_count` int unsigned NOT NULL COMMENT '资源个数',
  `res_day` int NOT NULL DEFAULT '0' COMMENT '资源天数,钻石类型为0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='candy 等级配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `candy_user_level`
--

DROP TABLE IF EXISTS `candy_user_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candy_user_level` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='candy用户等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `candy_user_level_detail`
--

DROP TABLE IF EXISTS `candy_user_level_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `candy_user_level_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `award_type` tinyint(1) NOT NULL COMMENT '奖励类型 1:钻石 2:礼物 3:头饰 4:贵族 5:座驾',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '资源id,钻石类型为0,贵族类型为贵族等级',
  `res_count` int unsigned NOT NULL COMMENT '资源个数',
  `res_day` int NOT NULL DEFAULT '0' COMMENT '资源天数,钻石类型为0',
  `status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '状态 1:发奖成功 2:未发奖',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='candy用户等级明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_callback_log`
--

DROP TABLE IF EXISTS `charge_callback_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_callback_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` smallint NOT NULL COMMENT '平台：4.checkout，5.茄子支付(payerMax)',
  `resp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'resp_id',
  `resp_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'resp_type',
  `resp_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'resp_data',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `resid_IDX` (`resp_id`) USING BTREE,
  KEY `createAt_IDX` (`create_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值回调日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_card_info`
--

DROP TABLE IF EXISTS `charge_card_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_card_info` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '支付卡名称',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '支付卡icon',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint NOT NULL DEFAULT '1',
  `paymenttype_code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '卡类型代码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家支持的支付卡和充值渠道';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_country_channel`
--

DROP TABLE IF EXISTS `charge_country_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_country_channel` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `card_id` int NOT NULL COMMENT '支付卡种类',
  `platform` int NOT NULL COMMENT '平台:4.checkout5.payerMax/茄子支付',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_card_plat_IDX` (`country`,`card_id`,`platform`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家支持的支付卡和充值渠道';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_currency`
--

DROP TABLE IF EXISTS `charge_currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_currency` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` int NOT NULL COMMENT '平台:1.apple;2.google;3.starchat回调茄子支付;4.checkout5.payerMax/茄子支付',
  `currency_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币编码',
  `currency_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币名字',
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `calculating` int NOT NULL COMMENT '计算',
  `res_country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '资源的国家',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `res_country_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_common` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_IDX` (`res_country`,`platform`) USING BTREE,
  KEY `platform_IDX` (`platform`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值货币';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_ext_info`
--

DROP TABLE IF EXISTS `charge_ext_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_ext_info` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `pay_order_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'pay_order表的id',
  `ext_order_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '支付平台的订单id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id_IDX` (`pay_order_id`) USING BTREE,
  UNIQUE KEY `ext_order_id_IDX` (`ext_order_id`) USING BTREE,
  KEY `user_id_IDX` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值订单其他平台的信息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `charge_white_list`
--

DROP TABLE IF EXISTS `charge_white_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_white_list` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` smallint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `platform_user_IDX` (`platform`,`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='官网充值白名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checkout_create_log`
--

DROP TABLE IF EXISTS `checkout_create_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_create_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `req_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'req_data',
  `resp_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'resp_data',
  `err_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'err_data',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3160 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='checkout创建日记';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checkout_currency`
--

DROP TABLE IF EXISTS `checkout_currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_currency` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `currency_code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币编码',
  `currency_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币名字',
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `calculating` int NOT NULL COMMENT '计算',
  `res_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '资源的国家',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `res_country_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_common` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key` (`currency_code`,`country`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='checkout货币';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checkout_diamond`
--

DROP TABLE IF EXISTS `checkout_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checkout_diamond` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `diamond` int NOT NULL COMMENT '钻石',
  `money` int NOT NULL COMMENT '金钱',
  `dollar` int NOT NULL,
  `currency_code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币编码',
  `discount` int NOT NULL COMMENT '折扣',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_agent` tinyint NOT NULL DEFAULT '0' COMMENT '0.用户给自己充1.代理给自己充2.用户给代理充',
  `diamond_show` int NOT NULL DEFAULT '0' COMMENT '用户给代理充值(is_agent=2)，用户看到的数量',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`currency_code`)
) ENGINE=InnoDB AUTO_INCREMENT=1587 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='checkout钻石面板';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `client_report`
--

DROP TABLE IF EXISTS `client_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `client_report` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `type` tinyint NOT NULL COMMENT '类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41864 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='客户端埋点上报';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `count_daily_user_active`
--

DROP TABLE IF EXISTS `count_daily_user_active`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_daily_user_active` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `date_str` date NOT NULL COMMENT '日期',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `imei` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `online_time` bigint NOT NULL DEFAULT '0' COMMENT '用户设备在线时长/秒',
  `last_login_time` timestamp NULL DEFAULT NULL COMMENT '上次登录时间',
  `last_logout_time` timestamp NULL DEFAULT NULL COMMENT '上次登出时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `u_i_d` (`user_id`,`imei`,`date_str`),
  KEY `date` (`date_str`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1667 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='统计用户设备活跃';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `count_daily_user_active_log`
--

DROP TABLE IF EXISTS `count_daily_user_active_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_daily_user_active_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `date_str` date NOT NULL COMMENT '日期',
  `imei` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `online_time` bigint NOT NULL DEFAULT '0' COMMENT '用户设备在线时长/秒',
  `last_login_time` timestamp NULL DEFAULT NULL COMMENT '登录时间',
  `last_logout_time` timestamp NULL DEFAULT NULL COMMENT '登出时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `u_d` (`user_id`,`date_str`),
  KEY `date` (`date_str`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16344 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='统计用户设备活跃-日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `count_daily_user_login`
--

DROP TABLE IF EXISTS `count_daily_user_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_daily_user_login` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `date_str` date NOT NULL COMMENT '日期',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`date_str`),
  KEY `date_str` (`date_str`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=89949 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='统计进入系统的用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `count_emas_matchcard`
--

DROP TABLE IF EXISTS `count_emas_matchcard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_emas_matchcard` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `deleted_count` int NOT NULL DEFAULT '0',
  `opened_count` int NOT NULL DEFAULT '0',
  `sms_receive_success_count` int NOT NULL DEFAULT '0',
  `sms_skip_count` int NOT NULL DEFAULT '0',
  `sms_receive_failed_count` int NOT NULL DEFAULT '0',
  `sms_failed_count` int NOT NULL DEFAULT '0',
  `received_count` int NOT NULL DEFAULT '0',
  `sent_count` int NOT NULL DEFAULT '0',
  `sms_sent_count` int NOT NULL DEFAULT '0',
  `accept_count` int NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=566 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `count_emas_matchcard_detail`
--

DROP TABLE IF EXISTS `count_emas_matchcard_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_emas_matchcard_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `count_emas_matchcard_id` bigint NOT NULL COMMENT 'count_emas_matchcard_id',
  `title` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'title',
  `body` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'body',
  `message_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'message_id',
  `err` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `deleted_count` int NOT NULL DEFAULT '0',
  `opened_count` int NOT NULL DEFAULT '0',
  `sms_receive_success_count` int NOT NULL DEFAULT '0',
  `sms_skip_count` int NOT NULL DEFAULT '0',
  `sms_receive_failed_count` int NOT NULL DEFAULT '0',
  `sms_failed_count` int NOT NULL DEFAULT '0',
  `received_count` int NOT NULL DEFAULT '0',
  `sent_count` int NOT NULL DEFAULT '0',
  `sms_sent_count` int NOT NULL DEFAULT '0',
  `accept_count` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1053 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='统计emas发送匹配消息详细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_consume`
--

DROP TABLE IF EXISTS `country_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_consume` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country` char(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送人',
  `diamond` bigint NOT NULL DEFAULT '0',
  `ref_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ref_id_IDX` (`ref_id`) USING BTREE,
  KEY `country_IDX` (`country`) USING BTREE,
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1546478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_consume_last_week`
--

DROP TABLE IF EXISTS `country_consume_last_week`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_consume_last_week` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `country` char(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送人',
  `diamond` bigint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_user` (`country`,`send_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家贡献-过期7天排行榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_consume_last_week_offset`
--

DROP TABLE IF EXISTS `country_consume_last_week_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_consume_last_week_offset` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `last_cal_time` timestamp NULL DEFAULT NULL COMMENT '上次计算到的时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家贡献-过期7天排行榜-记录偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_lang_region`
--

DROP TABLE IF EXISTS `country_lang_region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_lang_region` (
  `country` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `lang_region` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '语言区',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家语言区';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_mgr_user`
--

DROP TABLE IF EXISTS `country_mgr_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_mgr_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `country` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `user_id` bigint unsigned NOT NULL COMMENT '用户',
  `role` tinyint NOT NULL COMMENT '角色',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_user` (`user_id`,`country`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家管理人员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_star_consume`
--

DROP TABLE IF EXISTS `country_star_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_star_consume` (
  `activity_id` bigint unsigned NOT NULL,
  `country` char(128) NOT NULL,
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送人',
  `gift_id` bigint unsigned NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`activity_id`,`country`,`send_user_id`,`gift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_star_gift`
--

DROP TABLE IF EXISTS `country_star_gift`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_star_gift` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `country` char(128) NOT NULL,
  `gift_id` bigint unsigned NOT NULL COMMENT '礼物id',
  `is_avatar` tinyint unsigned NOT NULL,
  `status` tinyint unsigned NOT NULL COMMENT '1-开;2-关',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_gift_idx` (`country`,`gift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='国家之星礼物配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `country_treasure_award`
--

DROP TABLE IF EXISTS `country_treasure_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_treasure_award` (
  `activity_id` bigint unsigned NOT NULL,
  `country` char(128) NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `award_id` int unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `diamond` int unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`activity_id`,`country`,`user_id`,`award_id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cp`
--

DROP TABLE IF EXISTS `cp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cp` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id1` bigint NOT NULL COMMENT 'user_id1',
  `user_id2` bigint NOT NULL COMMENT 'user_id2',
  `disconnect_second` bigint NOT NULL DEFAULT '0' COMMENT '中断时间(单位秒）',
  `score` int NOT NULL COMMENT '分数',
  `day_score` int NOT NULL DEFAULT '0' COMMENT '日分数',
  `period_day` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '日字符串',
  `week_score` int NOT NULL DEFAULT '0' COMMENT '周分数',
  `period_week` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `month_score` int NOT NULL DEFAULT '0',
  `period_month` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id1`,`user_id2`),
  KEY `user_id1` (`user_id1`,`score`),
  KEY `user_id2` (`user_id2`,`score`),
  KEY `score` (`score`)
) ENGINE=InnoDB AUTO_INCREMENT=1106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='CP，CP业务固定只有两个人 ，userId1>userId2，userId1+userId2保证唯一锁';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cp_score_log`
--

DROP TABLE IF EXISTS `cp_score_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cp_score_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cp_id` bigint NOT NULL COMMENT 'cp_id',
  `score` int NOT NULL COMMENT '分数',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `aft_score` int NOT NULL COMMENT '之后分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_id` bigint NOT NULL COMMENT '来源Id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`cp_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=15776 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='cp得分日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cp_status_log`
--

DROP TABLE IF EXISTS `cp_status_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cp_status_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '操作者',
  `cp_id` bigint NOT NULL COMMENT 'cp_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`cp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1498 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='CP状态日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dealer_charge_detail`
--

DROP TABLE IF EXISTS `dealer_charge_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dealer_charge_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `dealer_id` bigint unsigned NOT NULL,
  `mgr_id` bigint unsigned NOT NULL COMMENT '后台发放代理充值的账户',
  `diamond` int unsigned NOT NULL,
  `dollar` int unsigned NOT NULL,
  `payment_method` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '0.运营给代理充1.代理给自己充2.用户给代理充',
  `money` float NOT NULL DEFAULT '0' COMMENT '花费的货币数量',
  `currency` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '货币',
  `goods_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '充值钻石套餐id/商品id',
  `content_msg_id` bigint NOT NULL DEFAULT '0' COMMENT '文案翻译id',
  PRIMARY KEY (`id`),
  KEY `dealer_id_IDX` (`dealer_id`),
  KEY `created_time_IDX` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='币商钻石充值流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dealer_country`
--

DROP TABLE IF EXISTS `dealer_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dealer_country` (
  `dealer_id` bigint unsigned NOT NULL,
  `country` char(100) NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`dealer_id`,`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='币商-国家关系';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dealer_transfer_detail`
--

DROP TABLE IF EXISTS `dealer_transfer_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dealer_transfer_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `dealer_id` bigint unsigned NOT NULL,
  `receiver_id` bigint unsigned NOT NULL,
  `diamond` int unsigned NOT NULL,
  `dollar` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `dealer_id_IDX` (`dealer_id`),
  KEY `created_time_IDX` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=1149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='币商钻石转账流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_account`
--

DROP TABLE IF EXISTS `diamond_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_account` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond_num` bigint NOT NULL DEFAULT '0' COMMENT '钻石数量',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pink_diamond_num` bigint NOT NULL DEFAULT '0' COMMENT '粉钻数量',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_alias` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4431 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_account_detail`
--

DROP TABLE IF EXISTS `diamond_account_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_account_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond_account_id` bigint NOT NULL COMMENT '钻石帐号ID',
  `operate_id` bigint NOT NULL,
  `operate_type` tinyint NOT NULL COMMENT '来源类型（1:充值, 2:礼物',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少）',
  `num` int NOT NULL COMMENT '数量',
  `remark` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `bef_num` bigint NOT NULL COMMENT '之前钻石数量',
  `aft_num` bigint NOT NULL COMMENT '之后钻石数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `operate_ids` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '批量送礼的operate_id列表',
  PRIMARY KEY (`id`),
  KEY `Index_2` (`diamond_account_id`,`operate_type`),
  KEY `created_time` (`created_time`),
  KEY `origin_id` (`origin_id`,`operate_type`),
  KEY `Index_1` (`user_id`,`operate_type`,`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14747570 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='钻石账号流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Temporary table structure for view `diamond_account_detail_copy`
--

DROP TABLE IF EXISTS `diamond_account_detail_copy`;
/*!50001 DROP VIEW IF EXISTS `diamond_account_detail_copy`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `diamond_account_detail_copy` AS SELECT 
 1 AS `id`,
 1 AS `user_id`,
 1 AS `diamond_account_id`,
 1 AS `operate_id`,
 1 AS `operate_type`,
 1 AS `origin_id`,
 1 AS `add_reduce`,
 1 AS `num`,
 1 AS `remark`,
 1 AS `bef_num`,
 1 AS `aft_num`,
 1 AS `created_time`,
 1 AS `updated_time`,
 1 AS `operate_ids`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `diamond_account_recharge_first`
--

DROP TABLE IF EXISTS `diamond_account_recharge_first`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_account_recharge_first` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond_account_detail_id` bigint NOT NULL COMMENT 'diamond_account_detail_id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='钻石首充记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_dealer`
--

DROP TABLE IF EXISTS `diamond_dealer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_dealer` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `diamond` int unsigned NOT NULL COMMENT '钻石余额',
  `wechat` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `whatsapp` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '淘汰次序，从1开始',
  `contact` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '对接人',
  `status` tinyint unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `has_invite` tinyint NOT NULL DEFAULT '0' COMMENT '是否可以邀请别人为他充值(0否1是)',
  `is_family_agent` tinyint NOT NULL DEFAULT '0' COMMENT '是否家族代理',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='币商';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_operate_set`
--

DROP TABLE IF EXISTS `diamond_operate_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_operate_set` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `frequency_num` int NOT NULL COMMENT '频率次数',
  `frequency_day` int NOT NULL COMMENT '频率天数',
  `diamond_max_num` int NOT NULL COMMENT '最大金币数',
  `add_reduce` tinyint NOT NULL COMMENT '增加减少',
  `type` tinyint NOT NULL COMMENT '操作类型',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作名字',
  `status` tinyint NOT NULL COMMENT '状态（1：开始 0：关闭）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `diamond_type` tinyint NOT NULL DEFAULT '1' COMMENT '钻石类型：1.黄钻2.粉钻',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=444 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='钻石操作';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_panel`
--

DROP TABLE IF EXISTS `diamond_panel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_panel` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` int NOT NULL COMMENT '平台:1.apple;2.google;3.starchat回调茄子支付;4.checkout5.payerMax/茄子支付',
  `diamond` int NOT NULL COMMENT '钻石',
  `money` int NOT NULL COMMENT '金钱',
  `dollar` int NOT NULL,
  `currency_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '货币编码',
  `discount` int NOT NULL COMMENT '折扣',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `card_id` int NOT NULL COMMENT '支付卡类型',
  `is_agent` tinyint NOT NULL DEFAULT '0' COMMENT '0.用户给自己充1.代理给自己充2.用户给代理充',
  `diamond_show` int NOT NULL DEFAULT '0' COMMENT '用户给代理充值(is_agent=2)，用户看到的数量',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`currency_code`)
) ENGINE=InnoDB AUTO_INCREMENT=417 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值钻石面板';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_pay_verify`
--

DROP TABLE IF EXISTS `diamond_pay_verify`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_pay_verify` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `platform` tinyint NOT NULL COMMENT '平台',
  `package_name` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'packageName',
  `product_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'productID',
  `purchase_token` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'purchaseToken',
  `order_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'orderID',
  `receipt` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'receipt',
  `transaction_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint DEFAULT NULL COMMENT '状态',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '错误',
  `res` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '返回结果',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`),
  KEY `created_time_IDX` (`created_time`) USING BTREE,
  KEY `transaction_id_IDX` (`transaction_id`) USING BTREE,
  KEY `order_id_IDX` (`order_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=34564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='支付校验记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `diamond_pink_account_detail`
--

DROP TABLE IF EXISTS `diamond_pink_account_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `diamond_pink_account_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond_account_id` bigint NOT NULL COMMENT '钻石帐号ID',
  `operate_id` bigint NOT NULL,
  `operate_type` tinyint NOT NULL COMMENT '来源类型（1:充值, 2:礼物',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少）',
  `num` int NOT NULL COMMENT '数量',
  `remark` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `bef_num` bigint NOT NULL COMMENT '之前粉钻数量',
  `aft_num` bigint NOT NULL COMMENT '之后粉钻数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_2` (`diamond_account_id`,`operate_type`),
  KEY `created_time` (`created_time`),
  KEY `origin_id` (`origin_id`,`operate_type`),
  KEY `Index_1` (`user_id`,`operate_type`,`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=14207154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='粉钻流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `discovery_banner`
--

DROP TABLE IF EXISTS `discovery_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discovery_banner` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'title',
  `image` char(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'image',
  `url` char(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'url',
  `group_code` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'group_id',
  `n` int NOT NULL COMMENT 'n',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT 'status',
  `begin_time` datetime NOT NULL COMMENT 'begin_time',
  `end_time` datetime NOT NULL COMMENT 'end_time',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `country_list` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户banner';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_gift_send`
--

DROP TABLE IF EXISTS `event_gift_send`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_gift_send` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `mark_hilo_group` tinyint(1) NOT NULL DEFAULT '2' COMMENT 'hilo_group服务的mark',
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`),
  KEY `mark_hilo_group` (`mark_hilo_group`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='送礼事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_gift_send2`
--

DROP TABLE IF EXISTS `event_gift_send2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_gift_send2` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `mark_hilo_group` tinyint(1) NOT NULL DEFAULT '2' COMMENT 'hilo_group服务的mark',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`),
  KEY `mark_hilo_group` (`mark_hilo_group`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='送礼事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_gift_send_offset`
--

DROP TABLE IF EXISTS `event_gift_send_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_gift_send_offset` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark_offset` bigint NOT NULL COMMENT 'event_gift_send的偏移值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='送礼事件-标记偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_gift_send_offset_hilo_group`
--

DROP TABLE IF EXISTS `event_gift_send_offset_hilo_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_gift_send_offset_hilo_group` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark_offset` bigint NOT NULL COMMENT 'event_gift_send的偏移值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='送礼事件-标记偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_group_in2`
--

DROP TABLE IF EXISTS `event_group_in2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_group_in2` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=9800 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='进房事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_group_in_offset`
--

DROP TABLE IF EXISTS `event_group_in_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_group_in_offset` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark_offset` bigint NOT NULL COMMENT 'event_group_in的偏移值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='进房事件-标记偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_group_leave2`
--

DROP TABLE IF EXISTS `event_group_leave2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_group_leave2` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=6973 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='离房事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_group_leave_offset`
--

DROP TABLE IF EXISTS `event_group_leave_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_group_leave_offset` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark_offset` bigint NOT NULL COMMENT 'event_group_in的偏移值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='离房事件-标记偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge`
--

DROP TABLE IF EXISTS `event_user_charge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202211`
--

DROP TABLE IF EXISTS `event_user_charge_202211`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202211` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202212`
--

DROP TABLE IF EXISTS `event_user_charge_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=398 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202301`
--

DROP TABLE IF EXISTS `event_user_charge_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202302`
--

DROP TABLE IF EXISTS `event_user_charge_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202303`
--

DROP TABLE IF EXISTS `event_user_charge_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_202304`
--

DROP TABLE IF EXISTS `event_user_charge_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id,也用于offset标记',
  `proto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '解析payload协议 1:json',
  `payload` varbinary(2048) NOT NULL DEFAULT '' COMMENT '内容',
  `mark` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否标记处理,1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `mark` (`mark`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `event_user_charge_offset`
--

DROP TABLE IF EXISTS `event_user_charge_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event_user_charge_offset` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mark_offset` bigint NOT NULL COMMENT '偏移值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值事件-标记偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_day_rank`
--

DROP TABLE IF EXISTS `fruit_day_rank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_day_rank` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='fruit日榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_day_rank_ksa`
--

DROP TABLE IF EXISTS `fruit_day_rank_ksa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_day_rank_ksa` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='fruit 沙特日榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_machine`
--

DROP TABLE IF EXISTS `fruit_machine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_machine` (
  `date` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL COMMENT '轮次',
  `pool` int DEFAULT '0' COMMENT '当前奖池',
  `stake` int unsigned NOT NULL COMMENT '投注额',
  `total` int unsigned NOT NULL COMMENT '总奖池',
  `fruit_id` smallint unsigned NOT NULL COMMENT '开奖的水果ID',
  `award` int unsigned NOT NULL DEFAULT '0' COMMENT '奖金',
  `left_over` int NOT NULL DEFAULT '0' COMMENT '本轮盈余',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`round`),
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_machine_opt_cfg`
--

DROP TABLE IF EXISTS `fruit_machine_opt_cfg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_machine_opt_cfg` (
  `id` smallint unsigned NOT NULL COMMENT '选项ID',
  `name` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名称',
  `ratio` int unsigned NOT NULL COMMENT '赔率',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_machine_player`
--

DROP TABLE IF EXISTS `fruit_machine_player`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_machine_player` (
  `date` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL COMMENT '轮次',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `fruit_num` int unsigned NOT NULL COMMENT '下注水果数',
  `award` int unsigned NOT NULL DEFAULT '0' COMMENT '赢得的金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`user_id`,`round`),
  KEY `user_id` (`user_id`,`award`),
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机参与者';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_machine_pool`
--

DROP TABLE IF EXISTS `fruit_machine_pool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_machine_pool` (
  `id` smallint unsigned NOT NULL,
  `pool` bigint NOT NULL COMMENT '补贴奖池',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机奖池';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_machine_stake`
--

DROP TABLE IF EXISTS `fruit_machine_stake`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_machine_stake` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `date` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL COMMENT '轮次',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `fruit_id` smallint unsigned NOT NULL COMMENT '选项ID',
  `stake` int unsigned NOT NULL COMMENT '下注金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `option_IDX` (`date`,`user_id`,`round`,`fruit_id`),
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=440917 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机赌注';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_tycoon_pool`
--

DROP TABLE IF EXISTS `fruit_tycoon_pool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_tycoon_pool` (
  `period` date NOT NULL COMMENT '开始日期',
  `total_award` int unsigned NOT NULL COMMENT '总奖池',
  `ranking_award` int unsigned NOT NULL COMMENT '排行榜奖金',
  `watermelon_award` int unsigned NOT NULL COMMENT '西瓜奖金',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机奖品池';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_tycoon_ranking`
--

DROP TABLE IF EXISTS `fruit_tycoon_ranking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_tycoon_ranking` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `rank` smallint unsigned NOT NULL COMMENT '排名',
  `money` int unsigned NOT NULL COMMENT '奖金',
  `status` tinyint NOT NULL COMMENT '是否领取',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机排行榜奖';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fruit_tycoon_watermelon`
--

DROP TABLE IF EXISTS `fruit_tycoon_watermelon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fruit_tycoon_watermelon` (
  `period` date NOT NULL COMMENT '开始日期',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `rank` smallint unsigned NOT NULL COMMENT '排名',
  `money` int unsigned NOT NULL COMMENT '奖金',
  `status` tinyint NOT NULL COMMENT '是否领取',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='水果机西瓜奖';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_info`
--

DROP TABLE IF EXISTS `game_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_info` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mg_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '第三方的游戏id',
  `game_type` int unsigned NOT NULL DEFAULT '0' COMMENT '游戏1.ludo',
  `mode` int NOT NULL DEFAULT '0' COMMENT '模式1.quick2.classic',
  `piece` int NOT NULL DEFAULT '0' COMMENT '游戏人数',
  `on_off1` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '通用开关1(ludo:是否开启魔法0否1是)',
  `diamond` bigint unsigned NOT NULL COMMENT '钻石',
  `create_id` bigint unsigned NOT NULL COMMENT '创建者id',
  `status` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '0.未开始 1.游戏中 2.结束',
  `auto_match` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否自动匹配0否1是',
  `tx_group_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组id',
  `game_round_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '本局游戏的id （重复上报，使用该字段去重）',
  `battle_start_at` int unsigned NOT NULL DEFAULT '0' COMMENT '战斗开始时间（秒）',
  `battle_end_at` int unsigned NOT NULL DEFAULT '0' COMMENT '战斗结束时间（秒）',
  `battle_duration` int unsigned NOT NULL DEFAULT '0' COMMENT '战斗总时间（秒）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新记录的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `txGIdIng_idx` (`tx_group_id`,`battle_end_at`) USING BTREE,
  KEY `type_idx` (`game_type`) USING BTREE,
  KEY `cid_idx` (`create_id`) USING BTREE,
  KEY `cat_idx` (`created_time`) USING BTREE,
  KEY `uat_idx` (`updated_time`) USING BTREE,
  KEY `bStartAt_idx` (`battle_start_at`) USING BTREE,
  KEY `bEndAt_idx` (`battle_end_at`) USING BTREE,
  KEY `grId_idx` (`game_round_id`) USING BTREE,
  KEY `status_idx` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1614 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏信息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_player`
--

DROP TABLE IF EXISTS `game_player`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_player` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `game_id` bigint NOT NULL COMMENT '游戏id',
  `user_id` bigint NOT NULL COMMENT '玩家id',
  `status` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '0.未开始 1.游戏中 2.游戏结束 3.逃跑 4.创建者关闭游戏',
  `user_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '给游戏方的用户code',
  `rank` int unsigned NOT NULL DEFAULT '0' COMMENT '排名',
  `is_escaped` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '0:正常，1:逃跑',
  `is_ai` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '0:普通用户，1:机器人',
  `role` int NOT NULL DEFAULT '0' COMMENT '0:表示没有角色信息，玩家在游戏中的角色',
  `score` int NOT NULL DEFAULT '0' COMMENT '玩家当前局得到的分数',
  `is_win` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '结果 0:表示没有信息，1:输，2:赢，3:平局',
  `award` int unsigned NOT NULL DEFAULT '0' COMMENT '奖励',
  `extras` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '扩展参数',
  `is_managed` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '是否托管 0:未托管 1:托管',
  `end_at` int unsigned NOT NULL DEFAULT '0' COMMENT '游戏结束时间（秒）',
  `diamond` bigint NOT NULL COMMENT '黄钻收益，有可能负数',
  `seat_idx` tinyint NOT NULL DEFAULT '0' COMMENT '座位，从1开始',
  `external_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户别名',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新记录的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uIdEndAt_idx` (`user_id`,`end_at`) USING BTREE,
  UNIQUE KEY `gidUid_idx` (`game_id`,`user_id`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `ext_idx` (`external_id`) USING BTREE,
  KEY `code_idx` (`user_code`) USING BTREE,
  KEY `cat_idx` (`created_time`) USING BTREE,
  KEY `uat_idx` (`updated_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3851 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏玩家';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_player_opt_log`
--

DROP TABLE IF EXISTS `game_player_opt_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_player_opt_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `game_id` bigint NOT NULL COMMENT '游戏id',
  `user_id` bigint NOT NULL COMMENT '玩家id',
  `opt` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '1.加入游戏 2.退出游戏',
  `tx_group_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组id',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `gid_idx` (`game_id`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `cat_idx` (`create_at`) USING BTREE,
  KEY `txgid_idx` (`tx_group_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8767 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏玩家操作日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_robot`
--

DROP TABLE IF EXISTS `game_robot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_robot` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `state` tinyint NOT NULL DEFAULT '0' COMMENT '状态 0:闲置 1:使用中',
  `op_step` tinyint NOT NULL DEFAULT '0' COMMENT '步骤 0:无 1:进房 2:上麦 3:加入游戏',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '当前所在群',
  `mic_index` int NOT NULL DEFAULT '-1' COMMENT '当前所在麦位',
  `game_uid` int unsigned NOT NULL DEFAULT '0' COMMENT '当前所在游戏id',
  `mg_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '当前所在游戏sdk的id',
  `last_use_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '上次使用的时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index_1` (`user_id`) USING BTREE,
  KEY `Index_2` (`state`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏机器人';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_robot_log`
--

DROP TABLE IF EXISTS `game_robot_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_robot_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `robot_uid` bigint NOT NULL COMMENT '机器人ID',
  `op` tinyint NOT NULL DEFAULT '0' COMMENT '1:进房 2:上麦 3:加入游戏 4:下麦 5:离房 6:退出游戏',
  `data_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '对应的groupId/gameUid/micIndex',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`robot_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=13488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏机器人操作日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `game_sdk_report`
--

DROP TABLE IF EXISTS `game_sdk_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_sdk_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `tx_group_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组id',
  `game_round_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '本局游戏的id',
  `report_type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '上报类型',
  `report_msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '上报数据对象',
  `external_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '给游戏方的用户id',
  `ss_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户ss_token，请求get_sstoken 接口返回ss_token参数',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `tgid_idx` (`tx_group_id`) USING BTREE,
  KEY `gid_idx` (`game_round_id`) USING BTREE,
  KEY `eid_idx` (`external_id`) USING BTREE,
  KEY `cat_idx` (`create_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='游戏sdk上报';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gift_count_user`
--

DROP TABLE IF EXISTS `gift_count_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gift_count_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT '礼物id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `num` int NOT NULL COMMENT '数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`res_gift_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15655 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='礼物统计用户相关';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gift_operate`
--

DROP TABLE IF EXISTS `gift_operate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gift_operate` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT '礼物id',
  `gift_n` int NOT NULL DEFAULT '0',
  `send_user_id` bigint NOT NULL COMMENT '发送人',
  `receive_user_id` bigint NOT NULL COMMENT '接收人',
  `send_user_diamond` int NOT NULL DEFAULT '0' COMMENT '发送人送礼物对应的钻石',
  `receive_user_diamond` int NOT NULL DEFAULT '0' COMMENT '接受人收礼物对应的钻石',
  `receive_user_bean` int NOT NULL DEFAULT '0' COMMENT '接受人收礼物对应的豆子',
  `scene_type` tinyint NOT NULL COMMENT '赠送场景类型',
  `scene_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '赠送场景ID',
  `bag_id` bigint NOT NULL DEFAULT '0' COMMENT '背包id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `礼物id` (`res_gift_id`),
  KEY `Index_3` (`receive_user_id`) USING BTREE,
  KEY `Index_2` (`send_user_id`,`res_gift_id`) USING BTREE,
  KEY `created_time` (`created_time`,`send_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1655412 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='礼物操作';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gift_private_record`
--

DROP TABLE IF EXISTS `gift_private_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gift_private_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL,
  `gift_n` int NOT NULL,
  `diamond_num` int unsigned NOT NULL,
  `send_user_id` bigint unsigned NOT NULL,
  `receive_user_id` bigint unsigned NOT NULL,
  `ref_id` bigint unsigned NOT NULL COMMENT '关联的钻石流水ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `origin_type` tinyint NOT NULL,
  `origin_id` bigint NOT NULL,
  `bag_id` bigint NOT NULL DEFAULT '0' COMMENT '背包id',
  PRIMARY KEY (`id`),
  KEY `sender_idx` (`send_user_id`) USING BTREE,
  KEY `receiver_idx` (`receive_user_id`) USING BTREE,
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=5360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='私聊礼物记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `girl_support_gift_record`
--

DROP TABLE IF EXISTS `girl_support_gift_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `girl_support_gift_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `send_user_id` bigint NOT NULL COMMENT '发送人',
  `receive_user_id` bigint NOT NULL COMMENT '接收人',
  `diamond` int NOT NULL DEFAULT '0' COMMENT '发送人送礼物对应的钻石',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `receive_user_id` (`receive_user_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='女性扶持礼物记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `girl_support_user`
--

DROP TABLE IF EXISTS `girl_support_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `girl_support_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `ip` char(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ip',
  `imei` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='女性扶持报名';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `global_broadcast_manager`
--

DROP TABLE IF EXISTS `global_broadcast_manager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `global_broadcast_manager` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_1` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人全球广播';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `google_subscribe_state`
--

DROP TABLE IF EXISTS `google_subscribe_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `google_subscribe_state` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `purchase_token` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` char(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price_amount_micros` bigint NOT NULL,
  `price_currency_code` char(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time_millis` bigint NOT NULL,
  `expiry_time_millis` bigint NOT NULL,
  `auto_renewing` tinyint(1) NOT NULL COMMENT '是否自动续费',
  `linked_purchase_token` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_state` bigint NOT NULL,
  `cancel_reason` bigint NOT NULL COMMENT '取消订阅的原因',
  `user_cancellation_time_millis` bigint NOT NULL DEFAULT '0' COMMENT '用户取消订阅的时刻',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `purchase_token` (`purchase_token`)
) ENGINE=InnoDB AUTO_INCREMENT=16280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='GOOGLE订阅状态';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_activity`
--

DROP TABLE IF EXISTS `group_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_activity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `end_at` bigint unsigned NOT NULL COMMENT '结束时间戳，毫秒',
  `start_at` bigint unsigned NOT NULL COMMENT '开始时间戳，毫秒',
  `banner` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动横幅',
  `desc` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动描述',
  `ac_type` tinyint unsigned NOT NULL COMMENT '类型1.游戏2.比赛3.排队4.诗歌',
  `theme` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '主题',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组id',
  `update_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新记录的时间',
  `update_id` bigint NOT NULL COMMENT '修改人id',
  `create_id` bigint NOT NULL COMMENT '创建者id',
  `external_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '活动对外uid',
  `is_first` tinyint unsigned NOT NULL DEFAULT '2' COMMENT '是否首个活动1是2否',
  `audit_status` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '审核状态：0.等待计算1.未审核，2.已审核',
  `week_num` tinyint unsigned NOT NULL COMMENT '本周的第几次活动',
  `reward_diamond` bigint unsigned NOT NULL COMMENT '活动奖励钻石，活动结束且后台审核后才有值',
  `audit_user_id` bigint NOT NULL COMMENT '审核人id',
  `audit_at` timestamp NOT NULL COMMENT '审核时间',
  `diamond` bigint unsigned NOT NULL COMMENT '活动期间钻石流水',
  `support_num` bigint unsigned NOT NULL COMMENT '活动期间在群组里消费的人数',
  `audit_pass` tinyint unsigned NOT NULL COMMENT '审核是否通过：1.通过，2.未通过',
  PRIMARY KEY (`id`),
  UNIQUE KEY `extId_idx` (`external_id`) USING BTREE,
  UNIQUE KEY `imid_start_IDX` (`im_group_id`,`start_at`) USING BTREE,
  KEY `start_idx` (`start_at`) USING BTREE,
  KEY `gid_idx` (`im_group_id`) USING BTREE,
  KEY `cid_idx` (`create_id`) USING BTREE,
  KEY `end_idx` (`end_at`) USING BTREE,
  KEY `auditAt_idx` (`audit_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_activity_award_log`
--

DROP TABLE IF EXISTS `group_activity_award_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_activity_award_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_act_id` bigint unsigned NOT NULL COMMENT 'group_activity表id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `im_group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组id',
  `award` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '奖励内容',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `group_act_id` (`group_act_id`) USING BTREE,
  KEY `im_group_id` (`im_group_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组活动奖励log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_activity_gift_record`
--

DROP TABLE IF EXISTS `group_activity_gift_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_activity_gift_record` (
  `group_act_id` bigint unsigned NOT NULL,
  `send_user_id` bigint unsigned NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_act_id`,`send_user_id`),
  KEY `send_user_id` (`send_user_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='群组活动礼物记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_activity_subscribe`
--

DROP TABLE IF EXISTS `group_activity_subscribe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_activity_subscribe` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_id` int unsigned NOT NULL COMMENT '订阅的群组活动id',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订阅时间',
  `user_id` bigint NOT NULL COMMENT '用户id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `activity_user_idx` (`activity_id`,`user_id`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE,
  KEY `create_idx` (`create_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1537 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_banned`
--

DROP TABLE IF EXISTS `group_banned`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_banned` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mgr_id` bigint unsigned NOT NULL,
  `rule_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `im_group_id` (`im_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=419 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='封禁的群';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_banner`
--

DROP TABLE IF EXISTS `group_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_banner` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `image` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩略图',
  `url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'URL',
  `group_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `n` int NOT NULL COMMENT '排序',
  `status` int NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `start_at` int unsigned NOT NULL DEFAULT '0' COMMENT '上架时间戳',
  `end_at` int unsigned NOT NULL DEFAULT '0' COMMENT '下架时间戳',
  `country_list` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`n`)
) ENGINE=InnoDB AUTO_INCREMENT=2309 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组banner';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_blacklist`
--

DROP TABLE IF EXISTS `group_blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_blacklist` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `imei` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '设备号',
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_user` (`im_group_id`,`user_id`),
  KEY `imei_IDX` (`imei`) USING BTREE,
  KEY `ip_IDX` (`ip`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1010 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群黑名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_custom_theme`
--

DROP TABLE IF EXISTS `group_custom_theme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_custom_theme` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'im_group_id',
  `pic_url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'pic_url',
  `expire_time` datetime NOT NULL COMMENT 'expire_time',
  `using` tinyint NOT NULL COMMENT 'useing',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`im_group_id`,`expire_time`)
) ENGINE=InnoDB AUTO_INCREMENT=579 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群自定义主题';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_info`
--

DROP TABLE IF EXISTS `group_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tx_group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` smallint unsigned NOT NULL DEFAULT '2',
  `code` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin_code` char(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `owner` bigint unsigned NOT NULL,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `introduction` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `notification` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `face_url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '国家',
  `channel_id` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` char(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `entry_level` int unsigned NOT NULL DEFAULT '0',
  `mic_on` tinyint(1) NOT NULL DEFAULT '1',
  `load_history` tinyint(1) NOT NULL DEFAULT '1',
  `mic_num_type` tinyint NOT NULL DEFAULT '1',
  `theme_id` smallint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tourist_mic` tinyint NOT NULL DEFAULT '1' COMMENT '游客是否能上麦(1是2否)',
  `tourist_send_msg` tinyint NOT NULL DEFAULT '1' COMMENT '游客是否是否能发言(1是2否)',
  `tourist_send_pic` tinyint NOT NULL DEFAULT '1' COMMENT '游客是否能发图片(1是2否)',
  `member_fee` bigint unsigned NOT NULL DEFAULT '0' COMMENT '加入群组需要的黄钻数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `im_group_id` (`im_group_id`),
  UNIQUE KEY `code` (`code`),
  KEY `tx_group_id_IDX` (`tx_group_id`) USING BTREE,
  KEY `owner` (`owner`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1444 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_invite_join`
--

DROP TABLE IF EXISTS `group_invite_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_invite_join` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `im_group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `invite_user_id` bigint unsigned NOT NULL COMMENT '邀请者id',
  `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受邀请',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_group` (`user_id`,`im_group_id`),
  KEY `im_group_id` (`im_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邀请加入群组会员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_kick_record`
--

DROP TABLE IF EXISTS `group_kick_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_kick_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'im_group_id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `be_kick_user_id` bigint NOT NULL COMMENT 'be_kick_user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='踢人记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_medal`
--

DROP TABLE IF EXISTS `group_medal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_medal` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'im_group_id',
  `res_medal_id` bigint NOT NULL COMMENT 'res_medal_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `expire_at` datetime DEFAULT NULL COMMENT '过期时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`im_group_id`,`res_medal_id`),
  KEY `expire_at` (`expire_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=434 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组勋章';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_member`
--

DROP TABLE IF EXISTS `group_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_member` (
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`,`user_id`),
  KEY `user_id_IDX` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群永久成员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log`
--

DROP TABLE IF EXISTS `group_mic_in_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=389997 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202212`
--

DROP TABLE IF EXISTS `group_mic_in_log_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=195620 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202301`
--

DROP TABLE IF EXISTS `group_mic_in_log_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=122498 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202302`
--

DROP TABLE IF EXISTS `group_mic_in_log_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=99683 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202303`
--

DROP TABLE IF EXISTS `group_mic_in_log_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=32969 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202304`
--

DROP TABLE IF EXISTS `group_mic_in_log_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=16237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_mic_in_log_202305`
--

DROP TABLE IF EXISTS `group_mic_in_log_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_mic_in_log_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦上用户的记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_msg`
--

DROP TABLE IF EXISTS `group_msg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_msg` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `callback_command` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '回调命令',
  `group_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组 ID',
  `type` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组类型',
  `from_account` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送者',
  `operator_account` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '请求的发起者',
  `random` bigint NOT NULL COMMENT '随机数',
  `msg_seq` bigint NOT NULL COMMENT '消息的序列号',
  `msg_time` bigint NOT NULL COMMENT '消息的时间',
  `online_only_flag` tinyint NOT NULL,
  `msg_body` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息体',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群消息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_popular`
--

DROP TABLE IF EXISTS `group_popular`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_popular` (
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='热门群白名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power`
--

DROP TABLE IF EXISTS `group_power`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_uid` char(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组UID',
  `name` char(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '运营后台看的',
  `status` tinyint NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `nameplate` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '家族铭牌',
  `declaration` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '家族宣言',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'https://image.whoisamy.shop/hilo/resource/family_default.png' COMMENT '家族头像',
  `modify_nameplate` tinyint NOT NULL DEFAULT '2' COMMENT '是否修改过nameplate，1：是 2：否',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_3` (`group_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_apply_join`
--

DROP TABLE IF EXISTS `group_power_apply_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_apply_join` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '申请者id',
  `group_power_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受',
  `mgr_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '审核的管理员id',
  PRIMARY KEY (`id`),
  KEY `group_power_id` (`group_power_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='申请加入家族';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_day_exp`
--

DROP TABLE IF EXISTS `group_power_day_exp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_day_exp` (
  `date` date NOT NULL COMMENT '日期',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `exp` bigint NOT NULL DEFAULT '0' COMMENT '经验值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`group_power_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-每日新增经验值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_day_star`
--

DROP TABLE IF EXISTS `group_power_day_star`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_day_star` (
  `date` date NOT NULL COMMENT '日期,格式200601',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL COMMENT '类型 1:送礼 2:活跃 3:收礼',
  `score` bigint NOT NULL DEFAULT '0' COMMENT '对应分值',
  `last_cal_ts` bigint NOT NULL DEFAULT '0' COMMENT '上次计算时间戳, 计算上麦时长用',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`group_power_id`,`user_id`,`type`),
  KEY `group_power_id` (`group_power_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-日家族之星';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log`
--

DROP TABLE IF EXISTS `group_power_diamond_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`group_power_id`),
  KEY `created_time_IDX` (`created_time`,`send_group_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=45621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log_202301`
--

DROP TABLE IF EXISTS `group_power_diamond_log_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log_202301` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '增加的类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_power_id_IDX` (`group_power_id`,`send_group_id`) USING BTREE,
  KEY `created_time_2` (`created_time`,`group_power_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log_202302`
--

DROP TABLE IF EXISTS `group_power_diamond_log_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log_202302` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '增加的类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_power_id_IDX` (`group_power_id`,`send_group_id`) USING BTREE,
  KEY `created_time_2` (`created_time`,`group_power_id`)
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log_202303`
--

DROP TABLE IF EXISTS `group_power_diamond_log_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log_202303` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '增加的类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_power_id_IDX` (`group_power_id`,`send_group_id`) USING BTREE,
  KEY `created_time_2` (`created_time`,`group_power_id`)
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log_202304`
--

DROP TABLE IF EXISTS `group_power_diamond_log_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log_202304` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '增加的类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_power_id_IDX` (`group_power_id`,`send_group_id`) USING BTREE,
  KEY `created_time_2` (`created_time`,`group_power_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1552 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_diamond_log_202305`
--

DROP TABLE IF EXISTS `group_power_diamond_log_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_diamond_log_202305` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送者ID',
  `send_group_id` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发送群',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收者ID',
  `diamond_num` int NOT NULL COMMENT '钻石',
  `gift_id` bigint NOT NULL COMMENT '礼物ID',
  `gift_num` int NOT NULL COMMENT '礼物数量',
  `gift_operate_id` bigint unsigned NOT NULL COMMENT '礼物操作ID',
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '增加的类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_power_id_IDX` (`group_power_id`,`send_group_id`) USING BTREE,
  KEY `created_time_2` (`created_time`,`group_power_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力钻石流水';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_exp_detail`
--

DROP TABLE IF EXISTS `group_power_exp_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_exp_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `user_id` bigint NOT NULL DEFAULT '0' COMMENT '用户id',
  `exp` bigint NOT NULL DEFAULT '0' COMMENT '经验值',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少 3: 设置）',
  `bef_num` bigint NOT NULL COMMENT '之前积分数量',
  `aft_num` bigint NOT NULL COMMENT '之后积分数量',
  `remark` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-经验值明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_grade`
--

DROP TABLE IF EXISTS `group_power_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_grade` (
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `exp` bigint NOT NULL DEFAULT '0' COMMENT '经验值',
  `grade` int NOT NULL DEFAULT '0' COMMENT '等级 0:青铜 1:白银 2:黄金 3:黑金',
  `expire_at` datetime NOT NULL COMMENT '过期时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_power_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_invite_join`
--

DROP TABLE IF EXISTS `group_power_invite_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_invite_join` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '被邀请者id',
  `group_power_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `invite_user_id` bigint unsigned NOT NULL COMMENT '邀请者id',
  `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受邀请',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_group` (`user_id`,`group_power_id`),
  KEY `group_power_id` (`group_power_id`),
  KEY `invite_user_id` (`invite_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邀请加入家族';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_month_star`
--

DROP TABLE IF EXISTS `group_power_month_star`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_month_star` (
  `month` char(6) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期,格式200601',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL COMMENT '类型 1:送礼 2:活跃 3:收礼',
  `score` bigint NOT NULL DEFAULT '0' COMMENT '对应分值',
  `last_cal_ts` bigint NOT NULL DEFAULT '0' COMMENT '上次计算时间戳, 计算上麦时长用',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`month`,`group_power_id`,`user_id`,`type`),
  KEY `group_power_id` (`group_power_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-月度家族之星';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_on_mic`
--

DROP TABLE IF EXISTS `group_power_on_mic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_on_mic` (
  `date` date NOT NULL COMMENT '日期',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `seconds` bigint NOT NULL DEFAULT '0' COMMENT '上麦时长',
  `last_cal_ts` bigint NOT NULL DEFAULT '0' COMMENT '上次计算的上麦时间戳',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`group_power_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-上麦时长';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_on_mic_detail`
--

DROP TABLE IF EXISTS `group_power_on_mic_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_on_mic_detail` (
  `date` date NOT NULL COMMENT '日期',
  `group_power_id` bigint NOT NULL COMMENT '势力id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `minute` int NOT NULL COMMENT '奖励的分钟',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`group_power_id`,`user_id`,`minute`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力-上麦时长-奖励明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_quit_log`
--

DROP TABLE IF EXISTS `group_power_quit_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_quit_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `mgr_id` bigint unsigned NOT NULL COMMENT '操作人id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `group_power_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE,
  KEY `mgr_id` (`mgr_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_user`
--

DROP TABLE IF EXISTS `group_power_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `user_id` bigint unsigned NOT NULL COMMENT '用户',
  `role` tinyint NOT NULL COMMENT '角色',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`) USING BTREE,
  KEY `group_power_id` (`group_power_id`,`role`)
) ENGINE=InnoDB AUTO_INCREMENT=1291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_user_log`
--

DROP TABLE IF EXISTS `group_power_user_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_user_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `user_id` bigint unsigned NOT NULL COMMENT '用户',
  `operate_type` tinyint NOT NULL COMMENT '操作类型',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注，可能用于解散的人员记录',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`group_power_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1703 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家势力用户日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_power_week_diamond`
--

DROP TABLE IF EXISTS `group_power_week_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_power_week_diamond` (
  `week` date NOT NULL,
  `power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `diamond` int NOT NULL COMMENT '钻石',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`week`,`power_id`,`group_id`),
  KEY `group_id_idx` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='国家势力周钻石统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_roles`
--

DROP TABLE IF EXISTS `group_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` smallint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_group` (`user_id`,`im_group_id`),
  KEY `im_group_id` (`im_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30954 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组角色';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_setting`
--

DROP TABLE IF EXISTS `group_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_setting` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `dice_num` smallint unsigned NOT NULL DEFAULT '5',
  `dice_type` smallint DEFAULT '1' COMMENT '数字类型  1: [0-9] 2:[1-6]',
  `profit_allocator` bigint unsigned NOT NULL DEFAULT '0' COMMENT '扶持奖励分配人',
  `is_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=865 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_support_award_admin`
--

DROP TABLE IF EXISTS `group_support_award_admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_support_award_admin` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `Issuer_user_id` bigint unsigned NOT NULL COMMENT '发放人',
  `user_id` bigint unsigned NOT NULL COMMENT '用户',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `grade` int NOT NULL COMMENT '等级',
  `res_group_support_id` bigint unsigned NOT NULL COMMENT '扶持ID',
  `period` char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发放周期时间(yyyy-MM-dd)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_uid` (`period`,`group_uid`) USING BTREE COMMENT '一个周期下，一个群只有一次利益分配者收益',
  KEY `Index_1` (`group_uid`,`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=549 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组扶持奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_support_award_mgr`
--

DROP TABLE IF EXISTS `group_support_award_mgr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_support_award_mgr` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `Issuer_user_id` bigint unsigned NOT NULL COMMENT '发放人',
  `user_id` bigint unsigned NOT NULL COMMENT '用户',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `grade` int NOT NULL COMMENT '等级',
  `res_group_support_id` bigint unsigned NOT NULL COMMENT '扶持ID',
  `period` char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '发放周期时间(yyyy-MM-dd)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `period` (`period`,`group_uid`,`user_id`) USING BTREE COMMENT '一个周期内，在一个房间，用户只能获取一次',
  KEY `Index_1` (`group_uid`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=700 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组扶持奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_support_result`
--

DROP TABLE IF EXISTS `group_support_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_support_result` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_uid` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `grade` int NOT NULL COMMENT '等级',
  `period` char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期时间(yyyy-MM-dd)',
  `heat` int unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `period` (`group_uid`,`period`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=404 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组扶持结果';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_supporter`
--

DROP TABLE IF EXISTS `group_supporter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_supporter` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_user_id_IDX` (`group_id`,`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组支持者';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_top`
--

DROP TABLE IF EXISTS `group_top`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_top` (
  `id` int unsigned NOT NULL,
  `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `im_group_id` (`im_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='置顶的群';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_trtc`
--

DROP TABLE IF EXISTS `group_trtc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_trtc` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `im_group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `im_group_id` (`im_group_id`),
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='使用trtc的群组';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_user`
--

DROP TABLE IF EXISTS `group_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'group_info_id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `msg_status` tinyint NOT NULL COMMENT '群消息状态',
  `in_room_time` datetime DEFAULT NULL COMMENT '进入房间的时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`group_id`,`user_id`),
  KEY `group_id` (`group_id`,`created_time`,`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11292 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_user_limits`
--

DROP TABLE IF EXISTS `group_user_limits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_user_limits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `max_join` int unsigned NOT NULL COMMENT '最多能加入的群数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群用户的上限';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_welcome_text`
--

DROP TABLE IF EXISTS `group_welcome_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_welcome_text` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `text` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '欢迎语',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='入群欢迎语';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `guild_user_hello`
--

DROP TABLE IF EXISTS `guild_user_hello`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guild_user_hello` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `guild_user_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_guild_idx` (`user_id`,`guild_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3334 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `guild_user_hello_text`
--

DROP TABLE IF EXISTS `guild_user_hello_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guild_user_hello_text` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `language` char(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '语言',
  `msg_id` int unsigned NOT NULL COMMENT '消息ID',
  `content` varchar(5600) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_id_idx` (`language`,`msg_id`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `hilo_configs`
--

DROP TABLE IF EXISTS `hilo_configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hilo_configs` (
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202209`
--

DROP TABLE IF EXISTS `log_login_202209`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202209` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=625 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202210`
--

DROP TABLE IF EXISTS `log_login_202210`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202210` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202211`
--

DROP TABLE IF EXISTS `log_login_202211`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202211` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202212`
--

DROP TABLE IF EXISTS `log_login_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=317 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202301`
--

DROP TABLE IF EXISTS `log_login_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=281 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202302`
--

DROP TABLE IF EXISTS `log_login_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=333 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202303`
--

DROP TABLE IF EXISTS `log_login_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=306 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_login_202304`
--

DROP TABLE IF EXISTS `log_login_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_login_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `is_succeed` tinyint NOT NULL COMMENT '是否成功',
  `imei` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备号',
  `login_type` smallint NOT NULL COMMENT '登陆类型 1:phone, 2:google, 3:facebook 4:apple 5：wechat',
  `device_type` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备类型',
  `client_ver` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端版本',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录token',
  `login_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '登录时间',
  `login_ip` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录ip',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '失败错误信息',
  PRIMARY KEY (`id`),
  KEY `time_idx` (`login_time`) USING BTREE,
  KEY `ip_idx` (`login_ip`) USING BTREE,
  KEY `uid_idx` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `login_checkout_ip_white`
--

DROP TABLE IF EXISTS `login_checkout_ip_white`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `login_checkout_ip_white` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `black_uid` bigint unsigned NOT NULL DEFAULT '0' COMMENT '被拉黑的用户id',
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '白名单ip',
  `black_ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '被拉黑的ip',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_IDX` (`user_id`),
  KEY `black_uid_IDX` (`black_uid`) USING BTREE,
  KEY `white_ip_IDX` (`ip`) USING BTREE,
  KEY `black_ip_IDX` (`black_ip`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='登录检查ip白名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `logout_config`
--

DROP TABLE IF EXISTS `logout_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logout_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `logout_second` int NOT NULL COMMENT '注销后多少天（秒为单位）',
  `freeze_second` int NOT NULL COMMENT '冻结时间（秒为单位）',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `bean_num` int NOT NULL COMMENT '豆子数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='注销配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `logout_requisition`
--

DROP TABLE IF EXISTS `logout_requisition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logout_requisition` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `status` tinyint NOT NULL COMMENT 'status',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=261 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='注销申请单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `lucky_wheel`
--

DROP TABLE IF EXISTS `lucky_wheel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lucky_wheel` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creator` bigint unsigned NOT NULL COMMENT '创建者',
  `creator_join` tinyint(1) NOT NULL DEFAULT '0' COMMENT '创建者是否加入',
  `entrance_fee` int unsigned NOT NULL COMMENT '入场费用',
  `auto_restart` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动创建下一轮',
  `player_num` int unsigned NOT NULL DEFAULT '0',
  `play_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '轮盘转动的时间',
  `next_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '下一个时刻',
  `status` tinyint unsigned NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9668 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='轮盘游戏控制';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `lucky_wheel_history`
--

DROP TABLE IF EXISTS `lucky_wheel_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lucky_wheel_history` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `wheel_id` bigint unsigned NOT NULL COMMENT '关联的轮盘ID',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creator` bigint unsigned NOT NULL COMMENT '创建者',
  `entrance_fee` int unsigned NOT NULL COMMENT '入场费用',
  `player_num` int unsigned NOT NULL COMMENT '参与人数',
  `winner` bigint unsigned NOT NULL COMMENT '获胜者',
  `winner_award` int unsigned NOT NULL COMMENT '获胜者奖励',
  `group_owner` bigint unsigned NOT NULL COMMENT '群主',
  `group_owner_award` int unsigned NOT NULL COMMENT '群主奖励',
  `end_status` tinyint unsigned NOT NULL COMMENT '结束状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `wheel_id` (`wheel_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33651 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='轮盘游戏历史';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `lucky_wheel_seat`
--

DROP TABLE IF EXISTS `lucky_wheel_seat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lucky_wheel_seat` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `wheel_id` bigint unsigned NOT NULL COMMENT '关联的轮盘ID',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `seat_id` int unsigned NOT NULL COMMENT '座位编号，从0开始',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `seq_id` int unsigned NOT NULL DEFAULT '0' COMMENT '淘汰次序，从1开始',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wheel_user` (`wheel_id`,`user_id`),
  UNIQUE KEY `wheel_seat` (`wheel_id`,`seat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='轮盘座位';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `lucky_wheel_user_option`
--

DROP TABLE IF EXISTS `lucky_wheel_user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lucky_wheel_user_option` (
  `user_id` bigint unsigned NOT NULL,
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_id` bigint unsigned NOT NULL,
  `self_join` tinyint(1) NOT NULL,
  `auto_restart` tinyint(1) NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运轮盘用户选项';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox`
--

DROP TABLE IF EXISTS `luckybox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `diamond_num` int NOT NULL COMMENT 'diamond_num',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_award`
--

DROP TABLE IF EXISTS `luckybox_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_award` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `award_n` bigint NOT NULL COMMENT '奖品数量或者主键ID',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `pic_url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片地址',
  `day_n` int NOT NULL COMMENT '当前数量',
  `day_total_n` int NOT NULL COMMENT '日临界数量',
  `day_str` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日字符串',
  `probability` int NOT NULL COMMENT '概率',
  `is_use` tinyint NOT NULL COMMENT '是否上架',
  `is_public_screen` tinyint NOT NULL COMMENT '是否公屏推送',
  `is_scroll_screen` tinyint NOT NULL COMMENT '是否滚动推送',
  `interval_n` int NOT NULL COMMENT '间隔多少次，才能增加',
  `protection_second` int NOT NULL DEFAULT '0' COMMENT '保护多少秒',
  `protection_sum` int NOT NULL COMMENT '保护的总金额阀值',
  `protection_probability` int NOT NULL COMMENT '保护之后的概率',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=622 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子奖励';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_cycle`
--

DROP TABLE IF EXISTS `luckybox_cycle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_cycle` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` char(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `diamond` int NOT NULL COMMENT '奖金池',
  `begin_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`cycle`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子奖金池';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_cycle_config`
--

DROP TABLE IF EXISTS `luckybox_cycle_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_cycle_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `pool_rate` int NOT NULL,
  `top1_rate` int NOT NULL COMMENT 'top1_rate',
  `top2_rate` int NOT NULL COMMENT 'top2_rate',
  `top3_rate` int NOT NULL COMMENT 'top3_rate',
  `top4_rate` int NOT NULL COMMENT 'top4_rate',
  `top5_rate` int NOT NULL COMMENT 'top5_rate',
  `top6_rate` int NOT NULL COMMENT 'top6_rate',
  `top7_rate` int NOT NULL COMMENT 'top7_rate',
  `top8_rate` int NOT NULL COMMENT 'top8_rate',
  `top9_rate` int NOT NULL COMMENT 'top9_rate',
  `top10_rate` int NOT NULL COMMENT 'top10_rate',
  `top11_rate` int NOT NULL COMMENT 'top11_rate',
  `top12_rate` int NOT NULL COMMENT 'top12_rate',
  `top13_rate` int NOT NULL COMMENT 'top13_rate',
  `top14_rate` int NOT NULL COMMENT 'top14_rate',
  `top15_rate` int NOT NULL COMMENT 'top15_rate',
  `top16_rate` int NOT NULL COMMENT 'top16_rate',
  `top17_rate` int NOT NULL COMMENT 'top17_rate',
  `top18_rate` int NOT NULL COMMENT 'top18_rate',
  `top19_rate` int NOT NULL COMMENT 'top19_rate',
  `top20_rate` int NOT NULL COMMENT 'top20_rate',
  `top21_rate` int NOT NULL COMMENT 'top21_rate',
  `top22_rate` int NOT NULL COMMENT 'top22_rate',
  `top23_rate` int NOT NULL COMMENT 'top23_rate',
  `top24_rate` int NOT NULL COMMENT 'top24_rate',
  `top25_rate` int NOT NULL COMMENT 'top25_rate',
  `top26_rate` int NOT NULL COMMENT 'top26_rate',
  `top27_rate` int NOT NULL COMMENT 'top27_rate',
  `top28_rate` int NOT NULL COMMENT 'top28_rate',
  `top29_rate` int NOT NULL COMMENT 'top29_rate',
  `top30_rate` int NOT NULL COMMENT 'top30_rate',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子周期配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_cycle_user`
--

DROP TABLE IF EXISTS `luckybox_cycle_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_cycle_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `luckybox_cycle_id` bigint NOT NULL COMMENT 'luckybox_cycle_id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `diamond` int NOT NULL COMMENT 'diamond',
  `cycle` char(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `award_diamond` int NOT NULL COMMENT '奖励钻石',
  `status` tinyint NOT NULL COMMENT '领取状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`luckybox_cycle_id`,`user_id`) USING BTREE,
  KEY `luckybox_cycle_id` (`luckybox_cycle_id`),
  KEY `luckybox_cycle_id_2` (`luckybox_cycle_id`,`award_diamond`)
) ENGINE=InnoDB AUTO_INCREMENT=2877 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子周期用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_total_user`
--

DROP TABLE IF EXISTS `luckybox_total_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_total_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `buy_diamond` int unsigned NOT NULL,
  `award_diamond` int unsigned NOT NULL,
  `award_n` bigint unsigned NOT NULL,
  `sync` tinyint NOT NULL DEFAULT '2' COMMENT '是否同步 1：是 2：否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3790 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子用户汇总(全部)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user`
--

DROP TABLE IF EXISTS `luckybox_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`),
  KEY `user_id_2` (`user_id`,`id`),
  KEY `user_id_3` (`user_id`,`award_diamond`)
) ENGINE=InnoDB AUTO_INCREMENT=473939918 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202203`
--

DROP TABLE IF EXISTS `luckybox_user_202203`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202203` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`) USING BTREE,
  KEY `user_id_2` (`user_id`,`id`) USING BTREE,
  KEY `user_id_3` (`user_id`,`award_diamond`),
  KEY `user_id_4` (`user_id`,`created_time`),
  KEY `created_time` (`created_time`,`user_id`) USING BTREE,
  KEY `luckybox_award_id` (`luckybox_award_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18687721 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202204`
--

DROP TABLE IF EXISTS `luckybox_user_202204`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202204` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`) USING BTREE,
  KEY `user_id_2` (`user_id`,`id`) USING BTREE,
  KEY `user_id_3` (`user_id`,`award_diamond`),
  KEY `user_id_4` (`user_id`,`created_time`),
  KEY `created_time` (`created_time`,`user_id`) USING BTREE,
  KEY `luckybox_award_id` (`luckybox_award_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41162571 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202205`
--

DROP TABLE IF EXISTS `luckybox_user_202205`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202205` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`) USING BTREE,
  KEY `user_id_2` (`user_id`,`id`) USING BTREE,
  KEY `user_id_3` (`user_id`,`award_diamond`),
  KEY `user_id_4` (`user_id`,`created_time`),
  KEY `created_time` (`created_time`,`user_id`) USING BTREE,
  KEY `luckybox_award_id` (`luckybox_award_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64107762 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202206`
--

DROP TABLE IF EXISTS `luckybox_user_202206`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202206` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`) USING BTREE,
  KEY `user_id_2` (`user_id`,`id`) USING BTREE,
  KEY `user_id_3` (`user_id`,`award_diamond`),
  KEY `user_id_4` (`user_id`,`created_time`),
  KEY `created_time` (`created_time`,`user_id`) USING BTREE,
  KEY `luckybox_award_id` (`luckybox_award_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87007482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202207`
--

DROP TABLE IF EXISTS `luckybox_user_202207`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202207` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`) USING BTREE,
  KEY `user_id_2` (`user_id`,`id`) USING BTREE,
  KEY `user_id_3` (`user_id`,`award_diamond`),
  KEY `user_id_4` (`user_id`,`created_time`),
  KEY `created_time` (`created_time`,`user_id`) USING BTREE,
  KEY `luckybox_award_id` (`luckybox_award_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=129612582 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202209`
--

DROP TABLE IF EXISTS `luckybox_user_202209`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202209` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`),
  KEY `user_id_2` (`user_id`,`id`),
  KEY `user_id_3` (`user_id`,`award_diamond`)
) ENGINE=InnoDB AUTO_INCREMENT=7883717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_202210`
--

DROP TABLE IF EXISTS `luckybox_user_202210`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_202210` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`),
  KEY `user_id_2` (`user_id`,`id`),
  KEY `user_id_3` (`user_id`,`award_diamond`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_user_20221009`
--

DROP TABLE IF EXISTS `luckybox_user_20221009`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_user_20221009` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `luckybox_award_id` bigint NOT NULL COMMENT '中奖奖励ID',
  `award_n` bigint NOT NULL COMMENT '奖品 （0代表未中奖）',
  `award_type` tinyint NOT NULL COMMENT '奖品类型',
  `buy_diamond` int NOT NULL DEFAULT '0' COMMENT '购买需要的钻石数量',
  `award_diamond` int NOT NULL DEFAULT '0' COMMENT '价值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`),
  KEY `user_id` (`user_id`,`luckybox_award_id`,`id`),
  KEY `user_id_2` (`user_id`,`id`),
  KEY `user_id_3` (`user_id`,`award_diamond`)
) ENGINE=InnoDB AUTO_INCREMENT=527902622 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运盒子抽奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_week_user`
--

DROP TABLE IF EXISTS `luckybox_week_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_week_user` (
  `date` date NOT NULL COMMENT '周期开始日期',
  `user_id` bigint unsigned NOT NULL,
  `buy_diamond` int unsigned NOT NULL,
  `award_diamond` int unsigned NOT NULL,
  `award_n` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='幸运盒子用户汇总(周)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `luckybox_week_user_20221023`
--

DROP TABLE IF EXISTS `luckybox_week_user_20221023`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `luckybox_week_user_20221023` (
  `date` date NOT NULL COMMENT '周期开始日期',
  `user_id` bigint unsigned NOT NULL,
  `buy_diamond` int unsigned NOT NULL,
  `award_diamond` int unsigned NOT NULL,
  `award_n` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='幸运盒子用户汇总(周)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_actity_set_daily`
--

DROP TABLE IF EXISTS `match_actity_set_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_actity_set_daily` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` tinyint NOT NULL COMMENT 'type',
  `score` int NOT NULL COMMENT '分数',
  `max_score` int NOT NULL COMMENT '最大分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配活跃设置-每日分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_actity_set_score_grade`
--

DROP TABLE IF EXISTS `match_actity_set_score_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_actity_set_score_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配活跃配置分数等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_actity_user_score`
--

DROP TABLE IF EXISTS `match_actity_user_score`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_actity_user_score` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `score` int NOT NULL COMMENT '分数',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1426 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配活跃用户分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_actity_user_score_daily`
--

DROP TABLE IF EXISTS `match_actity_user_score_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_actity_user_score_daily` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL COMMENT 'type',
  `score` int NOT NULL COMMENT '分数',
  `daily` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`daily`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9878 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配活跃用户每日分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_charm_set_score_grade`
--

DROP TABLE IF EXISTS `match_charm_set_score_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_charm_set_score_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='魅力分数同等级关系';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_charm_user_score`
--

DROP TABLE IF EXISTS `match_charm_user_score`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_charm_user_score` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `score` int NOT NULL COMMENT '分数',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1837 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户魅力分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_charm_user_score_detail`
--

DROP TABLE IF EXISTS `match_charm_user_score_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_charm_user_score_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_charm_user_score_id` bigint NOT NULL COMMENT '用户魅力分数ID',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `before_score` int NOT NULL COMMENT '之前分数',
  `score` int NOT NULL COMMENT '分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `type` tinyint NOT NULL COMMENT '类型',
  `orgin_id` bigint NOT NULL COMMENT '来源ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=363308 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户魅力分数详细表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_config`
--

DROP TABLE IF EXISTS `match_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `time_gift_id` bigint NOT NULL COMMENT '加时礼物',
  `minute_diamond` int NOT NULL COMMENT '分钟扣费',
  `goddess_open_close` int NOT NULL DEFAULT '0' COMMENT '女神开启关闭',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配卡配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm`
--

DROP TABLE IF EXISTS `match_confirm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配UID',
  `channel_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `start_timestamp` bigint NOT NULL DEFAULT '0' COMMENT '声网开始时间',
  `end_timestamp` bigint NOT NULL DEFAULT '0' COMMENT '声网结束时间',
  `reality_timestamp` bigint DEFAULT NULL COMMENT '实际通话时长',
  `pic_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图片地址',
  `version` int unsigned DEFAULT '0',
  `call_ready_time` timestamp NULL DEFAULT NULL COMMENT '第一帧的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_uid`) USING BTREE,
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=453000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配确认结果';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm_free_time_record`
--

DROP TABLE IF EXISTS `match_confirm_free_time_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm_free_time_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配UID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`match_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=13902 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配免费加时';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm_gift_sum`
--

DROP TABLE IF EXISTS `match_confirm_gift_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm_gift_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配UID',
  `send_user_id` bigint NOT NULL COMMENT '发送者',
  `receive_user_id` bigint NOT NULL COMMENT '接收者',
  `time_diamond` int NOT NULL COMMENT '加时钻石汇总',
  `time_bean` int NOT NULL COMMENT '加时豆子汇总',
  `gift_diamond` int NOT NULL COMMENT '礼物钻石汇总',
  `gift_bean` int NOT NULL COMMENT '礼物豆子汇总',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_uid`,`receive_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配过程礼物汇总';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm_history`
--

DROP TABLE IF EXISTS `match_confirm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm_history` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `other_user_id` bigint NOT NULL COMMENT 'other_user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `match_uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `n` int DEFAULT '0' COMMENT '次数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`other_user_id`) USING BTREE,
  KEY `updated_time` (`updated_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12302 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配历史';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm_user`
--

DROP TABLE IF EXISTS `match_confirm_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `match_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配UID',
  `other_user_id` bigint NOT NULL,
  `accept_refuse` tinyint NOT NULL COMMENT '接受拒绝',
  `agora_id` int DEFAULT NULL COMMENT '声网Id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`match_uid`,`user_id`),
  KEY `user_id` (`user_id`,`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=699236 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配参与者';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_confirm_user_condition`
--

DROP TABLE IF EXISTS `match_confirm_user_condition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_confirm_user_condition` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_confrim_user_id` bigint NOT NULL COMMENT 'match_confrim_user_id',
  `condition_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'condition_type',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`match_confrim_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3862 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='本次匹配的参与条件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle`
--

DROP TABLE IF EXISTS `match_cycle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `join_num` int NOT NULL COMMENT '参与人数',
  `success_num` int NOT NULL COMMENT '匹配成功的人数',
  `fail_num` int NOT NULL COMMENT '匹配失败的人数',
  `trade_union_broadcast` tinyint NOT NULL COMMENT '是否发出工会广播  1:广播 2：不广播',
  `is_send` tinyint DEFAULT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=63313322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_condition`
--

DROP TABLE IF EXISTS `match_cycle_condition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_condition` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `type` tinyint NOT NULL COMMENT '类型（1：国家 2：性别）',
  `value` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`type`),
  KEY `Index_1` (`match_cycle`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期条件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=2326731 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_202302`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_202303`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_202304`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_202305`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=21895822 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202212`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202301`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=1133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202302`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202303`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202304`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_excellent_user_form_202305`
--

DROP TABLE IF EXISTS `match_cycle_excellent_user_form_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_excellent_user_form_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user`
--

DROP TABLE IF EXISTS `match_cycle_priority_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=2121256 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_202302`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_202303`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_202304`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_202305`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`),
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=16161794 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202212`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202301`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=967 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202302`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=518 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202303`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202304`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_priority_user_form_202305`
--

DROP TABLE IF EXISTS `match_cycle_priority_user_form_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_priority_user_form_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user`
--

DROP TABLE IF EXISTS `match_cycle_relation_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`,`relation_user_id`),
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=1705463 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_202302`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`,`relation_user_id`),
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_202303`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`,`relation_user_id`),
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_202304`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`,`relation_user_id`),
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_202305`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`match_cycle`,`user_id`,`relation_user_id`),
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=9020459 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202212`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202301`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=278 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202302`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202303`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202304`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_relation_user_form_202305`
--

DROP TABLE IF EXISTS `match_cycle_relation_user_form_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_relation_user_form_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`match_cycle`,`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `Index_1` (`match_cycle`,`user_id`,`score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配周期关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_cycle_success`
--

DROP TABLE IF EXISTS `match_cycle_success`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_cycle_success` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_cycle` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配周期',
  `match_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '匹配UID',
  `user1_id` bigint NOT NULL COMMENT 'user1Id',
  `user2_Id` bigint NOT NULL COMMENT 'user2Id',
  `status` tinyint(1) NOT NULL,
  `priority` int NOT NULL,
  `excellent` int NOT NULL,
  `relation` int NOT NULL,
  `excellent_relation` int NOT NULL,
  `rpc_status` tinyint NOT NULL,
  `rpc_err` varchar(9999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`user2_Id`),
  UNIQUE KEY `match_uid` (`match_uid`),
  KEY `user1_id` (`user1_id`,`created_time`) USING BTREE,
  KEY `user2_Id` (`user2_Id`,`created_time`) USING BTREE,
  KEY `match_cycle` (`match_cycle`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2264010 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配结果';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_enum_count`
--

DROP TABLE IF EXISTS `match_enum_count`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_enum_count` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL DEFAULT '0',
  `type` tinyint NOT NULL COMMENT '类型',
  `origin_type` tinyint NOT NULL DEFAULT '0',
  `num` int NOT NULL COMMENT '数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`user_id`,`type`),
  KEY `Index_1` (`user_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配元素统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_add_time_rate`
--

DROP TABLE IF EXISTS `match_excellent_set_add_time_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_add_time_rate` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` float NOT NULL COMMENT '最小数量',
  `max_num` float NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='加时率率（视频通话加时次数/视频通话次数（匹配推送接受次数））';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_be_black`
--

DROP TABLE IF EXISTS `match_excellent_set_be_black`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_be_black` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被拉黑的次数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_be_like`
--

DROP TABLE IF EXISTS `match_excellent_set_be_like`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_be_like` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被喜欢的次数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_be_report`
--

DROP TABLE IF EXISTS `match_excellent_set_be_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_be_report` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被举报的次数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_charm_grade`
--

DROP TABLE IF EXISTS `match_excellent_set_charm_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_charm_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='魅力等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_confirm_rate`
--

DROP TABLE IF EXISTS `match_excellent_set_confirm_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_confirm_rate` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` float NOT NULL COMMENT '最小数量',
  `max_num` float NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配接通率（匹配推送接受次数/匹配推送次数）';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_gift_video_receive_f`
--

DROP TABLE IF EXISTS `match_excellent_set_gift_video_receive_f`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_gift_video_receive_f` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='接收礼物次数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_gift_video_receive_num`
--

DROP TABLE IF EXISTS `match_excellent_set_gift_video_receive_num`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_gift_video_receive_num` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='接收礼物数量';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_like_me`
--

DROP TABLE IF EXISTS `match_excellent_set_like_me`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_like_me` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被喜欢等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_session_create`
--

DROP TABLE IF EXISTS `match_excellent_set_session_create`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_session_create` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='融云会话被付费';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_set_trade_union`
--

DROP TABLE IF EXISTS `match_excellent_set_trade_union`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_set_trade_union` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='工会成员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user`
--

DROP TABLE IF EXISTS `match_excellent_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=53888 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail`
--

DROP TABLE IF EXISTS `match_excellent_user_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '新增时间',
  `data_change` int NOT NULL DEFAULT '0',
  `num` float NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=5864868 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_202302`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '新增时间',
  `data_change` int NOT NULL DEFAULT '0',
  `num` float NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=403 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_202303`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '新增时间',
  `data_change` int NOT NULL DEFAULT '0',
  `num` float NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=453 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_202304`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '新增时间',
  `data_change` int NOT NULL DEFAULT '0',
  `num` float NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=926803 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_202305`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '新增时间',
  `data_change` int NOT NULL DEFAULT '0',
  `num` float NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_sum`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB AUTO_INCREMENT=22994 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_sum_202302`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_sum_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_sum_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_sum_202303`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_sum_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_sum_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_sum_202304`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_sum_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_sum_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB AUTO_INCREMENT=182412 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_detail_sum_202305`
--

DROP TABLE IF EXISTS `match_excellent_user_detail_sum_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_detail_sum_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_excellent_user_form`
--

DROP TABLE IF EXISTS `match_excellent_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_excellent_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源类型',
  `origin_type` bigint NOT NULL COMMENT '来源ID',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` float NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userId` (`user_id`,`origin_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=131965 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配质量分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_gift_operate_count`
--

DROP TABLE IF EXISTS `match_gift_operate_count`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_gift_operate_count` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `num` int NOT NULL COMMENT '数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='礼物操作统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_active_grade`
--

DROP TABLE IF EXISTS `match_priority_set_active_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_active_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='活跃等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_again_refuse`
--

DROP TABLE IF EXISTS `match_priority_set_again_refuse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_again_refuse` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='连续被拒';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_again_same_sex`
--

DROP TABLE IF EXISTS `match_priority_set_again_same_sex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_again_same_sex` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配到同性';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_be_black`
--

DROP TABLE IF EXISTS `match_priority_set_be_black`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_be_black` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被拉黑';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_be_report`
--

DROP TABLE IF EXISTS `match_priority_set_be_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_be_report` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被举报';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_daily_user`
--

DROP TABLE IF EXISTS `match_priority_set_daily_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_daily_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='每日新登陆用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_diamond`
--

DROP TABLE IF EXISTS `match_priority_set_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_diamond` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小钻石',
  `max_num` int NOT NULL COMMENT '最大钻石',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='钻石等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_first_pay`
--

DROP TABLE IF EXISTS `match_priority_set_first_pay`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_first_pay` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='24小时首充用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_new_user`
--

DROP TABLE IF EXISTS `match_priority_set_new_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_new_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='新用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_recently_pay`
--

DROP TABLE IF EXISTS `match_priority_set_recently_pay`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_recently_pay` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='近期充值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_trade_union`
--

DROP TABLE IF EXISTS `match_priority_set_trade_union`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_trade_union` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='优先度工会成员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_set_wealth_grade`
--

DROP TABLE IF EXISTS `match_priority_set_wealth_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_set_wealth_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小财富',
  `max_num` int NOT NULL COMMENT '最大财富',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='财富等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user`
--

DROP TABLE IF EXISTS `match_priority_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4911 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先度分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail`
--

DROP TABLE IF EXISTS `match_priority_user_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202211`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202211`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202211` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=16587 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202212`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=40879 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202301`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202302`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=1733 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202303`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=1212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202304`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=1031 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_202305`
--

DROP TABLE IF EXISTS `match_priority_user_detail_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '触发类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户行为ID',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配分数详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_sum`
--

DROP TABLE IF EXISTS `match_priority_user_detail_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`origin_type`,`period`,`period_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=46739 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_sum_202302`
--

DROP TABLE IF EXISTS `match_priority_user_detail_sum_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_sum_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`origin_type`,`period`,`period_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=652 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_sum_202303`
--

DROP TABLE IF EXISTS `match_priority_user_detail_sum_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_sum_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`origin_type`,`period`,`period_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=911 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_sum_202304`
--

DROP TABLE IF EXISTS `match_priority_user_detail_sum_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_sum_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`origin_type`,`period`,`period_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=655 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_detail_sum_202305`
--

DROP TABLE IF EXISTS `match_priority_user_detail_sum_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_detail_sum_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`origin_type`,`period`,`period_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配优先详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_priority_user_form`
--

DROP TABLE IF EXISTS `match_priority_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_priority_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源类型',
  `origin_type` bigint NOT NULL COMMENT '来源ID',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userId` (`user_id`,`origin_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配顺序分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_set_like`
--

DROP TABLE IF EXISTS `match_relation_set_like`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_set_like` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小值',
  `max_num` int NOT NULL COMMENT '最大值',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='是否喜欢等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_set_match_refuse`
--

DROP TABLE IF EXISTS `match_relation_set_match_refuse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_set_match_refuse` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='被拒绝的次数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_set_match_user`
--

DROP TABLE IF EXISTS `match_relation_set_match_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_set_match_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配过的用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_set_match_user_last_time`
--

DROP TABLE IF EXISTS `match_relation_set_match_user_last_time`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_set_match_user_last_time` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='上一轮匹配推送过的用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_set_session_no_match_confirm`
--

DROP TABLE IF EXISTS `match_relation_set_session_no_match_confirm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_set_session_no_match_confirm` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `score` int NOT NULL COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='付费发送过消息但没进行过视频聊天';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user`
--

DROP TABLE IF EXISTS `match_relation_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_userId` (`user_id`,`relation_user_id`),
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=616382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail`
--

DROP TABLE IF EXISTS `match_relation_user_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=10244142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_202301`
--

DROP TABLE IF EXISTS `match_relation_user_detail_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_202302`
--

DROP TABLE IF EXISTS `match_relation_user_detail_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=268 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_202303`
--

DROP TABLE IF EXISTS `match_relation_user_detail_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_202304`
--

DROP TABLE IF EXISTS `match_relation_user_detail_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2728177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_202305`
--

DROP TABLE IF EXISTS `match_relation_user_detail_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `bef_score` int NOT NULL COMMENT '之前分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `score` int NOT NULL COMMENT '分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_remark` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源备注',
  `log_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'log_id',
  `data_change` int NOT NULL DEFAULT '0',
  `num` int NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`relation_user_id`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`,`period`,`period_type`)
) ENGINE=InnoDB AUTO_INCREMENT=110284 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum_202301`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`period_type`,`period`,`origin_type`,`user_id`,`relation_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum_202302`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`period_type`,`period`,`origin_type`,`user_id`,`relation_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum_202303`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`period_type`,`period`,`origin_type`,`user_id`,`relation_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum_202304`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`period_type`,`period`,`origin_type`,`user_id`,`relation_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3233751 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_detail_sum_202305`
--

DROP TABLE IF EXISTS `match_relation_user_detail_sum_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_detail_sum_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `total_score` int NOT NULL COMMENT '总分数',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `period` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '周期',
  `period_type` tinyint NOT NULL COMMENT '周期类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`period_type`,`period`,`origin_type`,`user_id`,`relation_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系详情统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_form`
--

DROP TABLE IF EXISTS `match_relation_user_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_form` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源ID',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=195459 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_form_202302`
--

DROP TABLE IF EXISTS `match_relation_user_form_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_form_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源ID',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_form_202303`
--

DROP TABLE IF EXISTS `match_relation_user_form_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_form_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源ID',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_form_202304`
--

DROP TABLE IF EXISTS `match_relation_user_form_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_form_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源ID',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1060981 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_relation_user_form_202305`
--

DROP TABLE IF EXISTS `match_relation_user_form_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_relation_user_form_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'userId',
  `relation_user_id` bigint NOT NULL COMMENT '关系的人',
  `score` int NOT NULL COMMENT '分数',
  `origin_id` tinyint NOT NULL COMMENT '来源ID',
  `origin_type` bigint NOT NULL COMMENT '来源类型',
  `origin_name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '来源名字',
  `num` int NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`relation_user_id`,`origin_type`) USING BTREE,
  KEY `relation_user_id` (`relation_user_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配关系分数构成';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_set_condition`
--

DROP TABLE IF EXISTS `match_set_condition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_set_condition` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` tinyint NOT NULL COMMENT '分类',
  `type_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '分类名字',
  `condition_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '条件分类',
  `condition_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '条件名字',
  `domain_num` int NOT NULL COMMENT '钻石数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='匹配条件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_wealth_set_score_grade`
--

DROP TABLE IF EXISTS `match_wealth_set_score_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_wealth_set_score_grade` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min_num` int NOT NULL COMMENT '最小数量',
  `max_num` int NOT NULL COMMENT '最大数量',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='财富分数同等级关系';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_wealth_user_score`
--

DROP TABLE IF EXISTS `match_wealth_user_score`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_wealth_user_score` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `score` int NOT NULL COMMENT '分数',
  `grade` int NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户财富分数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `match_wealth_user_score_detail`
--

DROP TABLE IF EXISTS `match_wealth_user_score_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `match_wealth_user_score_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `match_wealth_user_score_id` bigint NOT NULL COMMENT '用户财富分数ID',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `before_score` int NOT NULL COMMENT '之前分数',
  `score` int NOT NULL COMMENT '分数',
  `after_score` int NOT NULL COMMENT '之后分数',
  `type` tinyint NOT NULL COMMENT '类型',
  `orgin_id` bigint NOT NULL COMMENT '来源ID',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1292556 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户财富分数详细表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr`
--

DROP TABLE IF EXISTS `mgr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'name',
  `user_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '使用者名字',
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `type` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1:主账号 2：子账号',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_advice`
--

DROP TABLE IF EXISTS `mgr_advice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_advice` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `advice` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '意见',
  `pic_urls` varchar(15000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=439 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户提供\r\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_deal`
--

DROP TABLE IF EXISTS `mgr_deal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_deal` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint NOT NULL COMMENT '处理者',
  `deal_type` tinyint NOT NULL COMMENT '处理方式（1：忽略，2：冻结）',
  `reason_type` tinyint NOT NULL COMMENT '处理理由',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '0.后台操作1.超管操作',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3652 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_imei`
--

DROP TABLE IF EXISTS `mgr_imei`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_imei` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint NOT NULL COMMENT '管理人ID',
  `imei` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `reason_type` tinyint NOT NULL COMMENT '处理原因',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `imei_IDX` (`imei`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=679 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理设备';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_imei_log`
--

DROP TABLE IF EXISTS `mgr_imei_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_imei_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint NOT NULL COMMENT '管理人ID',
  `imei` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `reason_type` tinyint NOT NULL COMMENT '处理原因',
  `type` tinyint NOT NULL COMMENT '类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理设备日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_ip`
--

DROP TABLE IF EXISTS `mgr_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_ip` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint NOT NULL COMMENT '管理人ID',
  `ip` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=593 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理ip';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_operation_log`
--

DROP TABLE IF EXISTS `mgr_operation_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_operation_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `module_id` bigint unsigned NOT NULL COMMENT '模块表的id',
  `module_url_id` bigint unsigned NOT NULL COMMENT '模块表url的id',
  `content` varchar(2047) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作内容',
  `description` text COLLATE utf8mb4_unicode_ci COMMENT '描述',
  `media_urls` varchar(2047) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片/视屏 json数组',
  `target_uid` bigint unsigned NOT NULL DEFAULT '0' COMMENT '被处理的ID',
  `oper_uid` bigint unsigned NOT NULL DEFAULT '0' COMMENT '操作人ID',
  `mgr_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '管理人id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理员操作记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_operation_module`
--

DROP TABLE IF EXISTS `mgr_operation_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_operation_module` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `module_name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模块名称',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理员操作模块';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_operation_module_url`
--

DROP TABLE IF EXISTS `mgr_operation_module_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_operation_module_url` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `module_id` bigint unsigned NOT NULL COMMENT '模块id',
  `method` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'http请求method: GET|POST|PUT|DELETE等',
  `full_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'http请求路径',
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `method` (`method`,`full_path`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理员操作模块-url';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_permission`
--

DROP TABLE IF EXISTS `mgr_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint NOT NULL COMMENT 'mgr_id',
  `permission_id` bigint NOT NULL COMMENT '拥有的权限ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`mgr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10657 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人权限';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_permission_config`
--

DROP TABLE IF EXISTS `mgr_permission_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_permission_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `parent_id` bigint NOT NULL COMMENT '父节点（没有父节点为0）',
  `name` char(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `method_url` char(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '限制method+url',
  `type` tinyint NOT NULL COMMENT '0：url 1：一级目录 2：二级目录',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人权限配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_report`
--

DROP TABLE IF EXISTS `mgr_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_report` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `from_user_id` bigint NOT NULL COMMENT '举报者',
  `to_user_id` bigint NOT NULL COMMENT '被举报人',
  `from_page_type` tinyint NOT NULL COMMENT '来自哪个页面或操作 1.视频页2.查看详情3.聊天页4.匹配历史5.群组活动',
  `origin_id` bigint NOT NULL DEFAULT '0' COMMENT '来源ID',
  `reason_type` tinyint NOT NULL COMMENT '举报原因 视频页1.言语骚扰 2.不雅行为 聊天页1.不良信息 2.不雅照片；群组活动：5.色情6.未成年7.广告8.其他',
  `image_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '举报图片',
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL COMMENT '状态 1.待处理 2.已忽略 3.处罚',
  `report_deal_id` bigint NOT NULL COMMENT '处理Id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`from_user_id`,`to_user_id`),
  KEY `Index_2` (`to_user_id`,`from_user_id`),
  KEY `Index_3` (`status`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=6255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_report_group`
--

DROP TABLE IF EXISTS `mgr_report_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_report_group` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `from_user_id` bigint NOT NULL COMMENT '举报者',
  `group_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '被举报人',
  `reason_type` tinyint NOT NULL COMMENT '举报原因 视频页1.言语骚扰 2.不雅行为 聊天页1.不良信息 2.不雅照片',
  `image_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '举报图片',
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL COMMENT '状态 1.待处理 2.已忽略 3.处罚',
  `report_deal_id` bigint NOT NULL COMMENT '处理Id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`from_user_id`,`group_id`),
  KEY `Index_2` (`group_id`,`from_user_id`),
  KEY `Index_3` (`status`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=5601 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_send_diamond_bill`
--

DROP TABLE IF EXISTS `mgr_send_diamond_bill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_send_diamond_bill` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_mgr_id` bigint unsigned NOT NULL COMMENT '创建者',
  `send_mgr_id` bigint DEFAULT NULL COMMENT '发放者',
  `uuid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'uuid',
  `status` tinyint NOT NULL COMMENT '状态',
  `send_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '发送时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人发放钻石';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_send_diamond_bill_detail`
--

DROP TABLE IF EXISTS `mgr_send_diamond_bill_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_send_diamond_bill_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_send_diamond_bill_id` bigint unsigned NOT NULL COMMENT 'mgr_send_diamond_bill_id',
  `uuid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'uuid',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `diamond` int NOT NULL COMMENT '钻石',
  `reason` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '原因',
  `type` tinyint NOT NULL COMMENT '类型(1活动扶持 2活动奖励)',
  `status` tinyint NOT NULL COMMENT '状态(未发放，发放成功，发放失败)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`mgr_send_diamond_bill_id`),
  KEY `Index_2` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人发放钻石详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_send_noble`
--

DROP TABLE IF EXISTS `mgr_send_noble`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_send_noble` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `bill_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'bill_id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `level` int NOT NULL COMMENT '贵族等级',
  `day` int NOT NULL COMMENT '天数',
  `reason` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '原因',
  `status` tinyint NOT NULL COMMENT '状态(0未发放，1发放成功，2发放失败)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `mgr_id` bigint unsigned NOT NULL COMMENT '发放人id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_bill_id_IDX` (`user_id`,`bill_id`) USING BTREE,
  KEY `bill_id_IDX` (`bill_id`) USING BTREE,
  KEY `mgr_id_IDX` (`mgr_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人发放贵族';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_send_user_bag`
--

DROP TABLE IF EXISTS `mgr_send_user_bag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_send_user_bag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `bill_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'bill_id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `res_type` int unsigned NOT NULL COMMENT '资源类型 1:礼物',
  `res_id` bigint unsigned NOT NULL COMMENT '资源ID',
  `count` int DEFAULT '0' COMMENT '道具数量',
  `day` int NOT NULL COMMENT '天数',
  `reason` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '原因',
  `status` tinyint NOT NULL COMMENT '状态(0未发放，1发放成功，2发放失败)',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `mgr_id` bigint unsigned NOT NULL COMMENT '发放人id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_bill_id_IDX` (`user_id`,`bill_id`) USING BTREE,
  KEY `bill_id_IDX` (`bill_id`) USING BTREE,
  KEY `mgr_id_IDX` (`mgr_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人发放用户背包';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_url_log`
--

DROP TABLE IF EXISTS `mgr_url_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_url_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `trace_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'TraceId',
  `mgr_id` bigint NOT NULL COMMENT '管理人ID',
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '方法',
  `url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '地址',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数',
  `result` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`mgr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16898 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理人请求日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mgr_user_status`
--

DROP TABLE IF EXISTS `mgr_user_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mgr_user_status` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `status` tinyint NOT NULL COMMENT '状态（1：永久冻结，2：封禁）',
  `end_time` datetime DEFAULT NULL COMMENT '解禁截至时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1592 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理_用户状态';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `moderate_record`
--

DROP TABLE IF EXISTS `moderate_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `moderate_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `file_name` varchar(512) NOT NULL,
  `labels` varchar(1024) NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_idx` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `msg_batch_record`
--

DROP TABLE IF EXISTS `msg_batch_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `msg_batch_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `send_user_id` bigint unsigned NOT NULL,
  `content` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pic_url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action_type` smallint unsigned NOT NULL,
  `total` int unsigned NOT NULL,
  `failed_count` int unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `send_user_IDX` (`send_user_id`) USING BTREE,
  KEY `created_time_IDX` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `msg_sys`
--

DROP TABLE IF EXISTS `msg_sys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `msg_sys` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `content` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `pic_url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片地址',
  `url` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'H5地址',
  `expect_send_time` timestamp NOT NULL COMMENT '预计发送时间',
  `action_type` tinyint NOT NULL DEFAULT '0' COMMENT '0:无跳转 1：网页跳转， 2：跳转到用户 3：跳转到群组',
  `actual_send_time` timestamp NULL DEFAULT NULL COMMENT '实际发送时间',
  `area` tinyint NOT NULL DEFAULT '0' COMMENT '区域 0:全区 1:阿语 2:非阿语',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=432 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统推送';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `msg_sys_record`
--

DROP TABLE IF EXISTS `msg_sys_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `msg_sys_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `type` int NOT NULL COMMENT '类型',
  `status` tinyint NOT NULL DEFAULT '1',
  `msg_sys_id` bigint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`) USING BTREE,
  KEY `Index_1` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=357 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推送系统消息记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `msg_sys_user`
--

DROP TABLE IF EXISTS `msg_sys_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `msg_sys_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL DEFAULT '1' COMMENT '类型',
  `msg_sys_last_id` bigint unsigned NOT NULL COMMENT 'msg_sys_last_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统消息用户读位置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `msg_user_record`
--

DROP TABLE IF EXISTS `msg_user_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `msg_user_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `type` tinyint NOT NULL COMMENT '类型（1：新用户 2：投诉）',
  `nick` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '昵称',
  `nick_user_id` bigint NOT NULL DEFAULT '0',
  `diamond_income` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `day_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '多少天',
  `property_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '座驾地址',
  `bean_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=347386 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推送记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `open_screen`
--

DROP TABLE IF EXISTS `open_screen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `open_screen` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'title',
  `image` char(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'image',
  `url` char(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'url',
  `group_code` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'group_id',
  `begin_time` datetime NOT NULL COMMENT 'begin_time',
  `end_time` datetime NOT NULL COMMENT 'end_time',
  `type` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `country_list` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='开屏弹窗';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operate_user_memo`
--

DROP TABLE IF EXISTS `operate_user_memo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operate_user_memo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint unsigned NOT NULL COMMENT '管理员ID',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `memo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '上报数据对象',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='运营备忘录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operation_log`
--

DROP TABLE IF EXISTS `operation_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operation_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `mgr_id` bigint unsigned NOT NULL COMMENT 'user_id',
  `doc` json DEFAULT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=379 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pay_order`
--

DROP TABLE IF EXISTS `pay_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pay_order` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` tinyint NOT NULL COMMENT '平台',
  `order_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'orderID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `amount` int NOT NULL COMMENT '钻石数量',
  `price` int NOT NULL COMMENT '价格',
  `user_id` bigint NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL DEFAULT '2' COMMENT '1：准备 2：成功',
  `refund_time` datetime DEFAULT NULL,
  `type` tinyint NOT NULL DEFAULT '0' COMMENT '类型：0.默认1.代理充值2.用户给代理充值',
  `money` float NOT NULL DEFAULT '0' COMMENT '花费的货币数量',
  `currency` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '货币',
  `goods_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '充值钻石套餐id/商品id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`platform`,`order_id`),
  KEY `user_id_plat_IDX` (`user_id`,`platform`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3792 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='支付订单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pay_to_checkout`
--

DROP TABLE IF EXISTS `pay_to_checkout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pay_to_checkout` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='支付不成功返回checkout链接';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `power_support_award`
--

DROP TABLE IF EXISTS `power_support_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `power_support_award` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `week` date NOT NULL,
  `power_id` bigint unsigned NOT NULL COMMENT '国家势力ID',
  `diamond` int NOT NULL COMMENT '钻石',
  `level` char(1) NOT NULL COMMENT '等级',
  `owner` bigint unsigned NOT NULL COMMENT '势力主',
  `owner_salary` int unsigned NOT NULL,
  `assistant_1` bigint unsigned NOT NULL,
  `assistant_2` bigint unsigned NOT NULL,
  `assistant_3` bigint unsigned NOT NULL,
  `assistant_salary` int unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`week`,`power_id`)
) ENGINE=InnoDB AUTO_INCREMENT=444 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='势力周扶持发奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_agent`
--

DROP TABLE IF EXISTS `promotion_agent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_agent` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `manager_id` bigint NOT NULL COMMENT '经理人id',
  `agent_id` bigint DEFAULT NULL COMMENT '推广员id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `agent_id` (`agent_id`),
  KEY `manager_id` (`manager_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_agent_log`
--

DROP TABLE IF EXISTS `promotion_agent_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_agent_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `manager_id` bigint NOT NULL COMMENT '经理人id',
  `agent_id` bigint DEFAULT NULL COMMENT '推广员id',
  `add_reduce` tinyint(1) NOT NULL COMMENT '操作 1:增加 2:删除',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广员-增加删除日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_invite`
--

DROP TABLE IF EXISTS `promotion_invite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_invite` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `manager_id` bigint DEFAULT NULL COMMENT '经理id',
  `agent_id` bigint DEFAULT NULL COMMENT '推广员id',
  `invitee` bigint DEFAULT NULL COMMENT '被邀请人user_id',
  `platform` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '来自平台',
  `platform_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '平台id',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邀请原因',
  `invite_date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邀请日期',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invitee` (`invitee`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广-邀请关系';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_invite_log`
--

DROP TABLE IF EXISTS `promotion_invite_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_invite_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `agent_id` bigint DEFAULT NULL COMMENT '推广员id',
  `invitee` bigint DEFAULT NULL COMMENT '被邀请人user_id',
  `add_reduce` tinyint(1) NOT NULL COMMENT '操作 1:增加 2:删除',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广-邀请关系增加删除日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_team`
--

DROP TABLE IF EXISTS `promotion_team`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_team` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `manager_id` bigint NOT NULL COMMENT '经理人id',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '团队名称',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `manager_id` (`manager_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广团队';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `promotion_team_data`
--

DROP TABLE IF EXISTS `promotion_team_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `promotion_team_data` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `team_id` bigint DEFAULT NULL COMMENT '团队id',
  `invite_charge_cnt` bigint DEFAULT NULL COMMENT '邀请充值用户数',
  `month_pay_sum` double NOT NULL COMMENT '30天内充值$',
  `two_month_pay_sum` double NOT NULL COMMENT '60天内充值$',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `team_id` (`team_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推广团队静态数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `read_last`
--

DROP TABLE IF EXISTS `read_last`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `read_last` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `n` int NOT NULL COMMENT '次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`user_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2541 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='已读截至时间（产品眼中的新已读，就是气泡中+），';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `read_note`
--

DROP TABLE IF EXISTS `read_note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `read_note` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `other_user_id` bigint NOT NULL COMMENT 'other_user_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `has_read` tinyint NOT NULL COMMENT '是否已读',
  `has_del` tinyint NOT NULL DEFAULT '2' COMMENT '是否删除',
  `n` int NOT NULL DEFAULT '0' COMMENT '次数，更新次数，无意义，是为了触发update',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`other_user_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=119436 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='已读';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recall`
--

DROP TABLE IF EXISTS `recall`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recall` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `cycle` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'cycle',
  `n` int NOT NULL DEFAULT '0' COMMENT '发送的数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=456012 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户召回批次';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recall_user`
--

DROP TABLE IF EXISTS `recall_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recall_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `recall_id` bigint NOT NULL COMMENT '批次ID',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id, created_time` (`user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=80222 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户召回用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recommend_user`
--

DROP TABLE IF EXISTS `recommend_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recommend_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `status` tinyint NOT NULL DEFAULT '1',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2009 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='推荐用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_code`
--

DROP TABLE IF EXISTS `res_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_code` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'code',
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=640 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='资源的code';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_country`
--

DROP TABLE IF EXISTS `res_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_country` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `short_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩写',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图标',
  `icon2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国旗2',
  `lang` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '语言',
  `is_common` tinyint NOT NULL COMMENT '是否常见',
  `is_default` tinyint NOT NULL,
  `status` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `standard_short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '国际标准缩写',
  `area_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家手机号码区号',
  `area_code_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号域名国家缩写',
  `area` tinyint unsigned NOT NULL DEFAULT '2' COMMENT '1.阿语区 2.除了阿语区的其他地区',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=522 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_dealer_transfer`
--

DROP TABLE IF EXISTS `res_dealer_transfer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_dealer_transfer` (
  `id` int unsigned NOT NULL,
  `diamond` int unsigned NOT NULL,
  `dollar` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='币商钻石转账配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_gift`
--

DROP TABLE IF EXISTS `res_gift`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_gift` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名字',
  `icon_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'icon地址',
  `svag_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'svag地址',
  `music_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '音乐地址',
  `column` smallint unsigned DEFAULT '0' COMMENT '分栏ID',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `bean_num` int NOT NULL COMMENT '豆子数量',
  `receive_diamond_num` int NOT NULL DEFAULT '0' COMMENT '接受礼物的一方钻石数量',
  `second` int NOT NULL COMMENT '秒',
  `n` int NOT NULL COMMENT '排序',
  `group_broadcast` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否全群组广播',
  `cp` tinyint NOT NULL DEFAULT '0',
  `together` tinyint NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `gift_type` tinyint NOT NULL DEFAULT '1' COMMENT '礼物类型：1.黄钻礼物2.粉钻礼物',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`n`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='礼物';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_gift_avatar`
--

DROP TABLE IF EXISTS `res_gift_avatar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_gift_avatar` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT 'res_gift_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `send_user_id` bigint NOT NULL COMMENT 'send_user_id',
  `receiver_user_id` bigint NOT NULL COMMENT 'receiver_user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_IDX` (`type`,`res_gift_id`) USING BTREE,
  KEY `Index_1` (`res_gift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='礼物头像';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_group_support`
--

DROP TABLE IF EXISTS `res_group_support`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_group_support` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `grade` tinyint(1) NOT NULL COMMENT '等级',
  `contribute_user_num` int NOT NULL COMMENT '贡献人数',
  `contribute_diamond_num` int NOT NULL COMMENT '贡献钻石',
  `admin_award` int NOT NULL COMMENT '群主奖励',
  `mgr_num` int NOT NULL COMMENT '管理数量',
  `mgr_award` int NOT NULL COMMENT '管理人奖励',
  `status` tinyint NOT NULL COMMENT '状态（1：正常 2：删除）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群组扶持资源';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_group_theme`
--

DROP TABLE IF EXISTS `res_group_theme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_group_theme` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` int NOT NULL,
  `status` tinyint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `weight_IDX` (`weight`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='群主题';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_headwear`
--

DROP TABLE IF EXISTS `res_headwear`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_headwear` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '头饰名称',
  `pic_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片',
  `effect_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '特效',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2005 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='头饰配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_headwear_diamond`
--

DROP TABLE IF EXISTS `res_headwear_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_headwear_diamond` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_headwear_id` bigint NOT NULL COMMENT 'res_headwear_id',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `second` int NOT NULL COMMENT '时长（秒）',
  `status` tinyint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='头饰价格';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_language`
--

DROP TABLE IF EXISTS `res_language`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_language` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `res_country_id` bigint NOT NULL COMMENT '国家ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='语言';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_lucky_wheel`
--

DROP TABLE IF EXISTS `res_lucky_wheel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_lucky_wheel` (
  `id` int unsigned NOT NULL,
  `entrance_fee` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='幸运轮盘配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_medal`
--

DROP TABLE IF EXISTS `res_medal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_medal` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pic_url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `svga_url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort` int NOT NULL DEFAULT '0' COMMENT '排序，值越低越靠前',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL DEFAULT '0',
  `scope` tinyint NOT NULL DEFAULT '1',
  `threshold` int NOT NULL DEFAULT '0',
  `no_pic_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `i` int NOT NULL DEFAULT '0' COMMENT '排序',
  `attr_type` tinyint unsigned NOT NULL DEFAULT '1' COMMENT '勋章类型1.个人2.房间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4792 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='勋章资源';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_medal_public_obtain`
--

DROP TABLE IF EXISTS `res_medal_public_obtain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_medal_public_obtain` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_medal_id` bigint NOT NULL COMMENT 'res_property_id',
  `res_gift_id` bigint NOT NULL COMMENT 'res_gift_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`res_medal_id`,`res_gift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='送了多少礼物，送勋章具，财富等级得勋章，魅力等级得勋章';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_mic_emoji`
--

DROP TABLE IF EXISTS `res_mic_emoji`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_mic_emoji` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` char(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `icon_url` char(250) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'icon地址',
  `svag_url` char(250) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'svag地址',
  `n` int NOT NULL COMMENT '排序',
  `status` tinyint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='麦位表情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_msg_translate`
--

DROP TABLE IF EXISTS `res_msg_translate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_msg_translate` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `language` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '语言',
  `title` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `content` varchar(5600) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `icon_url` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图标url',
  `msg_type` tinyint NOT NULL COMMENT '消息类型（1:系统消息，2：用户消息）',
  `type` int NOT NULL COMMENT '消息类型（1）',
  `action_type` tinyint NOT NULL DEFAULT '0' COMMENT '跳转类型',
  `action_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '跳转的路径',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`msg_type`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=5289 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='资源消息的的翻译';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_multi_text`
--

DROP TABLE IF EXISTS `res_multi_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_multi_text` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `msg_id` int unsigned NOT NULL COMMENT '消息ID',
  `language` char(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '语言',
  `content` varchar(5600) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_lang` (`msg_id`,`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2214 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='多语言文本';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_nameplate`
--

DROP TABLE IF EXISTS `res_nameplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_nameplate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pic_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `svga_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort` int NOT NULL DEFAULT '0' COMMENT '排序，值越低越靠前',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint NOT NULL DEFAULT '0',
  `scope` tinyint NOT NULL DEFAULT '1',
  `threshold` int NOT NULL DEFAULT '0',
  `no_pic_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='铭牌资源';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_noble`
--

DROP TABLE IF EXISTS `res_noble`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_noble` (
  `level` smallint unsigned NOT NULL COMMENT '贵族等级',
  `purchase_price` int unsigned NOT NULL COMMENT '购买价格',
  `renewal_price` int unsigned NOT NULL COMMENT '续费价格',
  `duration` smallint unsigned NOT NULL,
  `pic_url` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '大图url',
  `daily_gold` int unsigned NOT NULL COMMENT '每日登录领取的金币',
  `ride_id` int unsigned NOT NULL COMMENT '赠送的勋章ID',
  `headdress_id` int unsigned NOT NULL COMMENT '赠送的头饰ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='贵族配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_power_support`
--

DROP TABLE IF EXISTS `res_power_support`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_power_support` (
  `level` char(1) NOT NULL COMMENT '等级',
  `trophy` int unsigned NOT NULL COMMENT '阈值',
  `owner_salary` int unsigned NOT NULL,
  `assistant_salary` int unsigned NOT NULL,
  `assistant_num` int unsigned NOT NULL COMMENT '助手数量',
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='势力周扶持配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_property`
--

DROP TABLE IF EXISTS `res_property`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_property` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '道具名称',
  `pic_url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '图片',
  `effect_url` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '特效',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='道具配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_property_avatar`
--

DROP TABLE IF EXISTS `res_property_avatar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_property_avatar` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_property_id` bigint NOT NULL COMMENT 'res_property_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `send_user_id` bigint NOT NULL COMMENT 'send_user_id',
  `receiver_user_id` bigint NOT NULL COMMENT 'receiver_user_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`res_property_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='道具头像';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_property_diamond`
--

DROP TABLE IF EXISTS `res_property_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_property_diamond` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_property_id` bigint NOT NULL COMMENT 'res_property_id',
  `diamond_num` int NOT NULL COMMENT '钻石数量',
  `second` int NOT NULL COMMENT '时长（秒）',
  `status` tinyint NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='道具价格';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_purchase_diamond`
--

DROP TABLE IF EXISTS `res_purchase_diamond`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_purchase_diamond` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `product_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '产品ID',
  `amount` int NOT NULL COMMENT '钻石数量',
  `price` int NOT NULL COMMENT '价格',
  `platform` tinyint NOT NULL COMMENT '平台 1.安卓 2.iOS',
  `status` tinyint NOT NULL COMMENT '状态',
  `n` int NOT NULL COMMENT '排序',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `discount` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '折扣描述',
  `diamond_type` tinyint NOT NULL DEFAULT '1' COMMENT '类型：1.黄钻2.粉钻',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`platform`,`status`,`n`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='充值面版\r\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_purchase_vip`
--

DROP TABLE IF EXISTS `res_purchase_vip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_purchase_vip` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `product_id` char(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '产品ID',
  `price` int NOT NULL COMMENT '价格',
  `platform` tinyint NOT NULL COMMENT '平台 ',
  `status` tinyint NOT NULL COMMENT '状态',
  `n` int NOT NULL COMMENT '排序',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='VIP面板';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_tradeunion_welcome`
--

DROP TABLE IF EXISTS `res_tradeunion_welcome`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tradeunion_welcome` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `language` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '语言',
  `content` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='资源-公会欢迎语';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `res_uid`
--

DROP TABLE IF EXISTS `res_uid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_uid` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='资源ID';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_award`
--

DROP TABLE IF EXISTS `rocket_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_award` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `result_id` bigint unsigned NOT NULL COMMENT '关联的resultID',
  `user_id` bigint unsigned NOT NULL,
  `rank` tinyint unsigned NOT NULL COMMENT '贡献排名（从0开始）',
  `award_cfg_id` bigint unsigned NOT NULL COMMENT '获得的奖品配置id',
  `diamond` int unsigned NOT NULL COMMENT '获得的小额钻石数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `result_user_idx` (`result_id`,`user_id`),
  KEY `rank_IDX` (`rank`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=33119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='火箭奖励表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_award_config`
--

DROP TABLE IF EXISTS `rocket_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_award_config` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `stage` tinyint unsigned NOT NULL COMMENT '阶段id',
  `seq` tinyint unsigned NOT NULL COMMENT '次序',
  `award_type` tinyint unsigned NOT NULL COMMENT '奖励类型',
  `award_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '奖励ID',
  `num` int unsigned NOT NULL COMMENT '数量',
  `duration` int unsigned NOT NULL DEFAULT '0' COMMENT '奖励时长（天）',
  `probability` smallint unsigned NOT NULL COMMENT '中奖概率%',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `stage` (`stage`,`seq`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='火箭奖励配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_contribute`
--

DROP TABLE IF EXISTS `rocket_contribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_contribute` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `period` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL DEFAULT '0' COMMENT '轮次',
  `stage` smallint unsigned NOT NULL DEFAULT '0' COMMENT '阶段',
  `user_id` bigint unsigned NOT NULL,
  `gift_ref_id` bigint unsigned NOT NULL COMMENT '关联的礼物记录ID',
  `diamond` int unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_period_id` (`group_id`,`period`)
) ENGINE=InnoDB AUTO_INCREMENT=1568113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='火箭贡献表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_guest_award`
--

DROP TABLE IF EXISTS `rocket_guest_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_guest_award` (
  `stage` tinyint unsigned NOT NULL COMMENT '阶段id',
  `lower_bound` int unsigned NOT NULL COMMENT '随机范围的下限',
  `upper_bound` int unsigned NOT NULL COMMENT '随机范围的上限',
  `total` int unsigned NOT NULL COMMENT '总上限',
  `probability` smallint unsigned NOT NULL COMMENT '中奖概率%',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='火箭观众奖励配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_info`
--

DROP TABLE IF EXISTS `rocket_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `period` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL DEFAULT '0' COMMENT '今天产生了多少轮火箭',
  `stage` smallint unsigned NOT NULL DEFAULT '0' COMMENT '当前在哪个阶段',
  `score` int unsigned NOT NULL DEFAULT '0' COMMENT '火箭积分',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_period_id` (`group_id`,`period`)
) ENGINE=InnoDB AUTO_INCREMENT=1383213 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='火箭信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_result`
--

DROP TABLE IF EXISTS `rocket_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_result` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `period` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL DEFAULT '0' COMMENT '轮次',
  `stage` smallint unsigned NOT NULL DEFAULT '0' COMMENT '阶段',
  `is_awarded` tinyint(1) NOT NULL DEFAULT '0' COMMENT '奖励是否已发放',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rocket_id` (`group_id`,`period`,`round`,`stage`),
  KEY `stage_IDX` (`stage`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=18541 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='火箭结果表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rocket_stage`
--

DROP TABLE IF EXISTS `rocket_stage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rocket_stage` (
  `id` tinyint unsigned NOT NULL COMMENT '阶段id',
  `diamond` int unsigned NOT NULL COMMENT '升级需要的钻石数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='火箭升级配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `roderate_record`
--

DROP TABLE IF EXISTS `roderate_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roderate_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `file_name` varchar(512) NOT NULL,
  `labels` varchar(1024) NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_banner`
--

DROP TABLE IF EXISTS `room_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_banner` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `image` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '缩略图',
  `url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'URL',
  `n` int NOT NULL COMMENT '排序',
  `status` tinyint unsigned NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `country_list` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`),
  KEY `n_IDX` (`n`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='房间里的banner';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_day_consume`
--

DROP TABLE IF EXISTS `room_day_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_day_consume` (
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `day` date NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`,`day`),
  KEY `created_time_IDX` (`created_time`) USING BTREE,
  KEY `day_IDX` (`day`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_medal_config`
--

DROP TABLE IF EXISTS `room_medal_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_medal_config` (
  `level` smallint unsigned NOT NULL COMMENT '等级',
  `threshold` bigint unsigned NOT NULL COMMENT '阈值',
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章ID',
  `desc` varchar(1024) NOT NULL COMMENT '文案',
  `inactive_url` varchar(1024) NOT NULL,
  `active_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='房间勋章配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_month_consume`
--

DROP TABLE IF EXISTS `room_month_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_month_consume` (
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `month` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`,`month`),
  KEY `created_time_IDX` (`created_time`) USING BTREE,
  KEY `month_IDX` (`month`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_user_day_consume`
--

DROP TABLE IF EXISTS `room_user_day_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_user_day_consume` (
  `day` date NOT NULL,
  `group_id` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_user_id` bigint unsigned NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`day`,`group_id`,`send_user_id`),
  KEY `group_IDX` (`group_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `room_week_consume`
--

DROP TABLE IF EXISTS `room_week_consume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `room_week_consume` (
  `group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `week` date NOT NULL,
  `diamond` bigint unsigned NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`,`week`),
  KEY `created_time_IDX` (`created_time`) USING BTREE,
  KEY `week_IDX` (`week`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log`
--

DROP TABLE IF EXISTS `rpc_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3039642 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202212`
--

DROP TABLE IF EXISTS `rpc_log_202212`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202212` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202301`
--

DROP TABLE IF EXISTS `rpc_log_202301`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202301` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57920 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202302`
--

DROP TABLE IF EXISTS `rpc_log_202302`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202302` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45424 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202303`
--

DROP TABLE IF EXISTS `rpc_log_202303`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202303` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50990 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202304`
--

DROP TABLE IF EXISTS `rpc_log_202304`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202304` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37012 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rpc_log_202305`
--

DROP TABLE IF EXISTS `rpc_log_202305`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rpc_log_202305` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_id',
  `type` tinyint unsigned NOT NULL COMMENT 'type',
  `msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'msg',
  `err` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `fail_uids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`type`),
  KEY `type` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='rpc的日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session`
--

DROP TABLE IF EXISTS `session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `session_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sessionUid',
  `type` tinyint NOT NULL COMMENT '会话类型',
  `orgin_type` tinyint NOT NULL COMMENT '来源类型',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`session_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=16602 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='会话';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session_free_user`
--

DROP TABLE IF EXISTS `session_free_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session_free_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `day` date NOT NULL COMMENT '日期',
  `n` int NOT NULL COMMENT '次数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_3` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=342 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='免费视频';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session_pay`
--

DROP TABLE IF EXISTS `session_pay`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session_pay` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL COMMENT '类型（1:支付者 2：参与者）',
  `session_id` bigint NOT NULL COMMENT '会话ID',
  `diamond_account_detail_id` bigint NOT NULL COMMENT '钻石消费详情',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`session_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='会话支付';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session_view`
--

DROP TABLE IF EXISTS `session_view`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session_view` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `other_user_id` bigint NOT NULL COMMENT 'other_user_id',
  `session_id` bigint NOT NULL COMMENT 'session_id',
  `session_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'session_uid',
  `logic_del` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `i` int NOT NULL DEFAULT '0',
  `callback_time` datetime DEFAULT NULL COMMENT 'im回调时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`other_user_id`) USING BTREE,
  KEY `Index_1` (`other_user_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='会话视图';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sheep_match_queue`
--

DROP TABLE IF EXISTS `sheep_match_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sheep_match_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `sex` tinyint NOT NULL COMMENT '性别',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='羊羊队列表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sheep_match_robot`
--

DROP TABLE IF EXISTS `sheep_match_robot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sheep_match_robot` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='羊羊robot表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sheep_match_success`
--

DROP TABLE IF EXISTS `sheep_match_success`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sheep_match_success` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id1` bigint NOT NULL COMMENT '用户id1',
  `user_id2` bigint NOT NULL COMMENT '用户id2',
  `ai1` tinyint NOT NULL DEFAULT '0' COMMENT 'user_id1是否ai 0：否 1：是',
  `ai2` tinyint NOT NULL DEFAULT '0' COMMENT 'user_id2是否ai 0：否 1：是',
  `type` smallint unsigned NOT NULL COMMENT '1:随机匹配 2：指定匹配',
  `start_ux` bigint NOT NULL DEFAULT '0' COMMENT 'user1开始时间',
  `end_ux` bigint NOT NULL DEFAULT '0' COMMENT '结束时间',
  `winner` bigint NOT NULL DEFAULT '0' COMMENT '赢家',
  `payload` varchar(255) DEFAULT NULL COMMENT '回调body',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='羊羊匹配成功表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slot_day_rank`
--

DROP TABLE IF EXISTS `slot_day_rank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slot_day_rank` (
  `date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `stake_times` bigint NOT NULL DEFAULT '0' COMMENT '投注次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot 日榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slot_level_config`
--

DROP TABLE IF EXISTS `slot_level_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slot_level_config` (
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `exp` bigint unsigned NOT NULL COMMENT '所需经验值',
  `award_type` tinyint(1) NOT NULL COMMENT '奖励类型 1:钻石 2:礼物 3:头饰 4:贵族 5:座驾',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '资源id,钻石类型为0,贵族类型为贵族等级',
  `res_count` int unsigned NOT NULL COMMENT '资源个数',
  `res_day` int NOT NULL DEFAULT '0' COMMENT '资源天数,钻石类型为0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot 等级配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slot_sdk_report`
--

DROP TABLE IF EXISTS `slot_sdk_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slot_sdk_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `report_msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '上报数据对象',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4814 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='slot游戏sdk上报';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slot_user_level`
--

DROP TABLE IF EXISTS `slot_user_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slot_user_level` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户等级';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slot_user_level_detail`
--

DROP TABLE IF EXISTS `slot_user_level_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slot_user_level_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户id',
  `level` bigint unsigned NOT NULL COMMENT '等级',
  `award_type` tinyint(1) NOT NULL COMMENT '奖励类型 1:钻石 2:礼物 3:头饰 4:贵族 5:座驾',
  `res_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '资源id,钻石类型为0,贵族类型为贵族等级',
  `res_count` int unsigned NOT NULL COMMENT '资源个数',
  `res_day` int NOT NULL DEFAULT '0' COMMENT '资源天数,钻石类型为0',
  `status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '状态 1:发奖成功 2:未发奖',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户等级明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `splash_screen`
--

DROP TABLE IF EXISTS `splash_screen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `splash_screen` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'title',
  `image` char(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'image',
  `url` char(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'url',
  `group_code` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'group_id',
  `begin_time` datetime NOT NULL COMMENT 'begin_time',
  `end_time` datetime NOT NULL COMMENT 'end_time',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `area` tinyint unsigned NOT NULL DEFAULT '0' COMMENT '上线区域:0全区;1阿语区;2非阿语区;3指定国家',
  `country_list` varchar(800) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '指定区域的国家列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='运营弹窗';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `starchat_charge`
--

DROP TABLE IF EXISTS `starchat_charge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `starchat_charge` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `app_id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_amount` int NOT NULL,
  `goods_id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_amount` float NOT NULL,
  `order_no` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_amount` float NOT NULL,
  `pay_type` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `user_id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_no_IDX` (`order_no`) USING BTREE,
  KEY `user_id_IDX` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_day_stat`
--

DROP TABLE IF EXISTS `static_day_stat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_day_stat` (
  `date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `dau` bigint unsigned NOT NULL COMMENT 'DAU',
  `retention` bigint unsigned NOT NULL COMMENT '次日存留',
  `retention_ratio` bigint unsigned NOT NULL COMMENT '次日存留率',
  `new_user` bigint unsigned NOT NULL COMMENT '新注册',
  `confirm_count` bigint unsigned NOT NULL COMMENT '双方同意视频聊天的次数',
  `video_count` bigint unsigned NOT NULL COMMENT '视频聊天的次数',
  `video_user_count` bigint unsigned NOT NULL COMMENT '视频聊天的用户数',
  `apple_pay` bigint unsigned NOT NULL COMMENT '当日消费(苹果)',
  `google_pay` bigint unsigned NOT NULL COMMENT '当日消费(谷歌)',
  `official_pay` bigint unsigned NOT NULL COMMENT '当日充值(官网，当前包含渠道：checkout、茄子)',
  `agent_pay` bigint unsigned NOT NULL COMMENT '代理充值(当前包含渠道：茄子)',
  `eggplant_pay` bigint unsigned NOT NULL COMMENT '当日充值(茄子)',
  `checkout_pay` bigint unsigned NOT NULL COMMENT '当日充值(官网，当前包含渠道：checkout、茄子)',
  `total_pay` bigint unsigned NOT NULL COMMENT '当日消费合计',
  `income` bigint unsigned NOT NULL COMMENT '当日预估收入',
  `charge_user_count` bigint unsigned NOT NULL COMMENT '当日充值人数',
  `charge_count` bigint unsigned NOT NULL COMMENT '当日充值次数',
  `vip_buy_count` bigint unsigned NOT NULL COMMENT '当日购买vip的人数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-日活天数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_fruit_machine_award_week`
--

DROP TABLE IF EXISTS `static_fruit_machine_award_week`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_fruit_machine_award_week` (
  `begin_date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `end_date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `rank` int NOT NULL COMMENT '排名',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `profit_loss` bigint NOT NULL COMMENT '盈亏(中奖-投注)',
  `charge_money` float NOT NULL COMMENT '充值金额 $',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`begin_date`,`end_date`,`rank`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-水果机周排行数据-中奖';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_fruit_machine_day`
--

DROP TABLE IF EXISTS `static_fruit_machine_day`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_fruit_machine_day` (
  `date` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `round_num` int NOT NULL COMMENT '总轮数',
  `user_num` int NOT NULL COMMENT '总参与人数',
  `award_num` int NOT NULL DEFAULT '0' COMMENT '中奖人数',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `recycle` bigint unsigned NOT NULL COMMENT '总回收钻石数',
  `top_consumer` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消费TOP1',
  `top_consumer_diamond` bigint unsigned NOT NULL COMMENT '消费TOP1消费金额',
  `top_winner` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '中奖TOP1',
  `top_winner_diamond` bigint unsigned NOT NULL COMMENT '中奖TOP1中奖金额',
  `left_over` int NOT NULL DEFAULT '0' COMMENT '今日盈余',
  `pool` int NOT NULL DEFAULT '0' COMMENT '当前奖池',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-水果机天数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_fruit_machine_stake_week`
--

DROP TABLE IF EXISTS `static_fruit_machine_stake_week`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_fruit_machine_stake_week` (
  `begin_date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `end_date` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `rank` int NOT NULL COMMENT '排名',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `stake` bigint unsigned NOT NULL COMMENT '总参与钻石数',
  `award` bigint unsigned NOT NULL COMMENT '总中奖金额',
  `profit_loss` bigint NOT NULL COMMENT '盈亏(中奖-投注)',
  `charge_money` float NOT NULL COMMENT '充值金额 $',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`begin_date`,`end_date`,`rank`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-水果机周排行数据-投注';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_luckybox_award_count_day`
--

DROP TABLE IF EXISTS `static_luckybox_award_count_day`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_luckybox_award_count_day` (
  `date_str` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `buy_diamonds` bigint NOT NULL DEFAULT '0' COMMENT '消耗总金币',
  `award_diamonds` bigint NOT NULL DEFAULT '0' COMMENT '抽出奖品总价值',
  `lottery_num` bigint NOT NULL DEFAULT '0' COMMENT '总抽奖次数',
  `person_sum` bigint NOT NULL DEFAULT '0' COMMENT '总抽奖人数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date_str`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-幸运盒子奖励统计-天数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `static_luckybox_award_detail_day`
--

DROP TABLE IF EXISTS `static_luckybox_award_detail_day`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_luckybox_award_detail_day` (
  `date_str` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `luckybox_award_id` int NOT NULL DEFAULT '0' COMMENT '奖品ID',
  `award_type` int NOT NULL DEFAULT '0' COMMENT '奖品名称 1:钻石',
  `total_diamond` bigint NOT NULL DEFAULT '0' COMMENT '中奖价值',
  `n` int NOT NULL DEFAULT '0' COMMENT '中奖次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date_str`,`luckybox_award_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='静态数据-幸运盒子抽奖明细-天数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `super_manager`
--

DROP TABLE IF EXISTS `super_manager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `super_manager` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_1` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='超级管理人';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_config`
--

DROP TABLE IF EXISTS `task_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `diamond` int NOT NULL COMMENT '钻石',
  `type` tinyint NOT NULL COMMENT '类型',
  `rate_type` tinyint NOT NULL COMMENT '频率类型(1：每日任务 2：进阶任务)',
  `finish_n` int NOT NULL COMMENT '完成次数',
  `i` int NOT NULL COMMENT '排序',
  `status` tinyint NOT NULL COMMENT '状态',
  `award_n` int NOT NULL COMMENT '奖励次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='任务配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_user`
--

DROP TABLE IF EXISTS `task_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `task_config_id` bigint NOT NULL COMMENT '任务ID',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `day_str` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期字符串',
  `finish_n` int NOT NULL COMMENT '完成了多少次了',
  `award_n` int NOT NULL COMMENT '奖励次数',
  `has_finish` tinyint NOT NULL COMMENT '是否已经完成',
  `has_award` tinyint NOT NULL COMMENT '是否已经领取奖励（全部完成奖励）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`task_config_id`,`user_id`,`day_str`)
) ENGINE=InnoDB AUTO_INCREMENT=11213 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='任务用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_user_detail`
--

DROP TABLE IF EXISTS `task_user_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_user_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `task_user_id` bigint NOT NULL COMMENT 'task_user_id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `task_config_id` bigint NOT NULL COMMENT 'task_config_id',
  `origin_id` bigint NOT NULL COMMENT '来源ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=135873 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='任务用户明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `trade_union_agent`
--

DROP TABLE IF EXISTS `trade_union_agent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `trade_union_agent` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名字',
  `status` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='工会用户代理';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tx_moderate_record`
--

DROP TABLE IF EXISTS `tx_moderate_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tx_moderate_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `data_id` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `suggestion` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `response` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_idx` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `external_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '别名',
  `avatar` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '头像',
  `default_avatar` tinyint(1) NOT NULL DEFAULT '1',
  `nick` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '昵称',
  `sex` tinyint NOT NULL COMMENT '性别',
  `birthday` bigint DEFAULT '0' COMMENT '出生日期',
  `country` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家',
  `country_icon` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国旗图标地址',
  `language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '个性签名',
  `is_push` tinyint NOT NULL,
  `is_show_age` tinyint NOT NULL,
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邀请码',
  `origin_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '原始邀请码',
  `status` tinyint NOT NULL DEFAULT '1' COMMENT '状态',
  `device_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'ios，Android',
  `logout_time` bigint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `network_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '买量network',
  `tracker_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '买量tracker',
  `campaign_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '买量campaign',
  `adid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '买量adid',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`code`),
  KEY `external_id_IDX` (`external_id`) USING BTREE,
  KEY `country_IDX` (`country`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7643 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_appversion`
--

DROP TABLE IF EXISTS `user_appversion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_appversion` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `device_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'ios，Android',
  `appversion` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '版本号',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`),
  KEY `da_idx` (`device_type`,`appversion`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=526 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='版本号';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_award_data`
--

DROP TABLE IF EXISTS `user_award_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_award_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `timestart` int unsigned NOT NULL DEFAULT '0',
  `data_type` tinyint NOT NULL DEFAULT '0' COMMENT '1日数据2周数据3月数据',
  `number` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_bag`
--

DROP TABLE IF EXISTS `user_bag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_bag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `res_type` int unsigned NOT NULL COMMENT '道具类型 1:礼物道具',
  `res_id` bigint unsigned NOT NULL COMMENT '道具资源id',
  `count` int DEFAULT '0' COMMENT '道具数量',
  `end_time` datetime DEFAULT NULL COMMENT '有效截至时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `end_idx` (`user_id`,`res_type`,`res_id`,`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=313 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户背包';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_bag_detail`
--

DROP TABLE IF EXISTS `user_bag_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_bag_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `bag_id` bigint NOT NULL DEFAULT '0' COMMENT '背包id',
  `res_type` int unsigned NOT NULL COMMENT '资源类型 1:礼物',
  `res_id` bigint unsigned NOT NULL COMMENT '资源ID',
  `count` int DEFAULT '0' COMMENT '道具数量',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少）',
  `bef_num` bigint NOT NULL COMMENT '之前数量',
  `aft_num` bigint NOT NULL COMMENT '之后数量',
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_idx` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=571 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户背包明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_bind_info`
--

DROP TABLE IF EXISTS `user_bind_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_bind_info` (
  `user_id` bigint unsigned NOT NULL,
  `phone` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号码（包含区号）',
  `phone_country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号所属国家',
  `pwd` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '账号密码',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `area_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家区号',
  `icon` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家图标',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `phone_IDX` (`phone`,`area_code`) USING BTREE,
  KEY `create_at_IDX` (`create_at`) USING BTREE,
  KEY `update_at_IDX` (`update_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_black_tencentyun_tmp`
--

DROP TABLE IF EXISTS `user_black_tencentyun_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_black_tencentyun_tmp` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_external` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user_external',
  `block_external` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'block_external',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='腾讯云临时表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_block`
--

DROP TABLE IF EXISTS `user_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_block` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `block_user_id` bigint NOT NULL COMMENT '拉黑用户ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`block_user_id`),
  KEY `Index_1` (`user_id`,`created_time`),
  KEY `Index_2` (`block_user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=7003 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='黑名单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_code_gen_range`
--

DROP TABLE IF EXISTS `user_code_gen_range`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_code_gen_range` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `min` bigint NOT NULL COMMENT 'code范围的下限',
  `max` bigint NOT NULL COMMENT 'code范围的上限',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='预备生成的code范围';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_consume_half_month`
--

DROP TABLE IF EXISTS `user_consume_half_month`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_consume_half_month` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `send_user_id` bigint unsigned NOT NULL COMMENT '发送人',
  `receive_user_id` bigint unsigned NOT NULL COMMENT '接收人',
  `diamond` bigint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_idx` (`receive_user_id`,`send_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户贡献-过去15天排行榜';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_consume_half_month_offset`
--

DROP TABLE IF EXISTS `user_consume_half_month_offset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_consume_half_month_offset` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `last_cal_time` timestamp NULL DEFAULT NULL COMMENT '上次计算到的时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户贡献-过去15天排行榜-记录偏移值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_count`
--

DROP TABLE IF EXISTS `user_count`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_count` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `type` tinyint NOT NULL COMMENT '类型',
  `num` int NOT NULL COMMENT '数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=5098 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_country_log`
--

DROP TABLE IF EXISTS `user_country_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_country_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `before_country` char(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '之前国家',
  `after_country` char(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '现在国家',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户国家修改记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_enter_room`
--

DROP TABLE IF EXISTS `user_enter_room`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_enter_room` (
  `user_id` bigint unsigned NOT NULL,
  `group_id` char(32) NOT NULL,
  `enter_time` datetime NOT NULL COMMENT '最近一次进入时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_IDX` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='用户进房间记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_global_broadcast`
--

DROP TABLE IF EXISTS `user_global_broadcast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_global_broadcast` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `group_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '群组ID',
  `msg` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '消息',
  `status` tinyint NOT NULL COMMENT '状态',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2024 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户全球广播';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_global_broadcast_limit`
--

DROP TABLE IF EXISTS `user_global_broadcast_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_global_broadcast_limit` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `end_time` datetime DEFAULT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户全球广播限制';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_global_broadcast_prohibit`
--

DROP TABLE IF EXISTS `user_global_broadcast_prohibit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_global_broadcast_prohibit` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `user_global_broadcast_id` bigint NOT NULL COMMENT 'user_global_broadcast_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户全球广播删除';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_headwear`
--

DROP TABLE IF EXISTS `user_headwear`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_headwear` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `headwear_id` bigint NOT NULL COMMENT '头饰ID',
  `end_time` timestamp NOT NULL COMMENT '有效截至时间',
  `using` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`,`headwear_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户头饰';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_headwear_log`
--

DROP TABLE IF EXISTS `user_headwear_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_headwear_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `headwear_id` bigint NOT NULL COMMENT '头饰ID',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `type` tinyint NOT NULL COMMENT '类型（1：原来基础上延迟 2：直接修改截至时间 3：删除）',
  `add_second` int DEFAULT NULL COMMENT '增加时间（单位秒）',
  `update_end_time` timestamp NULL DEFAULT NULL COMMENT '修改截止时间',
  `operate_user_id` bigint NOT NULL DEFAULT '0' COMMENT '操作者ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`),
  KEY `Index_2` (`user_id`,`headwear_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户头饰日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_imei`
--

DROP TABLE IF EXISTS `user_imei`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_imei` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `imei` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备码',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`),
  KEY `imei_IDX` (`imei`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4021 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='设备码';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_interaction`
--

DROP TABLE IF EXISTS `user_interaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_interaction` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `send_user_id` bigint unsigned NOT NULL,
  `receive_user_id` bigint unsigned NOT NULL,
  `src_type` tinyint unsigned NOT NULL COMMENT '来源',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `receiver_idx` (`receive_user_id`) USING BTREE,
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2940 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户互动记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_ip`
--

DROP TABLE IF EXISTS `user_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_ip` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `ip` char(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ip',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户IP';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_like`
--

DROP TABLE IF EXISTS `user_like`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_like` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '喜欢者ID',
  `like_user_id` bigint NOT NULL COMMENT '被喜欢者ID',
  `scene_type` tinyint NOT NULL DEFAULT '0' COMMENT '1：随机匹配',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`user_id`,`like_user_id`),
  KEY `Index_2` (`like_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30676 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户喜欢';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_like_operate`
--

DROP TABLE IF EXISTS `user_like_operate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_like_operate` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '喜欢者ID',
  `like_user_id` bigint unsigned NOT NULL COMMENT '被喜欢者ID',
  `type` tinyint NOT NULL COMMENT '类型（1：喜欢，2：取消喜欢）',
  `scene_type` tinyint NOT NULL DEFAULT '0' COMMENT '1：随机匹配',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`,`like_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6176 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户喜欢操作';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_match_card`
--

DROP TABLE IF EXISTS `user_match_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_match_card` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `remain_n` int NOT NULL COMMENT '剩余次数',
  `date_str` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日期',
  `has_vip_daily_in` tinyint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1731 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户匹配卡';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_match_card_config`
--

DROP TABLE IF EXISTS `user_match_card_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_match_card_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `sign_no_vip_day_n` int NOT NULL COMMENT '签到非VIP匹配卡',
  `sign_vip_day_n` int NOT NULL COMMENT '签到VIP匹配卡',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户匹配卡配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_medal`
--

DROP TABLE IF EXISTS `user_medal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_medal` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `medal_id` int unsigned NOT NULL COMMENT '勋章ID',
  `end_time` datetime DEFAULT NULL COMMENT '有效截至时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_medal_un` (`user_id`,`medal_id`),
  KEY `user_id_IDX` (`user_id`) USING BTREE,
  KEY `medal_id_IDX` (`medal_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6681 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户勋章';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_nameplate`
--

DROP TABLE IF EXISTS `user_nameplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_nameplate` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `nameplate_id` int unsigned NOT NULL COMMENT '铭牌ID',
  `end_time` datetime DEFAULT NULL COMMENT '有效截至时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_nameplate_un` (`user_id`,`nameplate_id`),
  KEY `user_id_IDX` (`user_id`) USING BTREE,
  KEY `nameplate_id_IDX` (`nameplate_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户铭牌';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_nameplate_log`
--

DROP TABLE IF EXISTS `user_nameplate_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_nameplate_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `sender_id` bigint unsigned NOT NULL,
  `receiver_id` bigint unsigned NOT NULL,
  `nameplate_id` int unsigned NOT NULL COMMENT '铭牌ID',
  `old_end_time` datetime DEFAULT NULL COMMENT '旧截止时间',
  `new_end_time` datetime NOT NULL COMMENT '截止时间',
  `mgr_id` bigint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `receiver_id` (`receiver_id`) USING BTREE,
  KEY `mgr_id` (`mgr_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='用户铭牌日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_noble`
--

DROP TABLE IF EXISTS `user_noble`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_noble` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `level` smallint unsigned NOT NULL COMMENT '贵族等级',
  `end_time` datetime NOT NULL COMMENT '有效截至时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_level_IDX` (`user_id`,`level`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1644 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='贵族身份';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_noble_log`
--

DROP TABLE IF EXISTS `user_noble_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_noble_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `sender_id` bigint unsigned NOT NULL,
  `receiver_id` bigint unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `money` int unsigned NOT NULL COMMENT '花费',
  `src_type` smallint unsigned NOT NULL DEFAULT '1',
  `old_end_time` datetime NOT NULL COMMENT '旧截止时间',
  `new_end_time` datetime NOT NULL COMMENT '截止时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `receiver_id` (`receiver_id`) USING BTREE,
  KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3358 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='贵族消费日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_oauth`
--

DROP TABLE IF EXISTS `user_oauth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_oauth` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `third_party_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '第三方ID',
  `third_party_type` tinyint NOT NULL COMMENT '第三方类型',
  `third_party_token` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '第三方token',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `third_party_id` (`third_party_id`,`third_party_type`),
  UNIQUE KEY `uid_tid_IDX` (`user_id`,`third_party_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4503 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='授权登陆';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_on_mic`
--

DROP TABLE IF EXISTS `user_on_mic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_on_mic` (
  `date` date NOT NULL COMMENT '日期',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `seconds` bigint NOT NULL DEFAULT '0' COMMENT '上麦时长',
  `last_cal_ts` bigint NOT NULL DEFAULT '0' COMMENT '上次计算的上麦时间戳',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tz` tinyint NOT NULL DEFAULT '0' COMMENT '时区 0:北京 1:沙特',
  PRIMARY KEY (`date`,`user_id`,`tz`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户上麦时长';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_photos`
--

DROP TABLE IF EXISTS `user_photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_photos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL,
  `photo_url` varchar(1024) NOT NULL DEFAULT '',
  `position` tinyint unsigned NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `USER_ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2021 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_property`
--

DROP TABLE IF EXISTS `user_property`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_property` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `property_id` bigint unsigned NOT NULL COMMENT '道具ID',
  `end_time` timestamp NOT NULL COMMENT '有效截至时间',
  `using` tinyint NOT NULL DEFAULT '0',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`),
  KEY `property_id` (`property_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4324 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户道具';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_property_log`
--

DROP TABLE IF EXISTS `user_property_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_property_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `property_id` bigint NOT NULL COMMENT '道具ID',
  `origin_type` tinyint NOT NULL COMMENT '来源类型',
  `type` tinyint NOT NULL COMMENT '类型（1：原来基础上延迟 2：直接修改截至时间 3：删除）',
  `add_second` int DEFAULT NULL COMMENT '增加时间（单位秒）',
  `update_end_time` timestamp NULL DEFAULT NULL COMMENT '修改截止时间',
  `operate_user_id` bigint NOT NULL DEFAULT '0' COMMENT '操作者ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户道具日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_relation`
--

DROP TABLE IF EXISTS `user_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_relation` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id_1` bigint unsigned NOT NULL,
  `user_id_2` bigint unsigned NOT NULL,
  `heart_value` int NOT NULL DEFAULT '0' COMMENT '永恒之心值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `USER_ID` (`user_id_1`)
) ENGINE=InnoDB AUTO_INCREMENT=6382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户成长关系';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_request_last`
--

DROP TABLE IF EXISTS `user_request_last`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_request_last` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `time_last` timestamp NOT NULL COMMENT '最后的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2061 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户请求最后时间';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_svip`
--

DROP TABLE IF EXISTS `user_svip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_svip` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `points` bigint unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `level` int unsigned NOT NULL DEFAULT '0' COMMENT 'svip等级',
  `expire_at` datetime NOT NULL COMMENT '过期时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `expire_at` (`expire_at`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户SVIP';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_svip_detail`
--

DROP TABLE IF EXISTS `user_svip_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_svip_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `add_reduce` tinyint NOT NULL COMMENT '类型（1：增加 2：减少 3: 设置）',
  `num` int NOT NULL COMMENT '数量',
  `remark` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `bef_num` bigint NOT NULL COMMENT '之前积分数量',
  `aft_num` bigint NOT NULL COMMENT '之后积分数量',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_time` (`created_time`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=626 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户SVIP增减明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_svip_privilege`
--

DROP TABLE IF EXISTS `user_svip_privilege`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_svip_privilege` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `type` int NOT NULL COMMENT '类型 1.专属勋章, 2.专属标识, 3.设备和IP踢出房间, 4.隐藏在线, 5.禁止跟随, 6.炫彩昵称, 7.隐藏礼物墙, 8.隐藏访客记录, 9.排行榜隐身, 10.房间防踢, 11.房间防抱下麦',
  `open_close` tinyint NOT NULL COMMENT '1:开启 2:关闭',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户SVIP特权开关';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_trade_union`
--

DROP TABLE IF EXISTS `user_trade_union`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_trade_union` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `match_notification` tinyint NOT NULL,
  `agent_id` bigint NOT NULL DEFAULT '0' COMMENT '不存在则为0',
  `starchat_id` bigint unsigned NOT NULL DEFAULT '0',
  `avatar` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '公会头像',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='工会用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_transfer_detail`
--

DROP TABLE IF EXISTS `user_transfer_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_transfer_detail` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `pay_order_id` bigint NOT NULL COMMENT 'pay_order表id',
  `dealer_id` bigint unsigned NOT NULL COMMENT '收钻代理userid',
  `user_id` bigint unsigned NOT NULL COMMENT '充值支付的userid',
  `diamond` int unsigned NOT NULL,
  `dollar` int unsigned NOT NULL,
  `status` tinyint NOT NULL DEFAULT '2' COMMENT '1：准备 2：成功',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pay_id_IDX` (`pay_order_id`),
  KEY `dealer_id_IDX` (`dealer_id`),
  KEY `user_id_IDX` (`user_id`),
  KEY `created_time_IDX` (`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户给币商充值钻石记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_vip`
--

DROP TABLE IF EXISTS `user_vip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_vip` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `expire_at` datetime NOT NULL COMMENT '过期时间',
  `type` tinyint NOT NULL COMMENT '类型（1：用户充值 2：后台赠送）',
  `platform` tinyint NOT NULL COMMENT '平台',
  `vip_subscribe_order_id` bigint NOT NULL COMMENT 'vip订阅订单',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10534 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户VIP';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_visit`
--

DROP TABLE IF EXISTS `user_visit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_visit` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户',
  `visit_user_id` bigint NOT NULL COMMENT '访问者',
  `n` int NOT NULL DEFAULT '1' COMMENT '访问次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `AK_Key_2` (`user_id`,`visit_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户访问';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_wealth`
--

DROP TABLE IF EXISTS `user_wealth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_wealth` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `wealth` int NOT NULL COMMENT '财富值',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户财富';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `version_control`
--

DROP TABLE IF EXISTS `version_control`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `version_control` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `platform` varchar(63) NOT NULL COMMENT 'android / ios',
  `audit_version` varchar(255) NOT NULL DEFAULT '' COMMENT '提审版本号,>=时会过滤敏感模块',
  `status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1:有效 2:无效',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='版本控制';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_agora_log`
--

DROP TABLE IF EXISTS `video_agora_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_agora_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `video_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频ID',
  `request_id` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '声网日志ID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_1` (`video_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=46060 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='声网日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_chat_time_total`
--

DROP TABLE IF EXISTS `video_chat_time_total`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_chat_time_total` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户id',
  `video_seconds` bigint DEFAULT '0' COMMENT '视频聊天时长/秒',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频聊天总时长';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_data`
--

DROP TABLE IF EXISTS `video_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `date_str` date NOT NULL,
  `data_type` tinyint NOT NULL DEFAULT '1' COMMENT '1每天的数据',
  `dau` int unsigned NOT NULL DEFAULT '0',
  `video_dau` int unsigned NOT NULL DEFAULT '1' COMMENT '参与视频总人数',
  `video_keep` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '视频留存',
  `video_time` int NOT NULL DEFAULT '0' COMMENT '总通话时长',
  `video_diamond` int unsigned NOT NULL DEFAULT '0' COMMENT '视频总消耗',
  `video_start` int NOT NULL DEFAULT '0' COMMENT '发起随机匹配的人数总和',
  `video_match` int NOT NULL DEFAULT '0' COMMENT '发起匹配的次数总和',
  `video_success` int NOT NULL DEFAULT '0' COMMENT '匹配成功次数',
  `video_everyone` int unsigned NOT NULL DEFAULT '0' COMMENT '1v1人数',
  `video_everyone_all` int NOT NULL DEFAULT '0' COMMENT '1v1总次数',
  `video_everyone_success` int unsigned NOT NULL DEFAULT '0' COMMENT '1v1成功次数',
  `region` tinyint NOT NULL DEFAULT '0' COMMENT '用户的区域',
  `country` tinyint NOT NULL DEFAULT '0' COMMENT '国家',
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `date_str_IDX` (`date_str`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_detail`
--

DROP TABLE IF EXISTS `video_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频UID',
  `channel_id` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '频道ID',
  `send_user_id` bigint NOT NULL COMMENT '发起者',
  `receive_user_id` bigint NOT NULL COMMENT '接收者',
  `send_time` timestamp NOT NULL COMMENT '发起时间',
  `receive_time` timestamp NULL DEFAULT NULL COMMENT '接收时间',
  `refuse_time` timestamp NULL DEFAULT NULL COMMENT '拒绝时间',
  `refuse_user_id` bigint DEFAULT NULL COMMENT '拒绝用户ID',
  `send_agora_id` int NOT NULL COMMENT '发起者声网token',
  `receive_agora_id` int NOT NULL COMMENT '发起者声网id',
  `send_agora_token` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '接收者声网token',
  `receive_agora_token` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '接收者声网id',
  `status` tinyint NOT NULL COMMENT '状态',
  `type` tinyint NOT NULL COMMENT '类型',
  `start_time` timestamp NOT NULL COMMENT '开始时间',
  `end_time` timestamp NOT NULL COMMENT '结束时间',
  `reality_time` timestamp NULL DEFAULT NULL COMMENT '实际结束时间',
  `end_user_id` bigint DEFAULT NULL COMMENT '结束通话的人（已经通话了的结束）',
  `cost_diamond` int NOT NULL COMMENT '花费的钻石',
  `is_pink` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否粉钻 1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `call_ready_time` timestamp NULL DEFAULT NULL COMMENT '第一帧的时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_match_uid` (`video_uid`),
  KEY `AK_channel_id` (`channel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=53724 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_free_time_record`
--

DROP TABLE IF EXISTS `video_free_time_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_free_time_record` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '1对1UID',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`video_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=13082 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='1对1视频免费加时';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_free_user`
--

DROP TABLE IF EXISTS `video_free_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_free_user` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT 'user_id',
  `day` date NOT NULL COMMENT '日期',
  `n` int NOT NULL COMMENT '次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1223 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频免费用户';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_gift_sum`
--

DROP TABLE IF EXISTS `video_gift_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_gift_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频UID',
  `send_user_id` bigint NOT NULL COMMENT '发起者',
  `receive_user_id` bigint NOT NULL COMMENT '接收者',
  `send_diamond` int NOT NULL COMMENT '发送者花费的钻石',
  `receive_bean` int NOT NULL COMMENT '接收者收到的豆子',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index_1` (`video_uid`,`send_user_id`,`receive_user_id`) USING BTREE,
  KEY `video_uid` (`video_uid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=438 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频礼物统计';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_minute_detail`
--

DROP TABLE IF EXISTS `video_minute_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_minute_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频UID',
  `uuid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'UUID',
  `send_user_id` bigint NOT NULL COMMENT '发起者',
  `receive_user_id` bigint NOT NULL COMMENT '接收者',
  `diamond` int NOT NULL COMMENT '钻石数量',
  `bean` int NOT NULL COMMENT '豆子数量',
  `type` tinyint NOT NULL COMMENT '类型（1：callReady 2:分钟加时）',
  `status` tinyint NOT NULL COMMENT '状态（1：预状态，2：预扣费 3：已处理）',
  `deal_status` tinyint NOT NULL COMMENT '处理结果（1：退费，2：扣费）',
  `next_time` int NOT NULL COMMENT '预状态发起时间',
  `expect_check_time` int NOT NULL COMMENT '预状态应答时间',
  `actual_check_time` int NOT NULL COMMENT '预先扣费时间',
  `cost_time` int NOT NULL COMMENT '退费时间',
  `expect_deal_time` int NOT NULL COMMENT '扣费时间',
  `actual_deal_time` int NOT NULL COMMENT '期待处理时间',
  `end_type` tinyint NOT NULL DEFAULT '0',
  `end_err` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_pink` tinyint(1) NOT NULL DEFAULT '2' COMMENT '是否粉钻 1:是 2:否',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`uuid`),
  KEY `Index_1` (`video_uid`),
  KEY `Index_3` (`status`,`end_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2008 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频分钟明细';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_minute_detail_log`
--

DROP TABLE IF EXISTS `video_minute_detail_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_minute_detail_log` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频UID',
  `uuid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'UUID',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `remark` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'remark',
  `err` tinytext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'err',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Index_1` (`video_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2383 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频分钟核心日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_minute_sum`
--

DROP TABLE IF EXISTS `video_minute_sum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_minute_sum` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `video_uid` varchar(260) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '视频UID',
  `send_user_id` bigint NOT NULL COMMENT 'user_id',
  `receive_user_id` bigint NOT NULL,
  `diamond` int NOT NULL COMMENT 'diamond',
  `bean` int NOT NULL COMMENT '豆子',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`video_uid`,`send_user_id`,`receive_user_id`) USING BTREE,
  UNIQUE KEY `video_uid` (`video_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=1441 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频分钟汇总';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_read`
--

DROP TABLE IF EXISTS `video_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_read` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `type` tinyint NOT NULL COMMENT '类型',
  `read_time` timestamp NOT NULL COMMENT '已读时间',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_relation`
--

DROP TABLE IF EXISTS `video_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_relation` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `send_user_id` bigint NOT NULL COMMENT '发起者',
  `receive_user_id` bigint NOT NULL COMMENT '接收者',
  `type` tinyint NOT NULL COMMENT '类型',
  `n` int NOT NULL COMMENT '次数',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`send_user_id`,`receive_user_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=899 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频中，人物关系，视频次数，';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `video_trade_union_gift`
--

DROP TABLE IF EXISTS `video_trade_union_gift`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `video_trade_union_gift` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `res_gift_id` bigint NOT NULL COMMENT 'res_gift_id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='视频公会用户礼物';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vip_subscribe_apple`
--

DROP TABLE IF EXISTS `vip_subscribe_apple`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vip_subscribe_apple` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT 'user_id',
  `receipt` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'apple_receipt',
  `transaction_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'apple_transaction_id',
  `original_transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AK_Key_2` (`transaction_id`),
  KEY `original_transaction_id` (`original_transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1306 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Vip订阅订单，记录的数据用户定时轮询查询。查询状态\r\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vip_subscribe_google`
--

DROP TABLE IF EXISTS `vip_subscribe_google`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vip_subscribe_google` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `user_id` bigint unsigned NOT NULL COMMENT 'user_id',
  `package_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscription_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_token` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `purchase_token` (`purchase_token`)
) ENGINE=InnoDB AUTO_INCREMENT=504 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Vip订阅订单(google)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `watch_adv_record`
--

DROP TABLE IF EXISTS `watch_adv_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `watch_adv_record` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` char(64) NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `external_id` char(64) NOT NULL,
  `time_stamp` bigint NOT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_id` (`transaction_id`),
  KEY `user_id_idx` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='观看视频广告记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `watermelon_winner`
--

DROP TABLE IF EXISTS `watermelon_winner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `watermelon_winner` (
  `date` date NOT NULL COMMENT '日期',
  `round` int unsigned NOT NULL COMMENT '轮次',
  `user_id` bigint unsigned NOT NULL COMMENT '用户ID',
  `award` int unsigned NOT NULL DEFAULT '0' COMMENT '赢得的金额',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`round`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='西瓜中奖记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `weekly_star_award_config`
--

DROP TABLE IF EXISTS `weekly_star_award_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `weekly_star_award_config` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
  `n` smallint unsigned NOT NULL COMMENT '名次',
  `diamond` int unsigned NOT NULL COMMENT '第一名钻石数量',
  `headdress_id` bigint unsigned NOT NULL COMMENT '头饰ID',
  `headdress_duration` int NOT NULL COMMENT '头饰时长（单位秒， -1：无限）',
  `property_id` bigint unsigned NOT NULL COMMENT '坐骑ID',
  `property_duration` int NOT NULL COMMENT '坐骑时长（单位秒， -1：无限）',
  `medal_id` bigint unsigned NOT NULL COMMENT '勋章ID',
  `medal_duration` int unsigned NOT NULL COMMENT '勋章时长（单位天）',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order` (`n`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `weekly_star_gift`
--

DROP TABLE IF EXISTS `weekly_star_gift`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `weekly_star_gift` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `activity_billboard_id` bigint NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL COMMENT '开始日期',
  `gift_id` bigint NOT NULL COMMENT '礼物id',
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `date_gift_idx` (`start_date`,`gift_id`),
  KEY `activity_billboard_id` (`activity_billboard_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='周星活动礼物配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Final view structure for view `diamond_account_detail_copy`
--

/*!50001 DROP VIEW IF EXISTS `diamond_account_detail_copy`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`%` SQL SECURITY DEFINER */
/*!50001 VIEW `diamond_account_detail_copy` AS select `diamond_account_detail`.`id` AS `id`,`diamond_account_detail`.`user_id` AS `user_id`,`diamond_account_detail`.`diamond_account_id` AS `diamond_account_id`,`diamond_account_detail`.`operate_id` AS `operate_id`,`diamond_account_detail`.`operate_type` AS `operate_type`,`diamond_account_detail`.`origin_id` AS `origin_id`,`diamond_account_detail`.`add_reduce` AS `add_reduce`,`diamond_account_detail`.`num` AS `num`,`diamond_account_detail`.`remark` AS `remark`,`diamond_account_detail`.`bef_num` AS `bef_num`,`diamond_account_detail`.`aft_num` AS `aft_num`,`diamond_account_detail`.`created_time` AS `created_time`,`diamond_account_detail`.`updated_time` AS `updated_time`,`diamond_account_detail`.`operate_ids` AS `operate_ids` from `diamond_account_detail` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-04-20 17:45:02
