package diamond_m

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/diamond_e"
	"git.hilo.cn/hilo-common/resource/mysql"
)

func CheckEnoughDiamondFrozen(model *domain.Model, userId mysql.ID, diamondNum mysql.Num) (*DiamondAccount, error) {
	diamondAccount, err := GetDiamondAccountByUserId(model, userId)
	if err != nil {
		return nil, err
	}
	if diamondAccount.DiamondNum < diamondNum {
		return nil, fmt.Errorf("bizerr.DiamondNoEnough")
	}
	if diamondAccount.Status == diamond_e.Frozen {
		return nil, fmt.Errorf("bizerr.DiamondAccountFrozen")
	}
	return diamondAccount, nil
}
