package diamond_m

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"strconv"
)

func (diamondAccountDetail *DiamondAccountDetail) Persistent() error {
	txDiamondAccount := diamondAccountDetail.Db.Model(diamondAccountDetail.diamondAccount)
	if diamondAccountDetail.diamondAccount.CheckUpdateCondition() {
		txDiamondAccount = txDiamondAccount.Where(diamondAccountDetail.diamondAccount.GetUpdateCondition())
	}
	if diamondAccountDetail.AddReduce == mysql.ADD {
		//增加
		txDiamondAccount.UpdateColumn("diamond_num", gorm.Expr("diamond_num + ?", diamondAccountDetail.Num))
	} else if diamondAccountDetail.AddReduce == mysql.REDUCE {
		//减少，保证不能扣成负数
		txDiamondAccount.Where("diamond_num >= ?", diamondAccountDetail.Num).UpdateColumn("diamond_num", gorm.Expr("diamond_num - ?", diamondAccountDetail.Num))
	} else {
		mylogrus.MyLog.Errorf("addReduce 枚举错误 value:" + mysql.TypeToString(mysql.Type(diamondAccountDetail.AddReduce)))
	}
	if err := txDiamondAccount.Error; err != nil {
		return err
	}
	if txDiamondAccount.RowsAffected == 0 {
		mylogrus.MyLog.Errorf("gorm condition update.RowsAffected = 0，AddReduce：%v", diamondAccountDetail.AddReduce)
		return fmt.Errorf("gorm condition update.RowsAffected = 0")
	}

	//持久化diamondAccountDetail
	if err := domain.Persistent(diamondAccountDetail.Db, diamondAccountDetail); err != nil {
		return err
	}
	//改变diamondAccount值
	if diamondAccountDetail.diamondAccount == nil {
		return fmt.Errorf("持久化错误， 模型：DiamondAccountDetail 中没有diamondAccount, DiamondAccountDetail.Id =" + strconv.Itoa(int(diamondAccountDetail.ID)))
	}

	var newDiamondAccount DiamondAccount
	if err := diamondAccountDetail.Db.First(&newDiamondAccount, diamondAccountDetail.diamondAccount.ID).Error; err != nil {
		return err
	}

	if newDiamondAccount.DiamondNum < 0 {
		return fmt.Errorf("diamond_account表中，diamond_num 不能小于0, diamondAccount.id = " + strconv.Itoa(int(newDiamondAccount.ID)))
	}
	return nil
}
